/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCompilerCommand;
import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardConfigurationSource;
import com.android.tools.r8.shaking.ProguardConfigurationSourceFile;
import com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.IOExceptionDiagnostic;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OutputMode;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class R8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", ImmutableList.of("Usage: r8 [options] <input-files>", " where <input-files> are any combination of dex, class, zip, jar, or apk files", " and options are:", "  --release                # Compile without debugging information (default).", "  --debug                  # Compile with debugging information.", "  --output <file>          # Output result in <file>.", "                           # <file> must be an existing directory or a zip file.", "  --lib <file>             # Add <file> as a library resource.", "  --min-api                # Minimum Android API level compatibility.", "  --pg-conf <file>         # Proguard configuration <file> (implies tree", "                           # shaking/minification).", "  --pg-map-output <file>   # Output the resulting name and line mapping to <file>.", new String[]{"  --no-tree-shaking        # Force disable tree shaking of unreachable classes.", "  --no-discarded-checker   # Force disable the discarded checker (when tree shaking).", "  --no-minification        # Force disable minification of names.", "  --main-dex-rules <file>  # Proguard keep rules for classes to place in the", "                           # primary dex file.", "  --main-dex-list <file>   # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>  # Output the full main-dex list in <file>.", "  --version                # Print the version of r8.", "  --help                   # Print this message."}));
    private final ImmutableList<ProguardConfigurationRule> mainDexKeepRules;
    private final Path mainDexListOutput;
    private final ProguardConfiguration proguardConfiguration;
    private final boolean useTreeShaking;
    private final boolean useDiscardedChecker;
    private final boolean useMinification;
    private final boolean ignoreMissingClasses;
    private final boolean forceProguardCompatibility;
    private final boolean ignoreMissingClassesWhenNotShrinking;
    private final Path proguardMapOutput;
    private final Path proguardCompatibilityRulesOutput;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    static Builder builder(AndroidApp app, DiagnosticsHandler diagnosticsHandler) {
        return new Builder(app, diagnosticsHandler);
    }

    public static Builder parse(String[] args, Origin argsOrigin) {
        Builder builder = R8Command.builder();
        R8Command.parse(args, argsOrigin, builder, new ParseState());
        return builder;
    }

    private static ParseState parse(String[] args, Origin argsOrigin, Builder builder, ParseState state) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.length() == 0) continue;
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (arg.equals("--debug")) {
                if (state.mode == CompilationMode.RELEASE) {
                    builder.getReporter().error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", argsOrigin));
                }
                state.mode = CompilationMode.DEBUG;
                builder.setMode(state.mode);
                continue;
            }
            if (arg.equals("--release")) {
                if (state.mode == CompilationMode.DEBUG) {
                    builder.getReporter().error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", argsOrigin));
                }
                state.mode = CompilationMode.RELEASE;
                builder.setMode(state.mode);
                continue;
            }
            if (arg.equals("--output")) {
                String outputPath = args[++i];
                if (builder.getOutputPath() != null) {
                    builder.getReporter().error(new StringDiagnostic("Cannot output both to '" + builder.getOutputPath().toString() + "' and '" + outputPath + "'", argsOrigin));
                }
                builder.setOutputPath(Paths.get(outputPath, new String[0]));
                continue;
            }
            if (arg.equals("--lib")) {
                builder.addLibraryFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--min-api")) {
                builder.setMinApiLevel(Integer.valueOf(args[++i]));
                continue;
            }
            if (arg.equals("--no-tree-shaking")) {
                builder.setTreeShaking(false);
                continue;
            }
            if (arg.equals("--no-discarded-checker")) {
                builder.setDiscardedChecker(false);
                continue;
            }
            if (arg.equals("--no-minification")) {
                builder.setMinification(false);
                continue;
            }
            if (arg.equals("--main-dex-rules")) {
                builder.addMainDexRulesFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--pg-conf")) {
                builder.addProguardConfigurationFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--ignore-missing-classes")) {
                builder.setIgnoreMissingClasses(true);
                continue;
            }
            if (arg.equals("--pg-map-output")) {
                builder.setProguardMapOutput(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.startsWith("@")) {
                Path argsFile = Paths.get(arg.substring(1), new String[0]);
                PathOrigin argsFileOrigin = new PathOrigin(argsFile);
                try {
                    List<String> linesInFile = FileUtils.readTextFile(argsFile);
                    ArrayList<String> argsInFile = new ArrayList<String>();
                    for (String line : linesInFile) {
                        for (String word : line.split("\\s")) {
                            String trimmed = word.trim();
                            if (trimmed.isEmpty()) continue;
                            argsInFile.add(trimmed);
                        }
                    }
                    state = R8Command.parse(argsInFile.toArray(new String[argsInFile.size()]), argsFileOrigin, builder, state);
                }
                catch (IOException e) {
                    builder.getReporter().error(new StringDiagnostic("Failed to read arguments from file " + argsFile + ": " + e.getMessage(), argsFileOrigin));
                }
                continue;
            }
            if (arg.startsWith("--")) {
                builder.getReporter().error(new StringDiagnostic("Unknown option: " + arg, argsOrigin));
            }
            builder.addProgramFiles(Paths.get(arg, new String[0]));
        }
        return state;
    }

    private R8Command(AndroidApp inputApp, Path outputPath, OutputMode outputMode, ImmutableList<ProguardConfigurationRule> mainDexKeepRules, Path mainDexListOutput, ProguardConfiguration proguardConfiguration, CompilationMode mode, int minApiLevel, Reporter reporter, boolean enableDesugaring, boolean useTreeShaking, boolean useDiscardedChecker, boolean useMinification, boolean ignoreMissingClasses, boolean forceProguardCompatibility, boolean ignoreMissingClassesWhenNotShrinking, Path proguardMapOutput, Path proguardCompatibilityRulesOutput) {
        super(inputApp, outputPath, outputMode, mode, minApiLevel, reporter, enableDesugaring);
        assert (proguardConfiguration != null);
        assert (mainDexKeepRules != null);
        assert (this.getOutputMode() == OutputMode.Indexed) : "Only regular mode is supported in R8";
        this.mainDexKeepRules = mainDexKeepRules;
        this.mainDexListOutput = mainDexListOutput;
        this.proguardConfiguration = proguardConfiguration;
        this.useTreeShaking = useTreeShaking;
        this.useDiscardedChecker = useDiscardedChecker;
        this.useMinification = useMinification;
        this.ignoreMissingClasses = ignoreMissingClasses;
        this.forceProguardCompatibility = forceProguardCompatibility;
        this.ignoreMissingClassesWhenNotShrinking = ignoreMissingClassesWhenNotShrinking;
        this.proguardMapOutput = proguardMapOutput;
        this.proguardCompatibilityRulesOutput = proguardCompatibilityRulesOutput;
    }

    private R8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.mainDexKeepRules = ImmutableList.of();
        this.mainDexListOutput = null;
        this.proguardConfiguration = null;
        this.useTreeShaking = false;
        this.useDiscardedChecker = false;
        this.useMinification = false;
        this.ignoreMissingClasses = false;
        this.forceProguardCompatibility = false;
        this.ignoreMissingClassesWhenNotShrinking = false;
        this.proguardMapOutput = null;
        this.proguardCompatibilityRulesOutput = null;
    }

    public boolean useTreeShaking() {
        return this.useTreeShaking;
    }

    public boolean useDiscardedChecker() {
        return this.useDiscardedChecker;
    }

    public boolean useMinification() {
        return this.useMinification;
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(this.proguardConfiguration, this.getReporter());
        assert (!internal.debug);
        internal.debug = this.getMode() == CompilationMode.DEBUG;
        internal.minApiLevel = this.getMinApiLevel();
        if (!this.proguardConfiguration.isOptimizing()) {
            internal.skipDebugLineNumberOpt = true;
            internal.skipClassMerging = true;
            internal.inlineAccessors = false;
            internal.removeSwitchMaps = false;
            internal.outline.enabled = false;
            internal.propagateMemberValue = false;
        }
        assert (!internal.skipMinification);
        boolean bl = internal.skipMinification = !this.useMinification() || !this.proguardConfiguration.isObfuscating();
        assert (internal.useTreeShaking);
        internal.useTreeShaking = this.useTreeShaking();
        assert (internal.useDiscardedChecker);
        internal.useDiscardedChecker = this.useDiscardedChecker();
        assert (!internal.ignoreMissingClasses);
        internal.ignoreMissingClasses = this.ignoreMissingClasses;
        internal.ignoreMissingClasses |= this.proguardConfiguration.isIgnoreWarnings();
        internal.ignoreMissingClasses = internal.ignoreMissingClasses | (this.ignoreMissingClassesWhenNotShrinking && !this.proguardConfiguration.isShrinking());
        assert (!internal.verbose);
        internal.mainDexKeepRules = this.mainDexKeepRules;
        internal.minimalMainDex = internal.debug;
        if (this.mainDexListOutput != null) {
            internal.printMainDexListFile = this.mainDexListOutput;
        }
        internal.outputMode = this.getOutputMode();
        if (internal.debug) {
            internal.removeSwitchMaps = false;
            internal.inlineAccessors = false;
        }
        internal.proguardMapOutput = this.proguardMapOutput;
        internal.proguardCompatibilityRulesOutput = this.proguardCompatibilityRulesOutput;
        assert (!internal.forceProguardCompatibility);
        internal.forceProguardCompatibility = this.forceProguardCompatibility;
        return internal;
    }

    private static class ParseState {
        CompilationMode mode = null;

        private ParseState() {
        }
    }

    public static class Builder
    extends BaseCompilerCommand.Builder<R8Command, Builder> {
        private final List<ProguardConfigurationSource> mainDexRules = new ArrayList<ProguardConfigurationSource>();
        private Path mainDexListOutput = null;
        private Consumer<ProguardConfiguration.Builder> proguardConfigurationConsumer = null;
        private final List<ProguardConfigurationSource> proguardConfigs = new ArrayList<ProguardConfigurationSource>();
        private Optional<Boolean> treeShaking = Optional.empty();
        private Optional<Boolean> discardedChecker = Optional.empty();
        private Optional<Boolean> minification = Optional.empty();
        private boolean ignoreMissingClassesWhenNotShrinking = false;
        private boolean ignoreMissingClasses = false;
        private boolean forceProguardCompatibility = false;
        private Path proguardMapOutput = null;
        protected Path proguardCompatibilityRulesOutput = null;

        private Builder() {
            this.setMode(CompilationMode.RELEASE);
        }

        protected Builder(boolean forceProguardCompatibility, boolean ignoreMissingClassesWhenNotShrinking, boolean ignoreMissingClasses) {
            this.setMode(CompilationMode.RELEASE);
            this.forceProguardCompatibility = forceProguardCompatibility;
            this.ignoreMissingClassesWhenNotShrinking = ignoreMissingClassesWhenNotShrinking;
            this.ignoreMissingClasses = ignoreMissingClasses;
        }

        protected Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
            this.setMode(CompilationMode.DEBUG);
        }

        private Builder(AndroidApp app) {
            super(app);
            this.setMode(CompilationMode.RELEASE);
        }

        private Builder(AndroidApp app, DiagnosticsHandler diagnosticsHandler) {
            super(app, diagnosticsHandler);
            this.setMode(CompilationMode.RELEASE);
        }

        @Override
        Builder self() {
            return this;
        }

        public Builder setTreeShaking(boolean useTreeShaking) {
            this.treeShaking = Optional.of(useTreeShaking);
            return this.self();
        }

        public Builder setDiscardedChecker(boolean useDiscardedChecker) {
            this.discardedChecker = Optional.of(useDiscardedChecker);
            return this.self();
        }

        public Builder setMinification(boolean useMinification) {
            this.minification = Optional.of(useMinification);
            return this.self();
        }

        public Builder addMainDexRulesFiles(Path ... paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addMainDexRulesFiles(List<Path> paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addMainDexRules(List<String> lines, Origin origin) {
            this.guard(() -> this.mainDexRules.add(new ProguardConfigurationSourceStrings(lines, Paths.get(".", new String[0]), origin)));
            return this.self();
        }

        public Builder setMainDexListOutputPath(Path mainDexListOutputPath) {
            this.mainDexListOutput = mainDexListOutputPath;
            return this.self();
        }

        public Builder addProguardConfigurationFiles(Path ... paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.proguardConfigs.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addProguardConfigurationFiles(List<Path> paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.proguardConfigs.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addProguardConfiguration(List<String> lines, Origin origin) {
            this.guard(() -> this.proguardConfigs.add(new ProguardConfigurationSourceStrings(lines, Paths.get(".", new String[0]), origin)));
            return this.self();
        }

        public Builder addProguardConfigurationConsumer(Consumer<ProguardConfiguration.Builder> c) {
            Consumer<ProguardConfiguration.Builder> oldConsumer = this.proguardConfigurationConsumer;
            this.proguardConfigurationConsumer = builder -> {
                if (oldConsumer != null) {
                    oldConsumer.accept((ProguardConfiguration.Builder)builder);
                }
                c.accept((ProguardConfiguration.Builder)builder);
            };
            return this.self();
        }

        public Builder setProguardMapFile(Path path) {
            this.guard(() -> this.getAppBuilder().setProguardMapFile(path));
            return this.self();
        }

        Builder setIgnoreMissingClasses(boolean ignoreMissingClasses) {
            this.ignoreMissingClasses = ignoreMissingClasses;
            return this.self();
        }

        public Builder setProguardMapOutput(Path path) {
            this.proguardMapOutput = path;
            return this.self();
        }

        @Override
        protected void validate() {
            if (this.mainDexListOutput != null && this.mainDexRules.isEmpty() && !this.getAppBuilder().hasMainDexList()) {
                this.reporter.error("Option --main-dex-list-output require --main-dex-rules and/or --main-dex-list");
            }
            super.validate();
        }

        @Override
        protected R8Command makeCommand() {
            try {
                if (this.isPrintHelp() || this.isPrintVersion()) {
                    return new R8Command(this.isPrintHelp(), this.isPrintVersion());
                }
                return this.makeR8Command();
            }
            catch (IOException e) {
                throw this.reporter.fatalError(new IOExceptionDiagnostic(e), e);
            }
            catch (CompilationException e) {
                throw this.reporter.fatalError(new StringDiagnostic(e.getMessage()), e);
            }
        }

        private R8Command makeR8Command() throws IOException, CompilationException {
            ProguardConfiguration.Builder configurationBuilder;
            ImmutableList<Object> mainDexKeepRules;
            DexItemFactory factory = new DexItemFactory();
            if (this.mainDexRules.isEmpty()) {
                mainDexKeepRules = ImmutableList.of();
            } else {
                ProguardConfigurationParser parser = new ProguardConfigurationParser(factory, this.reporter);
                parser.parse(this.mainDexRules);
                mainDexKeepRules = parser.getConfig().getRules();
            }
            if (this.proguardConfigs.isEmpty()) {
                configurationBuilder = ProguardConfiguration.builder(factory, this.reporter);
            } else {
                ProguardConfigurationParser parser = new ProguardConfigurationParser(factory, this.reporter);
                parser.parse(this.proguardConfigs);
                configurationBuilder = parser.getConfigurationBuilder();
                configurationBuilder.setForceProguardCompatibility(this.forceProguardCompatibility);
            }
            if (this.proguardConfigurationConsumer != null) {
                this.proguardConfigurationConsumer.accept(configurationBuilder);
            }
            ProguardConfiguration configuration = configurationBuilder.build();
            this.getAppBuilder().addProgramFiles(configuration.getInjars());
            this.getAppBuilder().addLibraryFiles(configuration.getLibraryjars());
            boolean useTreeShaking = this.treeShaking.orElse(configuration.isShrinking());
            boolean useDiscardedChecker = this.discardedChecker.orElse(true);
            boolean useMinification = this.minification.orElse(configuration.isObfuscating());
            R8Command command = new R8Command(this.getAppBuilder().build(), this.getOutputPath(), this.getOutputMode(), mainDexKeepRules, this.mainDexListOutput, configuration, this.getMode(), this.getMinApiLevel(), this.reporter, this.getEnableDesugaring(), useTreeShaking, useDiscardedChecker, useMinification, this.ignoreMissingClasses, this.forceProguardCompatibility, this.ignoreMissingClassesWhenNotShrinking, this.proguardMapOutput, this.proguardCompatibilityRulesOutput);
            return command;
        }
    }
}

