/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.benchmarks;

import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.D8Output;
import com.android.tools.r8.benchmarks.BenchmarkUtils;
import com.android.tools.r8.utils.ThreadUtils;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.concurrent.ExecutorService;

public class IncrementalDexingBenchmark {
    private static final int ITERATIONS = 1000;

    public static void compile(ExecutorService executor) throws IOException, CompilationException, CompilationFailedException {
        D8Output output = D8.run((D8Command)((D8Command.Builder)((D8Command.Builder)D8Command.builder().addProgramFiles(Paths.get("build/test/examples/arithmetic.jar", new String[0]))).setMode(CompilationMode.DEBUG)).build(), executor);
        if (output.getDexResources().size() != 1) {
            throw new RuntimeException("WAT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, CompilationException, CompilationFailedException {
        int threads = Integer.min(Runtime.getRuntime().availableProcessors(), 16) / 2;
        ExecutorService executor = ThreadUtils.getExecutorService(threads);
        try {
            long start = System.nanoTime();
            for (int i = 0; i < 1000; ++i) {
                IncrementalDexingBenchmark.compile(executor);
            }
            double elapsedMs = (double)(System.nanoTime() - start) / 1000000.0;
            BenchmarkUtils.printRuntimeMilliseconds("IncrementalDexing", elapsedMs);
        }
        finally {
            executor.shutdown();
        }
    }
}

