/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import com.android.tools.r8.origin.SynthesizedOrigin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;

final class InterfaceProcessor {
    private final InterfaceMethodRewriter rewriter;
    final Map<DexProgramClass, DexProgramClass> companionClasses = new IdentityHashMap<DexProgramClass, DexProgramClass>();

    InterfaceProcessor(InterfaceMethodRewriter rewriter) {
        this.rewriter = rewriter;
    }

    void process(DexProgramClass iface) {
        assert (iface.isInterface());
        ArrayList<DexEncodedMethod> companionMethods = new ArrayList<DexEncodedMethod>();
        ArrayList<DexEncodedMethod> remainingMethods = new ArrayList<DexEncodedMethod>();
        for (DexEncodedMethod virtual : iface.virtualMethods()) {
            if (this.rewriter.isDefaultMethod(virtual)) {
                DexMethod companionMethod = this.rewriter.defaultAsMethodOfCompanionClass(virtual.method);
                Code code = virtual.getCode();
                if (code == null) {
                    throw new CompilationError("Code is missing for default interface method: " + virtual.method.toSourceString());
                }
                MethodAccessFlags newFlags = virtual.accessFlags.copy();
                newFlags.unsetBridge();
                newFlags.setStatic();
                DexCode dexCode = code.asDexCode();
                dexCode.setDebugInfo(dexCode.debugInfoWithAdditionalFirstParameter(null));
                assert (dexCode.getDebugInfo() == null || companionMethod.getArity() == dexCode.getDebugInfo().parameters.length);
                companionMethods.add(new DexEncodedMethod(companionMethod, newFlags, virtual.annotations, virtual.parameterAnnotations, code));
                virtual.accessFlags.setAbstract();
                virtual.removeCode();
            }
            if (virtual.accessFlags.isBridge()) continue;
            remainingMethods.add(virtual);
        }
        if (remainingMethods.size() < iface.virtualMethods().length) {
            iface.setVirtualMethods(remainingMethods.toArray(new DexEncodedMethod[remainingMethods.size()]));
        }
        remainingMethods.clear();
        for (DexEncodedMethod direct : iface.directMethods()) {
            if (direct.accessFlags.isPrivate()) {
                throw new Unimplemented("Private method are not yet supported.");
            }
            if (this.isStaticMethod(direct)) {
                companionMethods.add(new DexEncodedMethod(this.rewriter.staticAsMethodOfCompanionClass(direct.method), direct.accessFlags, direct.annotations, direct.parameterAnnotations, direct.getCode()));
                continue;
            }
            assert (this.rewriter.factory.isClassConstructor(direct.method));
            remainingMethods.add(direct);
        }
        if (remainingMethods.size() < iface.directMethods().length) {
            iface.setDirectMethods(remainingMethods.toArray(new DexEncodedMethod[remainingMethods.size()]));
        }
        if (companionMethods.isEmpty()) {
            return;
        }
        ClassAccessFlags companionClassFlags = iface.accessFlags.copy();
        companionClassFlags.unsetAbstract();
        companionClassFlags.unsetInterface();
        companionClassFlags.setFinal();
        companionClassFlags.setSynthetic();
        companionClassFlags.setPublic();
        DexType companionClassType = this.rewriter.getCompanionClassType(iface.type);
        DexProgramClass companionClass = new DexProgramClass(companionClassType, null, new SynthesizedOrigin("interface desugaring", this.getClass()), companionClassFlags, this.rewriter.factory.objectType, DexTypeList.empty(), iface.sourceFile, null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, companionMethods.toArray(new DexEncodedMethod[companionMethods.size()]), DexEncodedMethod.EMPTY_ARRAY, Collections.singletonList(iface));
        this.companionClasses.put(iface, companionClass);
    }

    private boolean isStaticMethod(DexEncodedMethod method) {
        if (method.accessFlags.isNative()) {
            throw new Unimplemented("Native interface methods are not yet supported.");
        }
        return method.accessFlags.isStatic() && !this.rewriter.factory.isClassConstructor(method.method);
    }
}

