/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ArchiveClassFileProvider;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.Resource;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.shaking.FilteredClassPath;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.DirectoryClassFileProvider;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.OutputMode;
import com.android.tools.r8.utils.ProgramFileArchiveReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class AndroidApp {
    public static final String DEFAULT_PROGUARD_MAP_FILE = "proguard.map";
    private final ImmutableList<ProgramResource> programResources;
    private final ImmutableMap<Resource, String> programResourcesMainDescriptor;
    private final ImmutableList<ClassFileResourceProvider> classpathResourceProviders;
    private final ImmutableList<ClassFileResourceProvider> libraryResourceProviders;
    private final ImmutableList<ProgramFileArchiveReader> programFileArchiveReaders;
    private final Resource deadCode;
    private final Resource proguardMap;
    private final Resource proguardSeeds;
    private final List<Resource> mainDexListResources;
    private final List<String> mainDexClasses;
    private final Resource mainDexListOutput;

    private AndroidApp(ImmutableList<ProgramResource> programResources, ImmutableMap<Resource, String> programResourcesMainDescriptor, ImmutableList<ProgramFileArchiveReader> programFileArchiveReaders, ImmutableList<ClassFileResourceProvider> classpathResourceProviders, ImmutableList<ClassFileResourceProvider> libraryResourceProviders, Resource deadCode, Resource proguardMap, Resource proguardSeeds, List<Resource> mainDexListResources, List<String> mainDexClasses, Resource mainDexListOutput) {
        this.programResources = programResources;
        this.programResourcesMainDescriptor = programResourcesMainDescriptor;
        this.programFileArchiveReaders = programFileArchiveReaders;
        this.classpathResourceProviders = classpathResourceProviders;
        this.libraryResourceProviders = libraryResourceProviders;
        this.deadCode = deadCode;
        this.proguardMap = proguardMap;
        this.proguardSeeds = proguardSeeds;
        this.mainDexListResources = mainDexListResources;
        this.mainDexClasses = mainDexClasses;
        this.mainDexListOutput = mainDexListOutput;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    public static AndroidApp fromProgramFiles(Path ... files) throws IOException {
        return AndroidApp.fromProgramFiles(Arrays.asList(files));
    }

    public static AndroidApp fromProgramFiles(List<Path> files) throws IOException {
        return AndroidApp.builder().addProgramFiles(ListUtils.map(files, FilteredClassPath::unfiltered)).build();
    }

    public static AndroidApp fromProgramDirectory(Path directory) throws IOException {
        return AndroidApp.builder().addProgramDirectory(directory).build();
    }

    public static AndroidApp fromDexProgramData(byte[] ... data) {
        return AndroidApp.fromDexProgramData(Arrays.asList(data));
    }

    public static AndroidApp fromDexProgramData(List<byte[]> data) {
        return AndroidApp.builder().addDexProgramData(data).build();
    }

    public static AndroidApp fromClassProgramData(byte[] ... data) {
        return AndroidApp.fromClassProgramData(Arrays.asList(data));
    }

    public static AndroidApp fromClassProgramData(List<byte[]> data) {
        return AndroidApp.builder().addClassProgramData(data).build();
    }

    public List<ProgramResource> getDexProgramResources() throws IOException {
        List<ProgramResource> dexResources = this.filter(this.programResources, ProgramResource.Kind.DEX);
        for (ProgramFileArchiveReader reader : this.programFileArchiveReaders) {
            dexResources.addAll(reader.getDexProgramResources());
        }
        return dexResources;
    }

    public List<ProgramResource> getDexProgramResourcesForOutput() {
        assert (this.programFileArchiveReaders.isEmpty());
        return this.filter(this.programResources, ProgramResource.Kind.DEX);
    }

    public List<ProgramResource> getClassProgramResources() throws IOException {
        List<ProgramResource> classResources = this.filter(this.programResources, ProgramResource.Kind.CF);
        for (ProgramFileArchiveReader reader : this.programFileArchiveReaders) {
            classResources.addAll(reader.getClassProgramResources());
        }
        return classResources;
    }

    public List<ClassFileResourceProvider> getClasspathResourceProviders() {
        return this.classpathResourceProviders;
    }

    public List<ClassFileResourceProvider> getLibraryResourceProviders() {
        return this.libraryResourceProviders;
    }

    public List<ProgramFileArchiveReader> getProgramFileArchiveReaders() {
        return this.programFileArchiveReaders;
    }

    private List<ProgramResource> filter(List<ProgramResource> resources, ProgramResource.Kind kind) {
        ArrayList<ProgramResource> out = new ArrayList<ProgramResource>(resources.size());
        for (ProgramResource code : resources) {
            if (code.getKind() != kind) continue;
            out.add(code);
        }
        return out;
    }

    public boolean hasDeadCode() {
        return this.deadCode != null;
    }

    public InputStream getDeadCode(Closer closer) throws IOException {
        return this.deadCode == null ? null : closer.register(this.deadCode.getStream());
    }

    public boolean hasProguardMap() {
        return this.proguardMap != null;
    }

    public InputStream getProguardMap() throws IOException {
        return this.proguardMap == null ? null : this.proguardMap.getStream();
    }

    public boolean hasProguardSeeds() {
        return this.proguardSeeds != null;
    }

    public InputStream getProguardSeeds(Closer closer) throws IOException {
        return this.proguardSeeds == null ? null : closer.register(this.proguardSeeds.getStream());
    }

    public boolean hasMainDexList() {
        return !this.mainDexListResources.isEmpty() || !this.mainDexClasses.isEmpty();
    }

    public boolean hasMainDexListResources() {
        return !this.mainDexListResources.isEmpty();
    }

    public List<Resource> getMainDexListResources() {
        return this.mainDexListResources;
    }

    public List<String> getMainDexClasses() {
        return this.mainDexClasses;
    }

    public boolean hasMainDexListOutput() {
        return this.mainDexListOutput != null;
    }

    public InputStream getMainDexListOutput(Closer closer) throws IOException {
        return this.mainDexListOutput == null ? null : closer.register(this.mainDexListOutput.getStream());
    }

    public void write(Path output, OutputMode outputMode) throws IOException {
        if (FileUtils.isArchive(output)) {
            this.writeToZip(output, outputMode);
        } else {
            this.writeToDirectory(output, outputMode);
        }
    }

    public void writeToDirectory(Path directory, OutputMode outputMode) throws IOException {
        if (outputMode == OutputMode.Indexed) {
            try (Stream<Path> filesInDir = Files.list(directory);){
                for (Path path : filesInDir.collect(Collectors.toList())) {
                    if (!FileUtils.isClassesDexFile(path)) continue;
                    Files.delete(path);
                }
            }
        }
        CopyOption[] options = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Closer closer = Closer.create();
        Object object = null;
        try {
            List<ProgramResource> dexProgramSources = this.getDexProgramResources();
            for (int i = 0; i < dexProgramSources.size(); ++i) {
                Path filePath = directory.resolve(this.getOutputPath(outputMode, dexProgramSources.get(i), i));
                if (!Files.exists(filePath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                }
                Files.copy(closer.register(dexProgramSources.get(i).getStream()), filePath, options);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (closer != null) {
                AndroidApp.$closeResource((Throwable)object, closer);
            }
        }
    }

    private String getOutputPath(OutputMode outputMode, Resource resource, int index) {
        switch (outputMode) {
            case Indexed: {
                return index == 0 ? "classes.dex" : "classes" + (index + 1) + ".dex";
            }
            case FilePerInputClass: {
                String classDescriptor = this.programResourcesMainDescriptor.get(resource);
                assert (classDescriptor != null && DescriptorUtils.isClassDescriptor(classDescriptor));
                return classDescriptor.substring(1, classDescriptor.length() - 1) + ".dex";
            }
        }
        throw new Unreachable("Unknown output mode: " + (Object)((Object)outputMode));
    }

    public List<byte[]> writeToMemory() throws IOException {
        ArrayList<byte[]> dex = new ArrayList<byte[]>();
        try (Closer closer = Closer.create();){
            List<ProgramResource> dexProgramSources = this.getDexProgramResources();
            for (int i = 0; i < dexProgramSources.size(); ++i) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteStreams.copy(closer.register(dexProgramSources.get(i).getStream()), out);
                dex.add(out.toByteArray());
            }
        }
        return dex;
    }

    public void writeToZip(Path archive, OutputMode outputMode) throws IOException {
        OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        try (Closer closer = Closer.create();
             ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(archive, options));){
            List<ProgramResource> dexProgramSources = this.getDexProgramResources();
            for (int i = 0; i < dexProgramSources.size(); ++i) {
                ZipEntry zipEntry = new ZipEntry(this.getOutputPath(outputMode, dexProgramSources.get(i), i));
                byte[] bytes = ByteStreams.toByteArray(closer.register(dexProgramSources.get(i).getStream()));
                zipEntry.setSize(bytes.length);
                out.putNextEntry(zipEntry);
                out.write(bytes);
                out.closeEntry();
            }
        }
    }

    public void writeProguardMap(OutputStream out) throws IOException {
        try (InputStream input = this.getProguardMap();){
            assert (input != null);
            out.write(ByteStreams.toByteArray(input));
        }
    }

    public void writeProguardSeeds(Closer closer, OutputStream out) throws IOException {
        InputStream input = this.getProguardSeeds(closer);
        assert (input != null);
        out.write(ByteStreams.toByteArray(input));
    }

    public void writeMainDexList(Closer closer, OutputStream out) throws IOException {
        InputStream input = this.getMainDexListOutput(closer);
        assert (input != null);
        out.write(ByteStreams.toByteArray(input));
    }

    public void writeDeadCode(Closer closer, OutputStream out) throws IOException {
        InputStream input = this.getDeadCode(closer);
        assert (input != null);
        out.write(ByteStreams.toByteArray(input));
    }

    public String getPrimaryClassDescriptor(Resource resource) {
        assert (resource instanceof ProgramResource);
        return this.programResourcesMainDescriptor.get(resource);
    }

    public static class Builder {
        private final List<ProgramResource> programResources = new ArrayList<ProgramResource>();
        private final Map<ProgramResource, String> programResourcesMainDescriptor = new HashMap<ProgramResource, String>();
        private final List<ProgramFileArchiveReader> programFileArchiveReaders = new ArrayList<ProgramFileArchiveReader>();
        private final List<ClassFileResourceProvider> classpathResourceProviders = new ArrayList<ClassFileResourceProvider>();
        private final List<ClassFileResourceProvider> libraryResourceProviders = new ArrayList<ClassFileResourceProvider>();
        private Resource deadCode;
        private Resource proguardMap;
        private Resource proguardSeeds;
        private List<Resource> mainDexListResources = new ArrayList<Resource>();
        private List<String> mainDexListClasses = new ArrayList<String>();
        private Resource mainDexListOutput;
        private boolean ignoreDexInArchive = false;
        private boolean vdexAllowed = false;

        private Builder() {
        }

        private Builder(AndroidApp app) {
            this.programResources.addAll(app.programResources);
            this.programFileArchiveReaders.addAll(app.programFileArchiveReaders);
            this.classpathResourceProviders.addAll(app.classpathResourceProviders);
            this.libraryResourceProviders.addAll(app.libraryResourceProviders);
            this.deadCode = app.deadCode;
            this.proguardMap = app.proguardMap;
            this.proguardSeeds = app.proguardSeeds;
            this.mainDexListResources = app.mainDexListResources;
            this.mainDexListClasses = app.mainDexClasses;
            this.mainDexListOutput = app.mainDexListOutput;
        }

        public Builder addProgramDirectory(Path directory) throws IOException {
            List<FilteredClassPath> resources = Arrays.asList(directory.toFile().listFiles(file -> FileUtils.isDexFile(file.toPath()))).stream().map(file -> FilteredClassPath.unfiltered(file)).collect(Collectors.toList());
            this.addProgramFiles(resources);
            File mapFile = new File(directory.toFile(), AndroidApp.DEFAULT_PROGUARD_MAP_FILE);
            if (mapFile.exists()) {
                this.setProguardMapFile(mapFile.toPath());
            }
            return this;
        }

        public Builder addProgramFiles(FilteredClassPath ... files) throws NoSuchFileException {
            return this.addProgramFiles(Arrays.asList(files));
        }

        public Builder addProgramFiles(Collection<FilteredClassPath> files) throws NoSuchFileException {
            for (FilteredClassPath file : files) {
                this.addProgramFile(file);
            }
            return this;
        }

        public Builder addClasspathFiles(Path ... files) throws IOException {
            return this.addClasspathFiles(Arrays.asList(files));
        }

        public Builder addClasspathFiles(Collection<Path> files) throws IOException {
            for (Path file : files) {
                this.addClasspathFile(file);
            }
            return this;
        }

        public Builder addClasspathFile(Path file) throws IOException {
            this.addClassProvider(FilteredClassPath.unfiltered(file), this.classpathResourceProviders);
            return this;
        }

        public Builder addClasspathResourceProvider(ClassFileResourceProvider provider) {
            this.classpathResourceProviders.add(provider);
            return this;
        }

        public Builder addLibraryFiles(FilteredClassPath ... files) throws IOException {
            return this.addLibraryFiles(Arrays.asList(files));
        }

        public Builder addLibraryFiles(Collection<FilteredClassPath> files) throws IOException {
            for (FilteredClassPath file : files) {
                this.addClassProvider(file, this.libraryResourceProviders);
            }
            return this;
        }

        public Builder addLibraryFile(FilteredClassPath file) throws IOException {
            this.addClassProvider(file, this.libraryResourceProviders);
            return this;
        }

        public Builder addLibraryResourceProvider(ClassFileResourceProvider provider) {
            this.libraryResourceProviders.add(provider);
            return this;
        }

        public Builder addDexProgramData(byte[] data, Set<String> classDescriptors) {
            this.addProgramResources(ProgramResource.fromBytes(ProgramResource.Kind.DEX, Origin.unknown(), data, classDescriptors));
            return this;
        }

        public Builder addDexProgramData(byte[] data, Set<String> classDescriptors, String primaryClassDescriptor) {
            ProgramResource resource = new ProgramResource(ProgramResource.Kind.DEX, Resource.fromBytes(Origin.unknown(), data), classDescriptors);
            this.programResources.add(resource);
            this.programResourcesMainDescriptor.put(resource, primaryClassDescriptor);
            return this;
        }

        public Builder addDexProgramData(byte[] data, Origin origin) {
            this.addProgramResources(ProgramResource.fromBytes(ProgramResource.Kind.DEX, origin, data, null));
            return this;
        }

        public Builder addDexProgramData(Collection<byte[]> data) {
            for (byte[] datum : data) {
                this.addProgramResources(ProgramResource.fromBytes(ProgramResource.Kind.DEX, Origin.unknown(), datum, null));
            }
            return this;
        }

        public Builder addClassProgramData(Collection<byte[]> data) {
            for (byte[] datum : data) {
                this.addClassProgramData(datum, Origin.unknown());
            }
            return this;
        }

        public Builder addClassProgramData(byte[] data, Origin origin) {
            return this.addClassProgramData(data, origin, null);
        }

        public Builder addClassProgramData(byte[] data, Origin origin, Set<String> classDescriptors) {
            this.addProgramResources(ProgramResource.fromBytes(ProgramResource.Kind.CF, origin, data, classDescriptors));
            return this;
        }

        public Builder setDeadCode(byte[] content) {
            this.deadCode = content == null ? null : Resource.fromBytes(Origin.unknown(), content);
            return this;
        }

        public Builder setProguardMapFile(Path file) {
            this.proguardMap = file == null ? null : Resource.fromFile(file);
            return this;
        }

        public Builder setProguardMapData(String content) {
            return this.setProguardMapData(content == null ? null : content.getBytes(StandardCharsets.UTF_8));
        }

        public Builder setProguardMapData(byte[] content) {
            this.proguardMap = content == null ? null : Resource.fromBytes(Origin.unknown(), content);
            return this;
        }

        public Builder setProguardSeedsData(byte[] content) {
            this.proguardSeeds = content == null ? null : Resource.fromBytes(Origin.unknown(), content);
            return this;
        }

        public Builder addMainDexListFiles(Path ... files) throws NoSuchFileException {
            return this.addMainDexListFiles(Arrays.asList(files));
        }

        public Builder addMainDexListFiles(Collection<Path> files) throws NoSuchFileException {
            for (Path file : files) {
                if (!Files.exists(file, new LinkOption[0])) {
                    throw new NoSuchFileException(file.toString());
                }
                this.mainDexListResources.add(Resource.fromFile(file));
            }
            return this;
        }

        public Builder addMainDexClasses(String ... classes) {
            return this.addMainDexClasses(Arrays.asList(classes));
        }

        public Builder addMainDexClasses(Collection<String> classes) {
            this.mainDexListClasses.addAll(classes);
            return this;
        }

        public boolean hasMainDexList() {
            return !this.mainDexListResources.isEmpty() || !this.mainDexListClasses.isEmpty();
        }

        public Builder setMainDexListOutputData(byte[] content) {
            this.mainDexListOutput = content == null ? null : Resource.fromBytes(Origin.unknown(), content);
            return this;
        }

        public Builder setIgnoreDexInArchive(boolean value) {
            this.ignoreDexInArchive = value;
            return this;
        }

        public AndroidApp build() {
            return new AndroidApp(ImmutableList.copyOf(this.programResources), ImmutableMap.copyOf(this.programResourcesMainDescriptor), ImmutableList.copyOf(this.programFileArchiveReaders), ImmutableList.copyOf(this.classpathResourceProviders), ImmutableList.copyOf(this.libraryResourceProviders), this.deadCode, this.proguardMap, this.proguardSeeds, this.mainDexListResources, this.mainDexListClasses, this.mainDexListOutput);
        }

        public void addProgramFile(FilteredClassPath filteredClassPath) throws NoSuchFileException {
            Path file = filteredClassPath.getPath();
            if (!Files.exists(file, new LinkOption[0])) {
                throw new NoSuchFileException(file.toString());
            }
            if (FileUtils.isDexFile(file)) {
                this.addProgramResources(ProgramResource.fromFile(ProgramResource.Kind.DEX, file));
            } else if (FileUtils.isClassFile(file)) {
                this.addProgramResources(ProgramResource.fromFile(ProgramResource.Kind.CF, file));
            } else if (FileUtils.isArchive(file)) {
                this.programFileArchiveReaders.add(new ProgramFileArchiveReader(filteredClassPath, this.ignoreDexInArchive));
            } else {
                throw new CompilationError("Unsupported source file type", new PathOrigin(file));
            }
        }

        private void addProgramResources(ProgramResource ... resources) {
            this.addProgramResources(Arrays.asList(resources));
        }

        private void addProgramResources(Collection<ProgramResource> resources) {
            this.programResources.addAll(resources);
        }

        private void addClassProvider(FilteredClassPath classPath, List<ClassFileResourceProvider> providerList) throws IOException {
            Path file = classPath.getPath();
            if (!Files.exists(file, new LinkOption[0])) {
                throw new NoSuchFileException(file.toString());
            }
            if (FileUtils.isArchive(file)) {
                providerList.add(ArchiveClassFileProvider.fromArchive(classPath));
            } else if (Files.isDirectory(file, new LinkOption[0])) {
                assert (classPath.isUnfiltered());
                providerList.add(DirectoryClassFileProvider.fromDirectory(file));
            } else {
                throw new CompilationError("Unsupported source file type", new PathOrigin(file));
            }
        }
    }
}

