/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.utils.FileSystemOutputSink;
import com.android.tools.r8.utils.InternalOptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipFileOutputSink
extends FileSystemOutputSink {
    private final ZipOutputStream outputStream;

    public ZipFileOutputSink(Path outputPath, InternalOptions options) throws IOException {
        super(options);
        this.outputStream = new ZipOutputStream(Files.newOutputStream(outputPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
    }

    @Override
    public void writeDexFile(byte[] contents, Set<String> classDescriptors, int fileId) throws IOException {
        this.writeToZipFile(this.getOutputFileName(fileId), contents);
    }

    @Override
    public void writeDexFile(byte[] contents, Set<String> classDescriptors, String primaryClassName) throws IOException {
        this.writeToZipFile(this.getOutputFileName(primaryClassName, ".dex"), contents);
    }

    @Override
    public void writeClassFile(byte[] contents, Set<String> classDescriptors, String primaryClassName) throws IOException {
        this.writeToZipFile(this.getOutputFileName(primaryClassName, ".class"), contents);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    private synchronized void writeToZipFile(String outputPath, byte[] content) throws IOException {
        CRC32 crc = new CRC32();
        crc.update(content);
        ZipEntry zipEntry = new ZipEntry(outputPath);
        zipEntry.setMethod(0);
        zipEntry.setSize(content.length);
        zipEntry.setCompressedSize(content.length);
        zipEntry.setCrc(crc.getValue());
        this.outputStream.putNextEntry(zipEntry);
        this.outputStream.write(content);
        this.outputStream.closeEntry();
    }
}

