/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.shaking.FilteredClassPath;
import com.android.tools.r8.utils.AbortException;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.DefaultDiagnosticsHandler;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

abstract class BaseCommand {
    private final boolean printHelp;
    private final boolean printVersion;
    private final AndroidApp app;

    BaseCommand(boolean printHelp, boolean printVersion) {
        this.printHelp = printHelp;
        this.printVersion = printVersion;
        this.app = null;
    }

    BaseCommand(AndroidApp app) {
        assert (app != null);
        this.app = app;
        this.printHelp = false;
        this.printVersion = false;
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    AndroidApp getInputApp() {
        return this.app;
    }

    abstract InternalOptions getInternalOptions();

    public static abstract class Builder<C extends BaseCommand, B extends Builder<C, B>> {
        protected final Reporter reporter;
        private boolean printHelp = false;
        private boolean printVersion = false;
        private final AndroidApp.Builder app;
        protected List<Path> programFiles = new ArrayList<Path>();

        protected Builder() {
            this(AndroidApp.builder(), new DefaultDiagnosticsHandler());
        }

        protected Builder(DiagnosticsHandler handler) {
            this(AndroidApp.builder(), handler);
        }

        protected Builder(AndroidApp.Builder builder) {
            this(builder, new DefaultDiagnosticsHandler());
        }

        protected Builder(AndroidApp.Builder builder, DiagnosticsHandler handler) {
            this.app = builder;
            this.reporter = new Reporter(handler);
        }

        abstract B self();

        public final C build() throws CompilationFailedException {
            try {
                this.validate();
                C c = this.makeCommand();
                this.reporter.failIfPendingErrors();
                return c;
            }
            catch (AbortException e) {
                throw new CompilationFailedException(e);
            }
        }

        protected abstract C makeCommand();

        AndroidApp.Builder getAppBuilder() {
            return this.app;
        }

        public B addProgramFiles(Path ... files) {
            this.addProgramFiles(Arrays.asList(files));
            return this.self();
        }

        Reporter getReporter() {
            return this.reporter;
        }

        public B addProgramFiles(Collection<Path> files) {
            this.guard(() -> files.forEach(path -> {
                try {
                    this.app.addProgramFile(FilteredClassPath.unfiltered(path));
                    this.programFiles.add((Path)path);
                }
                catch (CompilationError | IOException e) {
                    this.error("Error with input file: ", (Path)path, e);
                }
            }));
            return this.self();
        }

        public B addLibraryResourceProvider(ClassFileResourceProvider provider) {
            this.guard(() -> this.getAppBuilder().addLibraryResourceProvider(provider));
            return this.self();
        }

        public B addLibraryFiles(Path ... files) {
            this.addLibraryFiles(Arrays.asList(files));
            return this.self();
        }

        public B addLibraryFiles(Collection<Path> files) {
            this.guard(() -> files.forEach(path -> {
                try {
                    this.app.addLibraryFile(FilteredClassPath.unfiltered(path));
                }
                catch (CompilationError | IOException e) {
                    this.error("Error with library file: ", (Path)path, e);
                }
            }));
            return this.self();
        }

        public B addClassProgramData(byte[] data, Origin origin) {
            this.guard(() -> this.app.addClassProgramData(data, origin));
            return this.self();
        }

        public B addDexProgramData(byte[] data, Origin origin) {
            this.guard(() -> this.app.addDexProgramData(data, origin));
            return this.self();
        }

        public B addMainDexListFiles(Path ... files) {
            this.guard(() -> {
                try {
                    this.app.addMainDexListFiles(files);
                }
                catch (NoSuchFileException e) {
                    this.reporter.error(new StringDiagnostic("Main-dex-list file does not exist", new PathOrigin(Paths.get(e.getFile(), new String[0]))));
                }
            });
            return this.self();
        }

        public B addMainDexListFiles(Collection<Path> files) {
            this.guard(() -> {
                try {
                    this.app.addMainDexListFiles(files);
                }
                catch (NoSuchFileException e) {
                    this.reporter.error(new StringDiagnostic("Main-dex-ist file does not exist", new PathOrigin(Paths.get(e.getFile(), new String[0]))));
                }
            });
            return this.self();
        }

        public B addMainDexClasses(String ... classes) {
            this.guard(() -> this.app.addMainDexClasses(classes));
            return this.self();
        }

        public B addMainDexClasses(Collection<String> classes) {
            this.guard(() -> this.app.addMainDexClasses(classes));
            return this.self();
        }

        public boolean isPrintHelp() {
            return this.printHelp;
        }

        public B setPrintHelp(boolean printHelp) {
            this.printHelp = printHelp;
            return this.self();
        }

        public boolean isPrintVersion() {
            return this.printVersion;
        }

        public B setPrintVersion(boolean printVersion) {
            this.printVersion = printVersion;
            return this.self();
        }

        protected B setIgnoreDexInArchive(boolean value) {
            this.guard(() -> this.app.setIgnoreDexInArchive(value));
            return this.self();
        }

        protected void validate() {
        }

        protected void error(String baseMessage, Path path, Throwable throwable) {
            this.reporter.error(new StringDiagnostic(baseMessage + throwable.getMessage(), new PathOrigin(path)), throwable);
        }

        protected void guard(Runnable action) {
            try {
                action.run();
            }
            catch (CompilationError e) {
                this.reporter.error(e);
            }
            catch (AbortException abortException) {
                // empty catch block
            }
        }
    }
}

