/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.com.google.common.collect.ObjectArrays;
import com.android.tools.r8.dex.FileWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.dex.VirtualFile;
import com.android.tools.r8.errors.DexOverflowException;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationDirectory;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexAnnotationSetRefList;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexEncodedArray;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.ProguardMapSupplier;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ApplicationWriter {
    public final DexApplication application;
    public final String deadCode;
    public final NamingLens namingLens;
    public final String proguardSeedsData;
    public final InternalOptions options;
    public DexString markerString;
    public final ProguardMapSupplier proguardMapSupplier;

    public ApplicationWriter(DexApplication application, InternalOptions options, Marker marker, String deadCode, NamingLens namingLens, String proguardSeedsData, ProguardMapSupplier proguardMapSupplier) {
        assert (application != null);
        this.application = application;
        assert (options != null);
        this.options = options;
        this.markerString = marker == null ? null : application.dexItemFactory.createString(marker.toString());
        this.deadCode = deadCode;
        this.namingLens = namingLens;
        this.proguardSeedsData = proguardSeedsData;
        this.proguardMapSupplier = proguardMapSupplier;
    }

    private Iterable<VirtualFile> distribute() throws ExecutionException, IOException, DexOverflowException {
        VirtualFile.Distributor distributor = this.options.isGeneratingDexFilePerClassFile() ? new VirtualFile.FilePerInputClassDistributor(this) : (!this.options.canUseMultidex() && this.options.mainDexKeepRules.isEmpty() && this.application.mainDexList.isEmpty() ? new VirtualFile.MonoDexDistributor(this, this.options) : new VirtualFile.FillFilesDistributor(this, this.options));
        return ((VirtualFile.Distributor)distributor).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ExecutorService executorService) throws IOException, ExecutionException, DexOverflowException {
        this.application.timing.begin("DexApplication.write");
        try {
            this.insertAttributeAnnotations();
            this.application.dexItemFactory.sort(this.namingLens);
            assert (this.markerString == null || this.application.dexItemFactory.extractMarker() != null);
            SortAnnotations sortAnnotations = new SortAnnotations();
            this.application.classes().forEach(clazz -> clazz.addDependencies(sortAnnotations));
            LinkedHashMap<VirtualFile, Future<ObjectToOffsetMapping>> offsetMappingFutures = new LinkedHashMap<VirtualFile, Future<ObjectToOffsetMapping>>();
            for (VirtualFile virtualFile : this.distribute()) {
                assert (!virtualFile.isEmpty());
                if (virtualFile.isEmpty()) continue;
                offsetMappingFutures.put(virtualFile, executorService.submit(() -> {
                    ObjectToOffsetMapping mapping = virtualFile.computeMapping(this.application);
                    ApplicationWriter.rewriteCodeWithJumboStrings(mapping, virtualFile.classes(), this.application);
                    return mapping;
                }));
            }
            ThreadUtils.awaitFutures(offsetMappingFutures.values());
            ArrayList<Future<Boolean>> dexDataFutures = new ArrayList<Future<Boolean>>();
            try {
                for (VirtualFile virtualFile : offsetMappingFutures.keySet()) {
                    assert (!virtualFile.isEmpty());
                    ObjectToOffsetMapping mapping = (ObjectToOffsetMapping)((Future)offsetMappingFutures.get(virtualFile)).get();
                    dexDataFutures.add(executorService.submit(() -> {
                        byte[] result = this.writeDexFile(mapping);
                        if (virtualFile.getPrimaryClassDescriptor() != null) {
                            this.options.getDexFilePerClassFileConsumer().accept(virtualFile.getPrimaryClassDescriptor(), result, virtualFile.getClassDescriptors(), this.options.reporter);
                        } else {
                            this.options.getDexIndexedConsumer().accept(virtualFile.getId(), result, virtualFile.getClassDescriptors(), this.options.reporter);
                        }
                        return true;
                    }));
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted while waiting for future.", interruptedException);
            }
            offsetMappingFutures.clear();
            ThreadUtils.awaitFutures(dexDataFutures);
            this.options.reporter.failIfPendingErrors();
            if (this.options.usageInformationConsumer != null && this.deadCode != null) {
                ExceptionUtils.withConsumeResourceHandler(this.options.reporter, this.options.usageInformationConsumer, this.deadCode);
            }
            if (this.proguardMapSupplier != null && this.options.proguardMapConsumer != null) {
                ExceptionUtils.withConsumeResourceHandler(this.options.reporter, this.options.proguardMapConsumer, this.proguardMapSupplier.get());
            }
            if (this.options.proguardSeedsConsumer != null && this.proguardSeedsData != null) {
                ExceptionUtils.withConsumeResourceHandler(this.options.reporter, this.options.proguardSeedsConsumer, this.proguardSeedsData);
            }
            if (this.options.mainDexListConsumer != null) {
                ExceptionUtils.withConsumeResourceHandler(this.options.reporter, this.options.mainDexListConsumer, this.writeMainDexList());
            }
        }
        finally {
            this.application.timing.end();
        }
    }

    private void insertAttributeAnnotations() {
        for (DexProgramClass clazz : this.application.classes()) {
            EnclosingMethodAttribute enclosingMethod = clazz.getEnclosingMethod();
            List<InnerClassAttribute> innerClasses = clazz.getInnerClasses();
            if (enclosingMethod == null && innerClasses.isEmpty()) continue;
            ArrayList<DexAnnotation> annotations = new ArrayList<DexAnnotation>(1 + innerClasses.size());
            if (enclosingMethod != null) {
                if (enclosingMethod.getEnclosingMethod() != null) {
                    annotations.add(DexAnnotation.createEnclosingMethodAnnotation(enclosingMethod.getEnclosingMethod(), this.options.itemFactory));
                } else {
                    annotations.add(DexAnnotation.createEnclosingClassAnnotation(enclosingMethod.getEnclosingClass(), this.options.itemFactory));
                }
            }
            if (!innerClasses.isEmpty()) {
                ArrayList<DexType> memberClasses = new ArrayList<DexType>(innerClasses.size());
                for (InnerClassAttribute innerClass : innerClasses) {
                    if (clazz.type == innerClass.getInner()) {
                        if (enclosingMethod == null && (innerClass.getOuter() == null || innerClass.isAnonymous())) {
                            this.options.warningMissingEnclosingMember(clazz.type, clazz.origin, clazz.getClassFileVersion());
                            continue;
                        }
                        annotations.add(DexAnnotation.createInnerClassAnnotation(innerClass.getInnerName(), innerClass.getAccess(), this.options.itemFactory));
                        if (innerClass.getOuter() == null || !innerClass.isNamed()) continue;
                        annotations.add(DexAnnotation.createEnclosingClassAnnotation(innerClass.getOuter(), this.options.itemFactory));
                        continue;
                    }
                    if (clazz.type != innerClass.getOuter() || !innerClass.isNamed()) continue;
                    memberClasses.add(innerClass.getInner());
                }
                if (!memberClasses.isEmpty()) {
                    annotations.add(DexAnnotation.createMemberClassesAnnotation(memberClasses, this.options.itemFactory));
                }
            }
            if (!annotations.isEmpty()) {
                DexAnnotation[] copy = ObjectArrays.concat(clazz.annotations.annotations, annotations.toArray(new DexAnnotation[annotations.size()]), DexAnnotation.class);
                clazz.annotations = new DexAnnotationSet(copy);
            }
            clazz.clearEnclosingMethod();
            clazz.clearInnerClasses();
        }
    }

    private static void rewriteCodeWithJumboStrings(ObjectToOffsetMapping mapping, Collection<DexProgramClass> classes, DexApplication application) {
        if (!mapping.hasJumboStrings()) {
            return;
        }
        if (application.highestSortingString != null && application.highestSortingString.slowCompareTo(mapping.getFirstJumboString()) < 0) {
            return;
        }
        for (DexProgramClass clazz : classes) {
            clazz.forEachMethod(method -> method.rewriteCodeWithJumboStrings(mapping, application));
        }
    }

    private byte[] writeDexFile(ObjectToOffsetMapping mapping) throws ApiLevelException {
        FileWriter fileWriter = new FileWriter(mapping, this.application, this.options, this.namingLens);
        fileWriter.collect();
        return fileWriter.generate();
    }

    private String mapMainDexListName(DexType type) {
        return DescriptorUtils.descriptorToJavaType(this.namingLens.lookupDescriptor(type).toString()).replace('.', '/') + ".class";
    }

    private String writeMainDexList() {
        StringBuilder builder = new StringBuilder();
        this.application.mainDexList.forEach(type -> builder.append(this.mapMainDexListName((DexType)type)).append('\n'));
        return builder.toString();
    }

    private static class SortAnnotations
    extends MixedSectionCollection {
        private SortAnnotations() {
        }

        @Override
        public boolean add(DexAnnotationSet dexAnnotationSet) {
            dexAnnotationSet.sort();
            return true;
        }

        @Override
        public boolean add(DexAnnotation annotation) {
            annotation.annotation.sort();
            return true;
        }

        @Override
        public boolean add(DexEncodedArray dexEncodedArray) {
            for (DexValue value : dexEncodedArray.values) {
                value.sort();
            }
            return true;
        }

        @Override
        public boolean add(DexProgramClass dexClassData) {
            return true;
        }

        @Override
        public boolean add(DexCode dexCode) {
            return true;
        }

        @Override
        public boolean add(DexDebugInfo dexDebugInfo) {
            return true;
        }

        @Override
        public boolean add(DexTypeList dexTypeList) {
            return true;
        }

        @Override
        public boolean add(DexAnnotationSetRefList annotationSetRefList) {
            return true;
        }

        @Override
        public boolean setAnnotationsDirectoryForClass(DexProgramClass clazz, DexAnnotationDirectory annotationDirectory) {
            return true;
        }
    }
}

