/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.InvokeStaticRange;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InvokeStatic
extends InvokeMethod {
    public InvokeStatic(DexMethod target, Value result, List<Value> arguments) {
        super(target, result, arguments);
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.STATIC;
    }

    @Override
    protected String getTypeString() {
        return "Static";
    }

    @Override
    public DexEncodedMethod computeSingleTarget(AppInfoWithSubtyping appInfo) {
        return appInfo.lookupStaticTarget(this.getInvokedMethod());
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokeStaticRange(firstRegister, argumentRegisters, this.getInvokedMethod());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new com.android.tools.r8.code.InvokeStatic(argumentRegistersCount, this.getInvokedMethod(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isInvokeStatic()) {
            return false;
        }
        return super.identicalNonValueNonPositionParts(other);
    }

    @Override
    public boolean isInvokeStatic() {
        return true;
    }

    @Override
    public InvokeStatic asInvokeStatic() {
        return this;
    }

    @Override
    public DexEncodedMethod lookupSingleTarget(AppInfoWithSubtyping appInfo) {
        DexMethod method = this.getInvokedMethod();
        return appInfo.lookupStaticTarget(method);
    }

    @Override
    public Collection<DexEncodedMethod> lookupTargets(AppInfoWithSubtyping appInfo) {
        DexEncodedMethod target = appInfo.lookupStaticTarget(this.getInvokedMethod());
        return target == null ? Collections.emptyList() : Collections.singletonList(target);
    }

    @Override
    public Inliner.Constraint inliningConstraint(AppInfoWithSubtyping info, DexType holder) {
        return this.inliningConstraintForSinlgeTargetInvoke(info, holder);
    }

    @Override
    public Inliner.InlineAction computeInlining(InliningOracle decider) {
        return decider.computeForInvokeStatic(this);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfInvoke(184, this.getInvokedMethod()));
    }
}

