/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.cf.CfRegisterAllocator;
import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfNop;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Load;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.Store;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class CfBuilder {
    private final DexItemFactory factory;
    private final DexEncodedMethod method;
    private final IRCode code;
    private Map<Value, DexType> types;
    private Map<BasicBlock, CfLabel> labels;
    private Set<CfLabel> emittedLabels;
    private List<CfInstruction> instructions;
    private CfRegisterAllocator registerAllocator;
    private Position currentPosition = Position.none();
    private Int2ReferenceMap<DebugLocalInfo> emittedLocals = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
    private Int2ReferenceMap<DebugLocalInfo> pendingLocals = null;
    private boolean pendingLocalChanges = false;
    private List<CfCode.LocalVariableInfo> localVariablesTable = new ArrayList<CfCode.LocalVariableInfo>();
    private Int2ReferenceMap<CfCode.LocalVariableInfo> openLocalVariables = new Int2ReferenceOpenHashMap<CfCode.LocalVariableInfo>();

    public CfBuilder(DexEncodedMethod method, IRCode code, DexItemFactory factory) {
        this.method = method;
        this.code = code;
        this.factory = factory;
    }

    public Code build(CodeRewriter rewriter, InternalOptions options) {
        try {
            this.types = new TypeVerificationHelper(this.code, this.factory).computeVerificationTypes();
            this.splitExceptionalBlocks();
            LoadStoreHelper loadStoreHelper = new LoadStoreHelper(this.code, this.types);
            loadStoreHelper.insertLoadsAndStores();
            DeadCodeRemover.removeDeadCode(this.code, rewriter, options);
            this.removeUnneededLoadsAndStores();
            this.registerAllocator = new CfRegisterAllocator(this.code, options);
            this.registerAllocator.allocateRegisters();
            loadStoreHelper.insertPhiMoves(this.registerAllocator);
            CodeRewriter.collapsTrivialGotos(this.method, this.code);
            CfCode code = this.buildCfCode();
            return code;
        }
        catch (Unimplemented e) {
            System.out.println("Incomplete CF construction: " + e.getMessage());
            return this.method.getCode().asJarCode();
        }
    }

    private void splitExceptionalBlocks() {
        ListIterator<BasicBlock> it = this.code.listIterator();
        while (it.hasNext()) {
            Instruction instruction;
            BasicBlock block = it.next();
            if (!block.hasCatchHandlers()) continue;
            int size = block.getInstructions().size();
            boolean isThrow = block.exit().isThrow();
            if (isThrow && size == 1 || !isThrow && size == 2) continue;
            InstructionListIterator instructions = block.listIterator();
            boolean hasOutValues = false;
            while (instructions.hasNext() && !(instruction = (Instruction)instructions.next()).instructionTypeCanThrow()) {
                hasOutValues |= instruction.outValue() != null;
            }
            if (!hasOutValues) continue;
            instructions.previous();
            instructions.split(this.code, it);
        }
    }

    private void removeUnneededLoadsAndStores() {
        ListIterator<BasicBlock> blockIterator = this.code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = (BasicBlock)blockIterator.next();
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction load;
                Instruction store = (Instruction)it.next();
                if (!(store instanceof Store) || store.outValue().numberOfAllUsers() != 1 || !((load = it.peekNext()) instanceof Load) || load.inValues().get(0) != store.outValue()) continue;
                Value storeIn = store.inValues().get(0);
                Value loadOut = load.outValue();
                loadOut.replaceUsers(storeIn);
                storeIn.removeUser(store);
                store.outValue().removeUser(load);
                it.previous();
                it.remove();
                it.next();
                it.remove();
                it.previous();
            }
        }
    }

    private CfCode buildCfCode() {
        BasicBlock nextBlock;
        Stack stack = new Stack();
        ArrayList<CfTryCatch> tryCatchRanges = new ArrayList<CfTryCatch>();
        this.labels = new HashMap<BasicBlock, CfLabel>(this.code.blocks.size());
        this.emittedLabels = new HashSet<CfLabel>(this.code.blocks.size());
        this.instructions = new ArrayList<CfInstruction>();
        ListIterator<BasicBlock> blockIterator = this.code.listIterator();
        BasicBlock block = (BasicBlock)blockIterator.next();
        CfLabel tryCatchStart = null;
        CatchHandlers<BasicBlock> tryCatchHandlers = CatchHandlers.EMPTY_BASIC_BLOCK;
        do {
            CatchHandlers<BasicBlock> handlers;
            if (!tryCatchHandlers.equals(handlers = block.getCatchHandlers())) {
                if (!tryCatchHandlers.isEmpty()) {
                    CfLabel tryCatchEnd = this.getLabel(block);
                    tryCatchRanges.add(new CfTryCatch(tryCatchStart, tryCatchEnd, tryCatchHandlers, this));
                    this.emitLabel(tryCatchEnd);
                }
                if (!handlers.isEmpty()) {
                    tryCatchStart = this.getLabel(block);
                    this.emitLabel(tryCatchStart);
                }
                tryCatchHandlers = handlers;
            }
            nextBlock = blockIterator.hasNext() ? (BasicBlock)blockIterator.next() : null;
            boolean fallthrough = block.exit().isGoto() && block.exit().asGoto().getTarget() == nextBlock;
            Int2ReferenceMap<DebugLocalInfo> locals = block.getLocalsAtEntry();
            if (locals == null) {
                assert (this.pendingLocals == null);
            } else {
                this.pendingLocals = new Int2ReferenceOpenHashMap<DebugLocalInfo>(locals);
                this.pendingLocalChanges = true;
            }
            this.buildCfInstructions(block, fallthrough, stack);
            if (nextBlock == null || fallthrough && nextBlock.getPredecessors().size() <= 1) continue;
            assert (stack.isEmpty());
            this.emitLabel(this.getLabel(nextBlock));
            if (nextBlock.getPredecessors().size() <= 1) continue;
            this.addFrame(nextBlock, Collections.emptyList());
        } while ((block = nextBlock) != null);
        assert (stack.isEmpty());
        CfLabel endLabel = this.ensureLabel();
        for (CfCode.LocalVariableInfo info : this.openLocalVariables.values()) {
            info.setEnd(endLabel);
            this.localVariablesTable.add(info);
        }
        return new CfCode(this.method.method, stack.maxHeight, this.registerAllocator.registersUsed(), this.instructions, tryCatchRanges, this.localVariablesTable);
    }

    private void buildCfInstructions(BasicBlock block, boolean fallthrough, Stack stack) {
        InstructionIterator it = block.iterator();
        while (it.hasNext()) {
            Position position;
            CfLabel label;
            Value outValue;
            Instruction instruction = (Instruction)it.next();
            if (fallthrough && instruction.isGoto()) {
                assert (block.exit() == instruction);
                return;
            }
            for (int i = instruction.inValues().size() - 1; i >= 0; --i) {
                if (!(instruction.inValues().get(i) instanceof StackValue)) continue;
                stack.pop(instruction.inValues().get(i));
            }
            if (instruction.outValue() != null && (outValue = instruction.outValue()) instanceof StackValue) {
                stack.push(outValue);
            }
            if (instruction.isDebugLocalsChange()) {
                if (!instruction.asDebugLocalsChange().apply(this.pendingLocals)) continue;
                this.pendingLocalChanges = true;
                continue;
            }
            if (this.localsChanged()) {
                int localIndex;
                Int2ReferenceSortedMap<DebugLocalInfo> ending = DebugLocalInfo.endingLocals(this.emittedLocals, this.pendingLocals);
                Int2ReferenceSortedMap<DebugLocalInfo> starting = DebugLocalInfo.startingLocals(this.emittedLocals, this.pendingLocals);
                assert (!ending.isEmpty() || !starting.isEmpty());
                label = this.ensureLabel();
                for (Int2ReferenceMap.Entry entry : ending.int2ReferenceEntrySet()) {
                    localIndex = entry.getIntKey();
                    CfCode.LocalVariableInfo info = (CfCode.LocalVariableInfo)this.openLocalVariables.remove(localIndex);
                    info.setEnd(label);
                    this.localVariablesTable.add(info);
                    DebugLocalInfo removed = (DebugLocalInfo)this.emittedLocals.remove(localIndex);
                    assert (removed == entry.getValue());
                }
                for (Int2ReferenceMap.Entry entry : starting.int2ReferenceEntrySet()) {
                    localIndex = entry.getIntKey();
                    assert (!this.emittedLocals.containsKey(localIndex));
                    assert (!this.openLocalVariables.containsKey(localIndex));
                    this.openLocalVariables.put(localIndex, new CfCode.LocalVariableInfo(localIndex, (DebugLocalInfo)entry.getValue(), label));
                    this.emittedLocals.put(localIndex, (DebugLocalInfo)entry.getValue());
                }
                this.pendingLocalChanges = false;
            }
            if ((position = instruction.getPosition()).isSome() && position != this.currentPosition) {
                CfInstruction previous = this.getLastInstruction();
                if (instruction.isDebugPosition() && previous instanceof CfPosition) {
                    this.add(new CfNop());
                }
                label = this.ensureLabel();
                this.add(new CfPosition(label, position));
                this.currentPosition = position;
            }
            instruction.buildCf(this);
        }
    }

    private boolean localsChanged() {
        if (!this.pendingLocalChanges) {
            return false;
        }
        this.pendingLocalChanges = !DebugLocalInfo.localsInfoMapsEqual(this.emittedLocals, this.pendingLocals);
        return this.pendingLocalChanges;
    }

    private CfLabel ensureLabel() {
        CfInstruction last = this.getLastInstruction();
        if (last instanceof CfLabel) {
            return (CfLabel)last;
        }
        CfLabel label = new CfLabel();
        this.add(label);
        return label;
    }

    private CfInstruction getLastInstruction() {
        return this.instructions.isEmpty() ? null : this.instructions.get(this.instructions.size() - 1);
    }

    private void addFrame(BasicBlock block, Collection<StackValue> stack) {
        assert (stack.isEmpty());
        Collection<Value> locals = this.registerAllocator.getLocalsAtPosition(block.entry().getNumber());
        Int2ReferenceAVLTreeMap<DexType> mapping = new Int2ReferenceAVLTreeMap<DexType>();
        for (Value local : locals) {
            DexType type;
            switch (local.outType()) {
                case INT: {
                    type = this.factory.intType;
                    break;
                }
                case FLOAT: {
                    type = this.factory.floatType;
                    break;
                }
                case LONG: {
                    type = this.factory.longType;
                    break;
                }
                case DOUBLE: {
                    type = this.factory.doubleType;
                    break;
                }
                case OBJECT: {
                    type = this.types.get(local);
                    break;
                }
                default: {
                    throw new Unreachable("Unexpected local type: " + (Object)((Object)local.outType()) + " for local: " + local);
                }
            }
            mapping.put(this.getLocalRegister(local), type);
        }
        this.instructions.add(new CfFrame(mapping));
    }

    private void emitLabel(CfLabel label) {
        if (!this.emittedLabels.contains(label)) {
            this.emittedLabels.add(label);
            this.instructions.add(label);
        }
    }

    public CfLabel getLabel(BasicBlock target) {
        return this.labels.computeIfAbsent(target, block -> new CfLabel());
    }

    public int getLocalRegister(Value value) {
        return this.registerAllocator.getRegisterForValue(value);
    }

    public void add(CfInstruction instruction) {
        this.instructions.add(instruction);
    }

    public void addArgument(Argument argument) {
    }

    private static class Stack {
        int maxHeight = 0;
        int height = 0;

        private Stack() {
        }

        boolean isEmpty() {
            return this.height == 0;
        }

        void push(Value value) {
            assert (value instanceof StackValue);
            this.height += value.requiredRegisters();
            this.maxHeight = Math.max(this.maxHeight, this.height);
        }

        void pop(Value value) {
            assert (value instanceof StackValue);
            this.height -= value.requiredRegisters();
        }
    }
}

