/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.Resource;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FileUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public final class DirectoryClassFileProvider
implements ClassFileResourceProvider {
    private final Path root;

    public static ClassFileResourceProvider fromDirectory(Path dir) {
        return new DirectoryClassFileProvider(dir.toAbsolutePath());
    }

    private DirectoryClassFileProvider(Path root) {
        this.root = root;
    }

    @Override
    public Set<String> getClassDescriptors() {
        HashSet<String> result = Sets.newHashSet();
        this.collectClassDescriptors(this.root, result);
        return result;
    }

    private void collectClassDescriptors(Path dir, Set<String> result) {
        File[] files;
        File file = dir.toFile();
        if (file.exists() && (files = file.listFiles()) != null) {
            for (File child : files) {
                if (child.isDirectory()) {
                    this.collectClassDescriptors(child.toPath(), result);
                    continue;
                }
                Path relative = this.root.relativize(child.toPath());
                if (!FileUtils.isClassFile(relative)) continue;
                result.add(DescriptorUtils.guessTypeDescriptor(relative));
            }
        }
    }

    @Override
    public ProgramResource getProgramResource(String descriptor) {
        assert (DescriptorUtils.isClassDescriptor(descriptor));
        String classBinaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(descriptor);
        Path file = this.root.resolve(classBinaryName + ".class");
        return Files.exists(file, new LinkOption[0]) && !Files.isDirectory(file, new LinkOption[0]) ? ProgramResource.fromFile(ProgramResource.Kind.CF, file) : null;
    }

    @Override
    @Deprecated
    public Resource getResource(String descriptor) {
        return this.getProgramResource(descriptor);
    }

    public Path getRoot() {
        return this.root;
    }

    public String toString() {
        return "directory(" + this.root + ")";
    }
}

