/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.Invoke;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class AppInfoWithSubtyping
extends AppInfo {
    private Set<DexType> missingClasses = Sets.newIdentityHashSet();
    private final Map<DexType, ImmutableSet<DexType>> subtypeMap = new IdentityHashMap<DexType, ImmutableSet<DexType>>();

    public AppInfoWithSubtyping(DexApplication application) {
        super(application);
        this.populateSubtypeMap(application.asDirect(), application.dexItemFactory);
    }

    protected AppInfoWithSubtyping(AppInfoWithSubtyping previous) {
        super(previous);
        this.missingClasses.addAll(previous.missingClasses);
        this.subtypeMap.putAll(previous.subtypeMap);
        assert (this.app instanceof DirectMappedDexApplication);
    }

    protected AppInfoWithSubtyping(DirectMappedDexApplication application, GraphLense lense) {
        super(application, lense);
        this.populateSubtypeMap(application, this.dexItemFactory);
    }

    private DirectMappedDexApplication getDirectApplication() {
        return (DirectMappedDexApplication)this.app;
    }

    public Iterable<DexLibraryClass> libraryClasses() {
        return this.getDirectApplication().libraryClasses();
    }

    public Set<DexType> getMissingClasses() {
        return Collections.unmodifiableSet(this.missingClasses);
    }

    public ImmutableSet<DexType> subtypes(DexType type) {
        assert (type.isClassType());
        ImmutableSet<DexType> subtypes = this.subtypeMap.get(type);
        return subtypes == null ? ImmutableSet.of() : subtypes;
    }

    private void populateSuperType(Map<DexType, Set<DexType>> map, DexType superType, DexClass baseClass, Function<DexType, DexClass> definitions) {
        Set set;
        if (superType != null && (set = map.computeIfAbsent(superType, ignore -> new HashSet())).add(baseClass.type)) {
            this.populateAllSuperTypes(map, superType, baseClass, definitions);
        }
    }

    private void populateAllSuperTypes(Map<DexType, Set<DexType>> map, DexType holder, DexClass baseClass, Function<DexType, DexClass> definitions) {
        DexClass holderClass = definitions.apply(holder);
        if (holderClass != null) {
            this.populateSuperType(map, holderClass.superType, baseClass, definitions);
            if (holderClass.superType != null) {
                holderClass.superType.addDirectSubtype(holder);
            } else assert (this.dexItemFactory.objectType == holder);
            for (DexType inter : holderClass.interfaces.values) {
                this.populateSuperType(map, inter, baseClass, definitions);
                inter.addInterfaceSubtype(holder);
            }
            if (holderClass.isInterface()) {
                holder.tagAsInteface();
            }
        } else {
            if (!baseClass.isLibraryClass()) {
                this.missingClasses.add(holder);
            }
            if (holder != this.dexItemFactory.objectType) {
                this.dexItemFactory.objectType.addDirectSubtype(holder);
            }
        }
    }

    private void populateSubtypeMap(DirectMappedDexApplication app, DexItemFactory dexItemFactory) {
        dexItemFactory.clearSubtypeInformation();
        dexItemFactory.objectType.tagAsSubtypeRoot();
        IdentityHashMap<DexType, Set<DexType>> map = new IdentityHashMap<DexType, Set<DexType>>();
        for (DexClass dexClass : Iterables.concat(app.classes(), app.libraryClasses())) {
            this.populateAllSuperTypes(map, dexClass.type, dexClass, app::definitionFor);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.subtypeMap.put((DexType)entry.getKey(), ImmutableSet.copyOf((Collection)entry.getValue()));
        }
        assert (DexType.validateLevelsAreCorrect(app::definitionFor, dexItemFactory));
    }

    public DexEncodedMethod lookup(Invoke.Type type, DexMethod target, DexType invocationContext) {
        DexType holder = target.getHolder();
        if (!holder.isClassType()) {
            return null;
        }
        switch (type) {
            case VIRTUAL: {
                return this.lookupSingleVirtualTarget(target);
            }
            case INTERFACE: {
                return this.lookupSingleInterfaceTarget(target);
            }
            case DIRECT: {
                return this.lookupDirectTarget(target);
            }
            case STATIC: {
                return this.lookupStaticTarget(target);
            }
            case SUPER: {
                return this.lookupSuperTarget(target, invocationContext);
            }
        }
        return null;
    }

    public Set<DexEncodedMethod> lookupVirtualTargets(DexMethod method) {
        HashSet<DexEncodedMethod> result = new HashSet<DexEncodedMethod>();
        DexClass root = this.definitionFor(method.holder);
        if (root == null) {
            return null;
        }
        AppInfo.ResolutionResult topTargets = this.resolveMethodOnClass(method.holder, method);
        if (topTargets.asResultOfResolve() == null) {
            return null;
        }
        topTargets.forEachTarget(result::add);
        ImmutableSet<DexType> set = this.subtypes(method.holder);
        if (set != null) {
            for (DexType type : set) {
                DexClass clazz = this.definitionFor(type);
                if (clazz.isInterface()) continue;
                AppInfo.ResolutionResult methods = this.resolveMethodOnClass(type, method);
                methods.forEachTarget(result::add);
            }
        }
        return result;
    }

    public DexEncodedMethod lookupSingleVirtualTarget(DexMethod method) {
        assert (method != null);
        DexClass holder = this.definitionFor(method.holder);
        if (holder == null || holder.isLibraryClass() || holder.isInterface()) {
            return null;
        }
        if (method.isSingleVirtualMethodCached()) {
            return method.getSingleVirtualMethodCache();
        }
        AppInfo.ResolutionResult topMethod = this.resolveMethod(method.holder, method);
        if (!topMethod.hasSingleTarget() || !topMethod.asSingleTarget().isVirtualMethod()) {
            method.setSingleVirtualMethodCache(null);
            return null;
        }
        DexEncodedMethod result = topMethod.asSingleTarget();
        ImmutableSet<DexType> set = this.subtypes(method.holder);
        if (set != null) {
            for (DexType type : set) {
                DexClass clazz = this.definitionFor(type);
                if (clazz.isInterface() || clazz.lookupMethod(method) == null) continue;
                method.setSingleVirtualMethodCache(null);
                return null;
            }
        }
        method.setSingleVirtualMethodCache(result);
        return result;
    }

    private boolean holderIsAbstract(Descriptor<?, ?> desc) {
        DexClass holder = this.definitionFor(desc.getHolder());
        return holder.accessFlags.isAbstract();
    }

    private boolean holderIsInterface(Descriptor<?, ?> desc) {
        DexClass holder = this.definitionFor(desc.getHolder());
        return holder == null || holder.accessFlags.isInterface();
    }

    @Override
    public DexEncodedMethod lookupSuperTarget(DexMethod method, DexType invocationContext) {
        if (!invocationContext.isSubtypeOf(method.holder, this)) {
            DexClass contextClass = this.definitionFor(invocationContext);
            throw new CompilationError("Illegal invoke-super to " + method.toSourceString() + " from class " + invocationContext, contextClass.getOrigin());
        }
        return super.lookupSuperTarget(method, invocationContext);
    }

    public Set<DexEncodedMethod> lookupInterfaceTargets(DexMethod method) {
        AppInfo.ResolutionResult topTarget = this.resolveMethodOnInterface(method.holder, method);
        if (topTarget.asResultOfResolve() == null) {
            return null;
        }
        ImmutableSet<DexType> set = this.subtypes(method.holder);
        if (set == null) {
            return Collections.emptySet();
        }
        HashSet<DexEncodedMethod> result = new HashSet<DexEncodedMethod>();
        for (DexType type : set) {
            DexClass clazz = this.definitionFor(type);
            if (clazz.isInterface()) continue;
            AppInfo.ResolutionResult targetMethods = this.resolveMethodOnClass(type, method);
            targetMethods.forEachTarget(result::add);
        }
        return result;
    }

    public DexEncodedMethod lookupSingleInterfaceTarget(DexMethod method) {
        DexClass holder = this.definitionFor(method.holder);
        if (holder == null || holder.isLibraryClass() || !holder.accessFlags.isInterface()) {
            return null;
        }
        AppInfo.ResolutionResult topTarget = this.resolveMethodOnInterface(method.holder, method);
        if (topTarget.asResultOfResolve() == null) {
            return null;
        }
        DexEncodedMethod result = null;
        ImmutableSet<DexType> set = this.subtypes(method.holder);
        if (set != null) {
            for (DexType type : set) {
                AppInfo.ResolutionResult resolutionResult;
                DexClass clazz = this.definitionFor(type);
                if (clazz.isInterface() || !(resolutionResult = this.resolveMethodOnClass(type, method)).hasSingleTarget()) continue;
                if (result != null && result != resolutionResult.asSingleTarget()) {
                    return null;
                }
                result = resolutionResult.asSingleTarget();
            }
        }
        return result == null || !result.isVirtualMethod() ? null : result;
    }

    @Override
    public void registerNewType(DexType newType, DexType superType) {
        superType.addDirectSubtype(newType);
    }

    @Override
    public boolean hasSubtyping() {
        return true;
    }

    @Override
    public AppInfoWithSubtyping withSubtyping() {
        return this;
    }
}

