/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ArrayTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.NullLatticeElement;
import com.android.tools.r8.ir.analysis.type.PrimitiveArrayTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.Top;
import java.util.function.BiFunction;

public abstract class TypeLatticeElement {
    private final boolean isNullable;

    TypeLatticeElement(boolean isNullable) {
        this.isNullable = isNullable;
    }

    boolean isNullable() {
        return this.isNullable;
    }

    abstract TypeLatticeElement asNullable();

    String isNullableString() {
        return this.isNullable() ? "" : "@NonNull ";
    }

    static TypeLatticeElement join(AppInfoWithSubtyping appInfo, TypeLatticeElement l1, TypeLatticeElement l2) {
        boolean isNullable;
        if (l1.isBottom()) {
            return l2;
        }
        if (l2.isBottom()) {
            return l1;
        }
        if (l1.isTop() || l2.isTop()) {
            return Top.getInstance();
        }
        if (l1 instanceof NullLatticeElement) {
            return l2.asNullable();
        }
        if (l2 instanceof NullLatticeElement) {
            return l1.asNullable();
        }
        if (l1 instanceof PrimitiveTypeLatticeElement) {
            return l2 instanceof PrimitiveTypeLatticeElement ? l1 : Top.getInstance();
        }
        if (l2 instanceof PrimitiveTypeLatticeElement) {
            return Top.getInstance();
        }
        boolean bl = isNullable = l1.isNullable() || l2.isNullable();
        if (l1.getClass() != l2.getClass()) {
            return TypeLatticeElement.objectType(appInfo, isNullable);
        }
        if (l1 instanceof PrimitiveArrayTypeLatticeElement) {
            PrimitiveArrayTypeLatticeElement a1 = (PrimitiveArrayTypeLatticeElement)l1;
            PrimitiveArrayTypeLatticeElement a2 = (PrimitiveArrayTypeLatticeElement)l2;
            if (a1.nesting != a2.nesting) {
                int min = Math.min(a1.nesting, a2.nesting);
                if (min > 1) {
                    return TypeLatticeElement.objectArrayType(appInfo, min - 1, isNullable);
                }
                return TypeLatticeElement.objectType(appInfo, isNullable);
            }
            return l1;
        }
        if (l1 instanceof ArrayTypeLatticeElement) {
            ArrayTypeLatticeElement a1 = (ArrayTypeLatticeElement)l1;
            ArrayTypeLatticeElement a2 = (ArrayTypeLatticeElement)l2;
            if (a1.nesting != a2.nesting) {
                int min = Math.min(a1.nesting, a2.nesting);
                return TypeLatticeElement.objectArrayType(appInfo, min, isNullable);
            }
            if (a1.elementType == a2.elementType) {
                return a1.isNullable() ? a1 : a2;
            }
            if (a1.elementType.isClassType() && a2.elementType.isClassType()) {
                DexType lub = a1.elementType.computeLeastUpperBound(appInfo, a2.elementType);
                return new ArrayTypeLatticeElement(lub, a1.nesting, isNullable);
            }
        }
        if (l1 instanceof ClassTypeLatticeElement) {
            ClassTypeLatticeElement c1 = (ClassTypeLatticeElement)l1;
            ClassTypeLatticeElement c2 = (ClassTypeLatticeElement)l2;
            if (c1.classType == c2.classType) {
                return c1.isNullable() ? c1 : c2;
            }
            DexType lub = c1.classType.computeLeastUpperBound(appInfo, c2.classType);
            return new ClassTypeLatticeElement(lub, isNullable);
        }
        throw new Unreachable("unless a new type lattice is introduced.");
    }

    static BiFunction<TypeLatticeElement, TypeLatticeElement, TypeLatticeElement> joiner(AppInfoWithSubtyping appInfo) {
        return (l1, l2) -> TypeLatticeElement.join(appInfo, l1, l2);
    }

    boolean isTop() {
        return false;
    }

    boolean isBottom() {
        return false;
    }

    static ClassTypeLatticeElement objectType(AppInfo appInfo, boolean isNullable) {
        return new ClassTypeLatticeElement(appInfo.dexItemFactory.objectType, isNullable);
    }

    static ArrayTypeLatticeElement objectArrayType(AppInfo appInfo, int nesting, boolean isNullable) {
        return new ArrayTypeLatticeElement(appInfo.dexItemFactory.objectType, nesting, isNullable);
    }

    public static TypeLatticeElement fromDexType(AppInfoWithSubtyping appInfo, DexType type, boolean isNullable) {
        if (type.isPrimitiveType()) {
            return PrimitiveTypeLatticeElement.getInstance();
        }
        if (type.isPrimitiveArrayType()) {
            return new PrimitiveArrayTypeLatticeElement(type.getNumberOfLeadingSquareBrackets(), isNullable);
        }
        if (type.isClassType()) {
            return new ClassTypeLatticeElement(type, isNullable);
        }
        assert (type.isArrayType());
        return new ArrayTypeLatticeElement(type.toBaseType(appInfo.dexItemFactory), type.getNumberOfLeadingSquareBrackets(), isNullable);
    }

    public static TypeLatticeElement newArray(AppInfoWithSubtyping appInfo, DexType arrayType, boolean isNullable) {
        DexType baseType = arrayType.toBaseType(appInfo.dexItemFactory);
        assert (baseType != arrayType);
        int nesting = arrayType.getNumberOfLeadingSquareBrackets();
        if (baseType.isClassType()) {
            return new ArrayTypeLatticeElement(baseType, nesting, isNullable);
        }
        return TypeLatticeElement.newPrimitiveArray(nesting, isNullable);
    }

    public static TypeLatticeElement newPrimitiveArray(int nesting, boolean isNullable) {
        return new PrimitiveArrayTypeLatticeElement(nesting, isNullable);
    }

    public TypeLatticeElement arrayGet(AppInfoWithSubtyping appInfo) {
        return Top.getInstance();
    }

    public TypeLatticeElement checkCast(AppInfoWithSubtyping appInfo, DexType castType) {
        return TypeLatticeElement.fromDexType(appInfo, castType, this.isNullable());
    }

    public abstract String toString();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TypeLatticeElement otherElement = (TypeLatticeElement)o;
        return otherElement.isNullable() == this.isNullable;
    }

    public int hashCode() {
        return this.isNullable ? 1 : 0;
    }
}

