/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleType;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardMemberType;
import com.android.tools.r8.shaking.ProguardTypeMatcher;

public class ProguardConfigurationUtils {
    public static ProguardKeepRule buildDefaultInitializerKeepRule(DexClass clazz) {
        ProguardKeepRule.Builder builder = ProguardKeepRule.builder();
        builder.setType(ProguardKeepRuleType.KEEP);
        builder.getModifiersBuilder().allowsObfuscation = true;
        builder.getModifiersBuilder().allowsOptimization = true;
        builder.getClassAccessFlags().setPublic();
        builder.setClassType(ProguardClassType.CLASS);
        ProguardClassNameList.Builder classNameListBuilder = ProguardClassNameList.builder();
        classNameListBuilder.addClassName(false, ProguardTypeMatcher.create(clazz.type));
        builder.setClassNames(classNameListBuilder.build());
        if (clazz.hasDefaultInitializer()) {
            ProguardMemberRule.Builder memberRuleBuilder = ProguardMemberRule.builder();
            memberRuleBuilder.setRuleType(ProguardMemberType.INIT);
            memberRuleBuilder.setName("<init>");
            memberRuleBuilder.setArguments(ImmutableList.of());
            builder.getMemberRules().add(memberRuleBuilder.build());
        }
        return builder.build();
    }
}

