/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.code.AddIntLit16;
import com.android.tools.r8.code.AddIntLit8;
import com.android.tools.r8.code.RsubInt;
import com.android.tools.r8.code.RsubIntLit8;
import com.android.tools.r8.code.SubDouble;
import com.android.tools.r8.code.SubDouble2Addr;
import com.android.tools.r8.code.SubFloat;
import com.android.tools.r8.code.SubFloat2Addr;
import com.android.tools.r8.code.SubInt;
import com.android.tools.r8.code.SubInt2Addr;
import com.android.tools.r8.code.SubLong;
import com.android.tools.r8.code.SubLong2Addr;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.ArithmeticBinop;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;

public class Sub
extends ArithmeticBinop {
    public Sub(NumericType type, Value dest, Value left, Value right) {
        super(type, dest, left, right);
    }

    @Override
    public boolean isCommutative() {
        return false;
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateInt(int dest, int left, int right) {
        return new SubInt(dest, left, right);
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateLong(int dest, int left, int right) {
        assert (dest != left + 1);
        assert (dest != right + 1);
        return new SubLong(dest, left, right);
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateFloat(int dest, int left, int right) {
        return new SubFloat(dest, left, right);
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateDouble(int dest, int left, int right) {
        return new SubDouble(dest, left, right);
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateInt2Addr(int left, int right) {
        return new SubInt2Addr(left, right);
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateLong2Addr(int left, int right) {
        return new SubLong2Addr(left, right);
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateFloat2Addr(int left, int right) {
        return new SubFloat2Addr(left, right);
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateDouble2Addr(int left, int right) {
        return new SubDouble2Addr(left, right);
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateIntLit8(int dest, int left, int constant) {
        throw new Unreachable("Unsupported instruction SubIntLit8");
    }

    @Override
    public com.android.tools.r8.code.Instruction CreateIntLit16(int dest, int left, int constant) {
        throw new Unreachable("Unsupported instruction SubIntLit16");
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.asSub().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.ordinal() - other.asSub().type.ordinal();
    }

    @Override
    int foldIntegers(int left, int right) {
        return left - right;
    }

    @Override
    long foldLongs(long left, long right) {
        return left - right;
    }

    @Override
    float foldFloat(float left, float right) {
        return left - right;
    }

    @Override
    double foldDouble(double left, double right) {
        return left - right;
    }

    boolean negativeFitsInDexInstruction(Value value) {
        return this.type == NumericType.INT && value.isConstant() && value.getConstInstruction().asConstNumber().negativeIs16Bit();
    }

    @Override
    int maxInOutValueRegisterSize() {
        if (!this.needsValueInRegister(this.leftValue())) {
            assert (this.fitsInDexInstruction(this.leftValue()));
            ConstNumber left = this.leftValue().getConstInstruction().asConstNumber();
            return left.is8Bit() ? 255 : 15;
        }
        if (!this.needsValueInRegister(this.rightValue())) {
            assert (this.negativeFitsInDexInstruction(this.rightValue()));
            ConstNumber right = this.rightValue().getConstInstruction().asConstNumber();
            return right.negativeIs8Bit() ? 255 : 15;
        }
        return 255;
    }

    @Override
    public boolean needsValueInRegister(Value value) {
        if (this.leftValue() == this.rightValue()) {
            return true;
        }
        if (value == this.leftValue()) {
            return !this.fitsInDexInstruction(value);
        }
        assert (value == this.rightValue());
        return !this.negativeFitsInDexInstruction(value) || this.fitsInDexInstruction(this.leftValue());
    }

    @Override
    public void buildDex(DexBuilder builder) {
        if (this.isTwoAddr(builder.getRegisterAllocator()) || this.type != NumericType.INT) {
            super.buildDex(builder);
            return;
        }
        com.android.tools.r8.code.Instruction instruction = null;
        if (!this.needsValueInRegister(this.leftValue())) {
            assert (this.fitsInDexInstruction(this.leftValue()));
            ConstNumber left = this.leftValue().getConstInstruction().asConstNumber();
            int right = builder.allocatedRegister(this.rightValue(), this.getNumber());
            int dest = builder.allocatedRegister(this.outValue, this.getNumber());
            if (left.is8Bit()) {
                instruction = new RsubIntLit8(dest, right, left.getIntValue());
            } else {
                assert (left.is16Bit());
                instruction = new RsubInt(dest, right, left.getIntValue());
            }
        } else if (!this.needsValueInRegister(this.rightValue())) {
            assert (this.negativeFitsInDexInstruction(this.rightValue()));
            int dest = builder.allocatedRegister(this.outValue, this.getNumber());
            assert (this.needsValueInRegister(this.leftValue()));
            int left = builder.allocatedRegister(this.leftValue(), this.getNumber());
            ConstNumber right = this.rightValue().getConstInstruction().asConstNumber();
            if (right.negativeIs8Bit()) {
                instruction = new AddIntLit8(dest, left, -right.getIntValue());
            } else {
                assert (right.negativeIs16Bit());
                instruction = new AddIntLit16(dest, left, -right.getIntValue());
            }
        } else {
            assert (this.type == NumericType.INT);
            int left = builder.allocatedRegister(this.leftValue(), this.getNumber());
            int right = builder.allocatedRegister(this.rightValue(), this.getNumber());
            int dest = builder.allocatedRegister(this.outValue, this.getNumber());
            instruction = this.CreateInt(dest, left, right);
        }
        builder.add((Instruction)this, instruction);
    }

    @Override
    public boolean isSub() {
        return true;
    }

    @Override
    public Sub asSub() {
        return this;
    }

    @Override
    int getCfOpcode() {
        switch (this.type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return 100;
            }
            case FLOAT: {
                return 102;
            }
            case LONG: {
                return 101;
            }
            case DOUBLE: {
                return 103;
            }
        }
        throw new Unreachable("Unexpected numeric type: " + (Object)((Object)this.type));
    }
}

