/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class ProguardClassNameList {
    public static Builder builder() {
        return new Builder();
    }

    public static ProguardClassNameList emptyList() {
        return new EmptyClassNameList();
    }

    public static ProguardClassNameList singletonList(ProguardTypeMatcher matcher) {
        return new SingleClassNameList(matcher);
    }

    public abstract int size();

    public abstract void writeTo(StringBuilder var1);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.writeTo(builder);
        return builder.toString();
    }

    public abstract List<DexType> asSpecificDexTypes();

    public abstract boolean matches(DexType var1);

    public abstract void forEachTypeMatcher(Consumer<ProguardTypeMatcher> var1);

    private static class MixedClassNameList
    extends ProguardClassNameList {
        private final Object2BooleanMap<ProguardTypeMatcher> classNames;

        private MixedClassNameList(Object2BooleanMap<ProguardTypeMatcher> classNames) {
            this.classNames = classNames;
        }

        @Override
        public int size() {
            return this.classNames.size();
        }

        @Override
        public void writeTo(StringBuilder builder) {
            boolean first = true;
            for (Object2BooleanMap.Entry entry : this.classNames.object2BooleanEntrySet()) {
                if (!first) {
                    builder.append(',');
                }
                if (entry.getBooleanValue()) {
                    builder.append('!');
                }
                builder.append(((ProguardTypeMatcher)entry.getKey()).toString());
                first = false;
            }
        }

        @Override
        public List<DexType> asSpecificDexTypes() {
            return null;
        }

        @Override
        public boolean matches(DexType type) {
            for (Object2BooleanMap.Entry entry : this.classNames.object2BooleanEntrySet()) {
                if (!((ProguardTypeMatcher)entry.getKey()).matches(type)) continue;
                return !entry.getBooleanValue();
            }
            return false;
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            this.classNames.object2BooleanEntrySet().forEach(entry -> consumer.accept((ProguardTypeMatcher)entry.getKey()));
        }
    }

    private static class PositiveClassNameList
    extends ProguardClassNameList {
        private final ImmutableList<ProguardTypeMatcher> classNames;

        private PositiveClassNameList(Collection<ProguardTypeMatcher> classNames) {
            this.classNames = ImmutableList.copyOf(classNames);
        }

        @Override
        public int size() {
            return this.classNames.size();
        }

        @Override
        public void writeTo(StringBuilder builder) {
            boolean first = true;
            for (ProguardTypeMatcher className : this.classNames) {
                if (!first) {
                    builder.append(',');
                }
                builder.append(className);
                first = false;
            }
        }

        @Override
        public List<DexType> asSpecificDexTypes() {
            if (this.classNames.stream().allMatch(k -> k.getSpecificType() != null)) {
                return this.classNames.stream().map(ProguardTypeMatcher::getSpecificType).collect(Collectors.toList());
            }
            return null;
        }

        @Override
        public boolean matches(DexType type) {
            return this.classNames.stream().anyMatch(name -> name.matches(type));
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            this.classNames.forEach(consumer);
        }
    }

    private static class SingleClassNameList
    extends ProguardClassNameList {
        private final ProguardTypeMatcher className;

        private SingleClassNameList(ProguardTypeMatcher className) {
            this.className = className;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void writeTo(StringBuilder builder) {
            builder.append(this.className.toString());
        }

        @Override
        public List<DexType> asSpecificDexTypes() {
            DexType specific = this.className.getSpecificType();
            return specific == null ? null : Collections.singletonList(specific);
        }

        @Override
        public boolean matches(DexType type) {
            return this.className.matches(type);
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            consumer.accept(this.className);
        }
    }

    private static class EmptyClassNameList
    extends ProguardClassNameList {
        private EmptyClassNameList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void writeTo(StringBuilder builder) {
        }

        @Override
        public List<DexType> asSpecificDexTypes() {
            return null;
        }

        @Override
        public boolean matches(DexType type) {
            return false;
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
        }
    }

    public static class Builder {
        private final Object2BooleanMap<ProguardTypeMatcher> matchers = new Object2BooleanArrayMap<ProguardTypeMatcher>();

        private Builder() {
        }

        public Builder addClassName(boolean isNegated, ProguardTypeMatcher className) {
            this.matchers.put(className, isNegated);
            return this;
        }

        ProguardClassNameList build() {
            if (this.matchers.containsValue(true)) {
                return new MixedClassNameList(this.matchers);
            }
            if (this.matchers.size() == 1) {
                return new SingleClassNameList(Iterables.getOnlyElement(this.matchers.keySet()));
            }
            return new PositiveClassNameList(this.matchers.keySet());
        }
    }
}

