/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency.level2;

import com.android.builder.model.MavenCoordinates;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import java.util.Objects;

public abstract class Dependency {
    private final File artifactFile;
    private final MavenCoordinates coordinates;
    private final String name;
    private final String projectPath;

    public Dependency(File artifactFile, MavenCoordinates coordinates, String name, String projectPath) {
        this.artifactFile = artifactFile;
        this.coordinates = coordinates;
        this.name = name;
        this.projectPath = projectPath;
    }

    public Object getAddress() {
        return this.projectPath != null ? this.projectPath : this.coordinates;
    }

    public File getArtifactFile() {
        Preconditions.checkNotNull((Object)this.artifactFile, (Object)"artifactFile should not be null.");
        return this.artifactFile;
    }

    public abstract File getClasspathFile();

    public abstract List<File> getAdditionalClasspath();

    public MavenCoordinates getCoordinates() {
        return this.coordinates;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public boolean isLocal() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        return Objects.equals(this.artifactFile, that.artifactFile) && Objects.equals(this.coordinates, that.coordinates) && Objects.equals(this.name, that.name) && Objects.equals(this.projectPath, that.projectPath);
    }

    public int hashCode() {
        return Objects.hash(this.artifactFile, this.coordinates, this.name, this.projectPath);
    }
}

