/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v2.Aapt2;
import com.android.builder.internal.aapt.v2.Aapt2Daemon$WhenMappings;
import com.android.builder.internal.aapt.v2.Aapt2InternalException;
import com.android.ide.common.res2.CompileResourceRequest;
import com.android.utils.ILogger;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.NotThreadSafe;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H%J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005H%J\u001c\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0006\u0010!\u001a\u00020\u0013J\b\u0010\"\u001a\u00020\u0013H$J\b\u0010#\u001a\u00020\u0013H%R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "Lcom/android/builder/internal/aapt/v2/Aapt2;", "displayName", "", "logger", "Lcom/android/utils/ILogger;", "(Ljava/lang/String;Lcom/android/utils/ILogger;)V", "getDisplayName", "()Ljava/lang/String;", "getLogger", "()Lcom/android/utils/ILogger;", "<set-?>", "Lcom/android/builder/internal/aapt/v2/Aapt2Daemon$State;", "state", "getState", "()Lcom/android/builder/internal/aapt/v2/Aapt2Daemon$State;", "setState", "(Lcom/android/builder/internal/aapt/v2/Aapt2Daemon$State;)V", "checkStarted", "", "compile", "request", "Lcom/android/ide/common/res2/CompileResourceRequest;", "doCompile", "doLink", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "handleError", "", "action", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "link", "shutDown", "startProcess", "stopProcess", "State", "builder"})
@NotThreadSafe
public abstract class Aapt2Daemon
implements Aapt2 {
    @NotNull
    private State state;
    @NotNull
    private final String displayName;
    @NotNull
    private final ILogger logger;

    @NotNull
    public final State getState() {
        return this.state;
    }

    private final void setState(State state) {
        this.state = state;
    }

    private final void checkStarted() {
        switch (Aapt2Daemon$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                this.logger.info("%1$s: starting", new Object[]{this.displayName});
                try {
                    this.startProcess();
                }
                catch (TimeoutException e) {
                    Void void_ = this.handleError("Daemon startup timed out", e);
                    throw null;
                }
                catch (Exception e) {
                    Void void_ = this.handleError("Daemon startup failed", e);
                    throw null;
                }
                this.state = State.RUNNING;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                throw (Throwable)new IllegalStateException("" + this.displayName + ": Cannot restart a shutdown process");
            }
        }
    }

    protected abstract void startProcess();

    @Override
    public void compile(@NotNull CompileResourceRequest request, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.checkStarted();
        try {
            this.doCompile(request, logger);
        }
        catch (TimeoutException e) {
            Void void_ = this.handleError("Compile '" + request.getInputFile() + "' timed out", e);
            throw null;
        }
    }

    protected abstract void doCompile(@NotNull CompileResourceRequest var1, @NotNull ILogger var2) throws TimeoutException;

    @Override
    public void link(@NotNull AaptPackageConfig request, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.checkStarted();
        try {
            this.doLink(request, logger);
        }
        catch (TimeoutException e) {
            Void void_ = this.handleError("Link timed out", e);
            throw null;
        }
    }

    protected abstract void doLink(@NotNull AaptPackageConfig var1, @NotNull ILogger var2) throws TimeoutException;

    public final void shutDown() {
        State state;
        Aapt2Daemon aapt2Daemon = this;
        switch (Aapt2Daemon$WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
            case 1: {
                state = State.SHUTDOWN;
                break;
            }
            case 2: {
                this.logger.info("%1$s: shutdown", new Object[]{this.displayName});
                Aapt2Daemon aapt2Daemon2 = aapt2Daemon;
                try {
                    aapt2Daemon = aapt2Daemon2;
                    this.stopProcess();
                }
                catch (TimeoutException e) {
                    aapt2Daemon = aapt2Daemon2;
                    this.logger.error((Throwable)e, "" + this.displayName + " Failed to shutdown within timeout", new Object[0]);
                }
                state = State.SHUTDOWN;
                break;
            }
            case 3: {
                throw (Throwable)new IllegalStateException("Cannot call shutdown multiple times");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        aapt2Daemon.state = state;
    }

    protected abstract void stopProcess() throws TimeoutException;

    private final Void handleError(String action, Exception exception) {
        Aapt2InternalException aapt2InternalException;
        Aapt2InternalException $receiver = aapt2InternalException = new Aapt2InternalException("" + this.displayName + ": " + action + (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)State.RUNNING)) ? ", attempting to stop daemon.\n" : "\nThis should not happen under normal circumstances, please file an issue if it does."), exception);
        try {
            this.shutDown();
        }
        catch (Exception suppressed) {
            $receiver.addSuppressed(suppressed);
        }
        throw (Throwable)aapt2InternalException;
    }

    @NotNull
    protected final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    protected final ILogger getLogger() {
        return this.logger;
    }

    public Aapt2Daemon(@NotNull String displayName, @NotNull ILogger logger) {
        Intrinsics.checkParameterIsNotNull((Object)displayName, (String)"displayName");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.displayName = displayName;
        this.logger = logger;
        this.state = State.NEW;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2Daemon$State;", "", "(Ljava/lang/String;I)V", "NEW", "RUNNING", "SHUTDOWN", "builder"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NEW;
        public static final /* enum */ State RUNNING;
        public static final /* enum */ State SHUTDOWN;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = NEW = new State();
            stateArray[1] = RUNNING = new State();
            stateArray[2] = SHUTDOWN = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

