/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.jar;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.org.objectweb.asm.Handle;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Type;

public class JarRegisterEffectsVisitor
extends MethodVisitor {
    private final DexType clazz;
    private final UseRegistry registry;
    private final JarApplicationReader application;

    public JarRegisterEffectsVisitor(DexType clazz, UseRegistry registry, JarApplicationReader application) {
        super(393216);
        this.clazz = clazz;
        this.registry = registry;
        this.application = application;
    }

    @Override
    public void visitTypeInsn(int opcode, String name) {
        DexType type = this.application.getTypeFromName(name);
        if (opcode == 187) {
            this.registry.registerNewInstance(type);
        } else {
            this.registry.registerTypeReference(type);
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.registry.registerTypeReference(this.application.getTypeFromDescriptor(desc));
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type) {
            if (((Type)cst).getSort() != 11) {
                this.registry.registerTypeReference(this.application.getType((Type)cst));
            }
        } else if (cst instanceof Handle) {
            this.registerMethodHandleType((Handle)cst);
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        DexType ownerType = this.application.getTypeFromName(owner);
        DexMethod method = this.application.getMethod(ownerType, name, desc);
        switch (opcode) {
            case 182: {
                this.registry.registerInvokeVirtual(method);
                break;
            }
            case 184: {
                this.registry.registerInvokeStatic(method);
                break;
            }
            case 185: {
                this.registry.registerInvokeInterface(method);
                break;
            }
            case 183: {
                if (name.equals("<init>") || ownerType == this.clazz) {
                    this.registry.registerInvokeDirect(method);
                    break;
                }
                this.registry.registerInvokeSuper(method);
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + opcode);
            }
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        DexField field = this.application.getField(owner, name, desc);
        switch (opcode) {
            case 180: {
                this.registry.registerInstanceFieldRead(field);
                break;
            }
            case 181: {
                this.registry.registerInstanceFieldWrite(field);
                break;
            }
            case 178: {
                this.registry.registerStaticFieldRead(field);
                break;
            }
            case 179: {
                this.registry.registerStaticFieldWrite(field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected opcode " + opcode);
            }
        }
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.registerMethodHandleType(bsm);
        for (Object arg : bsmArgs) {
            if (arg instanceof Type && ((Type)arg).getSort() == 10) {
                this.registry.registerTypeReference(this.application.getType((Type)arg));
                continue;
            }
            if (!(arg instanceof Handle)) continue;
            this.registerMethodHandleType((Handle)arg);
        }
    }

    private void registerMethodHandleType(Handle handle) {
        switch (handle.getTag()) {
            case 1: {
                this.visitFieldInsn(180, handle.getOwner(), handle.getName(), handle.getDesc());
                break;
            }
            case 2: {
                this.visitFieldInsn(178, handle.getOwner(), handle.getName(), handle.getDesc());
                break;
            }
            case 3: {
                this.visitFieldInsn(181, handle.getOwner(), handle.getName(), handle.getDesc());
                break;
            }
            case 4: {
                this.visitFieldInsn(179, handle.getOwner(), handle.getName(), handle.getDesc());
                break;
            }
            case 5: {
                this.visitMethodInsn(182, handle.getOwner(), handle.getName(), handle.getDesc(), false);
                break;
            }
            case 9: {
                this.visitMethodInsn(185, handle.getOwner(), handle.getName(), handle.getDesc(), true);
                break;
            }
            case 7: {
                this.visitMethodInsn(183, handle.getOwner(), handle.getName(), handle.getDesc(), false);
                break;
            }
            case 6: {
                this.visitMethodInsn(184, handle.getOwner(), handle.getName(), handle.getDesc(), false);
                break;
            }
            case 8: {
                this.registry.registerNewInstance(this.application.getTypeFromName(handle.getOwner()));
                this.visitMethodInsn(183, handle.getOwner(), handle.getName(), handle.getDesc(), false);
                break;
            }
            default: {
                throw new Unreachable("MethodHandle tag is not supported: " + handle.getTag());
            }
        }
    }
}

