/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.D8DiagnosticsHandler;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.builder.dexing.r8.ClassFileProviderFactory;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.ProgramResource;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Stream;

final class D8DexArchiveBuilder
extends DexArchiveBuilder {
    private static final Logger LOGGER = Logger.getLogger(D8DexArchiveBuilder.class.getName());
    private static final String INVOKE_CUSTOM = "Invoke-customs are only supported starting with Android O";
    private final int minSdkVersion;
    private final CompilationMode compilationMode;
    private final List<Path> bootClasspath;
    private final List<Path> classpath;
    private final ClassFileProviderFactory classFileProviderFactory;
    private final boolean desugaring;
    private final MessageReceiver messageReceiver;

    public D8DexArchiveBuilder(int minSdkVersion, boolean isDebuggable, List<Path> bootClasspath, List<Path> classpath, ClassFileProviderFactory classFileProviderFactory, boolean desugaring, MessageReceiver messageReceiver) {
        this.minSdkVersion = minSdkVersion;
        this.compilationMode = isDebuggable ? CompilationMode.DEBUG : CompilationMode.RELEASE;
        this.bootClasspath = bootClasspath;
        this.classpath = classpath;
        this.classFileProviderFactory = classFileProviderFactory;
        this.desugaring = desugaring;
        this.messageReceiver = messageReceiver;
    }

    @Override
    public void convert(Stream<ClassFileEntry> input, Path output, boolean isIncremental) throws DexArchiveBuilderException {
        InterceptingDiagnosticsHandler d8DiagnosticsHandler = new InterceptingDiagnosticsHandler();
        try (ClassFileProviderFactory.Handler factory = this.classFileProviderFactory.open();){
            D8Command.Builder builder = D8Command.builder(d8DiagnosticsHandler);
            AtomicInteger entryCount = new AtomicInteger();
            input.forEach(entry -> {
                builder.addClassProgramData(D8DexArchiveBuilder.readAllBytes(entry), D8DiagnosticsHandler.getOrigin(entry));
                entryCount.incrementAndGet();
            });
            if (entryCount.get() == 0) {
                return;
            }
            OutputMode outputMode = isIncremental ? OutputMode.DexFilePerClassFile : OutputMode.DexIndexed;
            ((D8Command.Builder)((D8Command.Builder)builder.setMode(this.compilationMode)).setMinApiLevel(this.minSdkVersion)).setIntermediate(true).setOutput(output, outputMode);
            if (this.desugaring) {
                for (Path entry2 : this.bootClasspath) {
                    builder.addLibraryResourceProvider(factory.getProvider(entry2));
                }
                if (!this.classpath.isEmpty()) {
                    ImmutableList.Builder providers = ImmutableList.builder();
                    for (Path entry3 : this.classpath) {
                        providers.add((Object)factory.getProvider(entry3));
                    }
                    builder.addClasspathResourceProvider(new OrderedClassFileResourceProvider((ImmutableList<ClassFileResourceProvider>)providers.build()));
                }
            } else {
                builder.setDisableDesugaring(true);
            }
            D8.run((D8Command)builder.build(), (ExecutorService)MoreExecutors.newDirectExecutorService());
        }
        catch (Throwable e) {
            throw this.getExceptionToRethrow(e, d8DiagnosticsHandler);
        }
    }

    private static byte[] readAllBytes(ClassFileEntry entry) {
        try {
            return entry.readAllBytes();
        }
        catch (IOException ex) {
            throw new DexArchiveBuilderException(ex);
        }
    }

    private DexArchiveBuilderException getExceptionToRethrow(Throwable t, D8DiagnosticsHandler d8DiagnosticsHandler) {
        StringBuilder msg = new StringBuilder();
        msg.append("Error while dexing.");
        for (String hint : d8DiagnosticsHandler.getPendingHints()) {
            msg.append(System.lineSeparator());
            msg.append(hint);
        }
        return new DexArchiveBuilderException(msg.toString(), t);
    }

    private class InterceptingDiagnosticsHandler
    extends D8DiagnosticsHandler {
        public InterceptingDiagnosticsHandler() {
            super(D8DexArchiveBuilder.this.messageReceiver);
        }

        @Override
        protected Message convertToMessage(Message.Kind kind, Diagnostic diagnostic) {
            if (diagnostic.getDiagnosticMessage().startsWith(D8DexArchiveBuilder.INVOKE_CUSTOM)) {
                this.addHint("The dependency contains Java 8 bytecode. Please enable desugaring by adding the following to build.gradle\nandroid {\n    compileOptions {\n        sourceCompatibility 1.8\n        targetCompatibility 1.8\n    }\n}\nSee https://developer.android.com/studio/write/java8-support.html for details. Alternatively, increase the minSdkVersion to 26 or above.\n");
            }
            return super.convertToMessage(kind, diagnostic);
        }
    }

    private static class OrderedClassFileResourceProvider
    implements ClassFileResourceProvider {
        public final List<ClassFileResourceProvider> providers;
        public final Set<String> descriptors = Sets.newHashSet();

        OrderedClassFileResourceProvider(ImmutableList<ClassFileResourceProvider> providers) {
            this.providers = providers;
            this.providers.forEach(provider -> this.descriptors.addAll(provider.getClassDescriptors()));
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.descriptors;
        }

        @Override
        public ProgramResource getProgramResource(String descriptor) {
            for (ClassFileResourceProvider provider : this.providers) {
                if (!provider.getClassDescriptors().contains(descriptor)) continue;
                return provider.getProgramResource(descriptor);
            }
            return null;
        }
    }
}

