/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Bottom;
import com.android.tools.r8.ir.analysis.type.Top;
import com.android.tools.r8.ir.analysis.type.TypeEnvironment;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class TypeAnalysis
implements TypeEnvironment {
    private final AppInfo appInfo;
    private final DexEncodedMethod encodedMethod;
    private final Deque<Value> worklist = new ArrayDeque<Value>();
    private final Map<Value, TypeLatticeElement> typeMap = Maps.newHashMap();
    private static final TypeEnvironment DEFAULT_ENVIRONMENT = new TypeEnvironment(){

        @Override
        public TypeLatticeElement getLatticeElement(Value value) {
            return Top.getInstance();
        }

        @Override
        public DexType getRefinedReceiverType(InvokeMethodWithReceiver invoke) {
            return invoke.getInvokedMethod().holder;
        }

        @Override
        public void analyzeBlocks(List<BasicBlock> blocks) {
        }
    };

    public TypeAnalysis(AppInfo appInfo, DexEncodedMethod encodedMethod, IRCode code) {
        this.appInfo = appInfo;
        this.encodedMethod = encodedMethod;
        this.analyzeBlocks(code.topologicallySortedBlocks());
    }

    @Override
    public void analyzeBlocks(List<BasicBlock> blocks) {
        assert (this.worklist.isEmpty());
        for (BasicBlock block : blocks) {
            this.processBasicBlock(block);
        }
        while (!this.worklist.isEmpty()) {
            this.processValue(this.worklist.poll());
        }
    }

    private void addToWorklist(Value v) {
        assert (v != null);
        if (!this.worklist.contains(v)) {
            this.worklist.add(v);
        }
    }

    private void processBasicBlock(BasicBlock block) {
        int argumentsSeen = this.encodedMethod.accessFlags.isStatic() ? 0 : -1;
        for (Instruction instruction : block.getInstructions()) {
            Value outValue = instruction.outValue();
            if (instruction.isArgument()) {
                TypeLatticeElement derived;
                if (argumentsSeen < 0) {
                    derived = TypeLatticeElement.fromDexType(this.encodedMethod.method.holder, false);
                } else {
                    DexType argType = this.encodedMethod.method.proto.parameters.values[argumentsSeen];
                    derived = TypeLatticeElement.fromDexType(argType, true);
                }
                ++argumentsSeen;
                assert (outValue != null);
                this.updateTypeOfValue(outValue, derived);
                continue;
            }
            if (outValue == null) continue;
            this.addToWorklist(outValue);
        }
        for (Phi phi : block.getPhis()) {
            this.addToWorklist(phi);
        }
    }

    private void processValue(Value value) {
        TypeLatticeElement derived = value.isPhi() ? this.computePhiType(value.asPhi()) : value.definition.evaluate(this.appInfo, this::getLatticeElement);
        this.updateTypeOfValue(value, derived);
    }

    private void updateTypeOfValue(Value value, TypeLatticeElement type) {
        TypeLatticeElement current = this.getLatticeElement(value);
        if (current.equals(type)) {
            return;
        }
        this.setLatticeElement(value, type);
        for (Instruction instruction : value.uniqueUsers()) {
            Value outValue = instruction.outValue();
            if (outValue == null) continue;
            this.addToWorklist(outValue);
        }
        for (Phi phi : value.uniquePhiUsers()) {
            this.addToWorklist(phi);
        }
    }

    private TypeLatticeElement computePhiType(Phi phi) {
        return TypeLatticeElement.join(this.appInfo, phi.getOperands().stream().map(this::getLatticeElement));
    }

    private void setLatticeElement(Value value, TypeLatticeElement type) {
        this.typeMap.put(value, type);
    }

    @Override
    public TypeLatticeElement getLatticeElement(Value value) {
        return this.typeMap.getOrDefault(value, Bottom.getInstance());
    }

    @Override
    public DexType getRefinedReceiverType(InvokeMethodWithReceiver invoke) {
        DexType refinedType;
        DexType receiverType = invoke.getInvokedMethod().getHolder();
        TypeLatticeElement lattice = this.getLatticeElement(invoke.getReceiver());
        if (lattice.isClassTypeLatticeElement() && (refinedType = lattice.asClassTypeLatticeElement().getClassType()).isSubtypeOf(receiverType, this.appInfo)) {
            return refinedType;
        }
        return receiverType;
    }

    public static TypeEnvironment getDefaultTypeEnvironment() {
        return DEFAULT_ENVIRONMENT;
    }

    @VisibleForTesting
    void forEach(BiConsumer<Value, TypeLatticeElement> consumer) {
        this.typeMap.forEach(consumer);
    }
}

