/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.IOExceptionDiagnostic;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public interface StringConsumer {
    public void accept(String var1, DiagnosticsHandler var2);

    public static EmptyConsumer emptyConsumer() {
        return EmptyConsumer.EMPTY_CONSUMER;
    }

    public static class StreamConsumer
    extends ForwardingConsumer {
        private final Origin origin;
        private final OutputStream outputStream;
        private Charset encoding = StandardCharsets.UTF_8;

        public StreamConsumer(Origin origin, OutputStream outputStream) {
            this(origin, outputStream, null);
        }

        public StreamConsumer(Origin origin, OutputStream outputStream, StringConsumer consumer) {
            super(consumer);
            this.origin = origin;
            this.outputStream = outputStream;
        }

        public void setEncoding(Charset encoding) {
            assert (encoding != null);
            this.encoding = encoding;
        }

        @Override
        public void accept(String string, DiagnosticsHandler handler) {
            super.accept(string, handler);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, this.encoding.newEncoder()));
            try {
                writer.write(string);
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, this.origin));
            }
        }
    }

    public static class FileConsumer
    extends ForwardingConsumer {
        private final Path outputPath;
        private Charset encoding = StandardCharsets.UTF_8;

        public FileConsumer(Path outputPath) {
            this(outputPath, null);
        }

        public FileConsumer(Path outputPath, StringConsumer consumer) {
            super(consumer);
            this.outputPath = outputPath;
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public void setEncoding(Charset encoding) {
            assert (encoding != null);
            this.encoding = encoding;
        }

        public Charset getEncoding() {
            return this.encoding;
        }

        @Override
        public void accept(String string, DiagnosticsHandler handler) {
            super.accept(string, handler);
            try {
                Files.write(this.outputPath, string.getBytes(this.encoding), new OpenOption[0]);
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, new PathOrigin(this.outputPath)));
            }
        }
    }

    public static class ForwardingConsumer
    implements StringConsumer {
        private final StringConsumer consumer;

        public ForwardingConsumer(StringConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(String string, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.accept(string, handler);
            }
        }
    }

    public static class EmptyConsumer
    implements StringConsumer {
        private static final EmptyConsumer EMPTY_CONSUMER = new EmptyConsumer();

        @Override
        public void accept(String string, DiagnosticsHandler handler) {
        }
    }
}

