/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.ImmutableSortedSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Queues;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.CachedHashValueDexItem;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemBasedString;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.naming.IdentifierNameStringUtils;
import com.android.tools.r8.shaking.KeepReason;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationUtils;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ReasonPrinter;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.shaking.ScopedDexMethodSet;
import com.android.tools.r8.shaking.protolite.ProtoLiteExtension;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Enqueuer {
    private boolean tracingMainDex = false;
    private final AppInfoWithSubtyping appInfo;
    private final InternalOptions options;
    private RootSetBuilder.RootSet rootSet;
    private final Map<DexType, Set<DexMethod>> virtualInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<DexMethod>> interfaceInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<TargetWithContext<DexMethod>>> superInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<DexMethod>> directInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<DexMethod>> staticInvokes = Maps.newIdentityHashMap();
    private final Map<DexType, Set<DexField>> instanceFieldsWritten = Maps.newIdentityHashMap();
    private final Map<DexType, Set<DexField>> instanceFieldsRead = Maps.newIdentityHashMap();
    private final Map<DexType, Set<DexField>> staticFieldsRead = Maps.newIdentityHashMap();
    private final Map<DexType, Set<DexField>> staticFieldsWritten = Maps.newIdentityHashMap();
    private final ProtoLiteExtension protoLiteExtension;
    private final Set<DexField> protoLiteFields = Sets.newIdentityHashSet();
    private final Map<DexType, SetWithReason<DexEncodedMethod>> reachableVirtualMethods = Maps.newIdentityHashMap();
    private final Map<DexEncodedMethod, Set<DexEncodedMethod>> superInvokeDependencies = Maps.newIdentityHashMap();
    private final Map<DexType, SetWithReason<DexEncodedField>> reachableInstanceFields = Maps.newIdentityHashMap();
    private final Set<DexType> liveTypes = Sets.newIdentityHashSet();
    private final SetWithReason<DexType> instantiatedTypes = new SetWithReason();
    private final SetWithReason<DexEncodedMethod> targetedMethods = new SetWithReason();
    private final SetWithReason<DexEncodedMethod> liveMethods = new SetWithReason();
    private final SetWithReason<DexEncodedField> liveFields = new SetWithReason();
    private final Queue<Action> workList = Queues.newArrayDeque();
    private final Queue<Action> proguardCompatibilityWorkList = Queues.newArrayDeque();
    private final Set<DexEncodedMethod> pendingProguardReflectiveCompatibility = Sets.newLinkedHashSet();
    private final Set<DexMethod> virtualTargetsMarkedAsReachable = Sets.newIdentityHashSet();
    private final Set<DexItem> reportedMissing = Sets.newIdentityHashSet();
    private final Set<DexItem> pinnedItems = Sets.newIdentityHashSet();
    private final Map<DexType, Set<DexAnnotation>> deferredAnnotations = new IdentityHashMap<DexType, Set<DexAnnotation>>();
    private final ProguardConfiguration.Builder compatibility;

    public Enqueuer(AppInfoWithSubtyping appInfo, InternalOptions options) {
        this(appInfo, options, null, null);
    }

    public Enqueuer(AppInfoWithSubtyping appInfo, InternalOptions options, ProguardConfiguration.Builder compatibility, ProtoLiteExtension protoLiteExtension) {
        this.appInfo = appInfo;
        this.compatibility = compatibility;
        this.options = options;
        this.protoLiteExtension = protoLiteExtension;
    }

    private void enqueueRootItems(Map<DexItem, ProguardKeepRule> items) {
        items.entrySet().forEach(this::enqueueRootItem);
        this.pinnedItems.addAll(items.keySet());
    }

    private void enqueueRootItem(Map.Entry<DexItem, ProguardKeepRule> root) {
        DexItem item = root.getKey();
        KeepReason reason = KeepReason.dueToKeepRule(root.getValue());
        if (item instanceof DexClass) {
            DexClass clazz = (DexClass)item;
            this.workList.add(Action.markInstantiated(clazz, reason));
            if (this.options.forceProguardCompatibility && clazz.hasDefaultInitializer()) {
                ProguardKeepRule rule = ProguardConfigurationUtils.buildDefaultInitializerKeepRule(clazz);
                this.proguardCompatibilityWorkList.add(Action.markMethodLive(clazz.getDefaultInitializer(), KeepReason.dueToProguardCompatibilityKeepRule(rule)));
            }
        } else if (item instanceof DexEncodedField) {
            this.workList.add(Action.markFieldKept((DexEncodedField)item, reason));
        } else if (item instanceof DexEncodedMethod) {
            this.workList.add(Action.markMethodKept((DexEncodedMethod)item, reason));
        } else {
            throw new IllegalArgumentException(item.toString());
        }
    }

    private <S extends DexItem, T extends Descriptor<S, T>> boolean registerItemWithTarget(Map<DexType, Set<T>> seen, T item) {
        DexType holder = item.getHolder();
        if (holder.isArrayType()) {
            holder = holder.toBaseType(this.appInfo.dexItemFactory);
        }
        if (!holder.isClassType()) {
            return false;
        }
        this.markTypeAsLive(holder);
        return seen.computeIfAbsent(item.getHolder(), ignore -> Sets.newIdentityHashSet()).add(item);
    }

    private <S extends DexItem, T extends Descriptor<S, T>> boolean registerItemWithTargetAndContext(Map<DexType, Set<TargetWithContext<T>>> seen, T item, DexEncodedMethod context) {
        DexType holder = item.getHolder();
        if (holder.isArrayType()) {
            holder = holder.toBaseType(this.appInfo.dexItemFactory);
        }
        if (!holder.isClassType()) {
            return false;
        }
        this.markTypeAsLive(holder);
        return seen.computeIfAbsent(item.getHolder(), ignore -> new HashSet()).add(new TargetWithContext(item, context, null));
    }

    private DexMethod getInvokeSuperTarget(DexMethod method, DexEncodedMethod currentMethod) {
        DexClass holderClass = this.appInfo.definitionFor(currentMethod.method.getHolder());
        if (holderClass == null || holderClass.superType == null) {
            return method;
        }
        return this.appInfo.dexItemFactory.createMethod(holderClass.superType, method.proto, method.name);
    }

    private void markTypeAsLive(DexType type) {
        assert (type.isClassType());
        if (this.liveTypes.add(type)) {
            Set<DexAnnotation> annotations;
            DexEncodedMethod clinit;
            DexClass holder = this.appInfo.definitionFor(type);
            if (holder == null) {
                this.reportMissingClass(type);
                return;
            }
            for (DexType iface : holder.interfaces.values) {
                this.markTypeAsLive(iface);
            }
            if (holder.superType != null) {
                this.markTypeAsLive(holder.superType);
                if (holder.isLibraryClass()) {
                    this.ensureFromLibraryOrThrow(holder.superType, type);
                    for (DexType iface : holder.interfaces.values) {
                        this.ensureFromLibraryOrThrow(iface, type);
                    }
                }
            }
            if (!holder.annotations.isEmpty()) {
                this.processAnnotations(holder.annotations.annotations);
            }
            if (!holder.isLibraryClass() && holder.hasNonTrivialClassInitializer() && (clinit = holder.getClassInitializer()) != null) {
                assert (clinit.method.holder == holder.type);
                this.markDirectStaticOrConstructorMethodAsLive(clinit, KeepReason.reachableFromLiveType(type));
            }
            if ((annotations = this.deferredAnnotations.remove(type)) != null) {
                annotations.forEach(this::handleAnnotationOfLiveType);
            }
            if (this.options.forceProguardCompatibility) {
                this.enqueueRootItems(this.rootSet.getDependentItems(type));
            } else {
                this.enqueueRootItems(this.rootSet.getDependentStaticMembers(type));
            }
        }
    }

    private void handleAnnotationOfLiveType(DexAnnotation annotation) {
        AnnotationReferenceMarker referenceMarker = new AnnotationReferenceMarker(annotation.annotation.type, this.appInfo.dexItemFactory);
        annotation.annotation.collectIndexedItems(referenceMarker);
    }

    private void processAnnotations(DexAnnotation[] annotations) {
        for (DexAnnotation annotation : annotations) {
            DexType type = annotation.annotation.type;
            if (this.liveTypes.contains(type)) {
                this.handleAnnotationOfLiveType(annotation);
                continue;
            }
            this.deferredAnnotations.computeIfAbsent(type, ignore -> new HashSet()).add(annotation);
        }
    }

    private void handleInvokeOfStaticTarget(DexMethod method, KeepReason reason) {
        AppInfo.ResolutionResult resolutionResult = this.appInfo.resolveMethod(method.holder, method);
        if (resolutionResult == null) {
            this.reportMissingMethod(method);
            return;
        }
        resolutionResult.forEachTarget(m -> this.markMethodAsTargeted((DexEncodedMethod)m, reason));
        DexEncodedMethod targetMethod = this.appInfo.dispatchStaticInvoke(resolutionResult);
        if (targetMethod != null) {
            this.markDirectStaticOrConstructorMethodAsLive(targetMethod, reason);
        }
    }

    private void handleInvokeOfDirectTarget(DexMethod method, KeepReason reason) {
        AppInfo.ResolutionResult resolutionResult = this.appInfo.resolveMethod(method.holder, method);
        if (resolutionResult == null) {
            this.reportMissingMethod(method);
            return;
        }
        resolutionResult.forEachTarget(m -> this.markMethodAsTargeted((DexEncodedMethod)m, reason));
        DexEncodedMethod target = this.appInfo.dispatchDirectInvoke(resolutionResult);
        if (target != null) {
            this.markDirectStaticOrConstructorMethodAsLive(target, reason);
        }
    }

    private void ensureFromLibraryOrThrow(DexType type, DexType context) {
        if (this.tracingMainDex) {
            return;
        }
        DexClass holder = this.appInfo.definitionFor(type);
        if (holder != null && !holder.isLibraryClass()) {
            StringDiagnostic message = new StringDiagnostic("Library class " + context.toSourceString() + (holder.isInterface() ? " implements " : " extends ") + "program class " + type.toSourceString());
            if (this.options.forceProguardCompatibility) {
                this.options.reporter.warning(message);
            } else {
                this.options.reporter.error(message);
            }
        }
    }

    private void reportMissingClass(DexType clazz) {
    }

    private void reportMissingMethod(DexMethod method) {
    }

    private void reportMissingField(DexField field) {
    }

    private void markMethodAsTargeted(DexEncodedMethod encodedMethod, KeepReason reason) {
        this.markTypeAsLive(encodedMethod.method.holder);
        this.targetedMethods.add(encodedMethod, reason);
        if (this.options.forceProguardCompatibility) {
            DexClass clazz = this.appInfo.definitionFor(encodedMethod.method.holder);
            if (!encodedMethod.accessFlags.isAbstract() && clazz.isInterface() && !clazz.isLibraryClass()) {
                this.markMethodAsKeptWithCompatRule(encodedMethod);
            }
        }
    }

    private void processNewlyInstantiatedClass(DexClass clazz, KeepReason reason) {
        if (!this.instantiatedTypes.add(clazz.type, reason)) {
            return;
        }
        this.collectProguardCompatibilityRule(reason);
        this.markTypeAsLive(clazz.type);
        this.transitionMethodsForInstantiatedClass(clazz.type);
        this.transitionFieldsForInstantiatedClass(clazz.type);
        this.enqueueRootItems(this.rootSet.getDependentItems(clazz.type));
    }

    private void transitionMethodsForInstantiatedClass(DexType instantiatedType) {
        DexClass clazz;
        ScopedDexMethodSet seen = new ScopedDexMethodSet();
        Set<DexType> interfaces = Sets.newIdentityHashSet();
        DexType type = instantiatedType;
        do {
            if ((clazz = this.appInfo.definitionFor(type)) == null) {
                this.reportMissingClass(type);
                break;
            }
            SetWithReason<DexEncodedMethod> reachableMethods = this.reachableVirtualMethods.get(type);
            if (reachableMethods != null) {
                this.transitionNonAbstractMethodsToLiveAndShadow(reachableMethods.getItems(), instantiatedType, seen);
            }
            Collections.addAll(interfaces, clazz.interfaces.values);
        } while ((type = clazz.superType) != null && !this.instantiatedTypes.contains(type));
        for (DexType iface : interfaces) {
            DexClass clazz2 = this.appInfo.definitionFor(iface);
            if (clazz2 == null) {
                this.reportMissingClass(iface);
                break;
            }
            this.transitionDefaultMethodsForInstantiatedClass(iface, instantiatedType, seen);
        }
    }

    private void transitionDefaultMethodsForInstantiatedClass(DexType iface, DexType instantiatedType, ScopedDexMethodSet seen) {
        DexClass clazz = this.appInfo.definitionFor(iface);
        assert (clazz.accessFlags.isInterface());
        SetWithReason<DexEncodedMethod> reachableMethods = this.reachableVirtualMethods.get(iface);
        if (reachableMethods != null) {
            seen = seen.newNestedScope();
            this.transitionNonAbstractMethodsToLiveAndShadow(reachableMethods.getItems(), instantiatedType, seen);
            for (DexType subInterface : clazz.interfaces.values) {
                this.transitionDefaultMethodsForInstantiatedClass(subInterface, instantiatedType, seen);
            }
        }
    }

    private void transitionNonAbstractMethodsToLiveAndShadow(Iterable<DexEncodedMethod> reachable, DexType instantiatedType, ScopedDexMethodSet seen) {
        for (DexEncodedMethod encodedMethod : reachable) {
            if (!seen.addMethod(encodedMethod.method) || encodedMethod.accessFlags.isAbstract()) continue;
            this.markVirtualMethodAsLive(encodedMethod, KeepReason.reachableFromLiveType(instantiatedType));
        }
    }

    private void transitionFieldsForInstantiatedClass(DexType type) {
        DexClass clazz;
        do {
            if ((clazz = this.appInfo.definitionFor(type)) == null) {
                this.reportMissingClass(type);
                break;
            }
            SetWithReason<DexEncodedField> reachableFields = this.reachableInstanceFields.get(type);
            if (reachableFields == null) continue;
            for (DexEncodedField field : reachableFields.getItems()) {
                this.markInstanceFieldAsLive(field, KeepReason.reachableFromLiveType(type));
            }
        } while ((type = clazz.superType) != null && !this.instantiatedTypes.contains(type));
    }

    private void markStaticFieldAsLive(DexField field, KeepReason reason) {
        this.markTypeAsLive(field.clazz);
        DexEncodedField encodedField = this.appInfo.resolveFieldOn(field.clazz, field);
        if (encodedField == null) {
            this.reportMissingField(field);
            return;
        }
        if (encodedField.accessFlags.isStatic()) {
            // empty if block
        }
        this.liveFields.add(encodedField, reason);
        this.collectProguardCompatibilityRule(reason);
        this.enqueueRootItems(this.rootSet.getDependentItems(encodedField));
    }

    private void markInstanceFieldAsLive(DexEncodedField field, KeepReason reason) {
        assert (field != null);
        this.markTypeAsLive(field.field.clazz);
        this.liveFields.add(field, reason);
        this.collectProguardCompatibilityRule(reason);
        this.enqueueRootItems(this.rootSet.getDependentItems(field));
    }

    private void markInstantiated(DexType type, DexEncodedMethod method) {
        if (this.instantiatedTypes.contains(type)) {
            return;
        }
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz == null) {
            this.reportMissingClass(type);
            return;
        }
        this.workList.add(Action.markInstantiated(clazz, KeepReason.instantiatedIn(method)));
    }

    private void markDirectStaticOrConstructorMethodAsLive(DexEncodedMethod encodedMethod, KeepReason reason) {
        assert (encodedMethod != null);
        if (!this.liveMethods.contains(encodedMethod)) {
            this.markTypeAsLive(encodedMethod.method.holder);
            this.markMethodAsTargeted(encodedMethod, reason);
            if (encodedMethod.isInstanceInitializer() && encodedMethod.isSyntheticMethod()) {
                for (DexType type : encodedMethod.method.proto.parameters.values) {
                    DexClass clazz;
                    DexType dexType = type = type.isArrayType() ? type.toBaseType(this.appInfo.dexItemFactory) : type;
                    if (type.isPrimitiveType() || (clazz = this.appInfo.definitionFor(type)) == null || !clazz.accessFlags.isSynthetic()) continue;
                    this.markTypeAsLive(type);
                }
            }
            this.workList.add(Action.markMethodLive(encodedMethod, reason));
        }
    }

    private void markVirtualMethodAsLive(DexEncodedMethod method, KeepReason reason) {
        assert (method != null);
        assert (!method.accessFlags.isAbstract());
        if (!this.liveMethods.contains(method)) {
            this.workList.add(Action.markMethodLive(method, reason));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInstantiatedOrHasInstantiatedSubtype(DexType type) {
        if (this.instantiatedTypes.contains(type)) return true;
        if (!this.appInfo.subtypes(type).stream().anyMatch(this.instantiatedTypes::contains)) return false;
        return true;
    }

    private void markInstanceFieldAsReachable(DexField field, KeepReason reason) {
        DexEncodedField encodedField = this.appInfo.resolveFieldOn(field.clazz, field);
        if (encodedField == null) {
            this.reportMissingField(field);
            return;
        }
        if (encodedField.accessFlags.isStatic()) {
            this.markStaticFieldAsLive(encodedField.field, reason);
        } else {
            SetWithReason reachable = this.reachableInstanceFields.computeIfAbsent(encodedField.field.clazz, ignore -> new SetWithReason());
            if (reachable.add(encodedField, reason) && this.isInstantiatedOrHasInstantiatedSubtype(encodedField.field.clazz)) {
                this.markInstanceFieldAsLive(encodedField, reason);
            }
        }
    }

    private void markVirtualMethodAsReachable(DexMethod method, boolean interfaceInvoke, KeepReason reason) {
        DexEncodedMethod topTarget;
        if (!this.virtualTargetsMarkedAsReachable.add(method)) {
            return;
        }
        if (method.holder.isArrayType()) {
            DexType baseType = method.holder.toBaseType(this.appInfo.dexItemFactory);
            if (baseType.isClassType()) {
                this.markTypeAsLive(baseType);
            }
            return;
        }
        DexClass holder = this.appInfo.definitionFor(method.holder);
        if (holder == null) {
            this.reportMissingClass(method.holder);
            return;
        }
        DexEncodedMethod dexEncodedMethod = topTarget = interfaceInvoke ? this.appInfo.resolveMethodOnInterface(method.holder, method).asResultOfResolve() : this.appInfo.resolveMethodOnClass(method.holder, method).asResultOfResolve();
        if (topTarget == null) {
            this.reportMissingMethod(method);
            return;
        }
        this.markMethodAsTargeted(topTarget, reason);
        Set<DexEncodedMethod> targets = interfaceInvoke ? this.appInfo.lookupInterfaceTargets(method) : this.appInfo.lookupVirtualTargets(method);
        block0: for (DexEncodedMethod encodedMethod : targets) {
            SetWithReason reachable = this.reachableVirtualMethods.computeIfAbsent(encodedMethod.method.holder, ignore -> new SetWithReason());
            if (!reachable.add(encodedMethod, reason) || encodedMethod.accessFlags.isAbstract() || !this.isInstantiatedOrHasInstantiatedSubtype(encodedMethod.method.holder)) continue;
            if (this.instantiatedTypes.contains(encodedMethod.method.holder)) {
                this.markVirtualMethodAsLive(encodedMethod, KeepReason.reachableFromLiveType(encodedMethod.method.holder));
                continue;
            }
            ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
            Enqueuer.fillWorkList(worklist, encodedMethod.method.holder);
            while (!worklist.isEmpty()) {
                DexType current = (DexType)worklist.pollFirst();
                DexClass currentHolder = this.appInfo.definitionFor(current);
                if (currentHolder == null || currentHolder.lookupMethod(encodedMethod.method) != null) continue;
                if (this.instantiatedTypes.contains(current)) {
                    this.markVirtualMethodAsLive(encodedMethod, KeepReason.reachableFromLiveType(current));
                    continue block0;
                }
                Enqueuer.fillWorkList(worklist, current);
            }
        }
    }

    private static void fillWorkList(Deque<DexType> worklist, DexType type) {
        if (type.isInterface()) {
            type.forAllImplementsSubtypes(worklist::addLast);
            type.forAllExtendsSubtypes(worklist::addLast);
        } else {
            type.forAllExtendsSubtypes(worklist::addLast);
        }
    }

    private void markSuperMethodAsReachable(DexMethod method, DexEncodedMethod from) {
        DexEncodedMethod resolutionTarget = this.appInfo.resolveMethod(method.holder, method).asResultOfResolve();
        if (resolutionTarget == null) {
            this.reportMissingMethod(method);
            return;
        }
        this.markMethodAsTargeted(resolutionTarget, KeepReason.targetedBySuperFrom(from));
        DexEncodedMethod target = this.appInfo.lookupSuperTarget(method, from.method.holder);
        if (target == null) {
            this.reportMissingMethod(method);
            return;
        }
        assert (!this.superInvokeDependencies.containsKey(from) || !this.superInvokeDependencies.get(from).contains(target));
        this.superInvokeDependencies.computeIfAbsent(from, ignore -> Sets.newIdentityHashSet()).add(target);
        if (this.liveMethods.contains(from)) {
            this.markMethodAsTargeted(target, KeepReason.invokedViaSuperFrom(from));
            if (!target.accessFlags.isAbstract()) {
                this.markVirtualMethodAsLive(target, KeepReason.invokedViaSuperFrom(from));
            }
        }
    }

    public ReasonPrinter getReasonPrinter(Set<DexItem> queriedItems) {
        if (queriedItems.isEmpty()) {
            return ReasonPrinter.getNoOpPrinter();
        }
        HashMap<DexItem, KeepReason> reachability = new HashMap<DexItem, KeepReason>();
        for (SetWithReason<DexEncodedMethod> setWithReason : this.reachableVirtualMethods.values()) {
            reachability.putAll(setWithReason.getReasons());
        }
        for (SetWithReason<KeyedDexItem> setWithReason : this.reachableInstanceFields.values()) {
            reachability.putAll(setWithReason.getReasons());
        }
        return new ReasonPrinter(queriedItems, this.liveFields.getReasons(), this.liveMethods.getReasons(), reachability, this.instantiatedTypes.getReasons());
    }

    public Set<DexType> traceMainDex(RootSetBuilder.RootSet rootSet, Timing timing) {
        this.tracingMainDex = true;
        this.rootSet = rootSet;
        this.enqueueRootItems(rootSet.noShrinking);
        AppInfoWithLiveness appInfo = this.trace(timing);
        this.options.reporter.failIfPendingErrors();
        return new HashSet<DexType>(appInfo.liveTypes);
    }

    public AppInfoWithLiveness traceApplication(RootSetBuilder.RootSet rootSet, Timing timing) {
        this.rootSet = rootSet;
        this.enqueueRootItems(rootSet.noShrinking);
        this.appInfo.libraryClasses().forEach(this::markAllLibraryVirtualMethodsReachable);
        AppInfoWithLiveness result = this.trace(timing);
        this.options.reporter.failIfPendingErrors();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AppInfoWithLiveness trace(Timing timing) {
        timing.begin("Grow the tree.");
        try {
            block18: {
                block13: while (true) {
                    if (!this.workList.isEmpty()) {
                        Action action = this.workList.poll();
                        switch (action.kind) {
                            case MARK_INSTANTIATED: {
                                this.processNewlyInstantiatedClass((DexClass)action.target, action.reason);
                                continue block13;
                            }
                            case MARK_REACHABLE_FIELD: {
                                this.markInstanceFieldAsReachable((DexField)action.target, action.reason);
                                continue block13;
                            }
                            case MARK_REACHABLE_VIRTUAL: {
                                this.markVirtualMethodAsReachable((DexMethod)action.target, false, action.reason);
                                continue block13;
                            }
                            case MARK_REACHABLE_INTERFACE: {
                                this.markVirtualMethodAsReachable((DexMethod)action.target, true, action.reason);
                                continue block13;
                            }
                            case MARK_REACHABLE_SUPER: {
                                this.markSuperMethodAsReachable((DexMethod)action.target, (DexEncodedMethod)action.context);
                                continue block13;
                            }
                            case MARK_METHOD_KEPT: {
                                this.markMethodAsKept((DexEncodedMethod)action.target, action.reason);
                                continue block13;
                            }
                            case MARK_FIELD_KEPT: {
                                this.markFieldAsKept((DexEncodedField)action.target, action.reason);
                                continue block13;
                            }
                            case MARK_METHOD_LIVE: {
                                this.processNewlyLiveMethod((DexEncodedMethod)action.target, action.reason);
                                continue block13;
                            }
                        }
                        throw new IllegalArgumentException(action.kind.toString());
                    }
                    if (this.proguardCompatibilityWorkList.isEmpty() && this.pendingProguardReflectiveCompatibility.isEmpty()) {
                        if (!$assertionsDisabled) {
                            break;
                        }
                        break block18;
                    }
                    this.pendingProguardReflectiveCompatibility.forEach(this::handleProguardReflectiveBehavior);
                    this.workList.addAll(this.proguardCompatibilityWorkList);
                    this.proguardCompatibilityWorkList.clear();
                    this.pendingProguardReflectiveCompatibility.clear();
                }
                if (!this.liveTypes.stream().allMatch(DexType::isClassType)) {
                    throw new AssertionError();
                }
            }
            if ($assertionsDisabled) return new AppInfoWithLiveness(this.appInfo, this);
            if (this.instantiatedTypes.getItems().stream().allMatch(DexType::isClassType)) return new AppInfoWithLiveness(this.appInfo, this);
            throw new AssertionError();
        }
        finally {
            timing.end();
        }
    }

    private void markMethodAsKept(DexEncodedMethod target, KeepReason reason) {
        DexClass holder = this.appInfo.definitionFor(target.method.holder);
        if (holder == null) {
            return;
        }
        if (target.isVirtualMethod()) {
            this.markVirtualMethodAsReachable(target.method, holder.accessFlags.isInterface(), reason);
            if (holder.isInterface() && target.isNonAbstractVirtualMethod()) {
                this.markVirtualMethodAsLive(target, reason);
            }
        } else {
            this.markDirectStaticOrConstructorMethodAsLive(target, reason);
        }
    }

    private void markFieldAsKept(DexEncodedField target, KeepReason reason) {
        if (this.appInfo.definitionFor(target.field.clazz) == null) {
            return;
        }
        if (target.accessFlags.isStatic()) {
            this.markStaticFieldAsLive(target.field, reason);
        } else {
            this.markInstanceFieldAsReachable(target.field, reason);
        }
    }

    private void markAllLibraryVirtualMethodsReachable(DexClass clazz) {
        assert (clazz.isLibraryClass());
        for (DexEncodedMethod encodedMethod : clazz.virtualMethods()) {
            this.markMethodAsTargeted(encodedMethod, KeepReason.isLibraryMethod());
            this.markVirtualMethodAsReachable(encodedMethod.method, clazz.isInterface(), KeepReason.isLibraryMethod());
        }
    }

    private void processNewlyLiveMethod(DexEncodedMethod method, KeepReason reason) {
        if (this.liveMethods.add(method, reason)) {
            this.collectProguardCompatibilityRule(reason);
            DexClass holder = this.appInfo.definitionFor(method.method.holder);
            assert (holder != null);
            if (holder.isLibraryClass()) {
                return;
            }
            Set<DexEncodedMethod> superCallTargets = this.superInvokeDependencies.get(method);
            if (superCallTargets != null) {
                for (DexEncodedMethod superCallTarget : superCallTargets) {
                    this.markMethodAsTargeted(superCallTarget, KeepReason.invokedViaSuperFrom(method));
                    this.markVirtualMethodAsLive(superCallTarget, KeepReason.invokedViaSuperFrom(method));
                }
            }
            this.processAnnotations(method.annotations.annotations);
            for (DexAnnotationSet parameterAnnotation : method.parameterAnnotations.values) {
                this.processAnnotations(parameterAnnotation.annotations);
            }
            if (this.protoLiteExtension != null && this.protoLiteExtension.appliesTo(method)) {
                this.protoLiteExtension.processMethod(method, new UseRegistry(method), this.protoLiteFields);
            } else {
                method.registerInstructionsReferences(new UseRegistry(method));
            }
            this.enqueueRootItems(this.rootSet.getDependentItems(method));
        }
    }

    private void collectProguardCompatibilityRule(KeepReason reason) {
        if (reason.isDueToProguardCompatibility() && this.compatibility != null) {
            this.compatibility.addRule(reason.getProguardKeepRule());
        }
    }

    private Set<DexField> collectFields(Map<DexType, Set<DexField>> map) {
        return map.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    SortedSet<DexField> collectInstanceFieldsRead() {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, this.collectFields(this.instanceFieldsRead));
    }

    SortedSet<DexField> collectInstanceFieldsWritten() {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, this.collectFields(this.instanceFieldsWritten));
    }

    SortedSet<DexField> collectStaticFieldsRead() {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, this.collectFields(this.staticFieldsRead));
    }

    SortedSet<DexField> collectStaticFieldsWritten() {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, this.collectFields(this.staticFieldsWritten));
    }

    private Set<DexField> collectReachedFields(Map<DexType, Set<DexField>> map, Function<DexField, DexField> lookup) {
        return map.values().stream().flatMap(set -> set.stream().map(lookup).filter(Objects::nonNull)).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    private DexField tryLookupInstanceField(DexField field) {
        DexEncodedField target = this.appInfo.lookupInstanceTarget(field.clazz, field);
        return target == null ? null : target.field;
    }

    private DexField tryLookupStaticField(DexField field) {
        DexEncodedField target = this.appInfo.lookupStaticTarget(field.clazz, field);
        return target == null ? null : target.field;
    }

    SortedSet<DexField> collectFieldsRead() {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, Sets.union(this.collectReachedFields(this.instanceFieldsRead, this::tryLookupInstanceField), this.collectReachedFields(this.staticFieldsRead, this::tryLookupStaticField)));
    }

    SortedSet<DexField> collectFieldsWritten() {
        return ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, Sets.union(this.collectReachedFields(this.instanceFieldsWritten, this::tryLookupInstanceField), this.collectReachedFields(this.staticFieldsWritten, this::tryLookupStaticField)));
    }

    private void markClassAsInstantiatedWithCompatRule(DexClass clazz) {
        ProguardKeepRule rule = ProguardConfigurationUtils.buildDefaultInitializerKeepRule(clazz);
        this.proguardCompatibilityWorkList.add(Action.markInstantiated(clazz, KeepReason.dueToProguardCompatibilityKeepRule(rule)));
        if (clazz.hasDefaultInitializer()) {
            this.proguardCompatibilityWorkList.add(Action.markMethodLive(clazz.getDefaultInitializer(), KeepReason.dueToProguardCompatibilityKeepRule(rule)));
        }
    }

    private void markFieldAsKeptWithCompatRule(DexEncodedField field) {
        DexClass holderClass = this.appInfo.definitionFor(field.field.getHolder());
        ProguardKeepRule rule = ProguardConfigurationUtils.buildFieldKeepRule(holderClass, field);
        this.proguardCompatibilityWorkList.add(Action.markFieldKept(field, KeepReason.dueToProguardCompatibilityKeepRule(rule)));
    }

    private void markMethodAsKeptWithCompatRule(DexEncodedMethod method) {
        DexClass holderClass = this.appInfo.definitionFor(method.method.getHolder());
        ProguardKeepRule rule = ProguardConfigurationUtils.buildMethodKeepRule(holderClass, method);
        this.proguardCompatibilityWorkList.add(Action.markMethodLive(method, KeepReason.dueToProguardCompatibilityKeepRule(rule)));
    }

    private void handleProguardReflectiveBehavior(DexEncodedMethod method) {
        try {
            IRCode code = method.buildIR(this.options);
            code.instructionIterator().forEachRemaining(this::handleProguardReflectiveBehavior);
        }
        catch (ApiLevelException apiLevelException) {
            // empty catch block
        }
    }

    private void handleProguardReflectiveBehavior(Instruction instruction) {
        if (!instruction.isInvokeMethod()) {
            return;
        }
        InvokeMethod invoke = instruction.asInvokeMethod();
        DexMethod invokedMethod = invoke.getInvokedMethod();
        if (!IdentifierNameStringUtils.isReflectionMethod(this.appInfo.dexItemFactory, invokedMethod)) {
            return;
        }
        DexItemBasedString itemBasedString = IdentifierNameStringUtils.identifyIdentiferNameString(this.appInfo, invoke);
        if (itemBasedString == null) {
            return;
        }
        if (itemBasedString.basedOn instanceof DexType) {
            DexClass clazz = this.appInfo.definitionFor((DexType)itemBasedString.basedOn);
            if (clazz != null) {
                this.markClassAsInstantiatedWithCompatRule(clazz);
            }
        } else if (itemBasedString.basedOn instanceof DexField) {
            DexEncodedField encodedField = this.appInfo.definitionFor((DexField)itemBasedString.basedOn);
            if (encodedField != null) {
                this.markFieldAsKeptWithCompatRule(encodedField);
            }
        } else {
            assert (itemBasedString.basedOn instanceof DexMethod);
            DexEncodedMethod encodedMethod = this.appInfo.definitionFor((DexMethod)itemBasedString.basedOn);
            if (encodedMethod != null) {
                this.markMethodAsKeptWithCompatRule(encodedMethod);
            }
        }
    }

    private class AnnotationReferenceMarker
    implements IndexedItemCollection {
        private final DexItem annotationHolder;
        private final DexItemFactory dexItemFactory;

        private AnnotationReferenceMarker(DexItem annotationHolder, DexItemFactory dexItemFactory) {
            this.annotationHolder = annotationHolder;
            this.dexItemFactory = dexItemFactory;
        }

        @Override
        public boolean addClass(DexProgramClass dexProgramClass) {
            return false;
        }

        @Override
        public boolean addField(DexField field) {
            DexClass holder = Enqueuer.this.appInfo.definitionFor(field.clazz);
            if (holder == null) {
                return false;
            }
            DexEncodedField target = holder.lookupStaticField(field);
            if (target != null) {
                if (target.field == field) {
                    Enqueuer.this.markStaticFieldAsLive(field, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            } else {
                target = holder.lookupInstanceField(field);
                if (target != null && target.field != field) {
                    Enqueuer.this.markInstanceFieldAsReachable(field, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            }
            return false;
        }

        @Override
        public boolean addMethod(DexMethod method) {
            DexClass holder = Enqueuer.this.appInfo.definitionFor(method.holder);
            if (holder == null) {
                return false;
            }
            DexEncodedMethod target = holder.lookupDirectMethod(method);
            if (target != null) {
                if (target.method == method) {
                    Enqueuer.this.markDirectStaticOrConstructorMethodAsLive(target, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            } else {
                target = holder.lookupVirtualMethod(method);
                if (target != null && target.method == method) {
                    Enqueuer.this.markMethodAsTargeted(target, KeepReason.referencedInAnnotation(this.annotationHolder));
                }
            }
            return false;
        }

        @Override
        public boolean addString(DexString string) {
            return false;
        }

        @Override
        public boolean addProto(DexProto proto) {
            return false;
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            return false;
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            return false;
        }

        @Override
        public boolean addType(DexType type) {
            if (type != this.dexItemFactory.voidType) {
                Enqueuer.this.markTypeAsLive(type);
            }
            return false;
        }
    }

    private static final class TargetWithContext<T extends Descriptor<?, T>> {
        private final T target;
        private final DexEncodedMethod context;

        private TargetWithContext(T target, DexEncodedMethod context) {
            this.target = target;
            this.context = context;
        }

        public T getTarget() {
            return this.target;
        }

        public int hashCode() {
            return ((CachedHashValueDexItem)this.target).hashCode() * 31 + this.context.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TargetWithContext)) {
                return false;
            }
            TargetWithContext other = (TargetWithContext)obj;
            return this.target == other.target && this.context == other.context;
        }

        /* synthetic */ TargetWithContext(Descriptor x0, DexEncodedMethod x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static class SetWithReason<T> {
        private final Set<T> items = Sets.newIdentityHashSet();
        private final Map<T, KeepReason> reasons = Maps.newIdentityHashMap();

        private SetWithReason() {
        }

        boolean add(T item, KeepReason reason) {
            if (this.items.add(item)) {
                this.reasons.put(item, reason);
                return true;
            }
            return false;
        }

        boolean contains(T item) {
            return this.items.contains(item);
        }

        Set<T> getItems() {
            return ImmutableSet.copyOf(this.items);
        }

        Map<T, KeepReason> getReasons() {
            return ImmutableMap.copyOf(this.reasons);
        }
    }

    public static class AppInfoWithLiveness
    extends AppInfoWithSubtyping {
        public final SortedSet<DexType> liveTypes;
        final SortedSet<DexType> instantiatedTypes;
        final SortedSet<DexMethod> targetedMethods;
        final SortedSet<DexMethod> liveMethods;
        public final SortedSet<DexField> liveFields;
        public final SortedSet<DexField> fieldsRead;
        public final SortedSet<DexField> fieldsWritten;
        public final SortedSet<DexField> instanceFieldReads;
        public final SortedSet<DexField> instanceFieldWrites;
        public final SortedSet<DexField> staticFieldReads;
        public final SortedSet<DexField> staticFieldWrites;
        public final SortedSet<DexMethod> virtualInvokes;
        public final SortedSet<DexMethod> interfaceInvokes;
        public final SortedSet<DexMethod> superInvokes;
        public final SortedSet<DexMethod> directInvokes;
        public final SortedSet<DexMethod> staticInvokes;
        final Set<DexItem> pinnedItems;
        public final Map<DexItem, ProguardMemberRule> noSideEffects;
        public final Map<DexItem, ProguardMemberRule> assumedValues;
        public final Set<DexItem> alwaysInline;
        public final Set<DexItem> identifierNameStrings;
        final Set<DexField> protoLiteFields;
        final Set<DexType> prunedTypes;
        final Map<DexField, Int2ReferenceMap<DexField>> switchMaps;
        final Map<DexType, Reference2IntMap<DexField>> ordinalsMaps;

        private AppInfoWithLiveness(AppInfoWithSubtyping appInfo, Enqueuer enqueuer) {
            super(appInfo);
            this.liveTypes = ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, enqueuer.liveTypes);
            this.instantiatedTypes = ImmutableSortedSet.copyOf(PresortedComparable::slowCompareTo, enqueuer.instantiatedTypes.getItems());
            this.targetedMethods = this.toSortedDescriptorSet(enqueuer.targetedMethods.getItems());
            this.liveMethods = this.toSortedDescriptorSet(enqueuer.liveMethods.getItems());
            this.liveFields = this.toSortedDescriptorSet(enqueuer.liveFields.getItems());
            this.instanceFieldReads = enqueuer.collectInstanceFieldsRead();
            this.instanceFieldWrites = enqueuer.collectInstanceFieldsWritten();
            this.staticFieldReads = enqueuer.collectStaticFieldsRead();
            this.staticFieldWrites = enqueuer.collectStaticFieldsWritten();
            this.fieldsRead = enqueuer.collectFieldsRead();
            this.fieldsWritten = enqueuer.collectFieldsWritten();
            this.pinnedItems = this.rewritePinnedItemsToDescriptors(enqueuer.pinnedItems);
            this.virtualInvokes = this.joinInvokedMethods(enqueuer.virtualInvokes);
            this.interfaceInvokes = this.joinInvokedMethods(enqueuer.interfaceInvokes);
            this.superInvokes = this.joinInvokedMethods(enqueuer.superInvokes, TargetWithContext::getTarget);
            this.directInvokes = this.joinInvokedMethods(enqueuer.directInvokes);
            this.staticInvokes = this.joinInvokedMethods(enqueuer.staticInvokes);
            this.noSideEffects = ((Enqueuer)enqueuer).rootSet.noSideEffects;
            this.assumedValues = ((Enqueuer)enqueuer).rootSet.assumedValues;
            this.alwaysInline = ((Enqueuer)enqueuer).rootSet.alwaysInline;
            this.identifierNameStrings = ((Enqueuer)enqueuer).rootSet.identifierNameStrings;
            this.protoLiteFields = enqueuer.protoLiteFields;
            this.prunedTypes = Collections.emptySet();
            this.switchMaps = Collections.emptyMap();
            this.ordinalsMaps = Collections.emptyMap();
            assert (Sets.intersection(this.instanceFieldReads, this.staticFieldReads).size() == 0);
            assert (Sets.intersection(this.instanceFieldWrites, this.staticFieldWrites).size() == 0);
        }

        private AppInfoWithLiveness(AppInfoWithLiveness previous, DexApplication application, Collection<DexType> removedClasses) {
            super(application);
            this.liveTypes = previous.liveTypes;
            this.instantiatedTypes = previous.instantiatedTypes;
            this.targetedMethods = previous.targetedMethods;
            this.liveMethods = previous.liveMethods;
            this.liveFields = previous.liveFields;
            this.instanceFieldReads = previous.instanceFieldReads;
            this.instanceFieldWrites = previous.instanceFieldWrites;
            this.staticFieldReads = previous.staticFieldReads;
            this.staticFieldWrites = previous.staticFieldWrites;
            this.fieldsRead = previous.fieldsRead;
            this.fieldsWritten = previous.fieldsWritten;
            assert (this.assertNoItemRemoved(previous.pinnedItems, removedClasses));
            this.pinnedItems = previous.pinnedItems;
            this.noSideEffects = previous.noSideEffects;
            this.assumedValues = previous.assumedValues;
            this.virtualInvokes = previous.virtualInvokes;
            this.interfaceInvokes = previous.interfaceInvokes;
            this.superInvokes = previous.superInvokes;
            this.directInvokes = previous.directInvokes;
            this.staticInvokes = previous.staticInvokes;
            this.protoLiteFields = previous.protoLiteFields;
            this.alwaysInline = previous.alwaysInline;
            this.identifierNameStrings = previous.identifierNameStrings;
            this.prunedTypes = AppInfoWithLiveness.mergeSets(previous.prunedTypes, removedClasses);
            this.switchMaps = previous.switchMaps;
            this.ordinalsMaps = previous.ordinalsMaps;
            assert (Sets.intersection(this.instanceFieldReads, this.staticFieldReads).size() == 0);
            assert (Sets.intersection(this.instanceFieldWrites, this.staticFieldWrites).size() == 0);
        }

        private AppInfoWithLiveness(AppInfoWithLiveness previous, DirectMappedDexApplication application, GraphLense lense) {
            super(application, lense);
            this.liveTypes = AppInfoWithLiveness.rewriteItems(previous.liveTypes, lense::lookupType);
            this.instantiatedTypes = AppInfoWithLiveness.rewriteItems(previous.instantiatedTypes, lense::lookupType);
            this.targetedMethods = AppInfoWithLiveness.rewriteItems(previous.targetedMethods, lense::lookupMethod);
            this.liveMethods = AppInfoWithLiveness.rewriteItems(previous.liveMethods, lense::lookupMethod);
            this.liveFields = AppInfoWithLiveness.rewriteItems(previous.liveFields, lense::lookupField);
            this.instanceFieldReads = AppInfoWithLiveness.rewriteItems(previous.instanceFieldReads, lense::lookupField);
            this.instanceFieldWrites = AppInfoWithLiveness.rewriteItems(previous.instanceFieldWrites, lense::lookupField);
            this.staticFieldReads = AppInfoWithLiveness.rewriteItems(previous.staticFieldReads, lense::lookupField);
            this.staticFieldWrites = AppInfoWithLiveness.rewriteItems(previous.staticFieldWrites, lense::lookupField);
            this.fieldsRead = AppInfoWithLiveness.rewriteItems(previous.fieldsRead, lense::lookupField);
            this.fieldsWritten = AppInfoWithLiveness.rewriteItems(previous.fieldsWritten, lense::lookupField);
            this.pinnedItems = AppInfoWithLiveness.rewriteMixedItems(previous.pinnedItems, lense);
            this.virtualInvokes = AppInfoWithLiveness.rewriteItems(previous.virtualInvokes, lense::lookupMethod);
            this.interfaceInvokes = AppInfoWithLiveness.rewriteItems(previous.interfaceInvokes, lense::lookupMethod);
            this.superInvokes = AppInfoWithLiveness.rewriteItems(previous.superInvokes, lense::lookupMethod);
            this.directInvokes = AppInfoWithLiveness.rewriteItems(previous.directInvokes, lense::lookupMethod);
            this.staticInvokes = AppInfoWithLiveness.rewriteItems(previous.staticInvokes, lense::lookupMethod);
            this.prunedTypes = AppInfoWithLiveness.rewriteItems(previous.prunedTypes, lense::lookupType);
            assert (this.assertNotModifiedByLense(previous.noSideEffects.keySet(), lense));
            this.noSideEffects = previous.noSideEffects;
            assert (this.assertNotModifiedByLense(previous.assumedValues.keySet(), lense));
            this.assumedValues = previous.assumedValues;
            assert (this.assertNotModifiedByLense(previous.alwaysInline, lense));
            this.alwaysInline = previous.alwaysInline;
            this.identifierNameStrings = AppInfoWithLiveness.rewriteMixedItems(previous.identifierNameStrings, lense);
            assert (this.assertNotModifiedByLense(previous.switchMaps.keySet().stream().map(this::definitionFor).filter(Objects::nonNull).collect(Collectors.toList()), lense));
            this.switchMaps = previous.switchMaps;
            this.ordinalsMaps = AppInfoWithLiveness.rewriteKeys(previous.ordinalsMaps, lense::lookupType);
            this.protoLiteFields = previous.protoLiteFields;
            assert (Sets.intersection(this.instanceFieldReads, this.staticFieldReads).isEmpty());
            assert (Sets.intersection(this.instanceFieldWrites, this.staticFieldWrites).isEmpty());
        }

        public AppInfoWithLiveness(AppInfoWithLiveness previous, Map<DexField, Int2ReferenceMap<DexField>> switchMaps, Map<DexType, Reference2IntMap<DexField>> ordinalsMaps) {
            super(previous);
            this.liveTypes = previous.liveTypes;
            this.instantiatedTypes = previous.instantiatedTypes;
            this.targetedMethods = previous.targetedMethods;
            this.liveMethods = previous.liveMethods;
            this.liveFields = previous.liveFields;
            this.instanceFieldReads = previous.instanceFieldReads;
            this.instanceFieldWrites = previous.instanceFieldWrites;
            this.staticFieldReads = previous.staticFieldReads;
            this.staticFieldWrites = previous.staticFieldWrites;
            this.fieldsRead = previous.fieldsRead;
            this.fieldsWritten = previous.fieldsWritten;
            this.pinnedItems = previous.pinnedItems;
            this.noSideEffects = previous.noSideEffects;
            this.assumedValues = previous.assumedValues;
            this.virtualInvokes = previous.virtualInvokes;
            this.interfaceInvokes = previous.interfaceInvokes;
            this.superInvokes = previous.superInvokes;
            this.directInvokes = previous.directInvokes;
            this.staticInvokes = previous.staticInvokes;
            this.protoLiteFields = previous.protoLiteFields;
            this.alwaysInline = previous.alwaysInline;
            this.identifierNameStrings = previous.identifierNameStrings;
            this.prunedTypes = previous.prunedTypes;
            this.switchMaps = switchMaps;
            this.ordinalsMaps = ordinalsMaps;
        }

        public Reference2IntMap<DexField> getOrdinalsMapFor(DexType enumClass) {
            return this.ordinalsMaps.get(enumClass);
        }

        public Int2ReferenceMap<DexField> getSwitchMapFor(DexField field) {
            return this.switchMaps.get(field);
        }

        private boolean assertNoItemRemoved(Collection<DexItem> items, Collection<DexType> types) {
            ImmutableSet<DexType> typeSet = ImmutableSet.copyOf(types);
            for (DexItem item : items) {
                if (item instanceof DexType ? !$assertionsDisabled && typeSet.contains(item) : (item instanceof DexMethod ? !$assertionsDisabled && typeSet.contains(((DexMethod)item).getHolder()) : (item instanceof DexField ? !$assertionsDisabled && typeSet.contains(((DexField)item).getHolder()) : !$assertionsDisabled))) {
                    throw new AssertionError();
                }
            }
            return true;
        }

        private boolean assertNotModifiedByLense(Iterable<DexItem> items, GraphLense lense) {
            for (DexItem item : items) {
                if (item instanceof DexClass) {
                    DexType type = ((DexClass)item).type;
                    assert (lense.lookupType(type, null) == type);
                    continue;
                }
                if (item instanceof DexEncodedMethod) {
                    DexEncodedMethod method = (DexEncodedMethod)item;
                    assert (method.accessFlags.isBridge() || lense.lookupMethod(method.method, null) == method.method);
                    continue;
                }
                if (item instanceof DexEncodedField) {
                    DexField field = ((DexEncodedField)item).field;
                    assert (lense.lookupField(field, null) == field);
                    continue;
                }
                assert (false);
            }
            return true;
        }

        private SortedSet<DexMethod> joinInvokedMethods(Map<DexType, Set<DexMethod>> invokes) {
            return this.joinInvokedMethods(invokes, Function.identity());
        }

        private <T> SortedSet<DexMethod> joinInvokedMethods(Map<DexType, Set<T>> invokes, Function<T, DexMethod> getter) {
            return invokes.values().stream().flatMap(Collection::stream).map(getter).collect(ImmutableSortedSet.toImmutableSortedSet(PresortedComparable::slowCompare));
        }

        private <T extends PresortedComparable<T>> SortedSet<T> toSortedDescriptorSet(Set<? extends KeyedDexItem<T>> set) {
            ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompareTo);
            for (KeyedDexItem<T> item : set) {
                builder.add(item.getKey());
            }
            return builder.build();
        }

        private ImmutableSet<DexItem> rewritePinnedItemsToDescriptors(Collection<DexItem> source) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (DexItem item : source) {
                if (item instanceof DexClass) {
                    builder.add(((DexClass)item).type);
                    continue;
                }
                if (item instanceof DexEncodedMethod) {
                    builder.add(((DexEncodedMethod)item).method);
                    continue;
                }
                if (item instanceof DexEncodedField) {
                    builder.add(((DexEncodedField)item).field);
                    continue;
                }
                throw new Unreachable();
            }
            return builder.build();
        }

        private static <T extends PresortedComparable<T>> ImmutableSortedSet<T> rewriteItems(Set<T> original, BiFunction<T, DexEncodedMethod, T> rewrite) {
            ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompare);
            for (PresortedComparable item : original) {
                builder.add((PresortedComparable)rewrite.apply(item, null));
            }
            return builder.build();
        }

        private static <T extends PresortedComparable<T>, S> ImmutableMap<T, S> rewriteKeys(Map<T, S> original, BiFunction<T, DexEncodedMethod, T> rewrite) {
            ImmutableMap.Builder<PresortedComparable, S> builder = new ImmutableMap.Builder<PresortedComparable, S>();
            for (PresortedComparable item : original.keySet()) {
                builder.put((PresortedComparable)rewrite.apply(item, null), original.get(item));
            }
            return builder.build();
        }

        private static ImmutableSet<DexItem> rewriteMixedItems(Set<DexItem> original, GraphLense lense) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (DexItem item : original) {
                if (item instanceof DexType) {
                    builder.add(lense.lookupType((DexType)item, null));
                    continue;
                }
                if (item instanceof DexMethod) {
                    builder.add(lense.lookupMethod((DexMethod)item, null));
                    continue;
                }
                if (item instanceof DexField) {
                    builder.add(lense.lookupField((DexField)item, null));
                    continue;
                }
                throw new Unreachable();
            }
            return builder.build();
        }

        private static <T> Set<T> mergeSets(Collection<T> first, Collection<T> second) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll(first);
            builder.addAll(second);
            return builder.build();
        }

        @Override
        public boolean hasLiveness() {
            return true;
        }

        @Override
        public AppInfoWithLiveness withLiveness() {
            return this;
        }

        public boolean isPinned(DexType item) {
            return this.pinnedItems.contains(item);
        }

        public boolean isPinned(DexMethod item) {
            return this.pinnedItems.contains(item);
        }

        public boolean isPinned(DexField item) {
            return this.pinnedItems.contains(item);
        }

        public boolean isProtoLiteField(DexField field) {
            return this.protoLiteFields.contains(field);
        }

        public Iterable<DexItem> getPinnedItems() {
            return this.pinnedItems;
        }

        public AppInfoWithLiveness prunedCopyFrom(DexApplication application, Collection<DexType> removedClasses) {
            return new AppInfoWithLiveness(this, application, removedClasses);
        }

        public AppInfoWithLiveness rewrittenWithLense(DirectMappedDexApplication application, GraphLense lense) {
            assert (lense.isContextFree());
            return new AppInfoWithLiveness(this, application, lense);
        }

        public boolean wasPruned(DexType type) {
            return this.prunedTypes.contains(type);
        }

        public DexEncodedMethod lookup(Invoke.Type type, DexMethod target, DexType invocationContext) {
            DexType holder = target.getHolder();
            if (!holder.isClassType()) {
                return null;
            }
            switch (type) {
                case VIRTUAL: {
                    return this.lookupSingleVirtualTarget(target);
                }
                case INTERFACE: {
                    return this.lookupSingleInterfaceTarget(target);
                }
                case DIRECT: {
                    return this.lookupDirectTarget(target);
                }
                case STATIC: {
                    return this.lookupStaticTarget(target);
                }
                case SUPER: {
                    return this.lookupSuperTarget(target, invocationContext);
                }
            }
            return null;
        }

        public DexEncodedMethod lookupSingleVirtualTarget(DexMethod method) {
            return this.lookupSingleVirtualTarget(method, method.holder);
        }

        public DexEncodedMethod lookupSingleVirtualTarget(DexMethod method, DexType refinedReceiverType) {
            DexClass refinedHolder;
            assert (method != null);
            assert (refinedReceiverType.isSubtypeOf(method.holder, this));
            DexClass holder = this.definitionFor(method.holder);
            if (holder == null || holder.isLibraryClass() || holder.isInterface()) {
                return null;
            }
            boolean refinedReceiverIsStrictSubType = refinedReceiverType != method.holder;
            DexClass dexClass = refinedHolder = refinedReceiverIsStrictSubType ? this.definitionFor(refinedReceiverType) : holder;
            assert (refinedHolder != null);
            assert (!refinedHolder.isLibraryClass());
            if (method.isSingleVirtualMethodCached(refinedReceiverType)) {
                return method.getSingleVirtualMethodCache(refinedReceiverType);
            }
            if (this.pinnedItems.contains(method.holder)) {
                method.setSingleVirtualMethodCache(refinedReceiverType, null);
                return null;
            }
            AppInfo.ResolutionResult topMethod = this.resolveMethod(method.holder, method);
            if (!topMethod.hasSingleTarget() || !topMethod.asSingleTarget().isVirtualMethod()) {
                method.setSingleVirtualMethodCache(refinedReceiverType, null);
                return null;
            }
            if (refinedReceiverIsStrictSubType) {
                topMethod = this.resolveMethod(refinedReceiverType, method);
            }
            DexEncodedMethod topSingleTarget = topMethod.asSingleTarget();
            DexClass topHolder = this.definitionFor(topSingleTarget.method.holder);
            boolean topIsFromInterface = topHolder.isInterface();
            DexEncodedMethod result = this.findSingleTargetFromSubtypes(refinedReceiverType, method, topSingleTarget, !refinedHolder.accessFlags.isAbstract(), topIsFromInterface);
            result = result == DexEncodedMethod.SENTINEL ? null : result;
            method.setSingleVirtualMethodCache(refinedReceiverType, result);
            return result;
        }

        private DexEncodedMethod findSingleTargetFromSubtypes(DexType type, DexMethod method, DexEncodedMethod candidate, boolean candidateIsReachable, boolean checkForInterfaceConflicts) {
            DexEncodedMethod result;
            DexEncodedMethod dexEncodedMethod = result = candidateIsReachable ? candidate : null;
            if (this.pinnedItems.contains(type)) {
                return DexEncodedMethod.SENTINEL;
            }
            for (DexType subtype : type.allExtendsSubtypes()) {
                boolean newCandidateIsReachable;
                DexClass clazz = this.definitionFor(subtype);
                DexEncodedMethod target = clazz.lookupMethod(method);
                if (target != null && !clazz.accessFlags.isAbstract()) {
                    if (result != null && result != target) {
                        return DexEncodedMethod.SENTINEL;
                    }
                    result = target;
                }
                if (checkForInterfaceConflicts && this.interfacesMayHaveDefaultFor(clazz.interfaces, method)) {
                    return DexEncodedMethod.SENTINEL;
                }
                DexEncodedMethod newCandidate = target == null ? candidate : target;
                DexEncodedMethod subtypeTarget = this.findSingleTargetFromSubtypes(subtype, method, newCandidate, newCandidateIsReachable = !clazz.accessFlags.isAbstract() || target == null && candidateIsReachable, checkForInterfaceConflicts);
                if (subtypeTarget == null) continue;
                if (result != null && result != subtypeTarget) {
                    return DexEncodedMethod.SENTINEL;
                }
                result = subtypeTarget;
            }
            return result;
        }

        private boolean interfacesMayHaveDefaultFor(DexTypeList ifaces, DexMethod method) {
            for (DexType iface : ifaces.values) {
                DexClass clazz = this.definitionFor(iface);
                if (clazz == null || clazz.isLibraryClass()) {
                    return true;
                }
                DexEncodedMethod candidate = clazz.lookupMethod(method);
                if (candidate != null && !candidate.accessFlags.isAbstract()) {
                    return true;
                }
                if (!this.interfacesMayHaveDefaultFor(clazz.interfaces, method)) continue;
                return true;
            }
            return false;
        }

        public DexEncodedMethod lookupSingleInterfaceTarget(DexMethod method) {
            return this.lookupSingleInterfaceTarget(method, method.holder);
        }

        public DexEncodedMethod lookupSingleInterfaceTarget(DexMethod method, DexType refinedReceiverType) {
            DexClass holder = this.definitionFor(method.holder);
            if (holder == null || holder.isLibraryClass() || !holder.accessFlags.isInterface()) {
                return null;
            }
            AppInfo.ResolutionResult topTarget = this.resolveMethodOnInterface(method.holder, method);
            if (topTarget.asResultOfResolve() == null) {
                return null;
            }
            if (this.pinnedItems.contains(method.holder)) {
                return null;
            }
            DexEncodedMethod result = null;
            ImmutableSet<DexType> subTypesToExplore = refinedReceiverType == method.holder ? this.subtypes(method.holder) : Iterables.concat(ImmutableList.of(refinedReceiverType), this.subtypes(refinedReceiverType));
            for (DexType type : subTypesToExplore) {
                if (this.pinnedItems.contains(type)) {
                    return null;
                }
                DexClass clazz = this.definitionFor(type);
                if (clazz.isInterface() || clazz.accessFlags.isAbstract()) continue;
                AppInfo.ResolutionResult resolutionResult = this.resolveMethodOnClass(type, method);
                if (resolutionResult.hasSingleTarget()) {
                    if (result != null && result != resolutionResult.asSingleTarget()) {
                        return null;
                    }
                    result = resolutionResult.asSingleTarget();
                    continue;
                }
                return null;
            }
            return result == null || !result.isVirtualMethod() ? null : result;
        }

        public AppInfoWithLiveness addSwitchMaps(Map<DexField, Int2ReferenceMap<DexField>> switchMaps) {
            assert (this.switchMaps.isEmpty());
            return new AppInfoWithLiveness(this, switchMaps, this.ordinalsMaps);
        }

        public AppInfoWithLiveness addEnumOrdinalMaps(Map<DexType, Reference2IntMap<DexField>> ordinalsMaps) {
            assert (this.ordinalsMaps.isEmpty());
            return new AppInfoWithLiveness(this, this.switchMaps, ordinalsMaps);
        }
    }

    private static class Action {
        final Kind kind;
        final DexItem target;
        final DexItem context;
        final KeepReason reason;

        private Action(Kind kind, DexItem target, DexItem context, KeepReason reason) {
            this.kind = kind;
            this.target = target;
            this.context = context;
            this.reason = reason;
        }

        public static Action markReachableVirtual(DexMethod method, KeepReason reason) {
            return new Action(Kind.MARK_REACHABLE_VIRTUAL, method, null, reason);
        }

        public static Action markReachableInterface(DexMethod method, KeepReason reason) {
            return new Action(Kind.MARK_REACHABLE_INTERFACE, method, null, reason);
        }

        public static Action markReachableSuper(DexMethod method, DexEncodedMethod from) {
            return new Action(Kind.MARK_REACHABLE_SUPER, method, from, null);
        }

        public static Action markReachableField(DexField field, KeepReason reason) {
            return new Action(Kind.MARK_REACHABLE_FIELD, field, null, reason);
        }

        public static Action markInstantiated(DexClass clazz, KeepReason reason) {
            return new Action(Kind.MARK_INSTANTIATED, clazz, null, reason);
        }

        public static Action markMethodLive(DexEncodedMethod method, KeepReason reason) {
            return new Action(Kind.MARK_METHOD_LIVE, method, null, reason);
        }

        public static Action markMethodKept(DexEncodedMethod method, KeepReason reason) {
            return new Action(Kind.MARK_METHOD_KEPT, method, null, reason);
        }

        public static Action markFieldKept(DexEncodedField field, KeepReason reason) {
            return new Action(Kind.MARK_FIELD_KEPT, field, null, reason);
        }

        private static enum Kind {
            MARK_REACHABLE_VIRTUAL,
            MARK_REACHABLE_INTERFACE,
            MARK_REACHABLE_SUPER,
            MARK_REACHABLE_FIELD,
            MARK_INSTANTIATED,
            MARK_METHOD_LIVE,
            MARK_METHOD_KEPT,
            MARK_FIELD_KEPT;

        }
    }

    private class UseRegistry
    extends com.android.tools.r8.graph.UseRegistry {
        private final DexEncodedMethod currentMethod;

        private UseRegistry(DexEncodedMethod currentMethod) {
            this.currentMethod = currentMethod;
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            if (((Enqueuer)Enqueuer.this).options.forceProguardCompatibility && ((Enqueuer)Enqueuer.this).appInfo.dexItemFactory.classMethods.isReflectiveMemberLookup(method)) {
                Enqueuer.this.pendingProguardReflectiveCompatibility.add(this.currentMethod);
            }
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.virtualInvokes, method)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableVirtual(method, KeepReason.invokedFrom(this.currentMethod)));
            return true;
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.directInvokes, method)) {
                return false;
            }
            Enqueuer.this.handleInvokeOfDirectTarget(method, KeepReason.invokedFrom(this.currentMethod));
            return true;
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            if (((Enqueuer)Enqueuer.this).options.forceProguardCompatibility && (method == ((Enqueuer)Enqueuer.this).appInfo.dexItemFactory.classMethods.forName || ((Enqueuer)Enqueuer.this).appInfo.dexItemFactory.atomicFieldUpdaterMethods.isFieldUpdater(method))) {
                Enqueuer.this.pendingProguardReflectiveCompatibility.add(this.currentMethod);
            }
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.staticInvokes, method)) {
                return false;
            }
            Enqueuer.this.handleInvokeOfStaticTarget(method, KeepReason.invokedFrom(this.currentMethod));
            return true;
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.interfaceInvokes, method)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableInterface(method, KeepReason.invokedFrom(this.currentMethod)));
            return true;
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            DexMethod actualTarget = Enqueuer.this.getInvokeSuperTarget(method, this.currentMethod);
            if (!Enqueuer.this.registerItemWithTargetAndContext(Enqueuer.this.superInvokes, method, this.currentMethod)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableSuper(method, this.currentMethod));
            return true;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.instanceFieldsWritten, field)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableField(field, KeepReason.fieldReferencedIn(this.currentMethod)));
            return true;
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.instanceFieldsRead, field)) {
                return false;
            }
            Enqueuer.this.workList.add(Action.markReachableField(field, KeepReason.fieldReferencedIn(this.currentMethod)));
            return true;
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            Enqueuer.this.markInstantiated(type, this.currentMethod);
            return true;
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.staticFieldsRead, field)) {
                return false;
            }
            Enqueuer.this.markStaticFieldAsLive(field, KeepReason.fieldReferencedIn(this.currentMethod));
            return true;
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            if (!Enqueuer.this.registerItemWithTarget(Enqueuer.this.staticFieldsWritten, field)) {
                return false;
            }
            Enqueuer.this.markStaticFieldAsLive(field, KeepReason.fieldReferencedIn(this.currentMethod));
            return true;
        }

        @Override
        public boolean registerConstClass(DexType type) {
            return this.registerConstClassOrCheckCast(type);
        }

        @Override
        public boolean registerCheckCast(DexType type) {
            return this.registerConstClassOrCheckCast(type);
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            DexType baseType = type.toBaseType(((Enqueuer)Enqueuer.this).appInfo.dexItemFactory);
            if (baseType.isClassType()) {
                Enqueuer.this.markTypeAsLive(baseType);
                return true;
            }
            return false;
        }

        private boolean registerConstClassOrCheckCast(DexType type) {
            if (((Enqueuer)Enqueuer.this).options.forceProguardCompatibility) {
                DexType baseType = type.toBaseType(((Enqueuer)Enqueuer.this).appInfo.dexItemFactory);
                if (baseType.isClassType()) {
                    DexClass baseClass = Enqueuer.this.appInfo.definitionFor(baseType);
                    if (baseClass != null && !baseClass.isLibraryClass()) {
                        Enqueuer.this.markClassAsInstantiatedWithCompatRule(baseClass);
                    } else {
                        Enqueuer.this.markTypeAsLive(baseType);
                    }
                    return true;
                }
                return false;
            }
            return this.registerTypeReference(type);
        }
    }
}

