/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.DescriptorUtils;

public class CfNewArray
extends CfInstruction {
    private final DexType type;

    public CfNewArray(DexType type) {
        assert (type.isArrayType());
        this.type = type;
    }

    public DexType getType() {
        return this.type;
    }

    private int getPrimitiveTypeCode() {
        switch (this.type.descriptor.content[1]) {
            case 90: {
                return 4;
            }
            case 67: {
                return 5;
            }
            case 70: {
                return 6;
            }
            case 68: {
                return 7;
            }
            case 66: {
                return 8;
            }
            case 83: {
                return 9;
            }
            case 73: {
                return 10;
            }
            case 74: {
                return 11;
            }
        }
        throw new Unreachable("Unexpected type for new-array: " + this.type);
    }

    private String getElementInternalName(NamingLens lens) {
        assert (!this.type.isPrimitiveArrayType());
        String renamedArrayType = lens.lookupDescriptor(this.type).toString();
        assert (renamedArrayType.charAt(0) == '[');
        String elementType = renamedArrayType.substring(1);
        return DescriptorUtils.descriptorToInternalName(elementType);
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        if (this.type.isPrimitiveArrayType()) {
            visitor.visitIntInsn(188, this.getPrimitiveTypeCode());
        } else {
            visitor.visitTypeInsn(189, this.getElementInternalName(lens));
        }
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void registerUse(UseRegistry registry, DexType clazz) {
        if (!this.type.isPrimitiveArrayType()) {
            registry.registerTypeReference(this.type);
        }
    }
}

