/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeEnvironment;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokePolymorphic;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.conversion.CallSiteInformation;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningInfo;
import java.util.function.Predicate;

public class InliningOracle {
    private final Inliner inliner;
    private final DexEncodedMethod method;
    private final TypeEnvironment typeEnvironment;
    private final CallSiteInformation callSiteInformation;
    private final Predicate<DexEncodedMethod> isProcessedConcurrently;
    private final InliningInfo info;
    private final int inliningInstructionLimit;

    InliningOracle(Inliner inliner, DexEncodedMethod method, TypeEnvironment typeEnvironment, CallSiteInformation callSiteInformation, Predicate<DexEncodedMethod> isProcessedConcurrently, int inliningInstructionLimit) {
        this.inliner = inliner;
        this.method = method;
        this.typeEnvironment = typeEnvironment;
        this.callSiteInformation = callSiteInformation;
        this.isProcessedConcurrently = isProcessedConcurrently;
        this.info = null;
        this.inliningInstructionLimit = inliningInstructionLimit;
    }

    void finish() {
    }

    private DexEncodedMethod validateCandidate(InvokeMethod invoke, DexType invocationContext) {
        DexEncodedMethod candidate = invoke.computeSingleTarget(this.inliner.appInfo, this.typeEnvironment, invocationContext);
        if (candidate == null || candidate.getCode() == null || this.inliner.appInfo.definitionFor(candidate.method.getHolder()).isLibraryClass()) {
            if (this.info != null) {
                this.info.exclude(invoke, "No inlinee");
            }
            return null;
        }
        int numberOfArguments = invoke.arguments().size() - (invoke.isInvokeMethodWithReceiver() ? 1 : 0);
        if (numberOfArguments != candidate.method.getArity()) {
            if (this.info != null) {
                this.info.exclude(invoke, "Argument number mismatch");
            }
            return null;
        }
        return candidate;
    }

    private Inliner.Reason computeInliningReason(DexEncodedMethod target) {
        if (target.getOptimizationInfo().forceInline()) {
            return Inliner.Reason.FORCE;
        }
        if (this.inliner.appInfo.hasLiveness() && this.inliner.appInfo.withLiveness().alwaysInline.contains(target)) {
            return Inliner.Reason.ALWAYS;
        }
        if (this.callSiteInformation.hasSingleCallSite(target)) {
            return Inliner.Reason.SINGLE_CALLER;
        }
        if (this.isDoubleInliningTarget(target)) {
            return Inliner.Reason.DUAL_CALLER;
        }
        return Inliner.Reason.SIMPLE;
    }

    private boolean canInlineStaticInvoke(DexEncodedMethod method, DexEncodedMethod target) {
        DexType targetHolder = target.method.getHolder();
        if (method.method.getHolder() == targetHolder) {
            return true;
        }
        DexClass clazz = this.inliner.appInfo.definitionFor(targetHolder);
        assert (clazz != null);
        if (target.getOptimizationInfo().triggersClassInitBeforeAnySideEffect()) {
            return true;
        }
        return this.classInitializationHasNoSideffects(targetHolder);
    }

    private boolean classInitializationHasNoSideffects(DexType classToCheck) {
        DexClass clazz = this.inliner.appInfo.definitionFor(classToCheck);
        if (clazz == null || clazz.hasNonTrivialClassInitializer() || clazz.defaultValuesForStaticFieldsMayTriggerAllocation()) {
            return false;
        }
        for (DexType iface : clazz.interfaces.values) {
            if (this.classInitializationHasNoSideffects(iface)) continue;
            return false;
        }
        return clazz.superType == null || this.classInitializationHasNoSideffects(clazz.superType);
    }

    private synchronized boolean isDoubleInliningTarget(DexEncodedMethod candidate) {
        return this.inliner.isDoubleInliningTarget(this.callSiteInformation, candidate) && candidate.getCode().isDexCode() && candidate.getCode().asDexCode().instructions.length <= 10;
    }

    private boolean passesInliningConstraints(InvokeMethod invoke, DexEncodedMethod candidate, Inliner.Reason reason) {
        Code code;
        if (this.method == candidate) {
            assert (!candidate.getOptimizationInfo().forceInline());
            if (this.info != null) {
                this.info.exclude(invoke, "direct recursion");
            }
            return false;
        }
        if (reason != Inliner.Reason.FORCE && this.isProcessedConcurrently.test(candidate)) {
            if (this.info != null) {
                this.info.exclude(invoke, "is processed in parallel");
            }
            return false;
        }
        if (!this.inliner.hasInliningAccess(this.method, candidate)) {
            if (this.info != null) {
                this.info.exclude(invoke, "target does not have right access");
            }
            return false;
        }
        DexClass holder = this.inliner.appInfo.definitionFor(candidate.method.getHolder());
        if (holder.isInterface()) {
            if (this.info != null) {
                this.info.exclude(invoke, "Do not inline target if method holder is an interface class");
            }
            return false;
        }
        if (holder.isLibraryClass()) {
            return false;
        }
        if (candidate.accessFlags.isSynchronized()) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is synchronized");
            }
            return false;
        }
        if (reason == Inliner.Reason.DUAL_CALLER && this.inliner.doubleInlining(this.method, candidate) == null) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is not ready for double inlining");
            }
            return false;
        }
        return reason != Inliner.Reason.SIMPLE || (code = candidate.getCode()).estimatedSizeForInlining() <= this.inliningInstructionLimit;
    }

    public Inliner.InlineAction computeForInvokeWithReceiver(InvokeMethodWithReceiver invoke, DexType invocationContext) {
        boolean receiverIsNeverNull;
        DexEncodedMethod candidate = this.validateCandidate(invoke, invocationContext);
        if (candidate == null || this.inliner.isBlackListed(candidate.method)) {
            return null;
        }
        boolean bl = receiverIsNeverNull = !this.typeEnvironment.getLatticeElement(invoke.getReceiver()).isNullable();
        if (!receiverIsNeverNull && !candidate.getOptimizationInfo().checksNullReceiverBeforeAnySideEffect()) {
            if (this.info != null) {
                this.info.exclude(invoke, "receiver for candidate can be null");
            }
            return null;
        }
        Inliner.Reason reason = this.computeInliningReason(candidate);
        if (!candidate.isInliningCandidate(this.method, reason, (AppInfoWithSubtyping)this.inliner.appInfo)) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is not identified for inlining");
            }
            return null;
        }
        if (!this.passesInliningConstraints(invoke, candidate, reason)) {
            return null;
        }
        if (this.info != null) {
            this.info.include(invoke.getType(), candidate);
        }
        return new Inliner.InlineAction(candidate, invoke, reason);
    }

    public Inliner.InlineAction computeForInvokeStatic(InvokeStatic invoke, DexType invocationContext) {
        DexEncodedMethod candidate = this.validateCandidate(invoke, invocationContext);
        if (candidate == null || this.inliner.isBlackListed(candidate.method)) {
            return null;
        }
        Inliner.Reason reason = this.computeInliningReason(candidate);
        if (!candidate.isInliningCandidate(this.method, reason, (AppInfoWithSubtyping)this.inliner.appInfo)) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is not identified for inlining");
            }
            return null;
        }
        if (!this.canInlineStaticInvoke(this.method, candidate)) {
            if (this.info != null) {
                this.info.exclude(invoke, "target is static but we cannot guarantee class has been initialized");
            }
            return null;
        }
        if (!this.passesInliningConstraints(invoke, candidate, reason)) {
            return null;
        }
        if (this.info != null) {
            this.info.include(invoke.getType(), candidate);
        }
        return new Inliner.InlineAction(candidate, invoke, reason);
    }

    public Inliner.InlineAction computeForInvokePolymorpic(InvokePolymorphic invoke, DexType invocationContext) {
        if (this.info != null) {
            this.info.exclude(invoke, "inlining through invoke signature polymorpic is not supported");
        }
        return null;
    }
}

