/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.NonNull;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;

public class NonNullTracker {
    @VisibleForTesting
    static boolean throwsOnNullInput(Instruction instruction) {
        return instruction.isInvokeMethodWithReceiver() && !instruction.isInvokeDirect() || instruction.isInstanceGet() || instruction.isInstancePut() || instruction.isArrayGet() || instruction.isArrayPut() || instruction.isArrayLength() || instruction.isMonitor();
    }

    private Value getNonNullInput(Instruction instruction) {
        if (instruction.isInvokeMethodWithReceiver()) {
            return instruction.asInvokeMethodWithReceiver().getReceiver();
        }
        if (instruction.isInstanceGet()) {
            return instruction.asInstanceGet().object();
        }
        if (instruction.isInstancePut()) {
            return instruction.asInstancePut().object();
        }
        if (instruction.isArrayGet()) {
            return instruction.asArrayGet().array();
        }
        if (instruction.isArrayPut()) {
            return instruction.asArrayPut().array();
        }
        if (instruction.isArrayLength()) {
            return instruction.asArrayLength().array();
        }
        if (instruction.isMonitor()) {
            return instruction.asMonitor().object();
        }
        throw new Unreachable("Should conform to throwsOnNullInput.");
    }

    public void addNonNull(IRCode code) {
        ListIterator<BasicBlock> blocks = code.blocks.listIterator();
        while (blocks.hasNext()) {
            DominatorTree dominatorTree;
            BasicBlock target;
            If theIf;
            Value knownToBeNonNullValue;
            BasicBlock block = (BasicBlock)blocks.next();
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext()) {
                Instruction current = (Instruction)iterator.next();
                if (!NonNullTracker.throwsOnNullInput(current) || (knownToBeNonNullValue = this.getNonNullInput(current)).isNeverNull()) continue;
                BasicBlock blockWithNonNullInstruction = block.hasCatchHandlers() ? iterator.split(code, blocks) : block;
                Value nonNullValue = code.createValue(ValueType.OBJECT, knownToBeNonNullValue.getLocalInfo());
                NonNull nonNull = new NonNull(nonNullValue, knownToBeNonNullValue, current);
                nonNull.setPosition(current.getPosition());
                if (blockWithNonNullInstruction != block) {
                    blockWithNonNullInstruction.listIterator().add(nonNull);
                } else {
                    iterator.add(nonNull);
                }
                Set<Instruction> users = knownToBeNonNullValue.uniqueUsers();
                Set<Instruction> dominatedUsers = Sets.newIdentityHashSet();
                Iterator<Phi> dominatedPhiUsers = Sets.newIdentityHashSet();
                DominatorTree dominatorTree2 = new DominatorTree(code);
                Set<BasicBlock> dominatedBlocks = Sets.newIdentityHashSet();
                for (BasicBlock dominatee : dominatorTree2.dominatedBlocks(blockWithNonNullInstruction)) {
                    dominatedBlocks.add(dominatee);
                    InstructionListIterator dominateeIterator = dominatee.listIterator();
                    if (dominatee == blockWithNonNullInstruction) {
                        dominateeIterator.nextUntil(instruction -> instruction == nonNull);
                    }
                    while (dominateeIterator.hasNext()) {
                        Instruction potentialUser = (Instruction)dominateeIterator.next();
                        assert (potentialUser != nonNull);
                        if (!users.contains(potentialUser)) continue;
                        dominatedUsers.add(potentialUser);
                    }
                }
                for (Phi user : knownToBeNonNullValue.uniquePhiUsers()) {
                    if (!dominatedBlocks.contains(user.getBlock())) continue;
                    dominatedPhiUsers.add(user);
                }
                knownToBeNonNullValue.replaceSelectiveUsers(nonNullValue, dominatedUsers, (Set<Phi>)((Object)dominatedPhiUsers));
            }
            if (!block.exit().isIf() || !block.exit().asIf().isZeroTest() || (knownToBeNonNullValue = (theIf = block.exit().asIf()).inValues().get(0)).isNeverNull() || (target = theIf.targetFromCondition(1L)).isEmpty() || !(dominatorTree = new DominatorTree(code)).dominatedBy(target, block)) continue;
            Set<Instruction> dominatedUsers = Sets.newIdentityHashSet();
            Set<Phi> dominatedPhiUsers = Sets.newIdentityHashSet();
            HashSet<BasicBlock> dominatedBlocks = Sets.newHashSet(dominatorTree.dominatedBlocks(target));
            for (Instruction instruction2 : knownToBeNonNullValue.uniqueUsers()) {
                if (!dominatedBlocks.contains(instruction2.getBlock())) continue;
                dominatedUsers.add(instruction2);
            }
            for (Phi phi : knownToBeNonNullValue.uniquePhiUsers()) {
                if (!dominatedBlocks.contains(phi.getBlock())) continue;
                dominatedPhiUsers.add(phi);
            }
            if (dominatedUsers.isEmpty() || dominatedPhiUsers.isEmpty()) continue;
            Value nonNullValue = code.createValue(knownToBeNonNullValue.outType(), knownToBeNonNullValue.getLocalInfo());
            NonNull nonNull = new NonNull(nonNullValue, knownToBeNonNullValue, theIf);
            InstructionListIterator targetIterator = target.listIterator();
            nonNull.setPosition(((Instruction)targetIterator.next()).getPosition());
            targetIterator.previous();
            targetIterator.add(nonNull);
            knownToBeNonNullValue.replaceSelectiveUsers(nonNullValue, dominatedUsers, dominatedPhiUsers);
        }
    }

    public void cleanupNonNull(IRCode code) {
        InstructionIterator it = code.instructionIterator();
        boolean needToCheckTrivialPhis = false;
        while (it.hasNext()) {
            Instruction instruction = (Instruction)it.next();
            if (!instruction.isNonNull()) continue;
            NonNull nonNull = instruction.asNonNull();
            Value src = nonNull.src();
            Value dest = nonNull.dest();
            needToCheckTrivialPhis = needToCheckTrivialPhis || dest.uniquePhiUsers().size() != 0;
            dest.replaceUsers(src);
            it.remove();
        }
        if (needToCheckTrivialPhis) {
            code.removeAllTrivialPhis();
        }
    }
}

