/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.MemberNameMinifier;
import com.android.tools.r8.naming.NamingState;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MethodJavaSignatureEquivalence;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

class MethodNameMinifier
extends MemberNameMinifier<DexMethod, DexProto> {
    private final Equivalence<DexMethod> equivalence;

    MethodNameMinifier(AppInfoWithSubtyping appInfo, RootSetBuilder.RootSet rootSet, InternalOptions options) {
        super(appInfo, rootSet, options);
        this.equivalence = this.overloadAggressively ? MethodSignatureEquivalence.get() : MethodJavaSignatureEquivalence.get();
    }

    @Override
    Function<DexProto, ?> getKeyTransform() {
        if (this.overloadAggressively) {
            return a -> a;
        }
        return proto -> proto.parameters;
    }

    Map<DexMethod, DexString> computeRenaming(Timing timing) {
        timing.begin("Phase 1");
        IdentityHashMap<DexType, DexType> frontierMap = new IdentityHashMap<DexType, DexType>();
        this.reserveNamesInClasses(this.appInfo.dexItemFactory.objectType, this.appInfo.dexItemFactory.objectType, null, frontierMap);
        timing.end();
        timing.begin("Phase 2");
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, iface -> this.reserveNamesInInterfaces((DexType)iface, (Map<DexType, DexType>)frontierMap));
        timing.end();
        timing.begin("Phase 3");
        this.assignNamesToInterfaceMethods(frontierMap, timing);
        timing.end();
        timing.begin("Phase 4");
        this.assignNamesToClassesMethods(this.appInfo.dexItemFactory.objectType, false);
        timing.end();
        timing.begin("Phase 5");
        this.assignNamesToClassesMethods(this.appInfo.dexItemFactory.objectType, true);
        timing.end();
        return this.renaming;
    }

    private void assignNamesToClassesMethods(DexType type, boolean doPrivates) {
        DexClass holder = this.appInfo.definitionFor(type);
        if (holder != null && !holder.isLibraryClass()) {
            IdentityHashMap<DexMethod, DexString> renamingAtThisLevel = new IdentityHashMap<DexMethod, DexString>();
            NamingState state = this.computeStateIfAbsent(type, k -> this.getState(holder.superType).createChild());
            holder.forEachMethod(method -> this.assignNameToMethod((DexEncodedMethod)method, state, (Map<DexMethod, DexString>)renamingAtThisLevel, doPrivates));
            if (!doPrivates && !this.useUniqueMemberNames) {
                renamingAtThisLevel.forEach((method, candidate) -> state.addRenaming(method.name, method.proto, (DexString)candidate));
            }
        }
        type.forAllExtendsSubtypes(subtype -> this.assignNamesToClassesMethods((DexType)subtype, doPrivates));
    }

    private void assignNameToMethod(DexEncodedMethod encodedMethod, NamingState<DexProto, ?> state, Map<DexMethod, DexString> renamingAtThisLevel, boolean doPrivates) {
        if (encodedMethod.accessFlags.isPrivate() != doPrivates) {
            return;
        }
        DexMethod method = encodedMethod.method;
        if (!state.isReserved(method.name, method.proto) && !encodedMethod.accessFlags.isConstructor()) {
            DexString renamedName = state.assignNewNameFor(method.name, method.proto, this.useUniqueMemberNames);
            this.renaming.put(method, renamedName);
            renamingAtThisLevel.put(method, renamedName);
        }
    }

    private Set<NamingState<DexProto, ?>> getReachableStates(DexType type, Map<DexType, DexType> frontierMap) {
        Set<DexType> interfaces = Sets.newIdentityHashSet();
        interfaces.add(type);
        this.collectSuperInterfaces(type, interfaces);
        this.collectSubInterfaces(type, interfaces);
        HashSet reachableStates = new HashSet();
        for (DexType iface : interfaces) {
            reachableStates.add(this.getState(iface));
            iface.forAllImplementsSubtypes(t -> {
                NamingState state = this.getState((DexType)frontierMap.get(t));
                assert (state != null);
                reachableStates.add(state);
            });
        }
        return reachableStates;
    }

    private void assignNamesToInterfaceMethods(Map<DexType, DexType> frontierMap, Timing timing) {
        timing.begin("Compute map");
        HashMap globalStateMap = new HashMap();
        HashMap sourceMethodsMap = new HashMap();
        HashMap originStates = new HashMap();
        DexType.forAllInterfaces(this.appInfo.dexItemFactory, iface -> {
            assert (iface.isInterface());
            DexClass clazz = this.appInfo.definitionFor((DexType)iface);
            if (clazz != null) {
                Set<NamingState<DexProto, ?>> collectedStates = this.getReachableStates((DexType)iface, frontierMap);
                clazz.forEachMethod(method -> this.addStatesToGlobalMapForMethod((DexEncodedMethod)method, collectedStates, globalStateMap, sourceMethodsMap, originStates, (DexType)iface));
            }
        });
        timing.end();
        timing.begin("Allocate names");
        ArrayList methods = new ArrayList(globalStateMap.keySet());
        methods.sort((a, b) -> ((Set)globalStateMap.get(b)).size() - ((Set)globalStateMap.get(a)).size());
        for (Equivalence.Wrapper key : methods) {
            DexMethod method = (DexMethod)key.get();
            this.assignNameForInterfaceMethodInAllStates(method, (Set)globalStateMap.get(key), (Set)sourceMethodsMap.get(key), (NamingState)originStates.get(key));
        }
        timing.end();
    }

    private void collectSuperInterfaces(DexType iface, Set<DexType> interfaces) {
        DexClass clazz = this.appInfo.definitionFor(iface);
        if (clazz != null) {
            for (DexType type : clazz.interfaces.values) {
                if (!interfaces.add(type)) continue;
                this.collectSuperInterfaces(type, interfaces);
            }
        }
    }

    private void collectSubInterfaces(DexType iface, Set<DexType> interfaces) {
        iface.forAllExtendsSubtypes(subtype -> {
            assert (subtype.isInterface());
            if (interfaces.add((DexType)subtype)) {
                this.collectSubInterfaces((DexType)subtype, interfaces);
            }
        });
    }

    private void addStatesToGlobalMapForMethod(DexEncodedMethod method, Set<NamingState<DexProto, ?>> collectedStates, Map<Equivalence.Wrapper<DexMethod>, Set<NamingState<DexProto, ?>>> globalStateMap, Map<Equivalence.Wrapper<DexMethod>, Set<DexMethod>> sourceMethodsMap, Map<Equivalence.Wrapper<DexMethod>, NamingState<DexProto, ?>> originStates, DexType originInterface) {
        Equivalence.Wrapper<DexMethod> key = this.equivalence.wrap(method.method);
        Set stateSet = globalStateMap.computeIfAbsent(key, k -> new HashSet());
        stateSet.addAll(collectedStates);
        sourceMethodsMap.computeIfAbsent(key, k -> new HashSet()).add(method.method);
        originStates.putIfAbsent(key, this.getState(originInterface));
    }

    private void assignNameForInterfaceMethodInAllStates(DexMethod method, Set<NamingState<DexProto, ?>> collectedStates, Set<DexMethod> sourceMethods, NamingState<DexProto, ?> originState) {
        boolean isReserved = false;
        if (this.globalState.isReserved(method.name, method.proto)) {
            for (NamingState<DexProto, ?> state : collectedStates) {
                if (!state.isReserved(method.name, method.proto)) continue;
                isReserved = true;
                break;
            }
            if (isReserved) {
                for (NamingState<DexProto, ?> state : collectedStates) {
                    state.reserveName(method.name, method.proto);
                }
                return;
            }
        }
        DexString candidate = null;
        block2: do {
            candidate = originState.assignNewNameFor(method.name, method.proto, false);
            for (NamingState<DexProto, ?> state : collectedStates) {
                if (state.isAvailable(method.name, method.proto, candidate)) continue;
                candidate = null;
                continue block2;
            }
        } while (candidate == null);
        for (NamingState<DexProto, ?> state : collectedStates) {
            state.addRenaming(method.name, method.proto, candidate);
        }
        for (DexMethod sourceMethod : sourceMethods) {
            this.renaming.put(sourceMethod, candidate);
        }
    }

    private void reserveNamesInClasses(DexType type, DexType libraryFrontier, NamingState<DexProto, ?> parent, Map<DexType, DexType> frontierMap) {
        assert (!type.isInterface());
        DexClass holder = this.appInfo.definitionFor(type);
        NamingState<DexProto, ?> state = this.allocateNamingStateAndReserve(holder, type, libraryFrontier, parent, frontierMap);
        type.forAllExtendsSubtypes(subtype -> {
            assert (!subtype.isInterface());
            this.reserveNamesInClasses((DexType)subtype, holder == null || holder.isLibraryClass() ? subtype : libraryFrontier, state, frontierMap);
        });
    }

    private void reserveNamesInInterfaces(DexType type, Map<DexType, DexType> frontierMap) {
        assert (type.isInterface());
        frontierMap.put(type, type);
        DexClass holder = this.appInfo.definitionFor(type);
        this.allocateNamingStateAndReserve(holder, type, type, null, frontierMap);
    }

    private NamingState<DexProto, ?> allocateNamingStateAndReserve(DexClass holder, DexType type, DexType libraryFrontier, NamingState<DexProto, ?> parent, Map<DexType, DexType> frontierMap) {
        frontierMap.put(type, libraryFrontier);
        NamingState state = this.computeStateIfAbsent(libraryFrontier, ignore -> parent == null ? NamingState.createRoot(this.appInfo.dexItemFactory, this.dictionary, this.getKeyTransform(), this.useUniqueMemberNames) : parent.createChild());
        if (holder != null) {
            boolean keepAll = holder.isLibraryClass() || holder.accessFlags.isAnnotation();
            holder.forEachMethod(method -> this.reserveNamesForMethod((DexEncodedMethod)method, keepAll, state));
        }
        return state;
    }

    private void reserveNamesForMethod(DexEncodedMethod method, boolean keepAll, NamingState<DexProto, ?> state) {
        if (keepAll || this.rootSet.noObfuscation.contains(method)) {
            state.reserveName(method.method.name, method.method.proto);
            this.globalState.reserveName(method.method.name, method.method.proto);
        }
    }
}

