/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.optimize.InvokeSingleTargetExtractor;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.IdentityHashMap;
import java.util.Map;

public class BridgeMethodAnalysis {
    private final GraphLense lense;
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final Map<DexMethod, DexMethod> bridgeTargetToBridgeMap = new IdentityHashMap<DexMethod, DexMethod>();

    public BridgeMethodAnalysis(GraphLense lense, Enqueuer.AppInfoWithLiveness appInfo) {
        this.lense = lense;
        this.appInfo = appInfo;
    }

    public GraphLense run() {
        for (DexClass dexClass : this.appInfo.classes()) {
            dexClass.forEachMethod(this::identifyBridgeMethod);
        }
        return new BridgeLense(this.lense, this.bridgeTargetToBridgeMap);
    }

    private void identifyBridgeMethod(DexEncodedMethod method) {
        if (method.accessFlags.isBridge() && !method.accessFlags.isAbstract()) {
            InvokeSingleTargetExtractor targetExtractor = new InvokeSingleTargetExtractor();
            method.getCode().registerCodeReferences(targetExtractor);
            DexMethod target = targetExtractor.getTarget();
            InvokeSingleTargetExtractor.InvokeKind kind = targetExtractor.getKind();
            if (target != null && target.getArity() == method.method.getArity()) {
                DexEncodedMethod targetMethod;
                assert (!method.accessFlags.isPrivate() && !method.accessFlags.isConstructor());
                target = this.lense.lookupMethod(target, method);
                if (kind == InvokeSingleTargetExtractor.InvokeKind.STATIC) {
                    assert (method.accessFlags.isStatic());
                    DexEncodedMethod targetMethod2 = this.appInfo.lookupStaticTarget(target);
                    if (targetMethod2 != null) {
                        this.addForwarding(method, targetMethod2);
                    }
                } else if (kind == InvokeSingleTargetExtractor.InvokeKind.VIRTUAL && (targetMethod = this.appInfo.lookupSingleVirtualTarget(target)) != null) {
                    this.addForwarding(method, targetMethod);
                }
            }
        }
    }

    private void addForwarding(DexEncodedMethod method, DexEncodedMethod target) {
        this.bridgeTargetToBridgeMap.put(target.method, method.method);
    }

    private static class BridgeLense
    extends GraphLense {
        private final GraphLense previousLense;
        private final Map<DexMethod, DexMethod> bridgeTargetToBridgeMap;

        private BridgeLense(GraphLense previousLense, Map<DexMethod, DexMethod> bridgeTargetToBridgeMap) {
            this.previousLense = previousLense;
            this.bridgeTargetToBridgeMap = bridgeTargetToBridgeMap;
        }

        @Override
        public DexType lookupType(DexType type, DexEncodedMethod context) {
            return this.previousLense.lookupType(type, context);
        }

        @Override
        public DexMethod lookupMethod(DexMethod method, DexEncodedMethod context) {
            DexMethod previous = this.previousLense.lookupMethod(method, context);
            DexMethod target = this.bridgeTargetToBridgeMap.get(previous);
            if (target == null || context.accessFlags.isBridge() && target == context.method) {
                return previous;
            }
            return target;
        }

        @Override
        public DexField lookupField(DexField field, DexEncodedMethod context) {
            return this.previousLense.lookupField(field, context);
        }

        @Override
        public boolean isContextFree() {
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("------ BridgeMap ------").append(System.lineSeparator());
            for (Map.Entry<DexMethod, DexMethod> entry : this.bridgeTargetToBridgeMap.entrySet()) {
                builder.append(entry.getKey().toSourceString()).append(" -> ");
                builder.append(entry.getValue().toSourceString()).append(System.lineSeparator());
            }
            builder.append("-----------------------").append(System.lineSeparator());
            builder.append(this.previousLense.toString());
            return builder.toString();
        }
    }
}

