/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.CompilationError;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void iter(String zipFileStr, OnEntryHandler handler) throws IOException {
        try (ZipFile zipFile = new ZipFile(zipFileStr);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream entryStream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    handler.onEntry(entry, entryStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (entryStream == null) continue;
                    ZipUtils.$closeResource(throwable, entryStream);
                }
            }
        }
    }

    public static List<File> unzip(String zipFile, File outDirectory) throws IOException {
        return ZipUtils.unzip(zipFile, outDirectory, entry -> true);
    }

    public static List<File> unzip(String zipFile, File outDirectory, Predicate<ZipEntry> filter) throws IOException {
        Path outDirectoryPath = outDirectory.toPath();
        ArrayList<File> outFiles = new ArrayList<File>();
        ZipUtils.iter(zipFile, (entry, input) -> {
            String name = entry.getName();
            if (!entry.isDirectory() && filter.test(entry)) {
                if (name.contains("..")) {
                    throw new CompilationError("Invalid entry name \"" + name + "\"");
                }
                Path outPath = outDirectoryPath.resolve(name);
                File outFile = outPath.toFile();
                outFile.getParentFile().mkdirs();
                FileOutputStream output = new FileOutputStream(outFile);
                Throwable throwable = null;
                try {
                    ByteStreams.copy(input, output);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    ZipUtils.$closeResource(throwable, output);
                }
                outFiles.add(outFile);
            }
        });
        return outFiles;
    }

    public static void writeToZipStream(ZipOutputStream stream, String entry, byte[] content, int compressionMethod) throws IOException {
        ZipUtils.writeToZipStream(stream, entry, content, compressionMethod, false);
    }

    public static void writeToZipStream(ZipOutputStream stream, String entry, byte[] content, int compressionMethod, boolean setZeroTime) throws IOException {
        CRC32 crc = new CRC32();
        crc.update(content);
        ZipEntry zipEntry = new ZipEntry(entry);
        zipEntry.setMethod(compressionMethod);
        zipEntry.setSize(content.length);
        zipEntry.setCrc(crc.getValue());
        if (setZeroTime) {
            zipEntry.setTime(0L);
        }
        stream.putNextEntry(zipEntry);
        stream.write(content);
        stream.closeEntry();
    }

    public static interface OnEntryHandler {
        public void onEntry(ZipEntry var1, InputStream var2) throws IOException;
    }
}

