/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfInvoke
extends CfInstruction {
    private final DexMethod method;
    private final int opcode;
    private final boolean itf;

    public CfInvoke(int opcode, DexMethod method, boolean itf) {
        assert (182 <= opcode && opcode <= 185);
        assert (opcode != 182 || !itf) : "InvokeVirtual on interface type";
        assert (opcode != 185 || itf) : "InvokeInterface on class type";
        this.opcode = opcode;
        this.method = method;
        this.itf = itf;
    }

    public DexMethod getMethod() {
        return this.method;
    }

    public int getOpcode() {
        return this.opcode;
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        String owner = lens.lookupInternalName(this.method.getHolder());
        String name = lens.lookupName(this.method).toString();
        String desc = this.method.proto.toDescriptorString(lens);
        visitor.visitMethodInsn(this.opcode, owner, name, desc, this.itf);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void registerUse(UseRegistry registry, DexType clazz) {
        switch (this.opcode) {
            case 185: {
                registry.registerInvokeInterface(this.method);
                break;
            }
            case 182: {
                registry.registerInvokeVirtual(this.method);
                break;
            }
            case 183: {
                if (this.method.name.toString().equals("<init>")) {
                    registry.registerInvokeDirect(this.method);
                    break;
                }
                if (this.method.holder == clazz) {
                    registry.registerInvokeDirect(this.method);
                    break;
                }
                registry.registerInvokeSuper(this.method);
                break;
            }
            case 184: {
                registry.registerInvokeStatic(this.method);
                break;
            }
            default: {
                throw new Unreachable("unknown CfInvoke opcode " + this.opcode);
            }
        }
    }
}

