/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.Handle;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Type;
import java.util.List;

public class CfInvokeDynamic
extends CfInstruction {
    private final DexCallSite callSite;

    public CfInvokeDynamic(DexCallSite callSite) {
        this.callSite = callSite;
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        DexString methodName;
        DexMethodHandle bootstrapMethod = this.callSite.bootstrapMethod;
        List<DexValue> bootstrapArgs = this.callSite.bootstrapArgs;
        Object[] bsmArgs = new Object[bootstrapArgs.size()];
        for (int i = 0; i < bootstrapArgs.size(); ++i) {
            bsmArgs[i] = this.decodeBootstrapArgument(bootstrapArgs.get(i), lens);
        }
        Handle bsmHandle = bootstrapMethod.toAsmHandle(lens);
        if (lens.isIdentityLens()) {
            methodName = this.callSite.methodName;
        } else if (!this.callSite.interfaceMethods.isEmpty()) {
            methodName = lens.lookupName(this.callSite.interfaceMethods.get(0));
        } else {
            throw new Unimplemented("Minification of non-lambda InvokeDynamic not supported");
        }
        visitor.visitInvokeDynamicInsn(methodName.toString(), this.callSite.methodProto.toDescriptorString(lens), bsmHandle, bsmArgs);
    }

    private Object decodeBootstrapArgument(DexValue dexValue, NamingLens lens) {
        if (dexValue instanceof DexValue.DexValueInt) {
            return ((DexValue.DexValueInt)dexValue).getValue();
        }
        if (dexValue instanceof DexValue.DexValueLong) {
            return ((DexValue.DexValueLong)dexValue).getValue();
        }
        if (dexValue instanceof DexValue.DexValueFloat) {
            return Float.valueOf(((DexValue.DexValueFloat)dexValue).getValue());
        }
        if (dexValue instanceof DexValue.DexValueDouble) {
            return ((DexValue.DexValueDouble)dexValue).getValue();
        }
        if (dexValue instanceof DexValue.DexValueString) {
            return ((DexValue.DexValueString)dexValue).getValue();
        }
        if (dexValue instanceof DexValue.DexValueType) {
            return Type.getType(lens.lookupDescriptor((DexType)((DexValue.DexValueType)dexValue).value).toString());
        }
        if (dexValue instanceof DexValue.DexValueMethodType) {
            return Type.getMethodType(((DexProto)((DexValue.DexValueMethodType)dexValue).value).toDescriptorString(lens));
        }
        if (dexValue instanceof DexValue.DexValueMethodHandle) {
            return ((DexMethodHandle)((DexValue.DexValueMethodHandle)dexValue).value).toAsmHandle(lens);
        }
        throw new Unreachable("Unsupported bootstrap argument of type " + dexValue.getClass().getSimpleName());
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public DexCallSite getCallSite() {
        return this.callSite;
    }

    @Override
    public void registerUse(UseRegistry registry, DexType clazz) {
        registry.registerCallSite(this.callSite);
    }
}

