/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;

public class ClassTypeLatticeElement
extends TypeLatticeElement {
    private final DexType classType;

    ClassTypeLatticeElement(DexType classType, boolean isNullable) {
        super(isNullable);
        assert (classType.isClassType());
        this.classType = classType;
    }

    public DexType getClassType() {
        return this.classType;
    }

    @Override
    TypeLatticeElement asNullable() {
        return this.isNullable() ? this : new ClassTypeLatticeElement(this.classType, true);
    }

    @Override
    public TypeLatticeElement asNonNullable() {
        return this.isNullable() ? new ClassTypeLatticeElement(this.classType, false) : this;
    }

    @Override
    public boolean isClassTypeLatticeElement() {
        return true;
    }

    @Override
    public ClassTypeLatticeElement asClassTypeLatticeElement() {
        return this;
    }

    @Override
    public TypeLatticeElement arrayGet(AppInfo appInfo) {
        return ClassTypeLatticeElement.objectType(appInfo, true);
    }

    @Override
    public String toString() {
        return this.isNullableString() + this.classType.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ClassTypeLatticeElement other = (ClassTypeLatticeElement)o;
        return this.classType == other.classType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.classType.hashCode();
        return result;
    }
}

