/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NativeLibraryAbiPredicate
implements Predicate<String> {
    private static final Pattern ABI_PATTERN = Pattern.compile("lib/([^/]+)/([^/]+)");
    private static final String NATIVE_LIBRARY_EXTENSION = ".so";
    private Set<String> acceptedAbis;
    private final boolean jniDebugMode;

    public NativeLibraryAbiPredicate(Set<String> acceptedAbis, boolean jniDebugMode) {
        this.acceptedAbis = Sets.newHashSet(acceptedAbis);
        this.jniDebugMode = jniDebugMode;
    }

    @Override
    public boolean test(String input) {
        Matcher AbiMatcher = ABI_PATTERN.matcher(input);
        if (!AbiMatcher.matches()) {
            return false;
        }
        String abi = AbiMatcher.group(1);
        String fileName = AbiMatcher.group(2);
        if (!this.acceptedAbis.isEmpty() && !this.acceptedAbis.contains(abi)) {
            return false;
        }
        if (fileName.endsWith(NATIVE_LIBRARY_EXTENSION)) {
            return true;
        }
        return this.jniDebugMode && ("gdbserver".equals(fileName) || "gdb.setup".equals(fileName));
    }
}

