/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfFieldInstruction;
import com.android.tools.r8.code.Format22c;
import com.android.tools.r8.code.Iput;
import com.android.tools.r8.code.IputBoolean;
import com.android.tools.r8.code.IputByte;
import com.android.tools.r8.code.IputChar;
import com.android.tools.r8.code.IputObject;
import com.android.tools.r8.code.IputShort;
import com.android.tools.r8.code.IputWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import java.util.Arrays;

public class InstancePut
extends FieldInstruction {
    public InstancePut(MemberType type, DexField field, Value object, Value value) {
        super(type, field, null, Arrays.asList(object, value));
        assert (this.object().type.isObjectOrNull());
        assert (this.value().type.compatible(ValueType.fromDexType(field.type)));
    }

    public Value object() {
        return (Value)this.inValues.get(0);
    }

    public Value value() {
        return (Value)this.inValues.get(1);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format22c instruction;
        int valueRegister = builder.allocatedRegister(this.value(), this.getNumber());
        int objectRegister = builder.allocatedRegister(this.object(), this.getNumber());
        switch (this.type) {
            case INT: 
            case FLOAT: 
            case INT_OR_FLOAT: {
                instruction = new Iput(valueRegister, objectRegister, this.field);
                break;
            }
            case LONG: 
            case DOUBLE: 
            case LONG_OR_DOUBLE: {
                instruction = new IputWide(valueRegister, objectRegister, this.field);
                break;
            }
            case OBJECT: {
                instruction = new IputObject(valueRegister, objectRegister, this.field);
                break;
            }
            case BOOLEAN: {
                instruction = new IputBoolean(valueRegister, objectRegister, this.field);
                break;
            }
            case BYTE: {
                instruction = new IputByte(valueRegister, objectRegister, this.field);
                break;
            }
            case CHAR: {
                instruction = new IputChar(valueRegister, objectRegister, this.field);
                break;
            }
            case SHORT: {
                instruction = new IputShort(valueRegister, objectRegister, this.field);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        InstancePut o = other.asInstancePut();
        return o.field == this.field && o.type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        InstancePut o = other.asInstancePut();
        int result = this.field.slowCompareTo(o.field);
        if (result != 0) {
            return result;
        }
        return this.type.ordinal() - o.type.ordinal();
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "InstancePut instructions define no values.";
        return 0;
    }

    @Override
    DexEncodedField lookupTarget(DexType type, AppInfo appInfo) {
        return appInfo.lookupInstanceTarget(type, this.field);
    }

    @Override
    public boolean isInstancePut() {
        return true;
    }

    @Override
    public InstancePut asInstancePut() {
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + "; field: " + this.field.toSourceString();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfFieldInstruction(181, this.field, builder.resolveField(this.field)));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value) {
        return this.object() == value;
    }
}

