/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Opcodes;
import java.util.List;
import java.util.Objects;

public class CfFrame
extends CfInstruction {
    private final Int2ReferenceSortedMap<FrameType> locals;
    private final List<FrameType> stack;

    public CfFrame(Int2ReferenceSortedMap<FrameType> locals, List<FrameType> stack) {
        assert (locals.values().stream().allMatch(Objects::nonNull));
        assert (stack.stream().allMatch(Objects::nonNull));
        this.locals = locals;
        this.stack = stack;
    }

    public Int2ReferenceSortedMap<FrameType> getLocals() {
        return this.locals;
    }

    public List<FrameType> getStack() {
        return this.stack;
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        int stackCount = this.computeStackCount();
        Object[] stackTypes = this.computeStackTypes(stackCount, lens);
        int localsCount = this.computeLocalsCount();
        Object[] localsTypes = this.computeLocalsTypes(localsCount, lens);
        visitor.visitFrame(-1, localsCount, localsTypes, stackCount, stackTypes);
    }

    private int computeStackCount() {
        return this.stack.size();
    }

    private Object[] computeStackTypes(int stackCount, NamingLens lens) {
        assert (stackCount == this.stack.size());
        if (stackCount == 0) {
            return null;
        }
        Object[] stackTypes = new Object[stackCount];
        for (int i = 0; i < stackCount; ++i) {
            stackTypes[i] = this.stack.get(i).getTypeOpcode(lens);
        }
        return stackTypes;
    }

    private int computeLocalsCount() {
        if (this.locals.isEmpty()) {
            return 0;
        }
        int maxRegister = this.locals.lastIntKey();
        int localsCount = 0;
        for (int i = 0; i <= maxRegister; ++i) {
            ++localsCount;
            FrameType type = (FrameType)this.locals.get(i);
            if (type == null || !type.isWide()) continue;
            ++i;
        }
        return localsCount;
    }

    private Object[] computeLocalsTypes(int localsCount, NamingLens lens) {
        if (localsCount == 0) {
            return null;
        }
        int maxRegister = this.locals.lastIntKey();
        Object[] localsTypes = new Object[localsCount];
        int localIndex = 0;
        for (int i = 0; i <= maxRegister; ++i) {
            FrameType type = (FrameType)this.locals.get(i);
            Object object = localsTypes[localIndex++] = type == null ? Opcodes.TOP : type.getTypeOpcode(lens);
            if (type == null || !type.isWide()) continue;
            ++i;
        }
        return localsTypes;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    private static class UninitializedThis
    extends FrameType {
        private UninitializedThis() {
        }

        @Override
        Object getTypeOpcode(NamingLens lens) {
            return Opcodes.UNINITIALIZED_THIS;
        }

        public String toString() {
            return "uninitialized this";
        }
    }

    private static class UninitializedNew
    extends FrameType {
        private final CfLabel label;

        private UninitializedNew(CfLabel label) {
            this.label = label;
        }

        public String toString() {
            return "uninitialized new";
        }

        @Override
        Object getTypeOpcode(NamingLens lens) {
            return this.label.getLabel();
        }

        @Override
        public CfLabel getUninitializedLabel() {
            return this.label;
        }
    }

    private static class Top
    extends FrameType {
        private static final Top SINGLETON = new Top();

        private Top() {
        }

        public String toString() {
            return "top";
        }

        @Override
        Object getTypeOpcode(NamingLens lens) {
            return Opcodes.TOP;
        }
    }

    private static class InitializedType
    extends FrameType {
        private final DexType type;

        private InitializedType(DexType type) {
            assert (type != null);
            this.type = type;
        }

        public String toString() {
            return this.type.toString();
        }

        @Override
        Object getTypeOpcode(NamingLens lens) {
            if (this.type == DexItemFactory.nullValueType) {
                return Opcodes.NULL;
            }
            switch (this.type.toShorty()) {
                case 'L': {
                    return lens.lookupInternalName(this.type);
                }
                case 'I': {
                    return Opcodes.INTEGER;
                }
                case 'F': {
                    return Opcodes.FLOAT;
                }
                case 'J': {
                    return Opcodes.LONG;
                }
                case 'D': {
                    return Opcodes.DOUBLE;
                }
            }
            throw new Unreachable("Unexpected value type: " + this.type);
        }

        @Override
        public boolean isWide() {
            return this.type.isPrimitiveType() && (this.type.toShorty() == 'J' || this.type.toShorty() == 'D');
        }
    }

    public static abstract class FrameType {
        public static FrameType initialized(DexType type) {
            return new InitializedType(type);
        }

        public static FrameType uninitializedNew(CfLabel label) {
            return new UninitializedNew(label);
        }

        public static FrameType uninitializedThis() {
            return new UninitializedThis();
        }

        public static FrameType top() {
            return Top.SINGLETON;
        }

        abstract Object getTypeOpcode(NamingLens var1);

        public boolean isWide() {
            return false;
        }

        public boolean isUninitializedNew() {
            return false;
        }

        public CfLabel getUninitializedLabel() {
            return null;
        }

        private FrameType() {
        }
    }
}

