/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AccessFlags;
import java.util.List;
import java.util.function.BooleanSupplier;

public class ClassAccessFlags
extends AccessFlags {
    private static final int SHARED_FLAGS = 30239;
    private static final int DEX_FLAGS = 30239;
    private static final int CF_FLAGS = 30271;

    @Override
    protected List<String> getNames() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(super.getNames())).add("interface")).add("abstract")).add("annotation")).add("enum")).add("super")).build();
    }

    @Override
    protected List<BooleanSupplier> getPredicates() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(super.getPredicates())).add(this::isInterface)).add(this::isAbstract)).add(this::isAnnotation)).add(this::isEnum)).add(this::isSuper)).build();
    }

    private ClassAccessFlags(int flags) {
        super(flags);
    }

    public static ClassAccessFlags fromSharedAccessFlags(int access) {
        assert ((access & 0x761F) == access);
        return ClassAccessFlags.fromDexAccessFlags(access);
    }

    public static ClassAccessFlags fromDexAccessFlags(int access) {
        return new ClassAccessFlags(access & 0x761F | 0x20);
    }

    public static ClassAccessFlags fromCfAccessFlags(int access) {
        return new ClassAccessFlags(access & 0x763F);
    }

    public ClassAccessFlags copy() {
        return new ClassAccessFlags(this.flags);
    }

    @Override
    public int getAsDexAccessFlags() {
        if (this.isInterface()) {
            return this.flags & 0xFFFFFFDF | 0x400;
        }
        return this.flags & 0xFFFFFFDF;
    }

    @Override
    public int getAsCfAccessFlags() {
        return this.flags;
    }

    public boolean areValid(int majorVersion) {
        if (this.isInterface()) {
            if (majorVersion >= 53 && this.isSuper()) {
                return false;
            }
            if (majorVersion >= 51 && !this.isAbstract()) {
                return false;
            }
            return !this.isFinal() && !this.isEnum();
        }
        return !this.isAnnotation() && (!this.isFinal() || !this.isAbstract());
    }

    public boolean isInterface() {
        return this.isSet(512);
    }

    public void setInterface() {
        this.set(512);
    }

    public void unsetInterface() {
        this.unset(512);
    }

    public boolean isAbstract() {
        return this.isSet(1024);
    }

    public void setAbstract() {
        this.set(1024);
    }

    public void unsetAbstract() {
        this.unset(1024);
    }

    public boolean isAnnotation() {
        return this.isSet(8192);
    }

    public void setAnnotation() {
        this.set(8192);
    }

    public void unsetAnnotation() {
        this.unset(8192);
    }

    public boolean isEnum() {
        return this.isSet(16384);
    }

    public void setEnum() {
        this.set(16384);
    }

    public boolean isSuper() {
        return this.isSet(32);
    }

    public void setSuper() {
        this.set(32);
    }

    public void unsetSuper() {
        this.unset(32);
    }
}

