/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.cf.CfRegisterAllocator;
import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Load;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.Store;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class CfBuilder {
    private final DexItemFactory factory;
    private final DexEncodedMethod method;
    private final IRCode code;
    private Map<Value, DexType> types;
    private Map<BasicBlock, CfLabel> labels;
    private Set<CfLabel> emittedLabels;
    private List<CfInstruction> instructions;
    private CfRegisterAllocator registerAllocator;
    private Position currentPosition = Position.none();
    private final Int2ReferenceMap<DebugLocalInfo> emittedLocals = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
    private Int2ReferenceMap<DebugLocalInfo> pendingLocals = null;
    private boolean pendingLocalChanges = false;
    private final List<CfCode.LocalVariableInfo> localVariablesTable = new ArrayList<CfCode.LocalVariableInfo>();
    private final Int2ReferenceMap<CfCode.LocalVariableInfo> openLocalVariables = new Int2ReferenceOpenHashMap<CfCode.LocalVariableInfo>();
    private AppInfoWithSubtyping appInfo;
    private Map<NewInstance, List<InvokeDirect>> initializers;
    private List<InvokeDirect> thisInitializers;
    private Map<NewInstance, CfLabel> newInstanceLabels;

    public CfBuilder(DexEncodedMethod method, IRCode code, DexItemFactory factory) {
        this.method = method;
        this.code = code;
        this.factory = factory;
    }

    public DexItemFactory getFactory() {
        return this.factory;
    }

    public CfCode build(CodeRewriter rewriter, InternalOptions options, AppInfoWithSubtyping appInfo) {
        this.computeInitializers();
        this.types = new TypeVerificationHelper(this.code, this.factory, appInfo).computeVerificationTypes();
        this.splitExceptionalBlocks();
        LoadStoreHelper loadStoreHelper = new LoadStoreHelper(this.code, this.types);
        loadStoreHelper.insertLoadsAndStores();
        DeadCodeRemover.removeDeadCode(this.code, rewriter, options);
        this.removeUnneededLoadsAndStores();
        this.registerAllocator = new CfRegisterAllocator(this.code, options);
        this.registerAllocator.allocateRegisters();
        loadStoreHelper.insertPhiMoves(this.registerAllocator);
        CodeRewriter.collapsTrivialGotos(this.method, this.code);
        int instructionTableCount = DexBuilder.instructionNumberToIndex(this.code.numberRemainingInstructions());
        DexBuilder.removeRedundantDebugPositions(this.code, instructionTableCount);
        this.appInfo = appInfo;
        CfCode code = this.buildCfCode();
        return code;
    }

    public DexField resolveField(DexField field) {
        DexEncodedField resolvedField = this.appInfo.resolveFieldOn(field.clazz, field);
        return resolvedField == null ? field : resolvedField.field;
    }

    private void computeInitializers() {
        assert (this.initializers == null);
        assert (this.thisInitializers == null);
        this.initializers = new HashMap<NewInstance, List<InvokeDirect>>();
        for (BasicBlock block : this.code.blocks) {
            for (Instruction insn : block.getInstructions()) {
                if (insn.isNewInstance()) {
                    this.initializers.put(insn.asNewInstance(), this.computeInitializers(insn.outValue()));
                    continue;
                }
                if (!insn.isArgument() || !this.method.isInstanceInitializer() || !insn.outValue().isThis()) continue;
                this.thisInitializers = this.computeInitializers(insn.outValue());
            }
        }
        assert (!this.method.isInstanceInitializer() || this.thisInitializers != null);
    }

    private List<InvokeDirect> computeInitializers(Value value) {
        ArrayList<InvokeDirect> initializers = new ArrayList<InvokeDirect>();
        for (Instruction user : value.uniqueUsers()) {
            if (!(user instanceof InvokeDirect) || user.inValues().get(0) != value || user.asInvokeDirect().getInvokedMethod().name != this.factory.constructorMethodName) continue;
            initializers.add(user.asInvokeDirect());
        }
        return initializers;
    }

    private void splitExceptionalBlocks() {
        ListIterator<BasicBlock> it = this.code.listIterator();
        while (it.hasNext()) {
            Instruction instruction;
            BasicBlock block = it.next();
            if (!block.hasCatchHandlers()) continue;
            int size = block.getInstructions().size();
            boolean isThrow = block.exit().isThrow();
            if (isThrow && size == 1 || !isThrow && size == 2) continue;
            InstructionListIterator instructions = block.listIterator();
            boolean hasOutValues = false;
            while (instructions.hasNext() && !(instruction = (Instruction)instructions.next()).instructionTypeCanThrow()) {
                hasOutValues |= instruction.outValue() != null;
            }
            if (!hasOutValues) continue;
            instructions.previous();
            instructions.split(this.code, it);
        }
    }

    private void removeUnneededLoadsAndStores() {
        ListIterator<BasicBlock> blockIterator = this.code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = (BasicBlock)blockIterator.next();
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction load;
                Instruction store = (Instruction)it.next();
                if (!(store instanceof Store) || store.outValue().numberOfAllUsers() != 1 || !((load = it.peekNext()) instanceof Load) || load.inValues().get(0) != store.outValue()) continue;
                Value storeIn = store.inValues().get(0);
                Value loadOut = load.outValue();
                loadOut.replaceUsers(storeIn);
                storeIn.removeUser(store);
                store.outValue().removeUser(load);
                it.previous();
                it.removeOrReplaceByDebugLocalRead();
                it.next();
                it.remove();
                it.previous();
            }
        }
    }

    private CfCode buildCfCode() {
        Stack stack = new Stack();
        ArrayList<CfTryCatch> tryCatchRanges = new ArrayList<CfTryCatch>();
        this.labels = new HashMap<BasicBlock, CfLabel>(this.code.blocks.size());
        this.emittedLabels = new HashSet<CfLabel>(this.code.blocks.size());
        this.newInstanceLabels = new HashMap<NewInstance, CfLabel>(this.initializers.size());
        this.instructions = new ArrayList<CfInstruction>();
        ListIterator<BasicBlock> blockIterator = this.code.listIterator();
        BasicBlock block = blockIterator.next();
        CfLabel tryCatchStart = null;
        CatchHandlers<BasicBlock> tryCatchHandlers = CatchHandlers.EMPTY_BASIC_BLOCK;
        BasicBlock pendingFrame = null;
        boolean previousFallthrough = false;
        do {
            JumpInstruction exit;
            assert (stack.isEmpty());
            CatchHandlers<BasicBlock> handlers = block.getCatchHandlers();
            if (!tryCatchHandlers.equals(handlers)) {
                if (!tryCatchHandlers.isEmpty()) {
                    CfLabel tryCatchEnd = this.getLabel(block);
                    tryCatchRanges.add(CfTryCatch.fromBuilder(tryCatchStart, tryCatchEnd, tryCatchHandlers, this));
                    this.emitLabel(tryCatchEnd);
                }
                if (!handlers.isEmpty()) {
                    tryCatchStart = this.getLabel(block);
                    this.emitLabel(tryCatchStart);
                }
                tryCatchHandlers = handlers;
            }
            BasicBlock nextBlock = blockIterator.hasNext() ? blockIterator.next() : null;
            if (block.getPredecessors().size() > (previousFallthrough ? 1 : 0)) {
                pendingFrame = block;
                this.emitLabel(this.getLabel(block));
            }
            if (pendingFrame != null) {
                boolean advancesPC = this.hasMaterializingInstructions(block, nextBlock);
                assert (advancesPC || nextBlock != null);
                if (advancesPC) {
                    this.addFrame(pendingFrame, Collections.emptyList());
                    pendingFrame = null;
                }
            }
            boolean fallthrough = (exit = block.exit()).isGoto() && exit.asGoto().getTarget() == nextBlock || exit.isIf() && exit.fallthroughBlock() == nextBlock;
            Int2ReferenceMap<DebugLocalInfo> locals = block.getLocalsAtEntry();
            if (locals == null) {
                assert (this.pendingLocals == null);
            } else {
                this.pendingLocals = new Int2ReferenceOpenHashMap<DebugLocalInfo>(locals);
                this.pendingLocalChanges = true;
            }
            this.buildCfInstructions(block, fallthrough, stack);
            block = nextBlock;
            previousFallthrough = fallthrough;
        } while (block != null);
        assert (stack.isEmpty());
        CfLabel endLabel = this.ensureLabel();
        for (CfCode.LocalVariableInfo info : this.openLocalVariables.values()) {
            info.setEnd(endLabel);
            this.localVariablesTable.add(info);
        }
        return new CfCode(this.method.method, stack.maxHeight, this.registerAllocator.registersUsed(), this.instructions, tryCatchRanges, this.localVariablesTable);
    }

    private static boolean isNopInstruction(Instruction instruction, BasicBlock nextBlock) {
        return instruction.isArgument() || instruction.isDebugLocalsChange() || instruction.isGoto() && instruction.asGoto().getTarget() == nextBlock;
    }

    private boolean hasMaterializingInstructions(BasicBlock block, BasicBlock nextBlock) {
        if (block == null) {
            return false;
        }
        for (Instruction instruction : block.getInstructions()) {
            if (CfBuilder.isNopInstruction(instruction, nextBlock)) continue;
            return true;
        }
        return false;
    }

    private void buildCfInstructions(BasicBlock block, boolean fallthrough, Stack stack) {
        InstructionIterator it = block.iterator();
        while (it.hasNext()) {
            Value outValue;
            Instruction instruction = (Instruction)it.next();
            if (fallthrough && instruction.isGoto()) {
                assert (block.exit() == instruction);
                return;
            }
            for (int i = instruction.inValues().size() - 1; i >= 0; --i) {
                if (!(instruction.inValues().get(i) instanceof StackValue)) continue;
                stack.pop(instruction.inValues().get(i));
            }
            if (instruction.outValue() != null && (outValue = instruction.outValue()) instanceof StackValue) {
                stack.push(outValue);
            }
            if (instruction.isDebugLocalsChange()) {
                if (!instruction.asDebugLocalsChange().apply(this.pendingLocals)) continue;
                this.pendingLocalChanges = true;
                continue;
            }
            if (instruction.isNewInstance()) {
                this.newInstanceLabels.put(instruction.asNewInstance(), this.ensureLabel());
            }
            this.updatePositionAndLocals(instruction);
            instruction.buildCf(this);
        }
    }

    private void updatePositionAndLocals(Instruction instruction) {
        boolean didPositionChange;
        Position position = instruction.getPosition();
        boolean didLocalsChange = this.localsChanged();
        boolean bl = didPositionChange = position.isSome() && position != this.currentPosition;
        if (!didLocalsChange && !didPositionChange) {
            return;
        }
        CfLabel label = this.ensureLabel();
        if (didLocalsChange) {
            int localIndex;
            Int2ReferenceSortedMap<DebugLocalInfo> ending = DebugLocalInfo.endingLocals(this.emittedLocals, this.pendingLocals);
            Int2ReferenceSortedMap<DebugLocalInfo> starting = DebugLocalInfo.startingLocals(this.emittedLocals, this.pendingLocals);
            assert (!ending.isEmpty() || !starting.isEmpty());
            for (Int2ReferenceMap.Entry entry : ending.int2ReferenceEntrySet()) {
                localIndex = entry.getIntKey();
                CfCode.LocalVariableInfo info = (CfCode.LocalVariableInfo)this.openLocalVariables.remove(localIndex);
                info.setEnd(label);
                this.localVariablesTable.add(info);
                DebugLocalInfo removed = (DebugLocalInfo)this.emittedLocals.remove(localIndex);
                assert (removed == entry.getValue());
            }
            if (!starting.isEmpty()) {
                for (Int2ReferenceMap.Entry entry : starting.int2ReferenceEntrySet()) {
                    localIndex = entry.getIntKey();
                    assert (!this.emittedLocals.containsKey(localIndex));
                    assert (!this.openLocalVariables.containsKey(localIndex));
                    this.openLocalVariables.put(localIndex, new CfCode.LocalVariableInfo(localIndex, (DebugLocalInfo)entry.getValue(), label));
                    this.emittedLocals.put(localIndex, (DebugLocalInfo)entry.getValue());
                }
            }
            this.pendingLocalChanges = false;
        }
        if (didPositionChange) {
            this.add(new CfPosition(label, position));
            this.currentPosition = position;
        }
    }

    private boolean localsChanged() {
        if (!this.pendingLocalChanges) {
            return false;
        }
        this.pendingLocalChanges = !DebugLocalInfo.localsInfoMapsEqual(this.emittedLocals, this.pendingLocals);
        return this.pendingLocalChanges;
    }

    private CfLabel ensureLabel() {
        CfInstruction last = this.getLastInstruction();
        if (last instanceof CfLabel) {
            return (CfLabel)last;
        }
        CfLabel label = new CfLabel();
        this.add(label);
        return label;
    }

    private CfInstruction getLastInstruction() {
        return this.instructions.isEmpty() ? null : this.instructions.get(this.instructions.size() - 1);
    }

    private void addFrame(BasicBlock block, Collection<StackValue> stack) {
        List<CfFrame.FrameType> stackTypes;
        assert (stack.isEmpty());
        if (block.entry().isMoveException()) {
            StackValue exception = (StackValue)block.entry().outValue();
            stackTypes = Collections.singletonList(CfFrame.FrameType.initialized(exception.getObjectType()));
        } else {
            stackTypes = Collections.emptyList();
        }
        Collection<Value> locals = this.registerAllocator.getLocalsAtBlockEntry(block);
        Int2ReferenceAVLTreeMap<CfFrame.FrameType> mapping = new Int2ReferenceAVLTreeMap<CfFrame.FrameType>();
        for (Value local : locals) {
            mapping.put(this.getLocalRegister(local), this.getFrameType(block, local));
        }
        this.instructions.add(new CfFrame(mapping, stackTypes));
    }

    private CfFrame.FrameType getFrameType(BasicBlock liveBlock, Value local) {
        switch (local.outType()) {
            case INT: {
                return CfFrame.FrameType.initialized(this.factory.intType);
            }
            case FLOAT: {
                return CfFrame.FrameType.initialized(this.factory.floatType);
            }
            case LONG: {
                return CfFrame.FrameType.initialized(this.factory.longType);
            }
            case DOUBLE: {
                return CfFrame.FrameType.initialized(this.factory.doubleType);
            }
            case OBJECT: {
                CfFrame.FrameType type = this.findAllocator(liveBlock, local);
                return type != null ? type : CfFrame.FrameType.initialized(this.types.get(local));
            }
        }
        throw new Unreachable("Unexpected local type: " + (Object)((Object)local.outType()) + " for local: " + local);
    }

    private CfFrame.FrameType findAllocator(BasicBlock liveBlock, Value value) {
        CfFrame.FrameType res;
        Instruction definition = value.definition;
        while (definition != null && (definition.isStore() || definition.isLoad())) {
            definition = definition.inValues().get((int)0).definition;
        }
        if (definition == null) {
            return null;
        }
        if (definition.isNewInstance()) {
            res = CfFrame.FrameType.uninitializedNew(this.newInstanceLabels.get(definition.asNewInstance()));
        } else if (definition.isArgument() && this.method.isInstanceInitializer() && definition.outValue().isThis()) {
            res = CfFrame.FrameType.uninitializedThis();
        } else {
            return null;
        }
        BasicBlock definitionBlock = definition.getBlock();
        HashSet<BasicBlock> visited = new HashSet<BasicBlock>();
        ArrayDeque<BasicBlock> toVisit = new ArrayDeque<BasicBlock>();
        List<InvokeDirect> valueInitializers = definition.isArgument() ? this.thisInitializers : this.initializers.get(definition.asNewInstance());
        for (InvokeDirect initializer : valueInitializers) {
            BasicBlock initializerBlock = initializer.getBlock();
            if (initializerBlock == liveBlock) {
                return res;
            }
            if (initializerBlock == definitionBlock || !visited.add(initializerBlock)) continue;
            toVisit.addLast(initializerBlock);
        }
        while (!toVisit.isEmpty()) {
            BasicBlock block = (BasicBlock)toVisit.removeLast();
            for (BasicBlock predecessor : block.getPredecessors()) {
                if (predecessor == liveBlock) {
                    return res;
                }
                if (predecessor == definitionBlock || !visited.add(predecessor)) continue;
                toVisit.addLast(predecessor);
            }
        }
        return null;
    }

    private void emitLabel(CfLabel label) {
        if (!this.emittedLabels.contains(label)) {
            this.emittedLabels.add(label);
            this.instructions.add(label);
        }
    }

    public CfLabel getLabel(BasicBlock target) {
        return this.labels.computeIfAbsent(target, block -> new CfLabel());
    }

    public int getLocalRegister(Value value) {
        return this.registerAllocator.getRegisterForValue(value);
    }

    public void add(CfInstruction instruction) {
        this.instructions.add(instruction);
    }

    public void addArgument(Argument argument) {
    }

    private static class Stack {
        int maxHeight = 0;
        int height = 0;

        private Stack() {
        }

        boolean isEmpty() {
            return this.height == 0;
        }

        void push(Value value) {
            assert (value instanceof StackValue);
            this.height += value.requiredRegisters();
            this.maxHeight = Math.max(this.maxHeight, this.height);
        }

        void pop(Value value) {
            assert (value instanceof StackValue);
            this.height -= value.requiredRegisters();
        }
    }
}

