/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.org.json.simple.JSONObject;
import com.android.tools.r8.org.json.simple.parser.JSONParser;
import com.android.tools.r8.org.json.simple.parser.ParseException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class Marker {
    public static final String VERSION = "version";
    public static final String MIN_API = "min-api";
    public static final String SHA1 = "sha-1";
    private static final char PREFIX_CHAR = '~';
    private static final String PREFIX = "~~";
    private static final String D8_PREFIX = "~~" + (Object)((Object)Tool.D8) + "{";
    private static final String R8_PREFIX = "~~" + (Object)((Object)Tool.R8) + "{";
    private final TreeMap<String, Object> content;
    private final Tool tool;

    public Marker(Tool tool) {
        this.tool = tool;
        this.content = new TreeMap();
    }

    private Marker(Tool tool, JSONObject object) {
        this.tool = tool;
        this.content = new TreeMap();
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e;
            Map.Entry entry = e = iterator.next();
            this.content.put(String.valueOf(entry.getKey()), entry.getValue());
        }
    }

    public Tool getTool() {
        return this.tool;
    }

    public boolean isD8() {
        return this.tool == Tool.D8;
    }

    public boolean isR8() {
        return this.tool == Tool.R8;
    }

    public String getVersion() {
        return (String)this.content.get(VERSION);
    }

    public Marker setVersion(String version) {
        this.internalPut(VERSION, version);
        return this;
    }

    public Long getMinApi() {
        return (Long)this.content.get(MIN_API);
    }

    public Marker setMinApi(long minApi) {
        this.internalPut(MIN_API, minApi);
        return this;
    }

    public String getSha1() {
        return (String)this.content.get(SHA1);
    }

    public Marker setSha1(String sha1) {
        this.internalPut(SHA1, sha1);
        return this;
    }

    private Marker internalPut(String key, Object value) {
        assert (key != null && value != null);
        assert (!this.content.containsKey(key));
        this.content.put(key, value);
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(PREFIX + (Object)((Object)this.tool));
        boolean first = true;
        sb.append('{');
        for (String key : this.content.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(JSONObject.toString(key, this.content.get(key)));
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Marker) {
            Marker other = (Marker)obj;
            return this.tool == other.tool && this.content.equals(other.content);
        }
        return false;
    }

    public int hashCode() {
        return this.tool.hashCode() + 3 * this.content.hashCode();
    }

    public static Marker parse(DexString dexString) {
        if (dexString.size > 2 && dexString.content[0] == 126 && dexString.content[1] == 126) {
            String str = dexString.toString();
            if (str.startsWith(D8_PREFIX)) {
                return Marker.internalParse(Tool.D8, str.substring(D8_PREFIX.length() - 1));
            }
            if (str.startsWith(R8_PREFIX)) {
                return Marker.internalParse(Tool.R8, str.substring(R8_PREFIX.length() - 1));
            }
        }
        return null;
    }

    private static Marker internalParse(Tool tool, String str) {
        try {
            Object result = new JSONParser().parse(str);
            if (result instanceof JSONObject) {
                return new Marker(tool, (JSONObject)result);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    public static enum Tool {
        D8,
        R8;

    }
}

