/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.JarClassFileReader;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.JarSourceCode;
import com.android.tools.r8.jar.JarRegisterEffectsVisitor;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.org.objectweb.asm.ClassReader;
import com.android.tools.r8.org.objectweb.asm.ClassVisitor;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.commons.JSRInlinerAdapter;
import com.android.tools.r8.org.objectweb.asm.tree.AbstractInsnNode;
import com.android.tools.r8.org.objectweb.asm.tree.LabelNode;
import com.android.tools.r8.org.objectweb.asm.tree.LineNumberNode;
import com.android.tools.r8.org.objectweb.asm.tree.MethodNode;
import com.android.tools.r8.org.objectweb.asm.util.Textifier;
import com.android.tools.r8.org.objectweb.asm.util.TraceMethodVisitor;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ListIterator;

public class JarCode
extends Code {
    private final DexMethod method;
    private final Origin origin;
    private MethodNode node;
    private JarClassFileReader.ReparseContext context;
    private final JarApplicationReader application;

    public void writeTo(MethodVisitor visitor) {
        this.node.accept(visitor);
    }

    public JarCode(DexMethod method, Origin origin, JarClassFileReader.ReparseContext context, JarApplicationReader application) {
        this.method = method;
        this.origin = origin;
        this.context = context;
        this.application = application;
        context.codeList.add(this);
    }

    public MethodNode getNode() {
        this.triggerDelayedParsingIfNeccessary();
        return this.node;
    }

    @Override
    public boolean isJarCode() {
        return true;
    }

    @Override
    public JarCode asJarCode() {
        return this;
    }

    @Override
    protected int computeHashCode() {
        this.triggerDelayedParsingIfNeccessary();
        return this.node.hashCode();
    }

    @Override
    protected boolean computeEquals(Object other) {
        this.triggerDelayedParsingIfNeccessary();
        if (this == other) {
            return true;
        }
        if (other instanceof JarCode) {
            JarCode o = (JarCode)other;
            o.triggerDelayedParsingIfNeccessary();
            return this.node.equals(o.node);
        }
        return false;
    }

    @Override
    public boolean isEmptyVoidMethod() {
        ListIterator<AbstractInsnNode> it = this.getNode().instructions.iterator();
        while (it.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)it.next();
            if (insn.getType() == 177 || insn instanceof LabelNode || insn instanceof LineNumberNode) continue;
            return false;
        }
        return true;
    }

    @Override
    public IRCode buildIR(DexEncodedMethod encodedMethod, InternalOptions options, Origin origin) throws ApiLevelException {
        this.triggerDelayedParsingIfNeccessary();
        return options.debug ? this.internalBuildWithLocals(encodedMethod, options, null, null) : this.internalBuild(encodedMethod, options, null, null);
    }

    @Override
    public IRCode buildInliningIR(DexEncodedMethod encodedMethod, InternalOptions options, ValueNumberGenerator generator, Position callerPosition, Origin origin) throws ApiLevelException {
        assert (generator != null);
        this.triggerDelayedParsingIfNeccessary();
        return options.debug ? this.internalBuildWithLocals(encodedMethod, options, generator, callerPosition) : this.internalBuild(encodedMethod, options, generator, callerPosition);
    }

    private IRCode internalBuildWithLocals(DexEncodedMethod encodedMethod, InternalOptions options, ValueNumberGenerator generator, Position callerPosition) throws ApiLevelException {
        try {
            return this.internalBuild(encodedMethod, options, generator, callerPosition);
        }
        catch (InvalidDebugInfoException e) {
            options.warningInvalidDebugInfo(encodedMethod, this.origin, e);
            this.node.localVariables.clear();
            return this.internalBuild(encodedMethod, options, generator, callerPosition);
        }
    }

    private IRCode internalBuild(DexEncodedMethod encodedMethod, InternalOptions options, ValueNumberGenerator generator, Position callerPosition) throws ApiLevelException {
        if (!options.debug) {
            this.node.localVariables.clear();
        }
        JarSourceCode source = new JarSourceCode(this.method.getHolder(), this.node, this.application, encodedMethod.method, callerPosition);
        IRBuilder builder = generator == null ? new IRBuilder(encodedMethod, source, options) : new IRBuilder(encodedMethod, source, options, generator);
        return builder.build();
    }

    @Override
    public void registerCodeReferences(UseRegistry registry) {
        this.triggerDelayedParsingIfNeccessary();
        this.node.instructions.accept(new JarRegisterEffectsVisitor(this.method.getHolder(), registry, this.application));
        this.node.tryCatchBlocks.forEach(tryCatchBlockNode -> registry.registerTypeReference(this.application.getTypeFromDescriptor(DescriptorUtils.getDescriptorFromClassBinaryName(tryCatchBlockNode.type))));
    }

    @Override
    public String toString() {
        this.triggerDelayedParsingIfNeccessary();
        TraceMethodVisitor visitor = new TraceMethodVisitor(new Textifier());
        this.node.accept(visitor);
        StringWriter writer = new StringWriter();
        visitor.p.print(new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public String toString(DexEncodedMethod method, ClassNameMapper naming) {
        return this.toString();
    }

    private void triggerDelayedParsingIfNeccessary() {
        if (this.context != null) {
            DexProgramClass owner = this.context.owner;
            new ClassReader(this.context.classCache).accept(new SecondVisitor(this.context, this.application), 4);
            assert (JarCode.verifyNoReparseContext(owner));
        }
    }

    private static boolean verifyNoReparseContext(DexProgramClass owner) {
        Code code;
        for (DexEncodedMethod method : owner.virtualMethods()) {
            code = method.getCode();
            if (code == null || !code.isJarCode() || code.asJarCode().context == null) continue;
            return false;
        }
        for (DexEncodedMethod method : owner.directMethods()) {
            code = method.getCode();
            if (code == null || !code.isJarCode() || code.asJarCode().context == null) continue;
            return false;
        }
        return true;
    }

    private static class SecondVisitor
    extends ClassVisitor {
        private final JarClassFileReader.ReparseContext context;
        private final JarApplicationReader application;
        private int methodIndex = 0;

        public SecondVisitor(JarClassFileReader.ReparseContext context, JarApplicationReader application) {
            super(393216);
            this.context = context;
            this.application = application;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            JSRInlinerAdapter node = new JSRInlinerAdapter(null, access, name, desc, signature, exceptions);
            JarCode code = null;
            MethodAccessFlags flags = JarClassFileReader.createMethodAccessFlags(name, access);
            if (!flags.isAbstract() && !flags.isNative()) {
                code = this.context.codeList.get(this.methodIndex++).asJarCode();
                assert (code.method == this.application.getMethod(this.context.owner.type, name, desc));
            }
            if (code != null) {
                code.context = null;
                code.node = node;
                return node;
            }
            return null;
        }
    }
}

