/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner;

import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.Inliner;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ClassInliner {
    private final DexItemFactory factory;
    private final ConcurrentHashMap<DexType, Boolean> knownClasses = new ConcurrentHashMap();
    private static final Map<DexField, Integer> NO_MAPPING = new IdentityHashMap<DexField, Integer>();

    public ClassInliner(DexItemFactory factory) {
        this.factory = factory;
    }

    public final void processMethodCode(AppInfoWithSubtyping appInfo, DexEncodedMethod method, IRCode code, Predicate<DexEncodedMethod> isProcessedConcurrently, InlinerAction inliner) {
        List newInstances = Streams.stream(code.instructionIterator()).filter(Instruction::isNewInstance).map(Instruction::asNewInstance).collect(Collectors.toList());
        block0: for (NewInstance newInstance : newInstances) {
            DexType eligibleClass;
            Value eligibleInstance = newInstance.outValue();
            if (eligibleInstance == null || !this.isClassEligible(appInfo, eligibleClass = newInstance.clazz) || eligibleInstance.numberOfPhiUsers() > 0) continue;
            Set<Instruction> uniqueUsers = eligibleInstance.uniqueUsers();
            InvokeDirect eligibleInitCall = null;
            Map<DexField, Integer> mappings = null;
            for (Instruction user : uniqueUsers) {
                InvokeDirect candidate;
                DexMethod candidateInit;
                if (!user.isInvokeDirect() || !this.factory.isConstructor(candidateInit = (candidate = user.asInvokeDirect()).getInvokedMethod()) || candidate.inValues().lastIndexOf(eligibleInstance) != 0) continue;
                if (candidateInit.holder != eligibleClass) {
                    if (candidateInit.holder == this.factory.objectType) {
                        mappings = Collections.emptyMap();
                    }
                } else {
                    mappings = this.getConstructorFieldMappings(appInfo, candidateInit, isProcessedConcurrently);
                }
                eligibleInitCall = candidate;
                break;
            }
            if (mappings == null) continue;
            IdentityHashMap<InvokeMethodWithReceiver, Inliner.InliningInfo> methodCalls = new IdentityHashMap<InvokeMethodWithReceiver, Inliner.InliningInfo>();
            for (Instruction user : uniqueUsers) {
                DexEncodedMethod singleTarget;
                InvokeMethodWithReceiver invoke;
                if (user == eligibleInitCall) continue;
                if (user.isInstanceGet()) {
                    InstanceGet instanceGet = user.asInstanceGet();
                    if (!mappings.containsKey(instanceGet.getField())) continue block0;
                    continue;
                }
                if (!user.isInvokeVirtual() && !user.isInvokeInterface() || (invoke = user.asInvokeMethodWithReceiver()).inValues().lastIndexOf(eligibleInstance) > 0 || (singleTarget = this.findSingleTarget(appInfo, invoke, eligibleClass)) == null || isProcessedConcurrently.test(singleTarget) || method == singleTarget || !singleTarget.getOptimizationInfo().isReceiverOnlyUsedForReadingFields(mappings.keySet()) || !singleTarget.isInliningCandidate(method, Inliner.Reason.SIMPLE, appInfo)) continue block0;
                methodCalls.put(invoke, new Inliner.InliningInfo(singleTarget, eligibleClass));
            }
            this.inlineAllCalls(inliner, methodCalls);
            assert (this.assertOnlyConstructorAndFieldReads(eligibleInstance, eligibleInitCall, mappings));
            this.patchFieldReads(eligibleInstance, eligibleInitCall, mappings);
            assert (this.assertOnlyConstructor(eligibleInstance, eligibleInitCall));
            this.removeInstruction(eligibleInitCall);
            this.removeInstruction(newInstance);
            code.removeAllTrivialPhis();
        }
    }

    private void inlineAllCalls(InlinerAction inliner, Map<InvokeMethodWithReceiver, Inliner.InliningInfo> methodCalls) {
        if (!methodCalls.isEmpty()) {
            inliner.inline(methodCalls);
        }
    }

    private void patchFieldReads(Value instance, InvokeDirect invokeMethod, Map<DexField, Integer> mappings) {
        for (Instruction user : instance.uniqueUsers()) {
            if (!user.isInstanceGet()) continue;
            InstanceGet fieldRead = user.asInstanceGet();
            assert (mappings.containsKey(fieldRead.getField()));
            Value arg = invokeMethod.inValues().get(1 + mappings.get(fieldRead.getField()));
            assert (arg != null);
            Value value = fieldRead.outValue();
            if (value != null) {
                value.replaceUsers(arg);
                assert (value.numberOfAllUsers() == 0);
            }
            this.removeInstruction(fieldRead);
        }
    }

    private void removeInstruction(Instruction instruction) {
        instruction.inValues().forEach(v -> v.removeUser(instruction));
        instruction.getBlock().removeInstruction(instruction);
    }

    private boolean assertOnlyConstructorAndFieldReads(Value instance, InvokeDirect invokeMethod, Map<DexField, Integer> mappings) {
        for (Instruction user : instance.uniqueUsers()) {
            if (user == invokeMethod || user.isInstanceGet() && mappings.containsKey(user.asFieldInstruction().getField())) continue;
            throw new Unreachable("Not all calls are inlined!");
        }
        return true;
    }

    private boolean assertOnlyConstructor(Value instance, InvokeDirect invokeMethod) {
        for (Instruction user : instance.uniqueUsers()) {
            if (user == invokeMethod) continue;
            throw new Unreachable("Not all field reads are substituted!");
        }
        return true;
    }

    private DexEncodedMethod findSingleTarget(AppInfo appInfo, InvokeMethodWithReceiver invoke, DexType instanceType) {
        DexClass clazz = appInfo.definitionFor(instanceType);
        if (clazz != null) {
            DexMethod callee = invoke.getInvokedMethod();
            for (DexEncodedMethod candidate : clazz.virtualMethods()) {
                if (candidate.method.name != callee.name || candidate.method.proto != callee.proto) continue;
                return candidate;
            }
        }
        return null;
    }

    private Map<DexField, Integer> getConstructorFieldMappings(AppInfo appInfo, DexMethod init, Predicate<DexEncodedMethod> isProcessedConcurrently) {
        assert (this.isClassEligible(appInfo, init.holder));
        DexEncodedMethod definition = appInfo.definitionFor(init);
        if (definition == null) {
            return NO_MAPPING;
        }
        if (isProcessedConcurrently.test(definition)) {
            return NO_MAPPING;
        }
        if (definition.accessFlags.isAbstract() || definition.accessFlags.isNative()) {
            return NO_MAPPING;
        }
        return definition.getOptimizationInfo().onlyInitializesFieldsWithNoOtherSideEffects();
    }

    private boolean isClassEligible(AppInfo appInfo, DexType clazz) {
        Boolean eligible = this.knownClasses.get(clazz);
        if (eligible == null) {
            Boolean computed = this.computeClassEligible(appInfo, clazz);
            Boolean existing = this.knownClasses.putIfAbsent(clazz, computed);
            assert (existing == null || existing == computed);
            eligible = existing == null ? computed : existing;
        }
        return eligible;
    }

    private boolean computeClassEligible(AppInfo appInfo, DexType clazz) {
        DexClass definition = appInfo.definitionFor(clazz);
        if (definition == null || definition.isLibraryClass() || definition.accessFlags.isAbstract() || definition.accessFlags.isInterface()) {
            return false;
        }
        if (definition.superType != this.factory.objectType) {
            return false;
        }
        for (DexEncodedMethod method : definition.virtualMethods()) {
            if (method.method.name != this.factory.finalizeMethodName || method.method.proto != this.factory.objectMethods.finalize.proto) continue;
            return false;
        }
        return !appInfo.canTriggerStaticInitializer(clazz);
    }

    public static interface InlinerAction {
        public void inline(Map<InvokeMethodWithReceiver, Inliner.InliningInfo> var1);
    }
}

