/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexByteCodeWriter;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.utils.InternalOptions;
import java.io.PrintStream;

public class AssemblyWriter
extends DexByteCodeWriter {
    private final boolean writeAllClassInfo;
    private final boolean writeFields;
    private final boolean writeAnnotations;

    public AssemblyWriter(DexApplication application, InternalOptions options, boolean allInfo) {
        super(application, options);
        this.writeAllClassInfo = allInfo;
        this.writeFields = allInfo;
        this.writeAnnotations = allInfo;
    }

    @Override
    String getFileEnding() {
        return ".dump";
    }

    @Override
    void writeClassHeader(DexProgramClass clazz, PrintStream ps) {
        String clazzName = this.application.getProguardMap() != null ? this.application.getProguardMap().originalNameOf(clazz.type) : clazz.type.toSourceString();
        ps.println("# Bytecode for");
        ps.println("# Class: '" + clazzName + "'");
        if (this.writeAllClassInfo) {
            this.writeAnnotations(clazz.annotations, ps);
            ps.println("# Flags: '" + clazz.accessFlags + "'");
            if (clazz.superType != this.application.dexItemFactory.objectType) {
                ps.println("# Extends: '" + clazz.superType.toSourceString() + "'");
            }
            for (DexType value : clazz.interfaces.values) {
                ps.println("# Implements: '" + value.toSourceString() + "'");
            }
        }
        ps.println();
    }

    @Override
    void writeFieldsHeader(DexProgramClass clazz, PrintStream ps) {
        if (this.writeFields) {
            ps.println("#");
            ps.println("# Fields:");
            ps.println("#");
        }
    }

    @Override
    void writeField(DexEncodedField field, PrintStream ps) {
        if (this.writeFields) {
            ClassNameMapper naming = this.application.getProguardMap();
            MemberNaming.FieldSignature fieldSignature = naming != null ? naming.originalSignatureOf(field.field) : MemberNaming.FieldSignature.fromDexField(field.field);
            this.writeAnnotations(field.annotations, ps);
            ps.println(fieldSignature);
        }
    }

    @Override
    void writeFieldsFooter(DexProgramClass clazz, PrintStream ps) {
        ps.println();
    }

    @Override
    void writeMethod(DexEncodedMethod method, PrintStream ps) {
        ClassNameMapper naming = this.application.getProguardMap();
        String methodName = naming != null ? naming.originalSignatureOf((DexMethod)method.method).name : method.method.name.toString();
        ps.println("#");
        ps.println("# Method: '" + methodName + "':");
        this.writeAnnotations(method.annotations, ps);
        ps.println("#");
        ps.println();
        Code code = method.getCode();
        if (code != null) {
            ps.println(code.toString(method, naming));
        }
    }

    private void writeAnnotations(DexAnnotationSet annotations, PrintStream ps) {
        if (this.writeAnnotations && !annotations.isEmpty()) {
            ps.println("# Annotations:");
            for (DexAnnotation annotation : annotations.annotations) {
                ps.print("#   ");
                ps.println(annotation);
            }
        }
    }

    @Override
    void writeClassFooter(DexProgramClass clazz, PrintStream ps) {
    }
}

