/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCodeInstructionsIterator;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.MoveException;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueNumberGenerator;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class IRCode {
    public static final int INSTRUCTION_NUMBER_DELTA = 2;
    public final DexEncodedMethod method;
    public LinkedList<BasicBlock> blocks;
    public final ValueNumberGenerator valueNumberGenerator;
    private int usedMarkingColors = 0;
    private boolean numbered = false;
    private int nextInstructionNumber = 0;
    private boolean allThrowingInstructionsHavePositions;
    public final boolean hasDebugPositions;
    public final InternalOptions options;

    public IRCode(InternalOptions options, DexEncodedMethod method, LinkedList<BasicBlock> blocks, ValueNumberGenerator valueNumberGenerator, boolean hasDebugPositions) {
        this.options = options;
        this.method = method;
        this.blocks = blocks;
        this.valueNumberGenerator = valueNumberGenerator;
        this.hasDebugPositions = hasDebugPositions;
        this.allThrowingInstructionsHavePositions = this.computeAllThrowingInstructionsHavePositions();
    }

    public Map<BasicBlock, Set<Value>> computeLiveAtEntrySets() {
        IdentityHashMap<BasicBlock, Set<Value>> liveAtEntrySets = new IdentityHashMap<BasicBlock, Set<Value>>();
        ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
        ImmutableList<BasicBlock> sorted = this.topologicallySortedBlocks();
        worklist.addAll(sorted.reverse());
        while (!worklist.isEmpty()) {
            BasicBlock block = (BasicBlock)worklist.poll();
            HashSet<Value> live = new HashSet<Value>();
            for (BasicBlock succ : block.getSuccessors()) {
                Set succLiveAtEntry = (Set)liveAtEntrySets.get(succ);
                if (succLiveAtEntry != null) {
                    live.addAll(succLiveAtEntry);
                }
                int predIndex = succ.getPredecessors().indexOf(block);
                for (Phi phi : succ.getPhis()) {
                    live.add(phi.getOperand(predIndex));
                    assert (phi.getDebugValues().stream().allMatch(Value::needsRegister));
                    live.addAll(phi.getDebugValues());
                }
            }
            ListIterator<Instruction> iterator = block.getInstructions().listIterator(block.getInstructions().size());
            while (iterator.hasPrevious()) {
                Instruction instruction = iterator.previous();
                if (instruction.outValue() != null) {
                    live.remove(instruction.outValue());
                }
                for (Value use2 : instruction.inValues()) {
                    if (!use2.needsRegister()) continue;
                    live.add(use2);
                }
                assert (instruction.getDebugValues().stream().allMatch(Value::needsRegister));
                live.addAll(instruction.getDebugValues());
            }
            for (Phi phi : block.getPhis()) {
                live.remove(phi);
            }
            Set previousLiveAtEntry = liveAtEntrySets.put(block, live);
            if (previousLiveAtEntry != null && previousLiveAtEntry.equals(live)) continue;
            for (BasicBlock pred : block.getPredecessors()) {
                if (worklist.contains(pred)) continue;
                worklist.add(pred);
            }
        }
        assert (((Set)liveAtEntrySets.get(sorted.get(0))).size() == 0) : "Unexpected values live at entry to first block: " + liveAtEntrySets.get(sorted.get(0));
        return liveAtEntrySets;
    }

    public void splitCriticalEdges() {
        ArrayList<BasicBlock> newBlocks = new ArrayList<BasicBlock>();
        int nextBlockNumber = this.getHighestBlockNumber() + 1;
        for (BasicBlock block : this.blocks) {
            List<BasicBlock> predecessors = block.getPredecessors();
            if (predecessors.size() <= 1) continue;
            if (block.entry() instanceof MoveException) {
                nextBlockNumber = block.splitCriticalExceptionEdges(nextBlockNumber, this.valueNumberGenerator, newBlocks::add);
                continue;
            }
            for (int predIndex = 0; predIndex < predecessors.size(); ++predIndex) {
                BasicBlock pred = predecessors.get(predIndex);
                if (pred.hasOneNormalExit()) continue;
                BasicBlock newBlock = BasicBlock.createGotoBlock(nextBlockNumber++, block);
                newBlocks.add(newBlock);
                pred.replaceSuccessor(block, newBlock);
                newBlock.getPredecessors().add(pred);
                predecessors.set(predIndex, newBlock);
            }
        }
        this.blocks.addAll(newBlocks);
    }

    public void traceBlocks() {
        ImmutableList<BasicBlock> sorted = this.topologicallySortedBlocks();
        int color = this.reserveMarkingColor();
        int nextBlockNumber = this.blocks.size();
        LinkedList<BasicBlock> tracedBlocks = new LinkedList<BasicBlock>();
        for (BasicBlock block : sorted) {
            if (block.isMarked(color)) continue;
            block.mark(color);
            tracedBlocks.add(block);
            BasicBlock current = block;
            BasicBlock fallthrough = block.exit().fallthroughBlock();
            while (fallthrough != null && !fallthrough.isMarked(color)) {
                fallthrough.mark(color);
                tracedBlocks.add(fallthrough);
                current = fallthrough;
                fallthrough = fallthrough.exit().fallthroughBlock();
            }
            if (fallthrough == null) continue;
            BasicBlock newFallthrough = BasicBlock.createGotoBlock(nextBlockNumber++, fallthrough);
            current.exit().setFallthroughBlock(newFallthrough);
            newFallthrough.getPredecessors().add(current);
            fallthrough.replacePredecessor(current, newFallthrough);
            newFallthrough.mark(color);
            tracedBlocks.add(newFallthrough);
        }
        this.blocks = tracedBlocks;
        this.returnMarkingColor(color);
        assert (this.verifyNoColorsInUse());
    }

    private void ensureBlockNumbering() {
        if (!this.numbered) {
            this.numbered = true;
            int blockNumber = 0;
            for (BasicBlock block : this.topologicallySortedBlocks()) {
                block.setNumber(blockNumber++);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("blocks:\n");
        for (BasicBlock block : this.blocks) {
            builder.append(block.toDetailedString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public void clearMarks(int color) {
        for (BasicBlock block : this.blocks) {
            block.clearMark(color);
        }
    }

    public void removeMarkedBlocks(int color) {
        ListIterator<BasicBlock> blockIterator = this.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (!block.isMarked(color)) continue;
            blockIterator.remove();
        }
    }

    private boolean verifyNoBlocksMarked(int color) {
        for (BasicBlock block : this.blocks) {
            if (!block.isMarked(color)) continue;
            return false;
        }
        return true;
    }

    public void removeBlocks(List<BasicBlock> blocksToRemove) {
        this.blocks.removeAll(blocksToRemove);
    }

    public ImmutableList<BasicBlock> topologicallySortedBlocks() {
        ImmutableList<BasicBlock> ordered = this.depthFirstSorting();
        return this.options.testing.placeExceptionalBlocksLast ? IRCode.reorderExceptionalBlocksLastForTesting(ordered) : ordered;
    }

    private ImmutableList<BasicBlock> depthFirstSorting() {
        ArrayList<BasicBlock> reverseOrdered = new ArrayList<BasicBlock>(this.blocks.size());
        HashSet<BasicBlock> visitedBlocks = new HashSet<BasicBlock>(this.blocks.size());
        ArrayDeque<Object> worklist = new ArrayDeque<Object>(this.blocks.size());
        worklist.addLast(this.blocks.getFirst());
        while (!worklist.isEmpty()) {
            Object item = worklist.removeLast();
            if (item instanceof BlockMarker) {
                reverseOrdered.add(((BlockMarker)item).block);
                continue;
            }
            BasicBlock block = (BasicBlock)item;
            if (visitedBlocks.contains(block)) continue;
            visitedBlocks.add(block);
            worklist.addLast(new BlockMarker(block));
            for (int i = block.getSuccessors().size() - 1; i >= 0; --i) {
                worklist.addLast(block.getSuccessors().get(i));
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = reverseOrdered.size() - 1; i >= 0; --i) {
            builder.add((BasicBlock)reverseOrdered.get(i));
        }
        return builder.build();
    }

    private static ImmutableList<BasicBlock> reorderExceptionalBlocksLastForTesting(ImmutableList<BasicBlock> blocks) {
        ImmutableList.Builder reordered = ImmutableList.builder();
        for (BasicBlock block : blocks) {
            if (block.entry().isMoveException()) continue;
            reordered.add(block);
        }
        for (BasicBlock block : blocks) {
            if (!block.entry().isMoveException()) continue;
            reordered.add(block);
        }
        return reordered.build();
    }

    public void print(CfgPrinter printer) {
        this.ensureBlockNumbering();
        for (BasicBlock block : this.blocks) {
            block.print(printer);
        }
    }

    public boolean isConsistentSSA() {
        assert (this.isConsistentGraph());
        assert (this.consistentDefUseChains());
        assert (this.validThrowingInstructions());
        assert (this.noCriticalEdges());
        return true;
    }

    public boolean isConsistentGraph() {
        assert (this.verifyNoColorsInUse());
        assert (this.consistentBlockNumbering());
        assert (this.consistentPredecessorSuccessors());
        assert (this.consistentCatchHandlers());
        assert (this.consistentBlockInstructions());
        assert (!this.allThrowingInstructionsHavePositions || this.computeAllThrowingInstructionsHavePositions());
        return true;
    }

    private boolean noCriticalEdges() {
        for (BasicBlock block : this.blocks) {
            List<BasicBlock> predecessors = block.getPredecessors();
            if (predecessors.size() <= 1) continue;
            if (block.entry() instanceof MoveException) {
                assert (false);
                return false;
            }
            for (int predIndex = 0; predIndex < predecessors.size(); ++predIndex) {
                if (predecessors.get(predIndex).hasOneNormalExit()) continue;
                assert (false);
                return false;
            }
        }
        return true;
    }

    public boolean hasCatchHandlers() {
        for (BasicBlock block : this.blocks) {
            if (!block.hasCatchHandlers()) continue;
            return true;
        }
        return false;
    }

    private boolean consistentDefUseChains() {
        HashSet<Value> values = new HashSet<Value>();
        for (BasicBlock block : this.blocks) {
            int predecessorCount = block.getPredecessors().size();
            for (Phi phi : block.getPhis()) {
                assert (!phi.isTrivialPhi());
                assert (phi.getOperands().size() == predecessorCount);
                assert (phi.outType() != ValueType.INT_OR_FLOAT_OR_NULL);
                values.add(phi);
                for (Value value : phi.getOperands()) {
                    values.add(value);
                    assert (value.uniquePhiUsers().contains(phi));
                }
                for (Value value : phi.getDebugValues()) {
                    values.add(value);
                    assert (value.debugPhiUsers().contains(phi));
                }
            }
            for (Instruction instruction : block.getInstructions()) {
                assert (instruction.getBlock() == block);
                Value outValue = instruction.outValue();
                if (outValue != null) {
                    values.add(outValue);
                    assert (outValue.definition == instruction);
                    assert (outValue.outType() != ValueType.INT_OR_FLOAT_OR_NULL);
                }
                for (Value value : instruction.inValues()) {
                    values.add(value);
                    assert (value.uniqueUsers().contains(instruction));
                }
                for (Value value : instruction.getDebugValues()) {
                    values.add(value);
                    assert (value.debugUsers().contains(instruction));
                }
            }
        }
        for (Value value : values) {
            assert (this.verifyValue(value));
            assert (this.consistentValueUses(value));
        }
        return true;
    }

    private boolean verifyValue(Value value) {
        assert (!value.isPhi() ? this.verifyDefinition(value) : this.verifyPhi(value.asPhi()));
        return true;
    }

    private boolean verifyPhi(Phi phi) {
        assert (phi.getBlock().getPhis().contains(phi));
        return true;
    }

    private boolean verifyDefinition(Value value) {
        assert (value.definition.outValue() == value);
        return true;
    }

    private boolean consistentValueUses(Value value) {
        for (Instruction user : value.uniqueUsers()) {
            assert (user.inValues().contains(value));
        }
        for (Phi phiUser : value.uniquePhiUsers()) {
            assert (phiUser.getOperands().contains(value));
            assert (phiUser.getBlock().getPhis().contains(phiUser));
        }
        if (value.hasLocalInfo()) {
            for (Instruction debugUser : value.debugUsers()) {
                assert (debugUser.getDebugValues().contains(value));
            }
            for (Phi phiUser : value.debugPhiUsers()) {
                assert (this.verifyPhi(phiUser));
                assert (phiUser.getDebugValues().contains(value));
            }
        }
        return true;
    }

    private boolean consistentPredecessorSuccessors() {
        for (BasicBlock block : this.blocks) {
            assert (new HashSet<BasicBlock>(block.getSuccessors()).size() == block.getSuccessors().size());
            for (BasicBlock succ : block.getSuccessors()) {
                assert (this.blocks.contains(succ));
                assert (succ.getPredecessors().contains(block));
            }
            assert (new HashSet<BasicBlock>(block.getPredecessors()).size() == block.getPredecessors().size());
            for (BasicBlock pred : block.getPredecessors()) {
                assert (this.blocks.contains(pred));
                assert (pred.getSuccessors().contains(block));
            }
        }
        return true;
    }

    private boolean consistentCatchHandlers() {
        for (BasicBlock block : this.blocks) {
            if (!block.hasCatchHandlers()) continue;
            assert (block.exit().isGoto() || block.exit().isThrow());
            CatchHandlers<Integer> catchHandlers = block.getCatchHandlersWithSuccessorIndexes();
            List<DexType> guards = catchHandlers.getGuards();
            int lastGuardIndex = guards.size() - 1;
            for (int i = 0; i < guards.size(); ++i) {
                assert (guards.get(i) != DexItemFactory.catchAllType || i == lastGuardIndex);
            }
            ArrayList<Integer> sortedHandlerIndices = new ArrayList<Integer>(catchHandlers.getAllTargets());
            sortedHandlerIndices.sort(Comparator.naturalOrder());
            int firstIndex = (Integer)sortedHandlerIndices.get(0);
            int lastIndex = (Integer)sortedHandlerIndices.get(sortedHandlerIndices.size() - 1);
            assert (firstIndex == 0);
            assert (lastIndex < sortedHandlerIndices.size());
            int lastSuccessorIndex = block.getSuccessors().size() - 1;
            assert (lastIndex == lastSuccessorIndex || lastIndex == lastSuccessorIndex - 1);
            assert (lastIndex == lastSuccessorIndex || !block.exit().isThrow());
        }
        return true;
    }

    public boolean consistentBlockNumbering() {
        return this.blocks.stream().collect(Collectors.groupingBy(BasicBlock::getNumber, Collectors.counting())).entrySet().stream().noneMatch(bb2count -> (Long)bb2count.getValue() > 1L);
    }

    private boolean consistentBlockInstructions() {
        boolean argumentsAllowed = true;
        for (BasicBlock block : this.blocks) {
            block.consistentBlockInstructions(argumentsAllowed);
            argumentsAllowed = false;
        }
        return true;
    }

    private boolean validThrowingInstructions() {
        for (BasicBlock block : this.blocks) {
            if (!block.hasCatchHandlers()) continue;
            boolean seenThrowing = false;
            for (Instruction instruction : block.getInstructions()) {
                if (instruction.instructionTypeCanThrow()) {
                    assert (!seenThrowing);
                    seenThrowing = true;
                    continue;
                }
                if (seenThrowing) assert (instruction.isDebugInstruction() || instruction.isJumpInstruction() || instruction.isConstInstruction() || instruction.isNewArrayFilledData() || instruction.isStore() || instruction.isPop());
            }
        }
        return true;
    }

    public InstructionIterator instructionIterator() {
        return new IRCodeInstructionsIterator(this);
    }

    public ImmutableList<BasicBlock> computeNormalExitBlocks() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BasicBlock block : this.blocks) {
            if (!block.exit().isReturn()) continue;
            builder.add(block);
        }
        return builder.build();
    }

    public ListIterator<BasicBlock> listIterator() {
        return new BasicBlockIterator(this);
    }

    public ListIterator<BasicBlock> listIterator(int index) {
        return new BasicBlockIterator(this, index);
    }

    public ImmutableList<BasicBlock> numberInstructions() {
        ImmutableList<BasicBlock> blocks = this.topologicallySortedBlocks();
        for (BasicBlock block : blocks) {
            this.nextInstructionNumber = block.numberInstructions(this.nextInstructionNumber);
        }
        return blocks;
    }

    public int numberRemainingInstructions() {
        InstructionIterator it = this.instructionIterator();
        while (it.hasNext()) {
            Instruction i = (Instruction)it.next();
            if (i.getNumber() != -1) continue;
            i.setNumber(this.nextInstructionNumber);
            this.nextInstructionNumber += 2;
        }
        return this.nextInstructionNumber;
    }

    public int getNextInstructionNumber() {
        return this.nextInstructionNumber;
    }

    public List<Value> collectArguments() {
        return this.collectArguments(false);
    }

    public List<Value> collectArguments(boolean ignoreReceiver) {
        ArrayList<Value> arguments = new ArrayList<Value>();
        InstructionIterator iterator = this.blocks.get(0).iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            if (!instruction.isArgument()) continue;
            Value out = instruction.asArgument().outValue();
            if (ignoreReceiver && out.isThis()) continue;
            arguments.add(out);
        }
        assert (arguments.size() == this.method.method.getArity() + (this.method.accessFlags.isStatic() || ignoreReceiver ? 0 : 1));
        return arguments;
    }

    public Value getThis() {
        if (this.method.accessFlags.isStatic()) {
            return null;
        }
        Object firstArg = this.blocks.getFirst().listIterator().nextUntil(Instruction::isArgument);
        assert (firstArg != null);
        Value thisValue = ((Instruction)firstArg).asArgument().outValue();
        assert (thisValue.isThis());
        return thisValue;
    }

    public Value createValue(ValueType valueType, DebugLocalInfo local) {
        return new Value(this.valueNumberGenerator.next(), valueType, local);
    }

    public Value createValue(ValueType valueType) {
        return this.createValue(valueType, null);
    }

    public ConstNumber createIntConstant(int value) {
        return new ConstNumber(this.createValue(ValueType.INT), value);
    }

    public ConstNumber createTrue() {
        return new ConstNumber(this.createValue(ValueType.INT), 1L);
    }

    public ConstNumber createFalse() {
        return new ConstNumber(this.createValue(ValueType.INT), 0L);
    }

    public final int getHighestBlockNumber() {
        return this.blocks.stream().max(Comparator.comparingInt(BasicBlock::getNumber)).get().getNumber();
    }

    public Instruction createConstNull(Instruction from) {
        return new ConstNumber(this.createValue(from.outType()), 0L);
    }

    public boolean doAllThrowingInstructionsHavePositions() {
        return this.allThrowingInstructionsHavePositions;
    }

    public void setAllThrowingInstructionsHavePositions(boolean value) {
        this.allThrowingInstructionsHavePositions = value;
    }

    private boolean computeAllThrowingInstructionsHavePositions() {
        InstructionIterator it = this.instructionIterator();
        while (it.hasNext()) {
            Instruction instruction = (Instruction)it.next();
            if (!instruction.instructionTypeCanThrow() || instruction.isConstString() || !instruction.getPosition().isNone()) continue;
            return false;
        }
        return true;
    }

    public void removeAllTrivialPhis() {
        for (BasicBlock block : this.blocks) {
            ArrayList<Phi> phis = new ArrayList<Phi>(block.getPhis());
            for (Phi phi : phis) {
                phi.removeTrivialPhi();
            }
        }
    }

    public int reserveMarkingColor() {
        int color;
        for (color = 1; (this.usedMarkingColors & color) == color; color <<= 1) {
            assert (color <= 0x40000000);
        }
        assert (color == 1);
        assert (this.verifyNoBlocksMarked(color));
        this.usedMarkingColors |= color;
        return color;
    }

    public void returnMarkingColor(int color) {
        assert ((this.usedMarkingColors | color) == color);
        this.clearMarks(color);
        this.usedMarkingColors &= ~color;
    }

    public boolean verifyNoColorsInUse() {
        return this.usedMarkingColors == 0;
    }

    public void removeUnreachableBlocks() {
        int color = this.reserveMarkingColor();
        ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
        worklist.add(this.blocks.getFirst());
        while (!worklist.isEmpty()) {
            BasicBlock block = (BasicBlock)worklist.poll();
            if (block.isMarked(color)) continue;
            block.mark(color);
            for (BasicBlock successor : block.getSuccessors()) {
                if (successor.isMarked(color)) continue;
                worklist.add(successor);
            }
        }
        ListIterator<BasicBlock> blockIterator = this.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock current = blockIterator.next();
            if (current.isMarked(color)) continue;
            current.cleanForRemoval();
            blockIterator.remove();
        }
        this.returnMarkingColor(color);
    }

    private static class BlockMarker {
        final BasicBlock block;

        BlockMarker(BasicBlock block) {
            this.block = block;
        }
    }
}

