/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.com.google.gson.JsonElement;
import com.android.tools.r8.com.google.gson.JsonObject;
import com.android.tools.r8.com.google.gson.JsonParser;
import com.android.tools.r8.com.google.gson.JsonSyntaxException;
import com.android.tools.r8.graph.DexString;
import java.util.Comparator;
import java.util.Map;

public class Marker {
    public static final String VERSION = "version";
    public static final String MIN_API = "min-api";
    public static final String SHA1 = "sha-1";
    private static final char PREFIX_CHAR = '~';
    private static final String PREFIX = "~~";
    private static final String D8_PREFIX = "~~" + (Object)((Object)Tool.D8) + "{";
    private static final String R8_PREFIX = "~~" + (Object)((Object)Tool.R8) + "{";
    private final JsonObject jsonObject;
    private final Tool tool;

    public Marker(Tool tool) {
        this.tool = tool;
        this.jsonObject = new JsonObject();
    }

    private Marker(Tool tool, JsonObject jsonObject) {
        this.tool = tool;
        this.jsonObject = jsonObject;
    }

    public Tool getTool() {
        return this.tool;
    }

    public boolean isD8() {
        return this.tool == Tool.D8;
    }

    public boolean isR8() {
        return this.tool == Tool.R8;
    }

    public String getVersion() {
        return this.jsonObject.get(VERSION).getAsString();
    }

    public Marker setVersion(String version) {
        assert (!this.jsonObject.has(VERSION));
        this.jsonObject.addProperty(VERSION, version);
        return this;
    }

    public Long getMinApi() {
        return this.jsonObject.get(MIN_API).getAsLong();
    }

    public Marker setMinApi(long minApi) {
        assert (!this.jsonObject.has(MIN_API));
        this.jsonObject.addProperty(MIN_API, minApi);
        return this;
    }

    public String getSha1() {
        return this.jsonObject.get(SHA1).getAsString();
    }

    public Marker setSha1(String sha1) {
        assert (!this.jsonObject.has(SHA1));
        this.jsonObject.addProperty(SHA1, sha1);
        return this;
    }

    public String toString() {
        JsonObject sortedJson = new JsonObject();
        this.jsonObject.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(entry -> sortedJson.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        return PREFIX + (Object)((Object)this.tool) + sortedJson;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Marker) {
            Marker other = (Marker)obj;
            return this.tool == other.tool && this.jsonObject.equals(other.jsonObject);
        }
        return false;
    }

    public int hashCode() {
        return this.tool.hashCode() + 3 * this.jsonObject.hashCode();
    }

    public static Marker parse(DexString dexString) {
        if (dexString.size > 2 && dexString.content[0] == 126 && dexString.content[1] == 126) {
            String str = dexString.toString();
            if (str.startsWith(D8_PREFIX)) {
                return Marker.internalParse(Tool.D8, str.substring(D8_PREFIX.length() - 1));
            }
            if (str.startsWith(R8_PREFIX)) {
                return Marker.internalParse(Tool.R8, str.substring(R8_PREFIX.length() - 1));
            }
        }
        return null;
    }

    private static Marker internalParse(Tool tool, String str) {
        try {
            JsonElement result = new JsonParser().parse(str);
            if (result.isJsonObject()) {
                return new Marker(tool, result.getAsJsonObject());
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return null;
    }

    public static enum Tool {
        D8,
        R8;

    }
}

