/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.DataResourceConsumer;
import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.InvalidDebugInfoException;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.DefaultDiagnosticsHandler;
import com.android.tools.r8.utils.OffOrAuto;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;

public class InternalOptions {
    public static final boolean DETERMINISTIC_DEBUGGING = false;
    public final DexItemFactory itemFactory;
    public final ProguardConfiguration proguardConfiguration;
    public final Reporter reporter;
    public ProgramConsumer programConsumer = null;
    public final List<DataResourceProvider> dataResourceProviders = new ArrayList<DataResourceProvider>();
    public DataResourceConsumer dataResourceConsumer;
    public boolean printTimes = System.getProperty("com.android.tools.r8.printtimes") != null;
    public boolean passthroughDexCode = false;
    public boolean enableClassMerging = false;
    public boolean enableDevirtualization = true;
    public boolean enableNonNullTracking = true;
    public boolean enableInlining = !Version.isDev() || System.getProperty("com.android.tools.r8.disableinlining") == null;
    public boolean enableClassInlining = true;
    public int classInliningInstructionLimit = 50;
    public int inliningInstructionLimit = 5;
    public boolean enableSwitchMapRemoval = true;
    public final OutlineOptions outline = new OutlineOptions();
    public boolean enableValuePropagation = true;
    public int numberOfThreads = -1;
    public boolean useSmaliSyntax = false;
    public boolean verbose = false;
    public boolean quiet = false;
    public boolean invalidDebugInfoFatal = false;
    private boolean hasMarker = false;
    private Marker marker;
    public List<String> methodsFilter = ImmutableList.of();
    public int minApiLevel = AndroidApiLevel.getDefault().getLevel();
    public boolean intermediate = false;
    public List<String> logArgumentsFilter = ImmutableList.of();
    public boolean enableLambdaMerging = false;
    public boolean enableDesugaring = true;
    public OffOrAuto interfaceMethodDesugaring = OffOrAuto.Auto;
    public OffOrAuto tryWithResourcesDesugaring = OffOrAuto.Auto;
    public boolean processCovariantReturnTypeAnnotations = true;
    public boolean enableMainDexListCheck = true;
    public boolean enableTreeShaking = true;
    public boolean printCfg = false;
    public String printCfgFile;
    public boolean ignoreMissingClasses = false;
    public boolean forceProguardCompatibility = false;
    public boolean enableMinification = true;
    public boolean disableAssertions = true;
    public boolean debugKeepRules = false;
    public boolean enableCfFrontend = false;
    public boolean skipIR = false;
    public boolean debug = false;
    public final TestingOptions testing = new TestingOptions();
    public ImmutableList<ProguardConfigurationRule> mainDexKeepRules = ImmutableList.of();
    public boolean minimalMainDex;
    public boolean enableInheritanceClassInDexDistributor = true;
    public LineNumberOptimization lineNumberOptimization = LineNumberOptimization.ON;
    private final Map<Origin, List<TypeVersionPair>> missingEnclosingMembers = new HashMap<Origin, List<TypeVersionPair>>();
    private final Map<Origin, List<InvalidParameterAnnotationInfo>> warningInvalidParameterAnnotations = new HashMap<Origin, List<InvalidParameterAnnotationInfo>>();
    private final Map<Origin, List<Pair<DexEncodedMethod, String>>> warningInvalidDebugInfo = new HashMap<Origin, List<Pair<DexEncodedMethod, String>>>();
    public boolean skipReadingDexCode = false;
    public StringConsumer mainDexListConsumer = null;
    public StringConsumer proguardMapConsumer = null;
    public StringConsumer proguardSeedsConsumer = null;
    public StringConsumer usageInformationConsumer = null;
    public StringConsumer configurationConsumer = null;
    public Path proguardCompatibilityRulesOutput = null;

    public InternalOptions() {
        this.reporter = new Reporter(new DefaultDiagnosticsHandler());
        this.itemFactory = new DexItemFactory();
        this.proguardConfiguration = ProguardConfiguration.defaultConfiguration(this.itemFactory, this.reporter);
    }

    public InternalOptions(DexItemFactory factory, Reporter reporter) {
        assert (reporter != null);
        assert (factory != null);
        this.reporter = reporter;
        this.itemFactory = factory;
        this.proguardConfiguration = ProguardConfiguration.defaultConfiguration(this.itemFactory, reporter);
    }

    public InternalOptions(ProguardConfiguration proguardConfiguration, Reporter reporter) {
        assert (reporter != null);
        assert (proguardConfiguration != null);
        this.reporter = reporter;
        this.proguardConfiguration = proguardConfiguration;
        this.itemFactory = proguardConfiguration.getDexItemFactory();
        if (!proguardConfiguration.isOptimizing()) {
            this.enableClassMerging = false;
            this.enableDevirtualization = false;
            this.enableNonNullTracking = false;
            this.enableInlining = false;
            this.enableClassInlining = false;
            this.enableSwitchMapRemoval = false;
            this.outline.enabled = false;
            this.enableValuePropagation = false;
        }
    }

    public boolean hasMarker() {
        return this.hasMarker;
    }

    public void setMarker(Marker marker) {
        this.hasMarker = true;
        this.marker = marker;
    }

    public Marker getMarker() {
        assert (this.hasMarker());
        return this.marker;
    }

    public boolean isGeneratingDex() {
        return this.isGeneratingDexIndexed() || this.isGeneratingDexFilePerClassFile();
    }

    public boolean isGeneratingDexIndexed() {
        return this.programConsumer instanceof DexIndexedConsumer;
    }

    public boolean isGeneratingDexFilePerClassFile() {
        return this.programConsumer instanceof DexFilePerClassFileConsumer;
    }

    public boolean isGeneratingClassFiles() {
        return this.programConsumer instanceof ClassFileConsumer;
    }

    public DexIndexedConsumer getDexIndexedConsumer() {
        return (DexIndexedConsumer)this.programConsumer;
    }

    public DexFilePerClassFileConsumer getDexFilePerClassFileConsumer() {
        return (DexFilePerClassFileConsumer)this.programConsumer;
    }

    public ClassFileConsumer getClassFileConsumer() {
        return (ClassFileConsumer)this.programConsumer;
    }

    public void signalFinishedToConsumers() {
        if (this.programConsumer != null) {
            this.programConsumer.finished(this.reporter);
            if (this.dataResourceConsumer != null) {
                this.dataResourceConsumer.finished(this.reporter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warningMissingEnclosingMember(DexType clazz, Origin origin, int version) {
        TypeVersionPair pair = new TypeVersionPair(version, clazz);
        Map<Origin, List<TypeVersionPair>> map = this.missingEnclosingMembers;
        synchronized (map) {
            this.missingEnclosingMembers.computeIfAbsent(origin, k -> new ArrayList()).add(pair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warningInvalidParameterAnnotations(DexMethod method, Origin origin, int expected, int actual) {
        InvalidParameterAnnotationInfo info = new InvalidParameterAnnotationInfo(method, expected, actual);
        Map<Origin, List<InvalidParameterAnnotationInfo>> map = this.warningInvalidParameterAnnotations;
        synchronized (map) {
            this.warningInvalidParameterAnnotations.computeIfAbsent(origin, k -> new ArrayList()).add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warningInvalidDebugInfo(DexEncodedMethod method, Origin origin, InvalidDebugInfoException e) {
        if (this.invalidDebugInfoFatal) {
            throw new CompilationError("Fatal warning: Invalid debug info", e);
        }
        Map<Origin, List<Pair<DexEncodedMethod, String>>> map = this.warningInvalidDebugInfo;
        synchronized (map) {
            this.warningInvalidDebugInfo.computeIfAbsent(origin, k -> new ArrayList()).add(new Pair<DexEncodedMethod, String>(method, e.getMessage()));
        }
    }

    public boolean printWarnings() {
        StringBuilder builder;
        boolean printed = false;
        boolean printOutdatedToolchain = false;
        if (this.warningInvalidParameterAnnotations.size() > 0) {
            this.reporter.warning(new StringDiagnostic("Invalid parameter counts in MethodParameter attributes. This is likely due to Proguard having removed a parameter."));
            for (Origin origin : new TreeSet<Origin>(this.warningInvalidParameterAnnotations.keySet())) {
                builder = new StringBuilder("Methods with invalid MethodParameter attributes:");
                for (InvalidParameterAnnotationInfo info : this.warningInvalidParameterAnnotations.get(origin)) {
                    builder.append("\n  ").append(info.method).append(" expected count: ").append(info.expectedParameterCount).append(" actual count: ").append(info.actualParameterCount);
                }
                this.reporter.info(new StringDiagnostic(builder.toString(), origin));
            }
            printed = true;
        }
        if (this.warningInvalidDebugInfo.size() > 0) {
            int count = 0;
            for (List<Pair<DexEncodedMethod, String>> methods : this.warningInvalidDebugInfo.values()) {
                count += methods.size();
            }
            this.reporter.warning(new StringDiagnostic("Stripped invalid locals information from " + count + (count == 1 ? " method." : " methods.")));
            for (Origin origin : new TreeSet<Origin>(this.warningInvalidDebugInfo.keySet())) {
                StringBuilder builder2 = new StringBuilder("Methods with invalid locals information:");
                for (Pair pair : this.warningInvalidDebugInfo.get(origin)) {
                    builder2.append("\n  ").append(((DexEncodedMethod)pair.getFirst()).toSourceString());
                    builder2.append("\n  ").append((String)pair.getSecond());
                }
                this.reporter.warning(new StringDiagnostic(builder2.toString(), origin));
            }
            printed = true;
            printOutdatedToolchain = true;
        }
        if (this.missingEnclosingMembers.size() > 0) {
            this.reporter.warning(new StringDiagnostic("InnerClass annotations are missing corresponding EnclosingMember annotations. Such InnerClass annotations are ignored."));
            for (Origin origin : new TreeSet<Origin>(this.missingEnclosingMembers.keySet())) {
                builder = new StringBuilder("Classes with missing enclosing members: ");
                boolean first = true;
                for (TypeVersionPair typeVersionPair : this.missingEnclosingMembers.get(origin)) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(typeVersionPair.type);
                    printOutdatedToolchain |= typeVersionPair.version < 49;
                }
                this.reporter.info(new StringDiagnostic(builder.toString(), origin));
            }
            printed = true;
        }
        if (printOutdatedToolchain) {
            this.reporter.info(new StringDiagnostic("Some warnings are typically a sign of using an outdated Java toolchain. To fix, recompile the source with an updated toolchain."));
        }
        return printed;
    }

    public boolean hasMethodsFilter() {
        return this.methodsFilter.size() > 0;
    }

    public boolean methodMatchesFilter(DexEncodedMethod method) {
        if (!this.hasMethodsFilter()) {
            return true;
        }
        String qualifiedName = method.qualifiedName();
        return this.methodsFilter.indexOf(qualifiedName) >= 0;
    }

    public boolean methodMatchesLogArgumentsFilter(DexEncodedMethod method) {
        if (this.logArgumentsFilter.size() == 0) {
            return false;
        }
        String qualifiedName = method.qualifiedName();
        return this.logArgumentsFilter.indexOf(qualifiedName) >= 0;
    }

    public boolean canUseInvokePolymorphicOnVarHandle() {
        return this.hasMinApi(AndroidApiLevel.P);
    }

    public boolean canUseInvokePolymorphic() {
        return this.hasMinApi(AndroidApiLevel.O);
    }

    public boolean canUseConstantMethodHandle() {
        return this.hasMinApi(AndroidApiLevel.P);
    }

    private boolean hasMinApi(AndroidApiLevel level) {
        return this.isGeneratingClassFiles() || this.minApiLevel >= level.getLevel();
    }

    public boolean canUseConstantMethodType() {
        return this.hasMinApi(AndroidApiLevel.P);
    }

    public boolean canUseInvokeCustom() {
        return this.hasMinApi(AndroidApiLevel.O);
    }

    public boolean canUseDefaultAndStaticInterfaceMethods() {
        return this.hasMinApi(AndroidApiLevel.N);
    }

    public boolean canUsePrivateInterfaceMethods() {
        return this.hasMinApi(AndroidApiLevel.N);
    }

    public boolean canUseMultidex() {
        return this.intermediate || this.hasMinApi(AndroidApiLevel.L);
    }

    public boolean canUseLongCompareAndObjectsNonNull() {
        return this.hasMinApi(AndroidApiLevel.K);
    }

    public boolean canUseSuppressedExceptions() {
        return this.hasMinApi(AndroidApiLevel.K);
    }

    public boolean canUseParameterNameAnnotations() {
        return this.hasMinApi(AndroidApiLevel.O);
    }

    public boolean canUseFilledNewArrayOfObjects() {
        return this.hasMinApi(AndroidApiLevel.K);
    }

    public boolean canUseSameArrayAndResultRegisterInArrayGetWide() {
        return this.minApiLevel > AndroidApiLevel.O_MR1.getLevel();
    }

    public boolean canHaveBoundsCheckEliminationBug() {
        return this.minApiLevel <= AndroidApiLevel.L.getLevel();
    }

    public boolean canUseNotInstruction() {
        return this.hasMinApi(AndroidApiLevel.L);
    }

    public boolean canHaveThisTypeVerifierBug() {
        return this.minApiLevel < AndroidApiLevel.M.getLevel();
    }

    public boolean canHaveOverlappingLongRegisterBug() {
        return this.minApiLevel < AndroidApiLevel.L.getLevel();
    }

    public boolean canHaveCmpLongBug() {
        return this.minApiLevel < AndroidApiLevel.L.getLevel();
    }

    public boolean canHaveMul2AddrBug() {
        return this.minApiLevel < AndroidApiLevel.M.getLevel();
    }

    public boolean canHaveDex2OatLinkedListBug() {
        return this.minApiLevel < AndroidApiLevel.N.getLevel();
    }

    public boolean canHaveArtStringNewInitBug() {
        return this.minApiLevel <= AndroidApiLevel.P.getLevel();
    }

    public boolean canHaveNumberConversionRegisterAllocationBug() {
        return this.minApiLevel <= AndroidApiLevel.K.getLevel();
    }

    public static class TestingOptions {
        public Function<Set<DexEncodedMethod>, Set<DexEncodedMethod>> irOrdering = Function.identity();
        public boolean invertConditionals = false;
        public boolean placeExceptionalBlocksLast = false;
        public boolean dontCreateMarkerInD8 = false;
        public boolean forceJumboStringProcessing = false;
    }

    public static class OutlineOptions {
        public static final String CLASS_NAME = "r8.GeneratedOutlineSupport";
        public static final String METHOD_PREFIX = "outline";
        public boolean enabled = true;
        public int minSize = 3;
        public int maxSize = 99;
        public int threshold = 20;
    }

    public static enum PackageObfuscationMode {
        NONE,
        REPACKAGE,
        FLATTEN;

    }

    private static class TypeVersionPair {
        final int version;
        final DexType type;

        public TypeVersionPair(int version, DexType type) {
            this.version = version;
            this.type = type;
        }
    }

    public static class InvalidParameterAnnotationInfo {
        final DexMethod method;
        final int expectedParameterCount;
        final int actualParameterCount;

        public InvalidParameterAnnotationInfo(DexMethod method, int expectedParameterCount, int actualParameterCount) {
            this.method = method;
            this.expectedParameterCount = expectedParameterCount;
            this.actualParameterCount = actualParameterCount;
        }
    }

    public static enum LineNumberOptimization {
        OFF,
        ON,
        IDENTITY_MAPPING;

    }
}

