/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.base.Supplier;
import com.android.tools.r8.com.google.common.base.Suppliers;
import com.android.tools.r8.com.google.common.collect.ArrayListMultimap;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.ir.analysis.type.TypeEnvironment;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Binop;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.Cmp;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DebugLocalWrite;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeNewArray;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewArrayFilledData;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Switch;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.code.Xor;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.SwitchUtils;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntLists;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LongInterval;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class CodeRewriter {
    private static final int MAX_FILL_ARRAY_SIZE = 8192;
    private static final int STOP_SHARED_CONSTANT_THRESHOLD = 50;
    private final AppInfo appInfo;
    private final DexItemFactory dexItemFactory;
    private final Set<DexMethod> libraryMethodsReturningReceiver;
    private final InternalOptions options;
    private DexProgramClass cachedClass = null;

    public CodeRewriter(AppInfo appInfo, Set<DexMethod> libraryMethodsReturningReceiver, InternalOptions options) {
        this.appInfo = appInfo;
        this.options = options;
        this.dexItemFactory = appInfo.dexItemFactory;
        this.libraryMethodsReturningReceiver = libraryMethodsReturningReceiver;
    }

    private static boolean removedTrivialGotos(IRCode code) {
        BasicBlock nextBlock;
        ListIterator<BasicBlock> iterator = code.listIterator();
        assert (iterator.hasNext());
        BasicBlock block = iterator.next();
        do {
            nextBlock = iterator.hasNext() ? iterator.next() : null;
            BasicBlock blk = block;
            assert (!block.isTrivialGoto() || block.exit().asGoto().getTarget() == block || code.blocks.get(0) == block || block.getPredecessors().stream().anyMatch(b -> b.exit().fallthroughBlock() == blk));
            assert (!block.isTrivialGoto() || block.exit().asGoto().getTarget() != nextBlock);
        } while ((block = nextBlock) != null);
        return true;
    }

    private static boolean isFallthroughBlock(BasicBlock block) {
        for (BasicBlock pred : block.getPredecessors()) {
            if (pred.exit().fallthroughBlock() != block) continue;
            return true;
        }
        return false;
    }

    private static void collapsTrivialGoto(IRCode code, BasicBlock block, BasicBlock nextBlock, List<BasicBlock> blocksToRemove) {
        if (block.exit().asGoto().getTarget() == block) {
            return;
        }
        BasicBlock target = block.endOfGotoChain();
        boolean needed = false;
        if (target == null) {
            target = block.exit().asGoto().getTarget();
        }
        if (target != nextBlock) {
            boolean bl = needed = code.blocks.get(0) == block || CodeRewriter.isFallthroughBlock(block);
        }
        if (!needed) {
            blocksToRemove.add(block);
            for (BasicBlock pred : block.getPredecessors()) {
                pred.replaceSuccessor(block, target);
            }
            for (BasicBlock succ : block.getSuccessors()) {
                succ.getPredecessors().remove(block);
            }
            for (BasicBlock pred : block.getPredecessors()) {
                if (target.getPredecessors().contains(pred)) continue;
                target.getPredecessors().add(pred);
            }
        }
    }

    private static void collapsIfTrueTarget(BasicBlock block) {
        If insn = block.exit().asIf();
        BasicBlock target = insn.getTrueTarget();
        BasicBlock newTarget = target.endOfGotoChain();
        BasicBlock fallthrough = insn.fallthroughBlock();
        BasicBlock newFallthrough = fallthrough.endOfGotoChain();
        if (newTarget != null && target != newTarget) {
            insn.getBlock().replaceSuccessor(target, newTarget);
            target.getPredecessors().remove(block);
            if (!newTarget.getPredecessors().contains(block)) {
                newTarget.getPredecessors().add(block);
            }
        }
        if (block.exit().isIf() && (insn = block.exit().asIf()).getTrueTarget() == newFallthrough) {
            block.replaceSuccessor(insn.getTrueTarget(), fallthrough);
            assert (block.exit().isGoto());
            assert (block.exit().asGoto().getTarget() == fallthrough);
        }
    }

    private static void collapsNonFallthroughSwitchTargets(BasicBlock block) {
        Switch insn = block.exit().asSwitch();
        BasicBlock fallthroughBlock = insn.fallthroughBlock();
        HashSet<BasicBlock> replacedBlocks = new HashSet<BasicBlock>();
        for (int j = 0; j < insn.targetBlockIndices().length; ++j) {
            BasicBlock newTarget;
            BasicBlock target = insn.targetBlock(j);
            if (target == fallthroughBlock || (newTarget = target.endOfGotoChain()) == null || target == newTarget || replacedBlocks.contains(target)) continue;
            insn.getBlock().replaceSuccessor(target, newTarget);
            target.getPredecessors().remove(block);
            if (!newTarget.getPredecessors().contains(block)) {
                newTarget.getPredecessors().add(block);
            }
            replacedBlocks.add(target);
        }
    }

    private void convertSwitchToSwitchAndIfs(IRCode code, ListIterator<BasicBlock> blocksIterator, BasicBlock originalBlock, InstructionListIterator iterator, Switch theSwitch, List<IntList> switches, IntList keysToRemove) {
        int i;
        Position position = theSwitch.getPosition();
        Int2ReferenceSortedMap<BasicBlock> keyToTarget = theSwitch.getKeyToTargetMap();
        BasicBlock fallthroughBlock = theSwitch.fallthroughBlock();
        iterator.previous();
        BasicBlock originalSwitchBlock = iterator.split(code, blocksIterator);
        assert (!originalSwitchBlock.hasCatchHandlers());
        assert (originalSwitchBlock.getInstructions().size() == 1);
        assert (originalBlock.exit().isGoto());
        theSwitch.moveDebugValues(originalBlock.exit());
        blocksIterator.remove();
        theSwitch.getBlock().detachAllSuccessors();
        BasicBlock block = theSwitch.getBlock().unlinkSinglePredecessor();
        assert (theSwitch.getBlock().getPredecessors().size() == 0);
        assert (theSwitch.getBlock().getSuccessors().size() == 0);
        assert (block == originalBlock);
        int nextBlockNumber = code.getHighestBlockNumber() + 1;
        LinkedList<BasicBlock> newBlocks = new LinkedList<BasicBlock>();
        for (i = switches.size() - 1; i >= 0; --i) {
            SwitchBuilder switchBuilder = new SwitchBuilder(position);
            switchBuilder.setValue(theSwitch.value());
            IntList keys = switches.get(i);
            for (int j = 0; j < keys.size(); ++j) {
                int key = keys.getInt(j);
                switchBuilder.addKeyAndTarget(key, (BasicBlock)keyToTarget.get(key));
            }
            switchBuilder.setFallthrough(fallthroughBlock).setBlockNumber(nextBlockNumber++);
            BasicBlock newSwitchBlock = switchBuilder.build();
            newBlocks.addFirst(newSwitchBlock);
            fallthroughBlock = newSwitchBlock;
        }
        for (i = keysToRemove.size() - 1; i >= 0; --i) {
            int key = keysToRemove.getInt(i);
            BasicBlock peeledOffTarget = (BasicBlock)keyToTarget.get(key);
            IfBuilder ifBuilder = new IfBuilder(position, code);
            ifBuilder.setLeft(theSwitch.value()).setRight(key).setTarget(peeledOffTarget).setFallthrough(fallthroughBlock).setBlockNumber(nextBlockNumber++);
            BasicBlock ifBlock = ifBuilder.build();
            newBlocks.addFirst(ifBlock);
            fallthroughBlock = ifBlock;
        }
        originalBlock.link(fallthroughBlock);
        newBlocks.forEach(blocksIterator::add);
    }

    public void rewriteSwitch(IRCode code) {
        ListIterator<BasicBlock> blocksIterator = code.listIterator();
        while (blocksIterator.hasNext()) {
            BasicBlock block = blocksIterator.next();
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext()) {
                Instruction instruction = (Instruction)iterator.next();
                if (!instruction.isSwitch()) continue;
                Switch theSwitch = instruction.asSwitch();
                if (theSwitch.numberOfKeys() == 1) {
                    int caseBlockIndex;
                    int fallthroughBlockIndex = theSwitch.getFallthroughBlockIndex();
                    if (fallthroughBlockIndex < (caseBlockIndex = theSwitch.targetBlockIndices()[0])) {
                        block.swapSuccessorsByIndex(fallthroughBlockIndex, caseBlockIndex);
                    }
                    if (theSwitch.getFirstKey() == 0) {
                        iterator.replaceCurrentInstruction(new If(If.Type.EQ, theSwitch.value()));
                        continue;
                    }
                    ConstNumber labelConst = code.createIntConstant(theSwitch.getFirstKey());
                    labelConst.setPosition(theSwitch.getPosition());
                    iterator.previous();
                    iterator.add(labelConst);
                    Instruction dummy = (Instruction)iterator.next();
                    assert (dummy == theSwitch);
                    If theIf = new If(If.Type.EQ, ImmutableList.of(theSwitch.value(), labelConst.dest()));
                    iterator.replaceCurrentInstruction(theIf);
                    continue;
                }
                ArrayList<IntList> sequences = new ArrayList<IntList>();
                IntArrayList outliers = new IntArrayList();
                IntArrayList current = new IntArrayList();
                int[] keys = theSwitch.getKeys();
                int previousKey = keys[0];
                current.add(previousKey);
                for (int i = 1; i < keys.length; ++i) {
                    assert (current.size() > 0);
                    assert (current.getInt(current.size() - 1) == previousKey);
                    int key = keys[i];
                    if ((long)key - (long)previousKey > 1L) {
                        if (current.size() == 1) {
                            outliers.add(previousKey);
                        } else {
                            sequences.add(current);
                        }
                        current = new IntArrayList();
                    }
                    current.add(key);
                    previousKey = key;
                }
                if (current.size() == 1) {
                    outliers.add(previousKey);
                } else {
                    sequences.add(current);
                }
                int currentSize = Switch.payloadSize(keys) + Switch.estimatedDexSize();
                if (outliers.size() + sequences.size() <= 10) {
                    long rewrittenSize = 0L;
                    for (Integer n : outliers) {
                        if (n != 0) {
                            rewrittenSize += (long)ConstNumber.estimatedDexSize(theSwitch.value().outType(), n.intValue());
                        }
                        rewrittenSize += (long)If.estimatedDexSize();
                    }
                    for (List list : sequences) {
                        rewrittenSize += (long)Switch.payloadSize(list);
                    }
                    if ((rewrittenSize += (long)(Switch.estimatedDexSize() * sequences.size())) >= (long)currentSize) continue;
                    this.convertSwitchToSwitchAndIfs(code, blocksIterator, block, iterator, theSwitch, sequences, outliers);
                    continue;
                }
                if (outliers.size() <= 1) continue;
                long rewrittenSize = 0L;
                for (List list : sequences) {
                    rewrittenSize += (long)Switch.payloadSize(list);
                }
                rewrittenSize += (long)Switch.payloadSize(outliers);
                if ((rewrittenSize += (long)(Switch.estimatedDexSize() * (sequences.size() + 1))) >= (long)currentSize) continue;
                ArrayList<IntList> seqs = new ArrayList<IntList>(sequences);
                seqs.add(outliers);
                this.convertSwitchToSwitchAndIfs(code, blocksIterator, block, iterator, theSwitch, seqs, IntLists.EMPTY_LIST);
            }
        }
        code.splitCriticalEdges();
        assert (code.isConsistentSSA());
    }

    public void removeSwitchMaps(IRCode code) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction staticGet;
                Switch switchInsn;
                SwitchUtils.EnumSwitchInfo info;
                Instruction insn = (Instruction)it.next();
                if (!insn.isSwitch() || (info = SwitchUtils.analyzeSwitchOverEnum(switchInsn = insn.asSwitch(), this.appInfo.withLiveness())) == null) continue;
                Int2IntArrayMap targetMap = new Int2IntArrayMap();
                IntArrayList keys = new IntArrayList(switchInsn.numberOfKeys());
                for (int i = 0; i < switchInsn.numberOfKeys(); ++i) {
                    assert (switchInsn.targetBlockIndices()[i] != switchInsn.getFallthroughBlockIndex());
                    int key = info.ordinalsMap.getInt(info.indexMap.get(switchInsn.getKey(i)));
                    keys.add(key);
                    targetMap.put(key, switchInsn.targetBlockIndices()[i]);
                }
                keys.sort(Comparator.naturalOrder());
                int[] targets = new int[keys.size()];
                for (int i = 0; i < keys.size(); ++i) {
                    targets[i] = targetMap.get(keys.getInt(i));
                }
                Switch newSwitch = new Switch(info.ordinalInvoke.outValue(), keys.toIntArray(), targets, switchInsn.getFallthroughBlockIndex());
                it.replaceCurrentInstruction(newSwitch);
                Instruction arrayGet = info.arrayGet;
                if (arrayGet.outValue().numberOfUsers() == 0) {
                    arrayGet.inValues().forEach(v -> v.removeUser(arrayGet));
                    arrayGet.getBlock().removeInstruction(arrayGet);
                }
                if ((staticGet = info.staticGet).outValue().numberOfUsers() != 0) continue;
                assert (staticGet.inValues().isEmpty());
                staticGet.getBlock().removeInstruction(staticGet);
            }
        }
    }

    public static void collapsTrivialGotos(DexEncodedMethod method, IRCode code) {
        BasicBlock nextBlock;
        assert (code.isConsistentGraph());
        ArrayList<BasicBlock> blocksToRemove = new ArrayList<BasicBlock>();
        ListIterator<BasicBlock> iterator = code.listIterator();
        assert (iterator.hasNext());
        BasicBlock block = iterator.next();
        do {
            BasicBlock basicBlock = nextBlock = iterator.hasNext() ? iterator.next() : null;
            if (block.isTrivialGoto()) {
                CodeRewriter.collapsTrivialGoto(code, block, nextBlock, blocksToRemove);
            }
            if (block.exit().isIf()) {
                CodeRewriter.collapsIfTrueTarget(block);
            }
            if (block.exit().isSwitch()) {
                CodeRewriter.collapsNonFallthroughSwitchTargets(block);
            }
            block = nextBlock;
        } while (nextBlock != null);
        code.removeBlocks(blocksToRemove);
        while (!blocksToRemove.isEmpty()) {
            blocksToRemove = new ArrayList();
            iterator = code.listIterator();
            block = iterator.next();
            do {
                BasicBlock basicBlock = nextBlock = iterator.hasNext() ? iterator.next() : null;
                if (!block.isTrivialGoto()) continue;
                CodeRewriter.collapsTrivialGoto(code, block, nextBlock, blocksToRemove);
            } while ((block = nextBlock) != null);
            code.removeBlocks(blocksToRemove);
        }
        assert (CodeRewriter.removedTrivialGotos(code));
        assert (code.isConsistentGraph());
    }

    public void identifyReturnsArgument(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        ImmutableList<BasicBlock> normalExits = code.computeNormalExitBlocks();
        if (normalExits.isEmpty()) {
            feedback.methodNeverReturnsNormally(method);
            return;
        }
        Return firstExit = ((BasicBlock)normalExits.get(0)).exit().asReturn();
        if (firstExit.isReturnVoid()) {
            return;
        }
        Value returnValue = firstExit.returnValue();
        boolean isNeverNull = returnValue.isNeverNull();
        for (int i = 1; i < normalExits.size(); ++i) {
            Return exit = ((BasicBlock)normalExits.get(i)).exit().asReturn();
            Value value = exit.returnValue();
            if (value != returnValue) {
                returnValue = null;
            }
            isNeverNull = isNeverNull && value.isNeverNull();
        }
        if (returnValue != null) {
            if (returnValue.isArgument()) {
                int index = code.collectArguments().indexOf(returnValue);
                assert (index != -1);
                feedback.methodReturnsArgument(method, index);
            }
            if (returnValue.isConstant() && returnValue.definition.isConstNumber()) {
                long value = returnValue.definition.asConstNumber().getRawValue();
                feedback.methodReturnsConstant(method, value);
            }
        }
        if (isNeverNull) {
            feedback.methodNeverReturnsNull(method);
        }
    }

    public void identifyInvokeSemanticsForInlining(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        if (method.isStaticMethod()) {
            feedback.markTriggerClassInitBeforeAnySideEffect(method, CodeRewriter.triggersClassInitializationBeforeSideEffect(code, method.method.getHolder()));
        } else {
            Value receiver = code.getThis();
            feedback.markCheckNullReceiverBeforeAnySideEffect(method, receiver.isUsed() && CodeRewriter.checksNullReceiverBeforeSideEffect(code, receiver));
        }
    }

    public void identifyClassInlinerEligibility(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        boolean instanceInitializer = method.isInstanceInitializer();
        if (method.accessFlags.isNative() || !method.isNonAbstractVirtualMethod() && !instanceInitializer) {
            return;
        }
        feedback.setClassInlinerEligibility(method, null);
        Value receiver = code.getThis();
        if (receiver.numberOfPhiUsers() > 0) {
            return;
        }
        boolean receiverUsedAsReturnValue = false;
        boolean seenSuperInitCall = false;
        for (Instruction insn : receiver.uniqueUsers()) {
            if (insn.isReturn()) {
                receiverUsedAsReturnValue = true;
                continue;
            }
            if (insn.isInstanceGet() || insn.isInstancePut() && insn.asInstancePut().object() == receiver) {
                DexField field = insn.asFieldInstruction().getField();
                if (field.clazz == method.method.holder) continue;
                return;
            }
            if (instanceInitializer && insn.isInvokeDirect()) {
                InvokeDirect invokedDirect = insn.asInvokeDirect();
                if (invokedDirect.getInvokedMethod() == this.dexItemFactory.objectMethods.constructor && invokedDirect.getReceiver() == receiver && !seenSuperInitCall) {
                    seenSuperInitCall = true;
                    continue;
                }
                return;
            }
            return;
        }
        if (instanceInitializer && !seenSuperInitCall) {
            return;
        }
        feedback.setClassInlinerEligibility(method, new DexEncodedMethod.ClassInlinerEligibility(receiverUsedAsReturnValue));
    }

    private static boolean checksNullReceiverBeforeSideEffect(IRCode code, Value receiver) {
        return CodeRewriter.alwaysTriggerExpectedEffectBeforeAnythingElse(code, instr -> {
            if (instr.throwsNpeIfValueIsNull(receiver)) {
                if (!instr.getBlock().hasCatchHandlers()) {
                    return InstructionEffect.DESIRED_EFFECT;
                }
            } else if (CodeRewriter.instructionHasSideEffects(instr)) {
                return InstructionEffect.OTHER_EFFECT;
            }
            return InstructionEffect.NO_EFFECT;
        });
    }

    private static boolean instructionHasSideEffects(Instruction instruction) {
        return instruction.instructionTypeCanThrow();
    }

    private static boolean triggersClassInitializationBeforeSideEffect(IRCode code, DexType klass) {
        return CodeRewriter.alwaysTriggerExpectedEffectBeforeAnythingElse(code, instruction -> {
            if (instruction.triggersInitializationOfClass(klass)) {
                if (!instruction.getBlock().hasCatchHandlers()) {
                    return InstructionEffect.DESIRED_EFFECT;
                }
            } else if (CodeRewriter.instructionHasSideEffects(instruction)) {
                return InstructionEffect.OTHER_EFFECT;
            }
            return InstructionEffect.NO_EFFECT;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean alwaysTriggerExpectedEffectBeforeAnythingElse(IRCode code, Function<Instruction, InstructionEffect> function) {
        int color = code.reserveMarkingColor();
        try {
            ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
            BasicBlock entry = code.blocks.getFirst();
            worklist.add(entry);
            entry.mark(color);
            while (!worklist.isEmpty()) {
                BasicBlock currentBlock = (BasicBlock)worklist.poll();
                assert (currentBlock.isMarked(color));
                InstructionEffect result = InstructionEffect.NO_EFFECT;
                InstructionListIterator it = currentBlock.listIterator();
                while (result == InstructionEffect.NO_EFFECT && it.hasNext()) {
                    result = function.apply((Instruction)it.next());
                }
                if (result == InstructionEffect.OTHER_EFFECT) {
                    boolean bl = false;
                    return bl;
                }
                if (result == InstructionEffect.DESIRED_EFFECT) continue;
                assert (result == InstructionEffect.NO_EFFECT);
                if (currentBlock.getNormalSuccessors().isEmpty()) {
                    Instruction lastInstruction = currentBlock.getInstructions().getLast();
                    assert (lastInstruction.isReturn() || lastInstruction.isThrow());
                    boolean bl = false;
                    return bl;
                }
                for (BasicBlock successor : currentBlock.getSuccessors()) {
                    if (successor.isMarked(color)) continue;
                    worklist.add(successor);
                    successor.mark(color);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            code.returnMarkingColor(color);
        }
    }

    private boolean checkArgumentType(InvokeMethod invoke, DexMethod target, int argumentIndex) {
        DexType returnType = invoke.getInvokedMethod().proto.returnType;
        if (invoke.isInvokeStatic()) {
            return invoke.getInvokedMethod().proto.parameters.values[argumentIndex] == returnType;
        }
        if (argumentIndex == 0) {
            return invoke.getInvokedMethod().getHolder() == returnType;
        }
        return invoke.getInvokedMethod().proto.parameters.values[argumentIndex - 1] == returnType;
    }

    public void rewriteMoveResult(IRCode code) {
        if (this.options.isGeneratingClassFiles()) {
            return;
        }
        Enqueuer.AppInfoWithLiveness appInfoWithLiveness = this.appInfo.withLiveness();
        InstructionIterator iterator = code.instructionIterator();
        while (iterator.hasNext()) {
            int argumentIndex;
            DexMethod invokedMethod;
            DexEncodedMethod definition;
            DexEncodedMethod target;
            InvokeMethod invoke;
            Instruction current = (Instruction)iterator.next();
            if (!current.isInvokeMethod() || (invoke = current.asInvokeMethod()).outValue() == null || invoke.outValue().hasLocalInfo()) continue;
            boolean isLibraryMethodReturningReceiver = this.libraryMethodsReturningReceiver.contains(invoke.getInvokedMethod());
            if (isLibraryMethodReturningReceiver) {
                if (!this.checkArgumentType(invoke, invoke.getInvokedMethod(), 0)) continue;
                invoke.outValue().replaceUsers(invoke.arguments().get(0));
                invoke.setOutValue(null);
                continue;
            }
            if (appInfoWithLiveness == null || (target = invoke.computeSingleTarget(appInfoWithLiveness)) == null || (definition = this.appInfo.definitionFor(invokedMethod = target.method)) == null || !definition.getOptimizationInfo().returnsArgument() || (argumentIndex = definition.getOptimizationInfo().getReturnedArgument()) == -1 || !this.checkArgumentType(invoke, target.method, argumentIndex)) continue;
            Value argument = invoke.arguments().get(argumentIndex);
            assert (invoke.outType().verifyCompatible(argument.outType()));
            invoke.outValue().replaceUsers(argument);
            invoke.setOutValue(null);
        }
        assert (code.isConsistentGraph());
    }

    public void disableAssertions(AppInfo appInfo, DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        if (method.isClassInitializer()) {
            if (!this.hasJavacClinitAssertionCode(code)) {
                return;
            }
            feedback.setInitializerEnablingJavaAssertions(method);
        } else {
            DexClass clazz = appInfo.definitionFor(method.method.holder);
            if (clazz == null) {
                return;
            }
            DexEncodedMethod clinit = clazz.getClassInitializer();
            if (clinit == null || !clinit.isProcessed() || !clinit.getOptimizationInfo().isInitializerEnablingJavaAssertions()) {
                return;
            }
        }
        InstructionIterator iterator = code.instructionIterator();
        while (iterator.hasNext()) {
            Instruction current = (Instruction)iterator.next();
            if (current.isInvokeMethod()) {
                InvokeMethod invoke = current.asInvokeMethod();
                if (invoke.getInvokedMethod() != this.dexItemFactory.classMethods.desiredAssertionStatus) continue;
                iterator.replaceCurrentInstruction(code.createFalse());
                continue;
            }
            if (current.isStaticPut()) {
                StaticPut staticPut = current.asStaticPut();
                if (staticPut.getField().name != this.dexItemFactory.assertionsDisabled) continue;
                iterator.remove();
                continue;
            }
            if (!current.isStaticGet()) continue;
            StaticGet staticGet = current.asStaticGet();
            if (staticGet.getField().name != this.dexItemFactory.assertionsDisabled) continue;
            iterator.replaceCurrentInstruction(code.createTrue());
        }
    }

    private boolean isClassDesiredAssertionStatusInvoke(Instruction instruction) {
        return instruction.isInvokeMethod() && instruction.asInvokeMethod().getInvokedMethod() == this.dexItemFactory.classMethods.desiredAssertionStatus;
    }

    private boolean isAssertionsDisabledFieldPut(Instruction instruction) {
        return instruction.isStaticPut() && instruction.asStaticPut().getField().name == this.dexItemFactory.assertionsDisabled;
    }

    private boolean isNotDebugInstruction(Instruction instruction) {
        return !instruction.isDebugInstruction();
    }

    private Value blockWithSingleConstNumberAndGoto(BasicBlock block) {
        InstructionIterator iterator = block.iterator();
        Instruction constNumber = iterator.nextUntil(this::isNotDebugInstruction);
        if (constNumber == null || !constNumber.isConstNumber()) {
            return null;
        }
        Instruction exit = iterator.nextUntil(this::isNotDebugInstruction);
        return exit != null && exit.isGoto() ? constNumber.outValue() : null;
    }

    private Value blockWithAssertionsDisabledFieldPut(BasicBlock block) {
        InstructionIterator iterator = block.iterator();
        Instruction fieldPut = iterator.nextUntil(this::isNotDebugInstruction);
        return fieldPut != null && this.isAssertionsDisabledFieldPut(fieldPut) ? fieldPut.inValues().get(0) : null;
    }

    private boolean hasJavacClinitAssertionCode(IRCode code) {
        BasicBlock falseTarget;
        InstructionIterator iterator = code.instructionIterator();
        Instruction current = iterator.nextUntil(this::isClassDesiredAssertionStatusInvoke);
        if (current == null) {
            return false;
        }
        Value DesiredAssertionStatus = current.outValue();
        assert (iterator.hasNext());
        current = (Instruction)iterator.next();
        if (!current.isIf() || !current.asIf().isZeroTest() || current.asIf().inValues().get(0) != DesiredAssertionStatus) {
            return false;
        }
        If theIf = current.asIf();
        BasicBlock trueTarget = theIf.getTrueTarget();
        if (trueTarget == (falseTarget = theIf.fallthroughBlock())) {
            return false;
        }
        Value trueValue = this.blockWithSingleConstNumberAndGoto(trueTarget);
        Value falseValue = this.blockWithSingleConstNumberAndGoto(falseTarget);
        if (trueValue == null || falseValue == null || trueTarget.exit().asGoto().getTarget() != falseTarget.exit().asGoto().getTarget()) {
            return false;
        }
        BasicBlock target = trueTarget.exit().asGoto().getTarget();
        Value storeValue = this.blockWithAssertionsDisabledFieldPut(target);
        return storeValue != null && storeValue.isPhi() && storeValue.asPhi().getOperands().size() == 2 && storeValue.asPhi().getOperands().contains(trueValue) && storeValue.asPhi().getOperands().contains(falseValue);
    }

    private boolean isClassNameConstant(DexEncodedMethod method, StaticPut put) {
        InvokeVirtual invoke;
        if (put.getField().type != this.dexItemFactory.stringType) {
            return false;
        }
        return put.inValue().definition != null && put.inValue().definition.isInvokeVirtual() && ((invoke = put.inValue().definition.asInvokeVirtual()).getInvokedMethod() == this.dexItemFactory.classMethods.getSimpleName || invoke.getInvokedMethod() == this.dexItemFactory.classMethods.getName) && !invoke.inValues().get(0).isPhi() && invoke.inValues().get((int)0).definition.isConstClass() && invoke.inValues().get((int)0).definition.asConstClass().getValue() == method.method.getHolder();
    }

    public void collectClassInitializerDefaults(DexEncodedMethod method, IRCode code) {
        if (!method.isClassInitializer()) {
            return;
        }
        if (code.computeNormalExitBlocks().isEmpty()) {
            return;
        }
        DexClass clazz = this.definitionFor(method.method.getHolder());
        assert (clazz != null);
        DominatorTree dominatorTree = new DominatorTree(code);
        Set<StaticPut> puts = Sets.newIdentityHashSet();
        IdentityHashMap<DexField, StaticPut> dominatingPuts = Maps.newIdentityHashMap();
        for (BasicBlock block : dominatorTree.normalExitDominatorBlocks()) {
            InstructionListIterator iterator = block.listIterator(block.getInstructions().size());
            while (iterator.hasPrevious()) {
                DexField field;
                StaticPut put2;
                DexField field2;
                Instruction current = (Instruction)iterator.previous();
                if (current.isStaticPut() && clazz.definesStaticField(field2 = (put2 = current.asStaticPut()).getField())) {
                    if (put2.inValue().isConstant()) {
                        if ((field2.type.isClassType() || field2.type.isArrayType()) && put2.inValue().isZero()) {
                            dominatingPuts.putIfAbsent(put2.getField(), put2);
                            puts.add(put2);
                        } else if (field2.type.isPrimitiveType() || field2.type == this.dexItemFactory.stringType) {
                            dominatingPuts.putIfAbsent(put2.getField(), put2);
                            puts.add(put2);
                        }
                    } else if (this.isClassNameConstant(method, put2)) {
                        dominatingPuts.putIfAbsent(put2.getField(), put2);
                        puts.add(put2);
                    }
                }
                if (!current.isStaticGet() || !dominatingPuts.containsKey(field = current.asStaticGet().getField())) continue;
                dominatingPuts.remove(field);
                Iterables.removeIf(puts, put -> put.getField() == field);
            }
        }
        if (!puts.isEmpty()) {
            InstructionListIterator iterator;
            for (StaticPut put3 : dominatingPuts.values()) {
                ConstInstruction cnst;
                DexField field = put3.getField();
                DexEncodedField encodedField = this.appInfo.definitionFor(field);
                if (field.type == this.dexItemFactory.stringType) {
                    if (put3.inValue().isConstant()) {
                        if (put3.inValue().isConstNumber()) {
                            assert (put3.inValue().isZero());
                            encodedField.setStaticValue(DexValue.DexValueNull.NULL);
                            continue;
                        }
                        cnst = put3.inValue().getConstInstruction().asConstString();
                        encodedField.setStaticValue(new DexValue.DexValueString(((ConstString)cnst).getValue()));
                        continue;
                    }
                    InvokeVirtual invoke = put3.inValue().definition.asInvokeVirtual();
                    String name = method.method.getHolder().toSourceString();
                    if (invoke.getInvokedMethod() == this.dexItemFactory.classMethods.getSimpleName) {
                        String simpleName = name.substring(name.lastIndexOf(46) + 1);
                        encodedField.setStaticValue(new DexValue.DexValueString(this.dexItemFactory.createString(simpleName)));
                        continue;
                    }
                    assert (invoke.getInvokedMethod() == this.dexItemFactory.classMethods.getName);
                    encodedField.setStaticValue(new DexValue.DexValueString(this.dexItemFactory.createString(name)));
                    continue;
                }
                if (field.type.isClassType() || field.type.isArrayType()) {
                    if (put3.inValue().isZero()) {
                        encodedField.setStaticValue(DexValue.DexValueNull.NULL);
                        continue;
                    }
                    throw new Unreachable("Unexpected default value for field type " + field.type + ".");
                }
                cnst = put3.inValue().getConstInstruction().asConstNumber();
                if (field.type == this.dexItemFactory.booleanType) {
                    encodedField.setStaticValue(DexValue.DexValueBoolean.create(((ConstNumber)cnst).getBooleanValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.byteType) {
                    encodedField.setStaticValue(DexValue.DexValueByte.create((byte)((ConstNumber)cnst).getIntValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.shortType) {
                    encodedField.setStaticValue(DexValue.DexValueShort.create((short)((ConstNumber)cnst).getIntValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.intType) {
                    encodedField.setStaticValue(DexValue.DexValueInt.create(((ConstNumber)cnst).getIntValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.longType) {
                    encodedField.setStaticValue(DexValue.DexValueLong.create(((ConstNumber)cnst).getLongValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.floatType) {
                    encodedField.setStaticValue(DexValue.DexValueFloat.create(((ConstNumber)cnst).getFloatValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.doubleType) {
                    encodedField.setStaticValue(DexValue.DexValueDouble.create(((ConstNumber)cnst).getDoubleValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.charType) {
                    encodedField.setStaticValue(DexValue.DexValueChar.create((char)((ConstNumber)cnst).getIntValue()));
                    continue;
                }
                throw new Unreachable("Unexpected field type " + field.type + ".");
            }
            ArrayList<Instruction> toRemove = new ArrayList<Instruction>();
            for (BasicBlock block : dominatorTree.normalExitDominatorBlocks()) {
                iterator = block.listIterator();
                while (iterator.hasNext()) {
                    Instruction current = (Instruction)iterator.next();
                    if (!current.isStaticPut() || !puts.contains(current.asStaticPut())) continue;
                    iterator.remove();
                    StaticPut put4 = current.asStaticPut();
                    if (put4.inValue().uniqueUsers().size() != 0) continue;
                    if (put4.inValue().isConstString()) {
                        toRemove.add(put4.inValue().definition);
                        continue;
                    }
                    if (!put4.inValue().definition.isInvokeVirtual()) continue;
                    toRemove.add(put4.inValue().definition);
                }
            }
            if (toRemove.size() > 0) {
                for (BasicBlock block : dominatorTree.normalExitDominatorBlocks()) {
                    iterator = block.listIterator();
                    while (iterator.hasNext()) {
                        if (!toRemove.contains(iterator.next())) continue;
                        iterator.remove();
                    }
                }
            }
        }
    }

    private DexClass definitionFor(DexType type) {
        if (this.cachedClass != null && this.cachedClass.type == type) {
            return this.cachedClass;
        }
        return this.appInfo.definitionFor(type);
    }

    public void enterCachedClass(DexProgramClass clazz) {
        assert (this.cachedClass == null);
        this.cachedClass = clazz;
    }

    public void leaveCachedClass(DexProgramClass clazz) {
        assert (this.cachedClass == clazz);
        this.cachedClass = null;
    }

    public void removeCasts(IRCode code, TypeEnvironment typeEnvironment) {
        InstructionIterator it = code.instructionIterator();
        boolean needToRemoveTrivialPhis = false;
        while (it.hasNext()) {
            Instruction current = (Instruction)it.next();
            if (!current.isCheckCast()) continue;
            CheckCast checkCast = current.asCheckCast();
            Value inValue = checkCast.object();
            Value outValue = checkCast.outValue();
            DexType castType = checkCast.getType();
            Predicate<Instruction> isCheckcastToSubtype = user -> user.isCheckCast() && user.asCheckCast().getType().isSubtypeOf(castType, this.appInfo);
            if (!checkCast.getBlock().hasCatchHandlers() && outValue.isUsed() && outValue.numberOfPhiUsers() == 0 && outValue.uniqueUsers().stream().allMatch(isCheckcastToSubtype)) {
                this.removeOrReplaceByDebugLocalWrite(it, inValue, outValue);
                continue;
            }
            TypeLatticeElement inTypeLattice = typeEnvironment.getLatticeElement(inValue);
            if (inTypeLattice.isTop()) continue;
            TypeLatticeElement outTypeLattice = typeEnvironment.getLatticeElement(outValue);
            TypeLatticeElement castTypeLattice = TypeLatticeElement.fromDexType(castType, inTypeLattice.isNullable());
            if (inTypeLattice.mustBeNull()) {
                assert (outTypeLattice.equals(castTypeLattice));
                continue;
            }
            if (TypeLatticeElement.lessThanOrEqual(this.appInfo, inTypeLattice, castTypeLattice)) {
                assert (outTypeLattice.equals(inTypeLattice));
                needToRemoveTrivialPhis = needToRemoveTrivialPhis || outValue.numberOfPhiUsers() != 0;
                this.removeOrReplaceByDebugLocalWrite(it, inValue, outValue);
                continue;
            }
            assert (outTypeLattice.equals(castTypeLattice));
        }
        if (needToRemoveTrivialPhis) {
            code.removeAllTrivialPhis();
        }
        it = code.instructionIterator();
        assert (code.isConsistentSSA());
    }

    private void removeOrReplaceByDebugLocalWrite(InstructionIterator it, Value inValue, Value outValue) {
        if (outValue.getLocalInfo() != inValue.getLocalInfo() && outValue.hasLocalInfo()) {
            DebugLocalWrite debugLocalWrite = new DebugLocalWrite(outValue, inValue);
            it.replaceCurrentInstruction(debugLocalWrite);
        } else {
            outValue.replaceUsers(inValue);
            it.removeOrReplaceByDebugLocalRead();
        }
    }

    private boolean canBeFolded(Instruction instruction) {
        return instruction.isBinop() && instruction.asBinop().canBeFolded() || instruction.isUnop() && instruction.asUnop().canBeFolded();
    }

    public void splitRangeInvokeConstants(IRCode code) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction current = (Instruction)it.next();
                if (!current.isInvoke() || current.asInvoke().requiredArgumentRegisters() <= 5) continue;
                Invoke invoke = current.asInvoke();
                it.previous();
                IdentityHashMap<ConstNumber, ConstNumber> oldToNew = new IdentityHashMap<ConstNumber, ConstNumber>();
                for (int i = 0; i < invoke.inValues().size(); ++i) {
                    Value value = invoke.inValues().get(i);
                    if (!value.isConstNumber() || value.numberOfUsers() <= 1) continue;
                    ConstNumber definition = value.getConstInstruction().asConstNumber();
                    Value originalValue = definition.outValue();
                    ConstNumber newNumber = (ConstNumber)oldToNew.get(definition);
                    if (newNumber == null) {
                        newNumber = ConstNumber.copyOf(code, definition);
                        it.add(newNumber);
                        newNumber.setPosition(current.getPosition());
                        oldToNew.put(definition, newNumber);
                    }
                    invoke.inValues().set(i, newNumber.outValue());
                    originalValue.removeUser(invoke);
                    newNumber.outValue().addUser(invoke);
                }
                it.next();
            }
        }
    }

    public void useDedicatedConstantForLitInstruction(IRCode code) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator instructionIterator = block.listIterator();
            while (instructionIterator.hasNext()) {
                Value constValue;
                Instruction currentInstruction = (Instruction)instructionIterator.next();
                if (!CodeRewriter.shouldBeLitInstruction(currentInstruction)) continue;
                assert (currentInstruction.isBinop());
                Binop binop = currentInstruction.asBinop();
                if (binop.leftValue().isConstNumber()) {
                    constValue = binop.leftValue();
                } else if (binop.rightValue().isConstNumber()) {
                    constValue = binop.rightValue();
                } else {
                    throw new Unreachable();
                }
                if (constValue.numberOfAllUsers() <= 1) continue;
                ConstNumber newConstant = ConstNumber.copyOf(code, constValue.definition.asConstNumber());
                newConstant.setPosition(currentInstruction.getPosition());
                newConstant.setBlock(currentInstruction.getBlock());
                currentInstruction.replaceValue(constValue, newConstant.outValue());
                constValue.removeUser(currentInstruction);
                instructionIterator.previous();
                instructionIterator.add(newConstant);
                instructionIterator.next();
            }
        }
        assert (code.isConsistentSSA());
    }

    private static boolean shouldBeLitInstruction(Instruction instruction) {
        Binop binop;
        if (!(!instruction.isArithmeticBinop() && !instruction.isLogicalBinop() || (binop = instruction.asBinop()).needsValueInRegister(binop.leftValue()) && binop.needsValueInRegister(binop.rightValue()))) {
            return !CodeRewriter.canBe2AddrInstruction(binop);
        }
        return false;
    }

    private static boolean canBe2AddrInstruction(Binop binop) {
        Value value = null;
        if (binop.needsValueInRegister(binop.leftValue())) {
            value = binop.leftValue();
        } else if (binop.isCommutative() && binop.needsValueInRegister(binop.rightValue())) {
            value = binop.rightValue();
        }
        if (value != null) {
            Set<Instruction> users = value.debugUsers() != null ? Iterables.concat(value.uniqueUsers(), value.debugUsers()) : value.uniqueUsers();
            for (Instruction user : users) {
                if (!CodeRewriter.hasPath(binop, user)) continue;
                return false;
            }
            Set<Phi> phiUsers = value.debugPhiUsers() != null ? Iterables.concat(value.uniquePhiUsers(), value.debugPhiUsers()) : value.uniquePhiUsers();
            for (Phi user : phiUsers) {
                if (!binop.getBlock().hasPathTo(user.getBlock())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean hasPath(Instruction source, Instruction target) {
        BasicBlock targetBlock;
        BasicBlock sourceBlock = source.getBlock();
        if (sourceBlock == (targetBlock = target.getBlock())) {
            return sourceBlock.getInstructions().indexOf(source) < targetBlock.getInstructions().indexOf(target);
        }
        return source.getBlock().hasPathTo(targetBlock);
    }

    public void shortenLiveRanges(IRCode code) {
        Supplier<DominatorTree> dominatorTreeMemoization = Suppliers.memoize(() -> new DominatorTree(code));
        HashMap<BasicBlock, List<Instruction>> addConstantInBlock = new HashMap<BasicBlock, List<Instruction>>();
        LinkedList<BasicBlock> blocks = code.blocks;
        for (int i = 0; i < blocks.size(); ++i) {
            BasicBlock block = blocks.get(i);
            if (i == 0) {
                this.shortenLiveRangesInsideBlock(block, dominatorTreeMemoization, addConstantInBlock, insn -> insn.isConstNumber() && insn.outValue().numberOfAllUsers() != 0 || insn.isConstString() && insn.outValue().numberOfAllUsers() == 1);
                continue;
            }
            this.shortenLiveRangesInsideBlock(block, dominatorTreeMemoization, addConstantInBlock, insn -> insn.isConstString() && insn.outValue().numberOfAllUsers() == 1);
        }
        for (BasicBlock block : blocks) {
            List instructions = (List)addConstantInBlock.get(block);
            if (instructions == null) continue;
            if (block != blocks.get(0) && instructions.size() > 50) {
                for (Instruction instruction : instructions) {
                    if (instruction.outValue().numberOfPhiUsers() != 0 || instruction.isConstString()) {
                        this.insertConstantInBlock(instruction, block);
                        continue;
                    }
                    assert (instruction.isConstNumber());
                    ConstNumber constNumber = instruction.asConstNumber();
                    Value constantValue = instruction.outValue();
                    assert (constantValue.numberOfUsers() != 0);
                    assert (constantValue.numberOfUsers() == constantValue.numberOfAllUsers());
                    for (Instruction user : constantValue.uniqueUsers()) {
                        ConstNumber newCstNum = ConstNumber.copyOf(code, constNumber);
                        newCstNum.setPosition(user.getPosition());
                        InstructionListIterator iterator = user.getBlock().listIterator(user);
                        iterator.previous();
                        iterator.add(newCstNum);
                        user.replaceValue(constantValue, newCstNum.outValue());
                    }
                    constantValue.clearUsers();
                }
                continue;
            }
            for (Instruction instruction : instructions) {
                this.insertConstantInBlock(instruction, block);
            }
        }
        assert (code.isConsistentSSA());
    }

    private void shortenLiveRangesInsideBlock(BasicBlock block, Supplier<DominatorTree> dominatorTreeMemoization, Map<BasicBlock, List<Instruction>> addConstantInBlock, Predicate<Instruction> selector) {
        InstructionListIterator it = block.listIterator();
        while (it.hasNext()) {
            Instruction instruction = (Instruction)it.next();
            if (!selector.test(instruction) || instruction.outValue().hasLocalInfo()) continue;
            LinkedList<BasicBlock> userBlocks = new LinkedList<BasicBlock>();
            for (Instruction user : instruction.outValue().uniqueUsers()) {
                userBlocks.add(user.getBlock());
            }
            for (Phi phi : instruction.outValue().uniquePhiUsers()) {
                userBlocks.add(phi.getBlock());
            }
            DominatorTree dominatorTree = dominatorTreeMemoization.get();
            BasicBlock dominator = dominatorTree.closestDominator(userBlocks);
            for (Phi phi : instruction.outValue().uniquePhiUsers()) {
                if (phi.getBlock() != dominator) continue;
                if (instruction.outValue().numberOfAllUsers() == 1 && phi.usesValueOneTime(instruction.outValue())) {
                    int predIndex = phi.getOperands().indexOf(instruction.outValue());
                    dominator = dominator.getPredecessors().get(predIndex);
                    break;
                }
                dominator = dominatorTree.immediateDominator(dominator);
                break;
            }
            if (instruction.instructionTypeCanThrow() && (block.hasCatchHandlers() || dominator.hasCatchHandlers() || !dominator.isSimpleAlwaysThrowingPath())) continue;
            it.detach();
            List csts = addConstantInBlock.computeIfAbsent(dominator, k -> new ArrayList());
            csts.add(instruction);
        }
    }

    private void insertConstantInBlock(Instruction instruction, BasicBlock block) {
        boolean hasCatchHandlers = block.hasCatchHandlers();
        InstructionListIterator insertAt = block.listIterator();
        insertAt.nextUntil(i -> i.inValues().contains(instruction.outValue()) || i.isJumpInstruction() || hasCatchHandlers && i.instructionTypeCanThrow());
        Instruction next = (Instruction)insertAt.previous();
        instruction.forceSetPosition(next.isGoto() ? next.asGoto().getTarget().getPosition() : next.getPosition());
        insertAt.add(instruction);
    }

    private short[] computeArrayFilledData(ConstInstruction[] values, int size, int elementSize) {
        if (values == null) {
            return null;
        }
        if (elementSize == 1) {
            short[] result = new short[(size + 1) / 2];
            for (int i = 0; i < size; i += 2) {
                short value = (short)(values[i].asConstNumber().getIntValue() & 0xFF);
                if (i + 1 < size) {
                    value = (short)(value | (short)((values[i + 1].asConstNumber().getIntValue() & 0xFF) << 8));
                }
                result[i / 2] = value;
            }
            return result;
        }
        assert (elementSize == 2 || elementSize == 4 || elementSize == 8);
        int shortsPerConstant = elementSize / 2;
        short[] result = new short[size * shortsPerConstant];
        for (int i = 0; i < size; ++i) {
            long value = values[i].asConstNumber().getRawValue();
            for (int part = 0; part < shortsPerConstant; ++part) {
                result[i * shortsPerConstant + part] = (short)(value >> 16 * part & 0xFFFFL);
            }
        }
        return result;
    }

    private ConstInstruction[] computeConstantArrayValues(NewArrayEmpty newArray, BasicBlock block, int size) {
        BasicBlock nextBlock;
        if (size > 8192) {
            return null;
        }
        ConstInstruction[] values = new ConstInstruction[size];
        int remaining = size;
        Set<Instruction> users = newArray.outValue().uniqueUsers();
        Set<BasicBlock> visitedBlocks = Sets.newIdentityHashSet();
        InstructionListIterator it = block.listIterator();
        it.nextUntil(i -> i == newArray);
        do {
            visitedBlocks.add(block);
            while (it.hasNext()) {
                ConstInstruction value;
                Instruction instruction = (Instruction)it.next();
                if (block.hasCatchHandlers() && instruction.instructionInstanceCanThrow()) {
                    return null;
                }
                if (!users.contains(instruction)) continue;
                if (!instruction.isArrayPut()) {
                    return null;
                }
                ArrayPut arrayPut = instruction.asArrayPut();
                if (!arrayPut.value().isConstant() || !arrayPut.index().isConstNumber()) {
                    return null;
                }
                int index = arrayPut.index().getConstInstruction().asConstNumber().getIntValue();
                if (index < 0 || index >= values.length) {
                    return null;
                }
                if (values[index] != null) {
                    return null;
                }
                values[index] = value = arrayPut.value().getConstInstruction();
                if (--remaining != 0) continue;
                return values;
            }
        } while ((it = (block = (nextBlock = block.exit().isGoto() ? block.exit().asGoto().getTarget() : null) != null && !visitedBlocks.contains(nextBlock) ? nextBlock : null) != null ? block.listIterator() : null) != null);
        return null;
    }

    private boolean allowNewFilledArrayConstruction(Instruction instruction) {
        if (!(instruction instanceof NewArrayEmpty)) {
            return false;
        }
        NewArrayEmpty newArray = instruction.asNewArrayEmpty();
        if (!newArray.size().isConstant()) {
            return false;
        }
        assert (newArray.size().isConstNumber());
        int size = newArray.size().getConstInstruction().asConstNumber().getIntValue();
        if (size < 1) {
            return false;
        }
        if (newArray.type.isPrimitiveArrayType()) {
            return true;
        }
        return newArray.type == this.dexItemFactory.stringArrayType && this.options.canUseFilledNewArrayOfObjects();
    }

    public void simplifyArrayConstruction(IRCode code) {
        if (this.options.isGeneratingClassFiles()) {
            return;
        }
        for (BasicBlock block : code.blocks) {
            BasicBlock nextBlock;
            HashMap<Value, InvokeNewArray> instructionToInsertForArray = new HashMap<Value, InvokeNewArray>();
            HashMap<Value, Integer> storesToRemoveForArray = new HashMap<Value, Integer>();
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                int size;
                NewArrayEmpty newArray;
                ConstInstruction[] values;
                Instruction instruction = (Instruction)it.next();
                if (instruction.getLocalInfo() != null || !this.allowNewFilledArrayConstruction(instruction) || (values = this.computeConstantArrayValues(newArray = instruction.asNewArrayEmpty(), block, size = newArray.size().getConstInstruction().asConstNumber().getIntValue())) == null) continue;
                if (newArray.type == this.dexItemFactory.stringArrayType) {
                    if (size > 200) continue;
                    ArrayList<Value> stringValues = new ArrayList<Value>(size);
                    for (ConstInstruction value : values) {
                        stringValues.add(value.outValue());
                    }
                    InvokeNewArray invoke = new InvokeNewArray(this.dexItemFactory.stringArrayType, newArray.outValue(), stringValues);
                    invoke.setPosition(newArray.getPosition());
                    it.detach();
                    for (Value value : newArray.inValues()) {
                        value.removeUser(newArray);
                    }
                    instructionToInsertForArray.put(newArray.outValue(), invoke);
                } else {
                    int elementSize;
                    short[] contents;
                    if (size == 1 || (contents = this.computeArrayFilledData(values, size, elementSize = newArray.type.elementSizeForPrimitiveArrayType())) == null) continue;
                    int arraySize = newArray.size().getConstInstruction().asConstNumber().getIntValue();
                    NewArrayFilledData fillArray = new NewArrayFilledData(newArray.outValue(), elementSize, arraySize, contents);
                    fillArray.setPosition(newArray.getPosition());
                    it.add(fillArray);
                }
                storesToRemoveForArray.put(newArray.outValue(), size);
            }
            if (storesToRemoveForArray.isEmpty()) continue;
            Set<BasicBlock> visitedBlocks = Sets.newIdentityHashSet();
            do {
                visitedBlocks.add(block);
                it = block.listIterator();
                while (it.hasNext()) {
                    Value array;
                    Integer toRemoveCount;
                    Instruction instruction = (Instruction)it.next();
                    if (!instruction.isArrayPut() || (toRemoveCount = (Integer)storesToRemoveForArray.get(array = instruction.asArrayPut().array())) == null) continue;
                    if (toRemoveCount > 0) {
                        toRemoveCount = toRemoveCount - 1;
                        storesToRemoveForArray.put(array, toRemoveCount);
                        it.remove();
                    }
                    if (toRemoveCount != 0) continue;
                    toRemoveCount = toRemoveCount - 1;
                    storesToRemoveForArray.put(array, toRemoveCount);
                    Instruction construction = (Instruction)instructionToInsertForArray.get(array);
                    if (construction == null) continue;
                    it.add(construction);
                }
            } while ((block = (nextBlock = block.exit().isGoto() ? block.exit().asGoto().getTarget() : null) != null && !visitedBlocks.contains(nextBlock) ? nextBlock : null) != null);
        }
    }

    private static boolean hasLocalOrLineChangeBetween(Instruction from, Instruction to, DexString localVar) {
        if (from.getBlock() != to.getBlock()) {
            return true;
        }
        if (from.getPosition().isSome() && to.getPosition().isSome() && !from.getPosition().equals(to.getPosition())) {
            return true;
        }
        InstructionListIterator iterator = from.getBlock().listIterator(from);
        Position position = null;
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            if (position == null) {
                if (instruction.getPosition().isSome()) {
                    position = instruction.getPosition();
                }
            } else if (instruction.getPosition().isSome() && !position.equals(instruction.getPosition())) {
                return true;
            }
            if (instruction == to) {
                return false;
            }
            if (instruction.outValue() == null || !instruction.outValue().hasLocalInfo() || instruction.outValue().getLocalInfo().name != localVar) continue;
            return true;
        }
        throw new Unreachable();
    }

    public void simplifyDebugLocals(IRCode code) {
        for (BasicBlock block : code.blocks) {
            Instruction instruction;
            for (Phi phi : block.getPhis()) {
                if (phi.hasLocalInfo() || phi.numberOfUsers() != 1 || phi.numberOfAllUsers() != 1 || !(instruction = phi.uniqueUsers().iterator().next()).isDebugLocalWrite()) continue;
                this.removeDebugWriteOfPhi(phi, instruction.asDebugLocalWrite());
            }
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext()) {
                Instruction prevInstruction = iterator.peekPrevious();
                instruction = (Instruction)iterator.next();
                if (!instruction.isDebugLocalWrite()) continue;
                assert (instruction.inValues().size() == 1);
                Value inValue = instruction.inValues().get(0);
                DebugLocalInfo localInfo = instruction.outValue().getLocalInfo();
                DexString localName = localInfo.name;
                if (inValue.hasLocalInfo() || inValue.numberOfAllUsers() != 1 || inValue.definition == null || CodeRewriter.hasLocalOrLineChangeBetween(inValue.definition, instruction, localName)) continue;
                inValue.setLocalInfo(localInfo);
                instruction.outValue().replaceUsers(inValue);
                Value overwrittenLocal = instruction.removeDebugValue(localInfo);
                if (overwrittenLocal != null) {
                    inValue.definition.addDebugValue(overwrittenLocal);
                }
                if (prevInstruction != null) {
                    instruction.moveDebugValues(prevInstruction);
                }
                iterator.removeOrReplaceByDebugLocalRead();
            }
        }
    }

    private void removeDebugWriteOfPhi(Phi phi, DebugLocalWrite write) {
        assert (write.src() == phi);
        InstructionListIterator iterator = phi.getBlock().listIterator();
        while (iterator.hasNext()) {
            Instruction next = (Instruction)iterator.next();
            if (!next.isDebugLocalWrite()) {
                return;
            }
            if (next == write) {
                phi.setLocalInfo(write.getLocalInfo());
                write.outValue().replaceUsers(phi);
                iterator.removeOrReplaceByDebugLocalRead();
                return;
            }
            assert (next.getLocalInfo().name != write.getLocalInfo().name);
        }
    }

    private boolean shareCatchHandlers(Instruction i0, Instruction i1) {
        if (!i0.instructionTypeCanThrow()) {
            assert (!i1.instructionTypeCanThrow());
            return true;
        }
        assert (i1.instructionTypeCanThrow());
        CatchHandlers<BasicBlock> ch0 = i0.getBlock().getCatchHandlers();
        CatchHandlers<BasicBlock> ch1 = i1.getBlock().getCatchHandlers();
        return ch0.equals(ch1);
    }

    private boolean isCSEInstructionCandidate(Instruction instruction) {
        return (instruction.isBinop() || instruction.isUnop() || instruction.isInstanceOf() || instruction.isCheckCast()) && instruction.getLocalInfo() == null && !instruction.hasInValueWithLocalInfo();
    }

    private boolean hasCSECandidate(IRCode code, int noCandidate) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext()) {
                if (!this.isCSEInstructionCandidate((Instruction)iterator.next())) continue;
                return true;
            }
            block.mark(noCandidate);
        }
        return false;
    }

    public void commonSubexpressionElimination(IRCode code) {
        int noCandidate = code.reserveMarkingColor();
        if (this.hasCSECandidate(code, noCandidate)) {
            ArrayListMultimap<Equivalence.Wrapper<Instruction>, Value> instructionToValue = ArrayListMultimap.create();
            CSEExpressionEquivalence equivalence = new CSEExpressionEquivalence(code);
            DominatorTree dominatorTree = new DominatorTree(code);
            for (int i = 0; i < dominatorTree.getSortedBlocks().length; ++i) {
                BasicBlock block = dominatorTree.getSortedBlocks()[i];
                if (block.isMarked(noCandidate)) continue;
                InstructionListIterator iterator = block.listIterator();
                while (iterator.hasNext()) {
                    Instruction instruction = (Instruction)iterator.next();
                    if (!this.isCSEInstructionCandidate(instruction)) continue;
                    Collection candidates = instructionToValue.get((Object)equivalence.wrap(instruction));
                    boolean eliminated = false;
                    if (candidates.size() > 0) {
                        for (Value candidate : candidates) {
                            if (!dominatorTree.dominatedBy(block, candidate.definition.getBlock()) || !this.shareCatchHandlers(instruction, candidate.definition)) continue;
                            instruction.outValue().replaceUsers(candidate);
                            eliminated = true;
                            iterator.removeOrReplaceByDebugLocalRead();
                            break;
                        }
                    }
                    if (eliminated) continue;
                    instructionToValue.put(equivalence.wrap(instruction), instruction.outValue());
                }
            }
        }
        code.returnMarkingColor(noCandidate);
        assert (code.isConsistentSSA());
    }

    public void simplifyIf(IRCode code, TypeEnvironment typeEnvironment) {
        for (BasicBlock block : code.blocks) {
            if (block.getNumber() != 0 && block.getPredecessors().isEmpty() || !block.exit().isIf()) continue;
            this.flipIfBranchesIfNeeded(block);
            this.rewriteIfWithConstZero(block);
            if (this.simplifyKnownBooleanCondition(code, block)) continue;
            If theIf = block.exit().asIf();
            List<Value> inValues = theIf.inValues();
            if (inValues.get(0).isConstNumber() && (theIf.isZeroTest() || inValues.get(1).isConstNumber())) {
                if (theIf.isZeroTest()) {
                    ConstNumber cond = inValues.get(0).getConstInstruction().asConstNumber();
                    BasicBlock target = theIf.targetFromCondition(cond);
                    this.simplifyIfWithKnownCondition(code, block, theIf, target);
                    continue;
                }
                ConstNumber left = inValues.get(0).getConstInstruction().asConstNumber();
                ConstNumber right = inValues.get(1).getConstInstruction().asConstNumber();
                BasicBlock target = theIf.targetFromCondition(left, right);
                this.simplifyIfWithKnownCondition(code, block, theIf, target);
                continue;
            }
            if (inValues.get(0).hasValueRange() && (theIf.isZeroTest() || inValues.get(1).hasValueRange())) {
                LongInterval rightRange;
                if (theIf.isZeroTest()) {
                    if (inValues.get(0).isValueInRange(0)) continue;
                    int cond = Long.signum(inValues.get(0).getValueRange().getMin());
                    this.simplifyIfWithKnownCondition(code, block, theIf, cond);
                    continue;
                }
                LongInterval leftRange = inValues.get(0).getValueRange();
                if (leftRange.overlapsWith(rightRange = inValues.get(1).getValueRange())) continue;
                int cond = Long.signum(leftRange.getMin() - rightRange.getMin());
                this.simplifyIfWithKnownCondition(code, block, theIf, cond);
                continue;
            }
            if (!theIf.isZeroTest() || inValues.get(0).isConstNumber() || theIf.getType() != If.Type.EQ && theIf.getType() != If.Type.NE) continue;
            if (inValues.get(0).isNeverNull()) {
                this.simplifyIfWithKnownCondition(code, block, theIf, 1);
                continue;
            }
            TypeLatticeElement l = typeEnvironment.getLatticeElement(inValues.get(0));
            if (l.isPrimitive() || l.isNullable()) continue;
            this.simplifyIfWithKnownCondition(code, block, theIf, 1);
        }
        code.removeUnreachableBlocks();
        assert (code.isConsistentSSA());
    }

    private void simplifyIfWithKnownCondition(IRCode code, BasicBlock block, If theIf, BasicBlock target) {
        BasicBlock deadTarget = target == theIf.getTrueTarget() ? theIf.fallthroughBlock() : theIf.getTrueTarget();
        this.rewriteIfToGoto(code, block, theIf, target, deadTarget);
    }

    private void simplifyIfWithKnownCondition(IRCode code, BasicBlock block, If theIf, int cond) {
        this.simplifyIfWithKnownCondition(code, block, theIf, theIf.targetFromCondition(cond));
    }

    public void processMethodsNeverReturningNormally(IRCode code) {
        Enqueuer.AppInfoWithLiveness appInfoWithLiveness = this.appInfo.withLiveness();
        if (appInfoWithLiveness == null) {
            return;
        }
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (block.getNumber() != 0 && block.getPredecessors().isEmpty()) continue;
            InstructionListIterator insnIterator = block.listIterator();
            while (insnIterator.hasNext()) {
                DexEncodedMethod singleTarget;
                Instruction insn = (Instruction)insnIterator.next();
                if (!insn.isInvokeMethod() || (singleTarget = insn.asInvokeMethod().computeSingleTarget(appInfoWithLiveness)) == null || !singleTarget.getOptimizationInfo().neverReturnsNormally()) continue;
                BasicBlock newBlock = insnIterator.split(code, blockIterator);
                assert (!insnIterator.hasNext());
                blockIterator.previous();
                newBlock.unlinkSinglePredecessorSiblingsAllowed();
                Instruction gotoInsn = (Instruction)insnIterator.previous();
                assert (gotoInsn.isGoto());
                assert (insnIterator.hasNext());
                BasicBlock throwNullBlock = insnIterator.split(code, blockIterator);
                InstructionListIterator throwNullInsnIterator = throwNullBlock.listIterator();
                Value nullValue = code.createValue(ValueType.OBJECT, gotoInsn.getLocalInfo());
                ConstNumber nullConstant = new ConstNumber(nullValue, 0L);
                nullConstant.setPosition(insn.getPosition());
                throwNullInsnIterator.add(nullConstant);
                Throw notReachableThrow = new Throw(nullValue);
                Instruction insnGoto = (Instruction)throwNullInsnIterator.next();
                assert (insnGoto.isGoto());
                throwNullInsnIterator.replaceCurrentInstruction(notReachableThrow);
                notReachableThrow.forceSetPosition(insn.getPosition());
            }
        }
        code.removeUnreachableBlocks();
        assert (code.isConsistentSSA());
    }

    private boolean simplifyKnownBooleanCondition(IRCode code, BasicBlock block) {
        If theIf = block.exit().asIf();
        Value testValue = theIf.inValues().get(0);
        if (theIf.isZeroTest() && testValue.knownToBeBoolean()) {
            BasicBlock targetBlock;
            BasicBlock trueBlock = theIf.getTrueTarget();
            BasicBlock falseBlock = theIf.fallthroughBlock();
            if (this.isBlockSupportedBySimplifyKnownBooleanCondition(trueBlock) && this.isBlockSupportedBySimplifyKnownBooleanCondition(falseBlock) && trueBlock.getSuccessors().get(0) == falseBlock.getSuccessors().get(0) && (targetBlock = trueBlock.getSuccessors().get(0)).getPredecessors().size() == 2) {
                int trueIndex = targetBlock.getPredecessors().indexOf(trueBlock);
                int falseIndex = trueIndex == 0 ? 1 : 0;
                int deadPhis = 0;
                for (Phi phi : targetBlock.getPhis()) {
                    Value trueValue = phi.getOperand(trueIndex);
                    Value falseValue = phi.getOperand(falseIndex);
                    if (!trueValue.isConstNumber() || !falseValue.isConstNumber()) continue;
                    ConstNumber trueNumber = trueValue.getConstInstruction().asConstNumber();
                    ConstNumber falseNumber = falseValue.getConstInstruction().asConstNumber();
                    if (theIf.getType() == If.Type.EQ && trueNumber.isIntegerZero() && falseNumber.isIntegerOne() || theIf.getType() == If.Type.NE && trueNumber.isIntegerOne() && falseNumber.isIntegerZero()) {
                        phi.replaceUsers(testValue);
                        ++deadPhis;
                        continue;
                    }
                    if ((theIf.getType() != If.Type.NE || !trueNumber.isIntegerZero() || !falseNumber.isIntegerOne()) && (theIf.getType() != If.Type.EQ || !trueNumber.isIntegerOne() || !falseNumber.isIntegerZero())) continue;
                    Value newOutValue = code.createValue(phi.outType(), phi.getLocalInfo());
                    ConstNumber cstToUse = trueNumber.isIntegerOne() ? trueNumber : falseNumber;
                    BasicBlock phiBlock = phi.getBlock();
                    Position phiPosition = phiBlock.getPosition();
                    int insertIndex = 0;
                    if (cstToUse.getBlock() == trueBlock || cstToUse.getBlock() == falseBlock) {
                        cstToUse = ConstNumber.copyOf(code, cstToUse);
                        cstToUse.setBlock(phiBlock);
                        cstToUse.setPosition(phiPosition);
                        phiBlock.getInstructions().add(insertIndex++, cstToUse);
                    }
                    phi.replaceUsers(newOutValue);
                    Xor newInstruction = new Xor(NumericType.INT, newOutValue, testValue, cstToUse.outValue());
                    newInstruction.setBlock(phiBlock);
                    newInstruction.setPosition(phiPosition);
                    phiBlock.getInstructions().add(insertIndex, newInstruction);
                    ++deadPhis;
                }
                if (deadPhis == targetBlock.getPhis().size()) {
                    this.rewriteIfToGoto(code, block, theIf, trueBlock, falseBlock);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isBlockSupportedBySimplifyKnownBooleanCondition(BasicBlock b) {
        Instruction constInstruction;
        if (b.isTrivialGoto()) {
            return true;
        }
        int instructionSize = b.getInstructions().size();
        if (b.exit().isGoto() && (instructionSize == 2 || instructionSize == 3) && (constInstruction = b.getInstructions().get(instructionSize - 2)).isConstNumber()) {
            if (!constInstruction.asConstNumber().isIntegerOne() && !constInstruction.asConstNumber().isIntegerZero()) {
                return false;
            }
            if (instructionSize == 2) {
                return true;
            }
            Instruction firstInstruction = b.getInstructions().getFirst();
            if (firstInstruction.isDebugPosition()) {
                assert (b.getPredecessors().size() == 1);
                BasicBlock predecessorBlock = b.getPredecessors().get(0);
                InstructionListIterator it = predecessorBlock.listIterator(predecessorBlock.exit());
                Instruction previousPosition = null;
                while (it.hasPrevious() && !(previousPosition = (Instruction)it.previous()).isDebugPosition()) {
                }
                if (previousPosition != null) {
                    return previousPosition.getPosition() == firstInstruction.getPosition();
                }
            }
        }
        return false;
    }

    private void rewriteIfToGoto(IRCode code, BasicBlock block, If theIf, BasicBlock target, BasicBlock deadTarget) {
        deadTarget.unlinkSinglePredecessorSiblingsAllowed();
        assert (theIf == block.exit());
        block.replaceLastInstruction(new Goto());
        assert (block.exit().isGoto());
        assert (block.exit().asGoto().getTarget() == target);
    }

    private void rewriteIfWithConstZero(BasicBlock block) {
        If theIf = block.exit().asIf();
        if (theIf.isZeroTest()) {
            return;
        }
        List<Value> inValues = theIf.inValues();
        Value leftValue = inValues.get(0);
        Value rightValue = inValues.get(1);
        if (leftValue.isConstNumber() || rightValue.isConstNumber()) {
            if (leftValue.isConstNumber()) {
                if (leftValue.getConstInstruction().asConstNumber().isZero()) {
                    If ifz = new If(theIf.getType().forSwappedOperands(), rightValue);
                    block.replaceLastInstruction(ifz);
                    assert (block.exit() == ifz);
                }
            } else if (rightValue.getConstInstruction().asConstNumber().isZero()) {
                If ifz = new If(theIf.getType(), leftValue);
                block.replaceLastInstruction(ifz);
                assert (block.exit() == ifz);
            }
        }
    }

    private boolean flipIfBranchesIfNeeded(BasicBlock block) {
        If theIf = block.exit().asIf();
        BasicBlock trueTarget = theIf.getTrueTarget();
        BasicBlock fallthrough = theIf.fallthroughBlock();
        assert (trueTarget != fallthrough);
        if (!fallthrough.isSimpleAlwaysThrowingPath() || trueTarget.isSimpleAlwaysThrowingPath()) {
            return false;
        }
        List<Value> inValues = theIf.inValues();
        If newIf = new If(theIf.getType().inverted(), inValues);
        block.replaceLastInstruction(newIf);
        block.swapSuccessors(trueTarget, fallthrough);
        return true;
    }

    public void rewriteLongCompareAndRequireNonNull(IRCode code, InternalOptions options) {
        if (options.canUseLongCompareAndObjectsNonNull()) {
            return;
        }
        InstructionIterator iterator = code.instructionIterator();
        while (iterator.hasNext()) {
            Instruction current = (Instruction)iterator.next();
            if (!current.isInvokeMethod()) continue;
            DexMethod invokedMethod = current.asInvokeMethod().getInvokedMethod();
            if (invokedMethod == this.dexItemFactory.longMethods.compare) {
                List<Value> inValues = current.inValues();
                assert (inValues.size() == 2);
                iterator.replaceCurrentInstruction(new Cmp(NumericType.LONG, Cmp.Bias.NONE, current.outValue(), inValues.get(0), inValues.get(1)));
                continue;
            }
            if (invokedMethod != this.dexItemFactory.objectsMethods.requireNonNull) continue;
            InvokeVirtual callToGetClass = new InvokeVirtual(this.dexItemFactory.objectMethods.getClass, null, current.inValues());
            if (current.outValue() != null) {
                current.outValue().replaceUsers(current.inValues().get(0));
                current.setOutValue(null);
            }
            iterator.replaceCurrentInstruction(callToGetClass);
        }
        assert (code.isConsistentSSA());
    }

    public void rewriteThrowableAddAndGetSuppressed(IRCode code) {
        DexItemFactory.ThrowableMethods throwableMethods = this.dexItemFactory.throwableMethods;
        for (BasicBlock block : code.blocks) {
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext()) {
                Instruction current = (Instruction)iterator.next();
                if (!current.isInvokeMethod()) continue;
                DexMethod invokedMethod = current.asInvokeMethod().getInvokedMethod();
                if (this.matchesMethodOfThrowable(invokedMethod, throwableMethods.addSuppressed)) {
                    iterator.removeOrReplaceByDebugLocalRead();
                    continue;
                }
                if (!this.matchesMethodOfThrowable(invokedMethod, throwableMethods.getSuppressed)) continue;
                Value destValue = current.outValue();
                if (destValue == null) {
                    iterator.removeOrReplaceByDebugLocalRead();
                    continue;
                }
                ConstNumber zero = code.createIntConstant(0);
                zero.setPosition(current.getPosition());
                assert (iterator.hasPrevious());
                iterator.previous();
                iterator.add(zero);
                Instruction next = (Instruction)iterator.next();
                assert (current == next);
                NewArrayEmpty newArray = new NewArrayEmpty(destValue, zero.outValue(), this.dexItemFactory.createType(this.dexItemFactory.throwableArrayDescriptor));
                iterator.replaceCurrentInstruction(newArray);
            }
        }
        assert (code.isConsistentSSA());
    }

    private boolean matchesMethodOfThrowable(DexMethod invoked, DexMethod expected) {
        return invoked.name == expected.name && invoked.proto == expected.proto && this.isSubtypeOfThrowable(invoked.holder);
    }

    private boolean isSubtypeOfThrowable(DexType type) {
        while (type != null && type != this.dexItemFactory.objectType) {
            if (type == this.dexItemFactory.throwableType) {
                return true;
            }
            DexClass dexClass = this.definitionFor(type);
            if (dexClass == null) {
                throw new CompilationError("Class or interface " + type.toSourceString() + " required for desugaring of try-with-resources is not found.");
            }
            type = dexClass.superType;
        }
        return false;
    }

    private Value addConstString(IRCode code, InstructionListIterator iterator, String s) {
        Value value = code.createValue(ValueType.OBJECT);
        iterator.add(new ConstString(value, this.dexItemFactory.createString(s)));
        return value;
    }

    public void logArgumentTypes(DexEncodedMethod method, IRCode code) {
        List<Value> arguments = code.collectArguments();
        BasicBlock block = code.blocks.getFirst();
        InstructionListIterator iterator = block.listIterator();
        Position position = Position.synthetic(1, method.method, null);
        iterator.setInsertionPosition(position);
        iterator.nextUntil(instruction -> !instruction.isArgument());
        iterator.previous();
        iterator.split(code);
        iterator.previous();
        assert (!block.hasCatchHandlers());
        Value out = code.createValue(ValueType.OBJECT);
        DexType javaLangSystemType = this.dexItemFactory.createType("Ljava/lang/System;");
        DexType javaIoPrintStreamType = this.dexItemFactory.createType("Ljava/io/PrintStream;");
        DexProto proto = this.dexItemFactory.createProto(this.dexItemFactory.voidType, this.dexItemFactory.objectType);
        DexMethod print = this.dexItemFactory.createMethod(javaIoPrintStreamType, proto, "print");
        DexMethod printLn = this.dexItemFactory.createMethod(javaIoPrintStreamType, proto, "println");
        iterator.add(new StaticGet(MemberType.OBJECT, out, this.dexItemFactory.createField(javaLangSystemType, javaIoPrintStreamType, "out")));
        Value value = code.createValue(ValueType.OBJECT);
        iterator.add(new ConstString(value, this.dexItemFactory.createString("INVOKE ")));
        iterator.add(new InvokeVirtual(print, null, ImmutableList.of(out, value)));
        value = code.createValue(ValueType.OBJECT);
        iterator.add(new ConstString(value, this.dexItemFactory.createString(method.method.qualifiedName())));
        iterator.add(new InvokeVirtual(print, null, ImmutableList.of(out, value)));
        Value openParenthesis = this.addConstString(code, iterator, "(");
        Value comma = this.addConstString(code, iterator, ",");
        Value closeParenthesis = this.addConstString(code, iterator, ")");
        Value indent = this.addConstString(code, iterator, "  ");
        Value nul = this.addConstString(code, iterator, "(null)");
        Value primitive = this.addConstString(code, iterator, "(primitive)");
        Value empty = this.addConstString(code, iterator, "");
        iterator.add(new InvokeVirtual(printLn, null, ImmutableList.of(out, openParenthesis)));
        for (int i = 0; i < arguments.size(); ++i) {
            iterator.add(new InvokeVirtual(print, null, ImmutableList.of(out, indent)));
            BasicBlock eol = BasicBlock.createGotoBlock(code.blocks.size());
            code.blocks.add(eol);
            BasicBlock successor = block.unlinkSingleSuccessor();
            block.link(eol);
            eol.link(successor);
            Value argument = arguments.get(i);
            if (argument.outType() != ValueType.OBJECT) {
                iterator.add(new InvokeVirtual(print, null, ImmutableList.of(out, primitive)));
            } else {
                successor = block.unlinkSingleSuccessor();
                If theIf = new If(If.Type.NE, argument);
                theIf.setPosition(position);
                BasicBlock ifBlock = BasicBlock.createIfBlock(code.blocks.size(), theIf);
                code.blocks.add(ifBlock);
                BasicBlock isNullBlock = BasicBlock.createGotoBlock(code.blocks.size());
                code.blocks.add(isNullBlock);
                BasicBlock isNotNullBlock = BasicBlock.createGotoBlock(code.blocks.size());
                code.blocks.add(isNotNullBlock);
                block.link(ifBlock);
                ifBlock.link(isNotNullBlock);
                ifBlock.link(isNullBlock);
                isNotNullBlock.link(successor);
                isNullBlock.link(successor);
                iterator = isNullBlock.listIterator();
                iterator.setInsertionPosition(position);
                iterator.add(new InvokeVirtual(print, null, ImmutableList.of(out, nul)));
                iterator = isNotNullBlock.listIterator();
                iterator.setInsertionPosition(position);
                value = code.createValue(ValueType.OBJECT);
                iterator.add(new InvokeVirtual(this.dexItemFactory.objectMethods.getClass, value, ImmutableList.of(arguments.get(i))));
                iterator.add(new InvokeVirtual(print, null, ImmutableList.of(out, value)));
            }
            iterator = eol.listIterator();
            iterator.setInsertionPosition(position);
            if (i == arguments.size() - 1) {
                iterator.add(new InvokeVirtual(printLn, null, ImmutableList.of(out, closeParenthesis)));
            } else {
                iterator.add(new InvokeVirtual(printLn, null, ImmutableList.of(out, comma)));
            }
            block = eol;
        }
        iterator.add(new InvokeVirtual(printLn, null, ImmutableList.of(out, empty)));
    }

    public static void ensureDirectStringNewToInit(IRCode code) {
        DexItemFactory factory = code.options.itemFactory;
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                InvokeDirect invoke;
                DexMethod method;
                Instruction instruction = (Instruction)it.next();
                if (!instruction.isInvokeDirect() || !factory.isConstructor(method = (invoke = instruction.asInvokeDirect()).getInvokedMethod()) || method.holder != factory.stringType || !invoke.getReceiver().isPhi()) continue;
                NewInstance newInstance = CodeRewriter.findNewInstance(invoke.getReceiver().asPhi());
                CodeRewriter.replaceTrivialNewInstancePhis(newInstance.outValue());
                if (invoke.getReceiver().isPhi()) {
                    throw new CompilationError("Failed to remove trivial phis between new-instance and <init>");
                }
                newInstance.markNoSpilling();
            }
        }
    }

    private static NewInstance findNewInstance(Phi phi) {
        HashSet<Phi> seen = new HashSet<Phi>();
        HashSet<Value> values = new HashSet<Value>();
        CodeRewriter.recursiveAddOperands(phi, seen, values);
        if (values.size() != 1) {
            throw new CompilationError("Failed to identify unique new-instance for <init>");
        }
        Value newInstanceValue = (Value)values.iterator().next();
        if (newInstanceValue.definition == null || !newInstanceValue.definition.isNewInstance()) {
            throw new CompilationError("Invalid defining value for call to <init>");
        }
        return newInstanceValue.definition.asNewInstance();
    }

    private static void recursiveAddOperands(Phi phi, Set<Phi> seen, Set<Value> values) {
        for (Value operand : phi.getOperands()) {
            if (!operand.isPhi()) {
                values.add(operand);
                continue;
            }
            Phi phiOp = operand.asPhi();
            if (!seen.add(phiOp)) continue;
            CodeRewriter.recursiveAddOperands(phiOp, seen, values);
        }
    }

    private static void replaceTrivialNewInstancePhis(Value newInstanceValue) {
        List<Set<Value>> components = new SCC().computeSCC(newInstanceValue);
        for (int i = components.size() - 1; i >= 0; --i) {
            Set<Value> component = components.get(i);
            if (component.size() == 1 && component.iterator().next() == newInstanceValue) continue;
            HashSet<Phi> trivialPhis = new HashSet<Phi>();
            for (Value value : component) {
                boolean isTrivial = true;
                Phi p = value.asPhi();
                for (Value op : p.getOperands()) {
                    if (op == newInstanceValue || component.contains(op)) continue;
                    isTrivial = false;
                    break;
                }
                if (!isTrivial) continue;
                trivialPhis.add(p);
            }
            for (Phi trivialPhi : trivialPhis) {
                for (Value op : trivialPhi.getOperands()) {
                    op.removePhiUser(trivialPhi);
                }
                trivialPhi.replaceUsers(newInstanceValue);
                trivialPhi.getBlock().removePhi(trivialPhi);
            }
        }
    }

    public void workaroundNumberConversionRegisterAllocationBug(IRCode code) {
        Supplier<DexMethod> javaLangDoubleisNaN = Suppliers.memoize(() -> this.dexItemFactory.createMethod(this.dexItemFactory.createString("Ljava/lang/Double;"), this.dexItemFactory.createString("isNaN"), this.dexItemFactory.booleanDescriptor, new DexString[]{this.dexItemFactory.doubleDescriptor}));
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                if (!instruction.isArithmeticBinop() && !instruction.isNeg()) continue;
                for (Value value : instruction.inValues()) {
                    BasicBlock blockWithInvokeNaN;
                    if (value.isPhi() || !value.definition.isNumberConversion() || value.definition.asNumberConversion().to != NumericType.DOUBLE) continue;
                    InvokeStatic invokeIsNaN = new InvokeStatic(javaLangDoubleisNaN.get(), null, ImmutableList.of(value));
                    invokeIsNaN.setPosition(instruction.getPosition());
                    it.previous();
                    BasicBlock basicBlock = blockWithInvokeNaN = block.hasCatchHandlers() ? it.split(code, blocks) : block;
                    if (blockWithInvokeNaN != block) {
                        it = block.listIterator(block.getInstructions().size());
                        it.previous();
                        it.add(invokeIsNaN);
                        block = blockWithInvokeNaN;
                        it = block.listIterator();
                    } else {
                        it.add(invokeIsNaN);
                    }
                    Instruction temp = (Instruction)it.next();
                    assert (temp == instruction);
                }
            }
        }
    }

    private static class SCC {
        private int currentTime = 0;
        private final Reference2IntMap<Value> discoverTime = new Reference2IntOpenHashMap<Value>();
        private final Set<Value> unassignedSet = new HashSet<Value>();
        private final Deque<Value> unassignedStack = new ArrayDeque<Value>();
        private final Deque<Value> preorderStack = new ArrayDeque<Value>();
        private final List<Set<Value>> components = new ArrayList<Set<Value>>();

        private SCC() {
        }

        public List<Set<Value>> computeSCC(Value v) {
            assert (this.currentTime == 0);
            this.dfs(v);
            return this.components;
        }

        private void dfs(Value value) {
            this.discoverTime.put(value, this.currentTime++);
            this.unassignedSet.add(value);
            this.unassignedStack.push(value);
            this.preorderStack.push(value);
            for (Phi phi : value.uniquePhiUsers()) {
                if (!this.discoverTime.containsKey(phi)) {
                    this.dfs(phi);
                    continue;
                }
                if (!this.unassignedSet.contains(phi)) continue;
                int discoverTimeOfPhi = this.discoverTime.getInt(phi);
                while (discoverTimeOfPhi < this.discoverTime.getInt(this.preorderStack.peek())) {
                    this.preorderStack.pop();
                }
            }
            if (this.preorderStack.peek() == value) {
                Value member;
                HashSet<Value> component = new HashSet<Value>(this.unassignedStack.size());
                do {
                    member = this.unassignedStack.pop();
                    this.unassignedSet.remove(member);
                    component.add(member);
                } while (member != value);
                this.components.add(component);
                this.preorderStack.pop();
            }
        }
    }

    private static class CSEExpressionEquivalence
    extends Equivalence<Instruction> {
        private final IRCode code;

        private CSEExpressionEquivalence(IRCode code) {
            this.code = code;
        }

        @Override
        protected boolean doEquivalent(Instruction a, Instruction b) {
            if (a.isCmp() && this.code.options.canHaveCmpLongBug()) {
                return false;
            }
            if (!a.identicalNonValueNonPositionParts(b)) {
                return false;
            }
            if (a.isBinop() && a.asBinop().isCommutative()) {
                Value a0 = a.inValues().get(0);
                Value a1 = a.inValues().get(1);
                Value b0 = b.inValues().get(0);
                Value b1 = b.inValues().get(1);
                return CSEExpressionEquivalence.identicalValue(a0, b0) && CSEExpressionEquivalence.identicalValue(a1, b1) || CSEExpressionEquivalence.identicalValue(a0, b1) && CSEExpressionEquivalence.identicalValue(a1, b0);
            }
            assert (a.inValues().size() == b.inValues().size());
            for (int i = 0; i < a.inValues().size(); ++i) {
                if (CSEExpressionEquivalence.identicalValue(a.inValues().get(i), b.inValues().get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int doHash(Instruction instruction) {
            int prime = 29;
            int hash = instruction.getClass().hashCode();
            if (instruction.isBinop()) {
                Binop binop = instruction.asBinop();
                Value in0 = instruction.inValues().get(0);
                Value in1 = instruction.inValues().get(1);
                if (binop.isCommutative()) {
                    hash += hash * 29 + CSEExpressionEquivalence.getHashCode(in0) * CSEExpressionEquivalence.getHashCode(in1);
                } else {
                    hash += hash * 29 + CSEExpressionEquivalence.getHashCode(in0);
                    hash += hash * 29 + CSEExpressionEquivalence.getHashCode(in1);
                }
                return hash;
            }
            for (Value value : instruction.inValues()) {
                hash += hash * 29 + CSEExpressionEquivalence.getHashCode(value);
            }
            return hash;
        }

        private static boolean identicalValue(Value a, Value b) {
            if (a.equals(b)) {
                return true;
            }
            if (a.isConstNumber() && b.isConstNumber()) {
                return a.definition.identicalNonValueNonPositionParts(b.definition);
            }
            return false;
        }

        private static int getHashCode(Value a) {
            if (a.isConstNumber()) {
                return Long.hashCode(a.definition.asConstNumber().getRawValue());
            }
            return a.hashCode();
        }
    }

    private static enum InstructionEffect {
        DESIRED_EFFECT,
        OTHER_EFFECT,
        NO_EFFECT;

    }

    public static class IfBuilder
    extends InstructionBuilder<IfBuilder> {
        private final IRCode code;
        private Value left;
        private int right;
        private BasicBlock target;
        private BasicBlock fallthrough;

        public IfBuilder(Position position, IRCode code) {
            super(position);
            this.code = code;
        }

        @Override
        public IfBuilder self() {
            return this;
        }

        public IfBuilder setLeft(Value left) {
            this.left = left;
            return this;
        }

        public IfBuilder setRight(int right) {
            this.right = right;
            return this;
        }

        public IfBuilder setTarget(BasicBlock target) {
            this.target = target;
            return this;
        }

        public IfBuilder setFallthrough(BasicBlock fallthrough) {
            this.fallthrough = fallthrough;
            return this;
        }

        public BasicBlock build() {
            BasicBlock ifBlock;
            If newIf;
            assert (this.target != null);
            assert (this.fallthrough != null);
            if (this.right != 0) {
                ConstNumber rightConst = this.code.createIntConstant(this.right);
                rightConst.setPosition(this.position);
                newIf = new If(If.Type.EQ, ImmutableList.of(this.left, rightConst.dest()));
                ifBlock = BasicBlock.createIfBlock(this.blockNumber, newIf, rightConst);
            } else {
                newIf = new If(If.Type.EQ, this.left);
                ifBlock = BasicBlock.createIfBlock(this.blockNumber, newIf);
            }
            newIf.setPosition(this.position);
            ifBlock.link(this.target);
            ifBlock.link(this.fallthrough);
            return ifBlock;
        }
    }

    public static class SwitchBuilder
    extends InstructionBuilder<SwitchBuilder> {
        private Value value;
        private final Int2ObjectSortedMap<BasicBlock> keyToTarget = new Int2ObjectAVLTreeMap<BasicBlock>();
        private BasicBlock fallthrough;

        public SwitchBuilder(Position position) {
            super(position);
        }

        @Override
        public SwitchBuilder self() {
            return this;
        }

        public SwitchBuilder setValue(Value value) {
            this.value = value;
            return this;
        }

        public SwitchBuilder addKeyAndTarget(int key, BasicBlock target) {
            this.keyToTarget.put(key, target);
            return this;
        }

        public SwitchBuilder setFallthrough(BasicBlock fallthrough) {
            this.fallthrough = fallthrough;
            return this;
        }

        public BasicBlock build() {
            int NOT_FOUND = -1;
            Object2IntLinkedOpenHashMap<BasicBlock> targetToSuccessorIndex = new Object2IntLinkedOpenHashMap<BasicBlock>();
            targetToSuccessorIndex.defaultReturnValue(-1);
            int[] keys = new int[this.keyToTarget.size()];
            int[] targetBlockIndices = new int[this.keyToTarget.size()];
            int count = 0;
            IntBidirectionalIterator iter = this.keyToTarget.keySet().iterator();
            while (iter.hasNext()) {
                int key = iter.nextInt();
                BasicBlock target = (BasicBlock)this.keyToTarget.get(key);
                Integer targetIndex = targetToSuccessorIndex.computeIfAbsent(target, b -> targetToSuccessorIndex.size());
                keys[count] = key;
                targetBlockIndices[count] = targetIndex;
                ++count;
            }
            Integer fallthroughIndex = targetToSuccessorIndex.computeIfAbsent(this.fallthrough, b -> targetToSuccessorIndex.size());
            Switch newSwitch = new Switch(this.value, keys, targetBlockIndices, fallthroughIndex);
            newSwitch.setPosition(this.position);
            BasicBlock newSwitchBlock = BasicBlock.createSwitchBlock(this.blockNumber, newSwitch);
            for (BasicBlock successor : targetToSuccessorIndex.keySet()) {
                newSwitchBlock.link(successor);
            }
            return newSwitchBlock;
        }
    }

    public static abstract class InstructionBuilder<T> {
        protected int blockNumber;
        protected final Position position;

        protected InstructionBuilder(Position position) {
            this.position = position;
        }

        public abstract T self();

        public T setBlockNumber(int blockNumber) {
            this.blockNumber = blockNumber;
            return this.self();
        }
    }
}

