/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.Invoke;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class VerticalClassMergerGraphLense
extends GraphLense {
    private final GraphLense previousLense;
    private final Map<DexField, DexField> fieldMap;
    private final Map<DexMethod, DexMethod> methodMap;
    private final Map<DexType, Map<DexMethod, DexMethod>> contextualVirtualToDirectMethodMaps;

    public VerticalClassMergerGraphLense(Map<DexField, DexField> fieldMap, Map<DexMethod, DexMethod> methodMap, Map<DexType, Map<DexMethod, DexMethod>> contextualVirtualToDirectMethodMaps, GraphLense previousLense) {
        this.previousLense = previousLense;
        this.fieldMap = fieldMap;
        this.methodMap = methodMap;
        this.contextualVirtualToDirectMethodMaps = contextualVirtualToDirectMethodMaps;
    }

    @Override
    public DexType lookupType(DexType type) {
        return this.previousLense.lookupType(type);
    }

    @Override
    public DexMethod lookupMethod(DexMethod method, DexEncodedMethod context, Invoke.Type type) {
        DexMethod directMethod;
        Map<DexMethod, DexMethod> virtualToDirectMethodMap;
        assert (this.isContextFreeForMethod(method) || context != null && type != null);
        DexMethod previous = this.previousLense.lookupMethod(method, context, type);
        if (type == Invoke.Type.SUPER && (virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.get(context.method.holder)) != null && (directMethod = virtualToDirectMethodMap.get(previous)) != null) {
            return directMethod;
        }
        return this.methodMap.getOrDefault(previous, previous);
    }

    @Override
    public Set<DexMethod> lookupMethodInAllContexts(DexMethod method) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DexMethod previous : this.previousLense.lookupMethodInAllContexts(method)) {
            builder.add(this.methodMap.getOrDefault(previous, previous));
            for (Map<DexMethod, DexMethod> virtualToDirectMethodMap : this.contextualVirtualToDirectMethodMaps.values()) {
                DexMethod directMethod = virtualToDirectMethodMap.get(previous);
                if (directMethod == null) continue;
                builder.add(directMethod);
            }
        }
        return builder.build();
    }

    @Override
    public DexField lookupField(DexField field) {
        DexField previous = this.previousLense.lookupField(field);
        return this.fieldMap.getOrDefault(previous, previous);
    }

    @Override
    public boolean isContextFreeForMethods() {
        return this.contextualVirtualToDirectMethodMaps.isEmpty() && this.previousLense.isContextFreeForMethods();
    }

    @Override
    public boolean isContextFreeForMethod(DexMethod method) {
        if (!this.previousLense.isContextFreeForMethod(method)) {
            return false;
        }
        DexMethod previous = this.previousLense.lookupMethod(method);
        for (Map<DexMethod, DexMethod> virtualToDirectMethodMap : this.contextualVirtualToDirectMethodMaps.values()) {
            if (!virtualToDirectMethodMap.containsKey(previous)) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private final ImmutableMap.Builder<DexField, DexField> fieldMapBuilder = ImmutableMap.builder();
        private final ImmutableMap.Builder<DexMethod, DexMethod> methodMapBuilder = ImmutableMap.builder();
        private final Map<DexType, Map<DexMethod, DexMethod>> contextualVirtualToDirectMethodMaps = new HashMap<DexType, Map<DexMethod, DexMethod>>();

        public GraphLense build(GraphLense previousLense) {
            ImmutableMap<DexField, DexField> fieldMap = this.fieldMapBuilder.build();
            ImmutableMap<DexMethod, DexMethod> methodMap = this.methodMapBuilder.build();
            if (fieldMap.isEmpty() && methodMap.isEmpty() && this.contextualVirtualToDirectMethodMaps.isEmpty()) {
                return previousLense;
            }
            return new VerticalClassMergerGraphLense(fieldMap, methodMap, this.contextualVirtualToDirectMethodMaps, previousLense);
        }

        public void map(DexField from, DexField to) {
            this.fieldMapBuilder.put(from, to);
        }

        public void map(DexMethod from, DexMethod to) {
            this.methodMapBuilder.put(from, to);
        }

        public void mapVirtualMethodToDirectInType(DexMethod from, DexMethod to, DexType type) {
            Map virtualToDirectMethodMap = this.contextualVirtualToDirectMethodMaps.computeIfAbsent(type, key -> new HashMap());
            virtualToDirectMethodMap.put(from, to);
        }

        public void merge(Builder builder) {
            this.fieldMapBuilder.putAll(builder.fieldMapBuilder.build());
            this.methodMapBuilder.putAll(builder.methodMapBuilder.build());
            for (DexType context : builder.contextualVirtualToDirectMethodMaps.keySet()) {
                Map<DexMethod, DexMethod> current = this.contextualVirtualToDirectMethodMaps.get(context);
                Map<DexMethod, DexMethod> other = builder.contextualVirtualToDirectMethodMaps.get(context);
                if (current != null) {
                    current.putAll(other);
                    continue;
                }
                this.contextualVirtualToDirectMethodMaps.put(context, other);
            }
        }
    }
}

