/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.it.unimi.dsi.fastutil.Hash;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.ArrayList;
import java.util.List;

public class ConstantCanonicalizer {
    private static final int MAX_CANONICALIZED_CONSTANT = 15;

    public static void canonicalize(IRCode code) {
        Object2ObjectLinkedOpenCustomHashMap<ConstNumber, ArrayList<Value>> valuesDefinedByConstant = new Object2ObjectLinkedOpenCustomHashMap<ConstNumber, ArrayList<Value>>(new Hash.Strategy<ConstNumber>(){

            @Override
            public int hashCode(ConstNumber constNumber) {
                return Long.hashCode(constNumber.getRawValue()) + 13 * constNumber.outType().hashCode();
            }

            @Override
            public boolean equals(ConstNumber a, ConstNumber b) {
                assert (a == null || !a.outValue().hasLocalInfo());
                assert (b == null || !b.outValue().hasLocalInfo());
                return a != null && b != null && a.identicalNonValueNonPositionParts(b);
            }
        });
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction current = (Instruction)it.next();
                if (!current.isConstNumber() || current.outValue().hasLocalInfo() || ConstantCanonicalizer.constantUsedByInvokeRange(current.asConstNumber())) continue;
                ArrayList<Value> oldValuesDefinedByConstant = (ArrayList<Value>)valuesDefinedByConstant.get(current);
                if (oldValuesDefinedByConstant == null) {
                    oldValuesDefinedByConstant = new ArrayList<Value>();
                    valuesDefinedByConstant.put(current.asConstNumber(), oldValuesDefinedByConstant);
                }
                oldValuesDefinedByConstant.add(current.outValue());
            }
        }
        if (!valuesDefinedByConstant.isEmpty()) {
            ObjectSortedSet entries = valuesDefinedByConstant.object2ObjectEntrySet();
            entries.stream().filter(a -> ((List)a.getValue()).size() > 1).sorted((a, b) -> Integer.compare(((List)b.getValue()).size(), ((List)a.getValue()).size())).limit(15L).forEach(entry -> {
                ConstNumber canonicalizedConstant = ((ConstNumber)entry.getKey()).asConstNumber();
                ConstNumber newConst = ConstNumber.copyOf(code, canonicalizedConstant);
                ConstantCanonicalizer.insertCanonicalizedConstant(code, newConst);
                newConst.setPosition(Position.none());
                for (Value outValue : (List)entry.getValue()) {
                    outValue.replaceUsers(newConst.outValue());
                }
            });
        }
        code.removeAllTrivialPhis();
        assert (code.isConsistentSSA());
    }

    private static void insertCanonicalizedConstant(IRCode code, ConstNumber canonicalizedConstant) {
        BasicBlock entryBlock = code.blocks.get(0);
        InstructionListIterator it = entryBlock.listIterator();
        while (it.hasNext()) {
            if (((Instruction)it.next()).isArgument()) continue;
            it.previous();
            break;
        }
        it.add(canonicalizedConstant);
    }

    private static boolean constantUsedByInvokeRange(ConstNumber constant) {
        for (Instruction user : constant.outValue().uniqueUsers()) {
            if (!user.isInvoke() || user.asInvoke().requiredArgumentRegisters() <= 5) continue;
            return true;
        }
        return false;
    }
}

