/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.desugar.LambdaClass;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.ir.desugar.SynthesizedLambdaSourceCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class LambdaMainMethodSourceCode
extends SynthesizedLambdaSourceCode {
    LambdaMainMethodSourceCode(LambdaClass lambda2, DexMethod mainMethod) {
        super(lambda2, mainMethod);
    }

    private boolean checkSignatures(DexType[] captures, DexType[] enforcedParams, DexType enforcedReturnType, List<DexType> implReceiverAndArgs, DexType implReturnType) {
        ArrayList<DexType> capturesAndParams = new ArrayList<DexType>();
        capturesAndParams.addAll(Lists.newArrayList(captures));
        capturesAndParams.addAll(Lists.newArrayList(enforcedParams));
        int size = capturesAndParams.size();
        if (size != implReceiverAndArgs.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.isSameOrAdaptableTo((DexType)capturesAndParams.get(i), implReceiverAndArgs.get(i))) continue;
            return false;
        }
        return enforcedReturnType.isVoidType() || this.isSameOrAdaptableTo(implReturnType, enforcedReturnType);
    }

    private DexType getPrimitiveFromBoxed(DexType boxedPrimitive) {
        DexString descriptor = boxedPrimitive.descriptor;
        DexItemFactory factory = this.factory();
        if (descriptor == factory.boxedBooleanDescriptor) {
            return factory.booleanType;
        }
        if (descriptor == factory.boxedByteDescriptor) {
            return factory.byteType;
        }
        if (descriptor == factory.boxedCharDescriptor) {
            return factory.charType;
        }
        if (descriptor == factory.boxedShortDescriptor) {
            return factory.shortType;
        }
        if (descriptor == factory.boxedIntDescriptor) {
            return factory.intType;
        }
        if (descriptor == factory.boxedLongDescriptor) {
            return factory.longType;
        }
        if (descriptor == factory.boxedFloatDescriptor) {
            return factory.floatType;
        }
        if (descriptor == factory.boxedDoubleDescriptor) {
            return factory.doubleType;
        }
        return null;
    }

    private DexType getBoxedForPrimitiveType(DexType primitive) {
        switch (primitive.descriptor.content[0]) {
            case 90: {
                return this.factory().boxedBooleanType;
            }
            case 66: {
                return this.factory().boxedByteType;
            }
            case 83: {
                return this.factory().boxedShortType;
            }
            case 67: {
                return this.factory().boxedCharType;
            }
            case 73: {
                return this.factory().boxedIntType;
            }
            case 74: {
                return this.factory().boxedLongType;
            }
            case 70: {
                return this.factory().boxedFloatType;
            }
            case 68: {
                return this.factory().boxedDoubleType;
            }
        }
        throw new Unreachable("Invalid primitive type descriptor: " + primitive);
    }

    private boolean isSameOrAdaptableTo(DexType a, DexType b) {
        if (a == b) {
            return true;
        }
        DexItemFactory factory = this.factory();
        if (a.isArrayType()) {
            return b == factory.objectType || b.isArrayType();
        }
        if (b.isArrayType()) {
            return a == factory.objectType;
        }
        if (a.isPrimitiveType()) {
            if (b.isPrimitiveType()) {
                return this.isSameOrAdaptableTo(a.descriptor.content[0], b.descriptor.content[0]);
            }
            DexType boxedPrimitiveType = this.getBoxedForPrimitiveType(a);
            if (b == boxedPrimitiveType || b == factory.objectType || b == factory.serializableType || b == factory.comparableType) {
                return true;
            }
            return boxedPrimitiveType != factory.boxedCharType && boxedPrimitiveType != factory.boxedBooleanType && b.descriptor == factory.boxedNumberDescriptor;
        }
        if (b.isPrimitiveType()) {
            if (a == factory.objectType) {
                return true;
            }
            DexType unboxedA = this.getPrimitiveFromBoxed(a);
            return unboxedA != null && this.isSameOrAdaptableTo(unboxedA.descriptor.content[0], b.descriptor.content[0]);
        }
        return a.isClassType() && b.isClassType();
    }

    private boolean isSameOrAdaptableTo(byte from, byte to) {
        if (from == to) {
            return true;
        }
        switch (from) {
            case 66: {
                return to == 83 || to == 73 || to == 74 || to == 70 || to == 68;
            }
            case 67: 
            case 83: {
                return to == 73 || to == 74 || to == 70 || to == 68;
            }
            case 73: {
                return to == 74 || to == 70 || to == 68;
            }
            case 74: {
                return to == 70 || to == 68;
            }
            case 70: {
                return to == 68;
            }
            case 68: 
            case 90: {
                return false;
            }
        }
        throw new Unreachable("Invalid primitive type descriptor: " + from);
    }

    @Override
    protected void prepareInstructions() {
        int i;
        boolean constructorTarget;
        DexType[] capturedTypes = this.captures();
        DexType[] erasedParams = this.descriptor().erasedProto.parameters.values;
        DexType erasedReturnType = this.descriptor().erasedProto.returnType;
        DexType[] enforcedParams = this.descriptor().enforcedProto.parameters.values;
        DexType enforcedReturnType = this.descriptor().enforcedProto.returnType;
        LambdaClass.Target target = this.lambda.target;
        DexMethod methodToCall = target.callTarget;
        boolean bl = constructorTarget = target.invokeType == Invoke.Type.DIRECT;
        assert (!constructorTarget || methodToCall.name == this.factory().constructorMethodName);
        ArrayList<DexType> implReceiverAndArgs = new ArrayList<DexType>();
        if (target.invokeType == Invoke.Type.VIRTUAL || target.invokeType == Invoke.Type.INTERFACE) {
            implReceiverAndArgs.add(methodToCall.holder);
        }
        implReceiverAndArgs.addAll(Lists.newArrayList(methodToCall.proto.parameters.values));
        DexType implReturnType = methodToCall.proto.returnType;
        assert (target.invokeType == Invoke.Type.STATIC || target.invokeType == Invoke.Type.VIRTUAL || target.invokeType == Invoke.Type.DIRECT || target.invokeType == Invoke.Type.INTERFACE);
        assert (this.checkSignatures(capturedTypes, enforcedParams, enforcedReturnType, implReceiverAndArgs, constructorTarget ? target.callTarget.holder : implReturnType));
        ArrayList<ValueType> argValueTypes = new ArrayList<ValueType>();
        ArrayList<Integer> argRegisters = new ArrayList<Integer>();
        if (constructorTarget) {
            int instance = this.nextRegister(ValueType.OBJECT);
            this.add(builder -> builder.addNewInstance(instance, methodToCall.holder));
            argValueTypes.add(ValueType.OBJECT);
            argRegisters.add(instance);
        }
        int capturedValues = capturedTypes.length;
        for (i = 0; i < capturedValues; ++i) {
            ValueType valueType = ValueType.fromDexType(capturedTypes[i]);
            int register = this.nextRegister(valueType);
            argValueTypes.add(valueType);
            argRegisters.add(register);
            DexField field = this.lambda.getCaptureField(i);
            this.add(builder -> builder.addInstanceGet(register, this.getReceiverRegister(), field));
        }
        for (i = 0; i < erasedParams.length; ++i) {
            DexType expectedParamType = (DexType)implReceiverAndArgs.get(i + capturedValues);
            argValueTypes.add(ValueType.fromDexType(expectedParamType));
            argRegisters.add(this.prepareParameterValue(this.getParamRegister(i), erasedParams[i], enforcedParams[i], expectedParamType));
        }
        this.add(builder -> builder.addInvoke(target.invokeType, (DexItem)methodToCall, methodToCall.proto, argValueTypes, argRegisters));
        if (enforcedReturnType.isVoidType()) {
            this.add(IRBuilder::addReturn);
        } else if (constructorTarget) {
            int instanceRegister = (Integer)argRegisters.get(0);
            int adjustedValue = this.prepareReturnValue(instanceRegister, erasedReturnType, enforcedReturnType, methodToCall.holder);
            this.add(builder -> builder.addReturn(ValueType.fromDexType(erasedReturnType), adjustedValue));
        } else {
            ValueType implValueType = ValueType.fromDexType(implReturnType);
            int tempValue = this.nextRegister(implValueType);
            this.add(builder -> builder.addMoveResult(tempValue));
            int adjustedValue = this.prepareReturnValue(tempValue, erasedReturnType, enforcedReturnType, methodToCall.proto.returnType);
            ValueType adjustedValueType = ValueType.fromDexType(erasedReturnType);
            this.add(builder -> builder.addReturn(adjustedValueType, adjustedValue));
        }
    }

    private int prepareReturnValue(int register, DexType erasedType, DexType enforcedType, DexType actualType) {
        register = this.adjustType(register, actualType, enforcedType, true);
        assert (LambdaDescriptor.isSameOrDerived(this.factory(), enforcedType, erasedType));
        return register;
    }

    private int prepareParameterValue(int register, DexType erasedType, DexType enforcedType, DexType expectedType) {
        register = this.enforceParameterType(register, erasedType, enforcedType);
        register = this.adjustType(register, enforcedType, expectedType, false);
        return register;
    }

    private int adjustType(int register, DexType fromType, DexType toType, boolean returnType) {
        DexType boxedFromType;
        if (fromType == toType) {
            return register;
        }
        boolean fromTypePrimitive = fromType.isPrimitiveType();
        boolean toTypePrimitive = toType.isPrimitiveType();
        if (fromTypePrimitive && toTypePrimitive) {
            return this.addPrimitiveWideningConversion(register, fromType, toType);
        }
        if (toTypePrimitive) {
            DexType fromTypeAsPrimitive;
            DexType boxedType = fromType;
            if (boxedType == this.factory().objectType) {
                boxedType = this.getBoxedForPrimitiveType(toType);
                register = this.castToBoxedType(register, boxedType);
            }
            if ((fromTypeAsPrimitive = this.getPrimitiveFromBoxed(boxedType)) != null) {
                int unboxedRegister = this.addPrimitiveUnboxing(register, fromTypeAsPrimitive, boxedType);
                return this.addPrimitiveWideningConversion(unboxedRegister, fromTypeAsPrimitive, toType);
            }
        }
        if (fromTypePrimitive && (toType == (boxedFromType = this.getBoxedForPrimitiveType(fromType)) || toType == this.factory().objectType || toType == this.factory().serializableType || toType == this.factory().comparableType || boxedFromType != this.factory().booleanType && boxedFromType != this.factory().charType && toType == this.factory().boxedNumberType)) {
            return this.addPrimitiveBoxing(register, fromType, boxedFromType);
        }
        if (fromType.isArrayType() && (toType == this.factory().objectType || toType.isArrayType())) {
            return register;
        }
        if (fromType.isClassType() && toType.isClassType() || fromType == this.factory().objectType && toType.isArrayType()) {
            if (returnType) {
                int finalRegister = register;
                this.add(builder -> builder.addCheckCast(finalRegister, toType));
            }
            return register;
        }
        throw new Unreachable("Unexpected type adjustment from " + fromType.toSourceString() + " to " + toType);
    }

    private int addPrimitiveWideningConversion(int register, DexType fromType, DexType toType) {
        assert (fromType.isPrimitiveType() && toType.isPrimitiveType());
        if (fromType == toType) {
            return register;
        }
        NumericType from = NumericType.fromDexType(fromType);
        NumericType to = NumericType.fromDexType(toType);
        if (from != null && to != null) {
            assert (from != to);
            switch (to) {
                case SHORT: {
                    if (from != NumericType.BYTE) break;
                    int result = this.nextRegister(ValueType.INT);
                    this.add(builder -> builder.addConversion(to, NumericType.INT, result, register));
                    return result;
                }
                case INT: {
                    if (from != NumericType.BYTE && from != NumericType.CHAR && from != NumericType.SHORT) break;
                    return register;
                }
                case LONG: {
                    if (from == NumericType.FLOAT || from == NumericType.DOUBLE) break;
                    int result = this.nextRegister(ValueType.LONG);
                    this.add(builder -> builder.addConversion(to, NumericType.INT, result, register));
                    return result;
                }
                case FLOAT: {
                    if (from == NumericType.DOUBLE) break;
                    int result = this.nextRegister(ValueType.FLOAT);
                    NumericType type = from == NumericType.LONG ? NumericType.LONG : NumericType.INT;
                    this.add(builder -> builder.addConversion(to, type, result, register));
                    return result;
                }
                case DOUBLE: {
                    int result = this.nextRegister(ValueType.DOUBLE);
                    NumericType type = from == NumericType.FLOAT || from == NumericType.LONG ? from : NumericType.INT;
                    this.add(builder -> builder.addConversion(to, type, result, register));
                    return result;
                }
            }
        }
        throw new Unreachable("Type " + fromType.toSourceString() + " cannot be converted to " + toType.toSourceString() + " via primitive widening conversion.");
    }

    private DexMethod getUnboxMethod(byte primitive, DexType boxType) {
        DexItemFactory factory = this.factory();
        switch (primitive) {
            case 90: {
                DexProto proto = factory.createProto(factory.booleanType, new DexType[0]);
                return factory.createMethod(boxType, proto, factory.unboxBooleanMethodName);
            }
            case 66: {
                DexProto proto = factory.createProto(factory.byteType, new DexType[0]);
                return factory.createMethod(boxType, proto, factory.unboxByteMethodName);
            }
            case 83: {
                DexProto proto = factory.createProto(factory.shortType, new DexType[0]);
                return factory.createMethod(boxType, proto, factory.unboxShortMethodName);
            }
            case 67: {
                DexProto proto = factory.createProto(factory.charType, new DexType[0]);
                return factory.createMethod(boxType, proto, factory.unboxCharMethodName);
            }
            case 73: {
                DexProto proto = factory.createProto(factory.intType, new DexType[0]);
                return factory.createMethod(boxType, proto, factory.unboxIntMethodName);
            }
            case 74: {
                DexProto proto = factory.createProto(factory.longType, new DexType[0]);
                return factory.createMethod(boxType, proto, factory.unboxLongMethodName);
            }
            case 70: {
                DexProto proto = factory.createProto(factory.floatType, new DexType[0]);
                return factory.createMethod(boxType, proto, factory.unboxFloatMethodName);
            }
            case 68: {
                DexProto proto = factory.createProto(factory.doubleType, new DexType[0]);
                return factory.createMethod(boxType, proto, factory.unboxDoubleMethodName);
            }
        }
        throw new Unreachable("Invalid primitive type descriptor: " + primitive);
    }

    private int addPrimitiveUnboxing(int register, DexType primitiveType, DexType boxType) {
        DexMethod method = this.getUnboxMethod(primitiveType.descriptor.content[0], boxType);
        List<ValueType> argValueTypes = Collections.singletonList(ValueType.OBJECT);
        List<Integer> argRegisters = Collections.singletonList(register);
        this.add(builder -> builder.addInvoke(Invoke.Type.VIRTUAL, (DexItem)method, method.proto, argValueTypes, argRegisters));
        ValueType valueType = ValueType.fromDexType(primitiveType);
        int result = this.nextRegister(valueType);
        this.add(builder -> builder.addMoveResult(result));
        return result;
    }

    private int castToBoxedType(int register, DexType boxType) {
        this.add(builder -> builder.addCheckCast(register, boxType));
        return register;
    }

    private int addPrimitiveBoxing(int register, DexType primitiveType, DexType boxType) {
        DexItemFactory factory = this.factory();
        DexProto proto = factory.createProto(boxType, primitiveType);
        DexMethod method = factory.createMethod(boxType, proto, factory.valueOfMethodName);
        ValueType valueType = ValueType.fromDexType(primitiveType);
        List<ValueType> argValueTypes = Collections.singletonList(valueType);
        List<Integer> argRegisters = Collections.singletonList(register);
        this.add(builder -> builder.addInvoke(Invoke.Type.STATIC, (DexItem)method, method.proto, argValueTypes, argRegisters));
        int result = this.nextRegister(ValueType.OBJECT);
        this.add(builder -> builder.addMoveResult(result));
        return result;
    }
}

