/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.Keep;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FileUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@Keep
public class ArchiveClassFileProvider
implements ClassFileResourceProvider,
Closeable {
    private final Origin origin;
    private final ZipFile zipFile;
    private final Set<String> descriptors = new HashSet<String>();

    public ArchiveClassFileProvider(Path archive) throws IOException {
        this(archive, entry -> true);
    }

    public ArchiveClassFileProvider(Path archive, Predicate<String> include) throws IOException {
        assert (FileUtils.isArchive(archive));
        this.origin = new PathOrigin(archive);
        try {
            this.zipFile = new ZipFile(archive.toFile(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            if (!Files.exists(archive, new LinkOption[0])) {
                throw new NoSuchFileException(archive.toString());
            }
            throw e;
        }
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!FileUtils.isClassFile(Paths.get(name, new String[0])) || !include.test(name)) continue;
            this.descriptors.add(DescriptorUtils.guessTypeDescriptor(name));
        }
    }

    @Override
    public Set<String> getClassDescriptors() {
        return Collections.unmodifiableSet(this.descriptors);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProgramResource getProgramResource(String descriptor) {
        if (!this.descriptors.contains(descriptor)) {
            return null;
        }
        ZipEntry zipEntry = this.getZipEntryFromDescriptor(descriptor);
        try (InputStream inputStream = this.zipFile.getInputStream(zipEntry);){
            ProgramResource programResource = ProgramResource.fromBytes(new ArchiveEntryOrigin(zipEntry.getName(), this.origin), ProgramResource.Kind.CF, ByteStreams.toByteArray(inputStream), Collections.singleton(descriptor));
            return programResource;
        }
        catch (IOException e) {
            throw new CompilationError("Failed to read '" + descriptor, this.origin);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    private ZipEntry getZipEntryFromDescriptor(String descriptor) {
        return this.zipFile.getEntry(descriptor.substring(1, descriptor.length() - 1) + ".class");
    }
}

