/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.compatdx;

import com.android.tools.r8.CompatDxHelper;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.joptsimple.OptionParser;
import com.android.tools.r8.joptsimple.OptionSet;
import com.android.tools.r8.joptsimple.OptionSpec;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.ThreadUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CompatDx {
    private static final String USAGE_HEADER = "Usage: compatdx [options] <input files>";

    public static void main(String[] args) throws IOException {
        try {
            CompatDx.run(args);
        }
        catch (DxCompatOptions.DxUsageMessage e) {
            System.err.println(USAGE_HEADER);
            e.printHelpOn(System.err);
            System.exit(1);
        }
        catch (CompilationFailedException e) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(String[] args) throws DxCompatOptions.DxUsageMessage, IOException, CompilationFailedException {
        DxCompatOptions dexArgs = DxCompatOptions.parse(args);
        if (dexArgs.help) {
            CompatDx.printHelpOn(System.out);
            return;
        }
        if (dexArgs.version) {
            Version.printToolVersion("CompatDx");
            return;
        }
        CompilationMode mode = CompilationMode.RELEASE;
        Path output = null;
        ArrayList<Path> inputs = new ArrayList<Path>();
        boolean singleDexFile = !dexArgs.multiDex;
        Path mainDexList = null;
        int numberOfThreads = 1;
        for (String path : dexArgs.inputs) {
            CompatDx.processPath(new File(path), inputs);
        }
        if (inputs.isEmpty()) {
            if (dexArgs.noFiles) {
                return;
            }
            throw new DxCompatOptions.DxUsageMessage("No input files specified");
        }
        if (dexArgs.debug) {
            System.out.println("Warning: logging is not enabled for this build.");
        }
        if (dexArgs.dump && dexArgs.verbose) {
            System.out.println("Warning: dump is not supported");
        }
        if (dexArgs.verboseDump) {
            throw new Unimplemented("verbose dump file not yet supported");
        }
        if (dexArgs.dumpMethod != null) {
            throw new Unimplemented("method-dump not yet supported");
        }
        if (dexArgs.output != null) {
            output = Paths.get(dexArgs.output, new String[0]);
            if (FileUtils.isDexFile(output)) {
                if (!singleDexFile) {
                    throw new DxCompatOptions.DxUsageMessage("Cannot output to a single dex-file when running with multidex");
                }
            } else if (!(FileUtils.isArchive(output) || output.toFile().exists() && output.toFile().isDirectory())) {
                throw new DxCompatOptions.DxUsageMessage("Unsupported output file or output directory does not exist. Output must be a directory or a file of type dex, apk, jar or zip.");
            }
        }
        if (dexArgs.dumpTo != null && dexArgs.verbose) {
            System.out.println("dump-to file not yet supported");
        }
        if (dexArgs.positions == DxCompatOptions.PositionInfo.NONE && dexArgs.verbose) {
            System.out.println("Warning: no support for positions none.");
        }
        if (dexArgs.positions == DxCompatOptions.PositionInfo.LINES && !dexArgs.noLocals) {
            mode = CompilationMode.DEBUG;
        }
        if (dexArgs.incremental) {
            throw new Unimplemented("incremental merge not supported yet");
        }
        if (dexArgs.forceJumbo && dexArgs.verbose) {
            System.out.println("Warning: no support for forcing jumbo-strings.\nStrings will only use jumbo-string indexing if necessary.\nMake sure that any dex merger subsequently used supports correct handling of jumbo-strings (eg, D8/R8 does).");
        }
        if (dexArgs.noOptimize && dexArgs.verbose) {
            System.out.println("Warning: no support for not optimizing");
        }
        if (dexArgs.optimizeList != null) {
            throw new Unimplemented("no support for optimize-method list");
        }
        if (dexArgs.noOptimizeList != null) {
            throw new Unimplemented("no support for dont-optimize-method list");
        }
        if (dexArgs.statistics && dexArgs.verbose) {
            System.out.println("Warning: no support for printing statistics");
        }
        if (dexArgs.numThreads > 1) {
            numberOfThreads = dexArgs.numThreads;
        }
        if (dexArgs.mainDexList != null) {
            mainDexList = Paths.get(dexArgs.mainDexList, new String[0]);
        }
        if (dexArgs.noStrict) {
            if (dexArgs.verbose) {
                System.out.println("Warning: conservative main-dex list not yet supported");
            }
        } else if (dexArgs.verbose) {
            System.out.println("Warning: strict name checking not yet supported");
        }
        if (dexArgs.minimalMainDex && dexArgs.verbose) {
            System.out.println("Warning: minimal main-dex support is not yet supported");
        }
        if (dexArgs.maxIndexNumber != 0 && dexArgs.verbose) {
            System.out.println("Warning: internal maximum-index setting is not supported");
        }
        if (numberOfThreads < 1) {
            throw new DxCompatOptions.DxUsageMessage("Invalid numThreads value of " + numberOfThreads);
        }
        ExecutorService executor = ThreadUtils.getExecutorService(numberOfThreads);
        try {
            D8Command.Builder builder = D8Command.builder();
            CompatDxHelper.ignoreDexInArchive(builder);
            ((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)builder.addProgramFiles(inputs)).setProgramConsumer(CompatDx.createConsumer(inputs, output, singleDexFile, dexArgs.keepClasses))).setMode(mode)).setMinApiLevel(dexArgs.minApiLevel);
            if (mainDexList != null) {
                builder.addMainDexListFiles(mainDexList);
            }
            CompatDxHelper.run((D8Command)builder.build(), dexArgs.minimalMainDex);
        }
        finally {
            executor.shutdown();
        }
    }

    private static ProgramConsumer createConsumer(List<Path> inputs, Path output, boolean singleDexFile, boolean keepClasses) throws DxCompatOptions.DxUsageMessage {
        if (output == null) {
            return DexIndexedConsumer.emptyConsumer();
        }
        if (singleDexFile) {
            return new SingleDexFileConsumer(FileUtils.isDexFile(output) ? new NamedDexFileConsumer(output) : CompatDx.createDexConsumer(output, inputs, keepClasses));
        }
        return CompatDx.createDexConsumer(output, inputs, keepClasses);
    }

    private static DexIndexedConsumer createDexConsumer(Path output, List<Path> inputs, boolean keepClasses) throws DxCompatOptions.DxUsageMessage {
        if (keepClasses) {
            if (!FileUtils.isArchive(output)) {
                throw new DxCompatOptions.DxUsageMessage("Output must be an archive when --keep-classes is set.");
            }
            return new DexKeepClassesConsumer(output, inputs);
        }
        return FileUtils.isArchive(output) ? new DexIndexedConsumer.ArchiveConsumer(output) : new DexIndexedConsumer.DirectoryConsumer(output);
    }

    static void printHelpOn(PrintStream sink) throws IOException {
        sink.println(USAGE_HEADER);
        new DxCompatOptions.Spec().parser.printHelpOn(sink);
    }

    private static void processPath(File file, List<Path> files) {
        if (!file.exists()) {
            throw new CompilationError("File does not exist: " + file);
        }
        if (file.isDirectory()) {
            CompatDx.processDirectory(file, files);
            return;
        }
        Path path = file.toPath();
        if (FileUtils.isZipFile(path) || FileUtils.isJarFile(path) || FileUtils.isClassFile(path)) {
            files.add(path);
            return;
        }
        if (FileUtils.isApkFile(path)) {
            throw new Unimplemented("apk files not yet supported");
        }
    }

    private static void processDirectory(File directory, List<Path> files) {
        assert (directory.exists());
        for (File file : directory.listFiles()) {
            CompatDx.processPath(file, files);
        }
    }

    private static class DexKeepClassesConsumer
    extends DexIndexedConsumer.ArchiveConsumer {
        private final List<Path> inputs;

        public DexKeepClassesConsumer(Path archive, List<Path> inputs) {
            super(archive);
            this.inputs = inputs;
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            try {
                this.writeZipWithClasses(handler);
            }
            catch (IOException e) {
                handler.error(new ExceptionDiagnostic(e, this.getOrigin()));
            }
            super.finished(handler);
        }

        private void writeZipWithClasses(DiagnosticsHandler handler) throws IOException {
            for (Path input : this.inputs) {
                if (!FileUtils.isArchive(input)) continue;
                try (ZipFile zipFile = new ZipFile(input.toFile(), StandardCharsets.UTF_8);){
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!FileUtils.isClassFile(Paths.get(entry.getName(), new String[0]))) continue;
                        InputStream entryStream = zipFile.getInputStream(entry);
                        Throwable throwable = null;
                        try {
                            this.outputBuilder.addFile(entry.getName(), ByteStreams.toByteArray(entryStream), handler);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (entryStream == null) continue;
                            DexKeepClassesConsumer.$closeResource(throwable, entryStream);
                        }
                    }
                }
            }
        }
    }

    private static class NamedDexFileConsumer
    extends DexIndexedConsumer.ForwardingConsumer {
        private final Path output;

        public NamedDexFileConsumer(Path output) {
            super(null);
            this.output = output;
        }

        @Override
        public void accept(int fileIndex, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            try {
                Files.write(this.output, data, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                handler.error(new ExceptionDiagnostic(e, new PathOrigin(this.output)));
            }
        }
    }

    private static class SingleDexFileConsumer
    extends DexIndexedConsumer.ForwardingConsumer {
        private byte[] bytes = null;

        public SingleDexFileConsumer(DexIndexedConsumer consumer) {
            super(consumer);
        }

        @Override
        public void accept(int fileIndex, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            if (fileIndex > 0) {
                throw new CompilationError("Compilation result could not fit into a single dex file. Reduce the input-program size or run with --multi-dex enabled");
            }
            assert (this.bytes == null);
            this.bytes = data;
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            if (this.bytes != null) {
                super.accept(0, this.bytes, null, handler);
            }
            super.finished(handler);
        }
    }

    public static class DxCompatOptions {
        public final boolean help;
        public final boolean version;
        public final boolean debug;
        public final boolean verbose;
        public final PositionInfo positions;
        public final boolean noLocals;
        public final boolean noOptimize;
        public final boolean statistics;
        public final String optimizeList;
        public final String noOptimizeList;
        public final boolean noStrict;
        public final boolean keepClasses;
        public final String output;
        public final String dumpTo;
        public final int dumpWidth;
        public final String dumpMethod;
        public final boolean verboseDump;
        public final boolean dump;
        public final boolean noFiles;
        public final boolean coreLibrary;
        public final int numThreads;
        public final boolean incremental;
        public final boolean forceJumbo;
        public final boolean noWarning;
        public final boolean multiDex;
        public final String mainDexList;
        public final boolean minimalMainDex;
        public final int minApiLevel;
        public final String inputList;
        public final ImmutableList<String> inputs;
        public final int maxIndexNumber;
        private static final String FILE_ARG = "file";
        private static final String NUM_ARG = "number";
        private static final String METHOD_ARG = "method";

        private DxCompatOptions(OptionSet options, Spec spec) {
            this.help = options.has(spec.help);
            this.version = options.has(spec.version);
            this.debug = options.has(spec.debug);
            this.verbose = options.has(spec.verbose);
            if (options.has(spec.positions)) {
                switch (options.valueOf(spec.positions)) {
                    case "none": {
                        this.positions = PositionInfo.NONE;
                        break;
                    }
                    case "important": {
                        this.positions = PositionInfo.IMPORTANT;
                        break;
                    }
                    case "lines": {
                        this.positions = PositionInfo.LINES;
                        break;
                    }
                    case "throwing": {
                        this.positions = PositionInfo.THROWING;
                        break;
                    }
                    default: {
                        this.positions = PositionInfo.IMPORTANT;
                        break;
                    }
                }
            } else {
                this.positions = PositionInfo.LINES;
            }
            this.noLocals = options.has(spec.noLocals);
            this.noOptimize = options.has(spec.noOptimize);
            this.statistics = options.has(spec.statistics);
            this.optimizeList = options.valueOf(spec.optimizeList);
            this.noOptimizeList = options.valueOf(spec.noOptimizeList);
            this.noStrict = options.has(spec.noStrict);
            this.keepClasses = options.has(spec.keepClasses);
            this.output = options.valueOf(spec.output);
            this.dumpTo = options.valueOf(spec.dumpTo);
            this.dumpWidth = options.valueOf(spec.dumpWidth);
            this.dumpMethod = options.valueOf(spec.dumpMethod);
            this.dump = options.has(spec.dump);
            this.verboseDump = options.has(spec.verboseDump);
            this.noFiles = options.has(spec.noFiles);
            this.coreLibrary = options.has(spec.coreLibrary);
            this.numThreads = DxCompatOptions.lastIntOf(options.valuesOf(spec.numThreads));
            this.incremental = options.has(spec.incremental);
            this.forceJumbo = options.has(spec.forceJumbo);
            this.noWarning = options.has(spec.noWarning);
            this.multiDex = options.has(spec.multiDex);
            this.mainDexList = options.valueOf(spec.mainDexList);
            this.minimalMainDex = options.has(spec.minimalMainDex);
            if (options.has(spec.minApiLevel)) {
                List<Integer> allMinApiLevels = options.valuesOf(spec.minApiLevel);
                this.minApiLevel = allMinApiLevels.get(allMinApiLevels.size() - 1);
            } else {
                this.minApiLevel = AndroidApiLevel.getDefault().getLevel();
            }
            this.inputList = options.valueOf(spec.inputList);
            this.inputs = ImmutableList.copyOf(options.valuesOf(spec.inputs));
            this.maxIndexNumber = options.valueOf(spec.maxIndexNumber);
        }

        public static DxCompatOptions parse(String[] args) {
            Spec spec = new Spec();
            return new DxCompatOptions(spec.parser.parse(args), spec);
        }

        private static int lastIntOf(List<Integer> values) {
            assert (!values.isEmpty());
            return values.get(values.size() - 1);
        }

        private static class Spec {
            final OptionParser parser = new OptionParser();
            final OptionSpec<Void> debug;
            final OptionSpec<Void> verbose;
            final OptionSpec<String> positions;
            final OptionSpec<Void> noLocals;
            final OptionSpec<Void> noOptimize;
            final OptionSpec<Void> statistics;
            final OptionSpec<String> optimizeList;
            final OptionSpec<String> noOptimizeList;
            final OptionSpec<Void> noStrict;
            final OptionSpec<Void> keepClasses;
            final OptionSpec<String> output;
            final OptionSpec<String> dumpTo;
            final OptionSpec<Integer> dumpWidth;
            final OptionSpec<String> dumpMethod;
            final OptionSpec<Void> dump;
            final OptionSpec<Void> verboseDump;
            final OptionSpec<Void> noFiles;
            final OptionSpec<Void> coreLibrary;
            final OptionSpec<Integer> numThreads;
            final OptionSpec<Void> incremental;
            final OptionSpec<Void> forceJumbo;
            final OptionSpec<Void> noWarning;
            final OptionSpec<Void> multiDex;
            final OptionSpec<String> mainDexList;
            final OptionSpec<Void> minimalMainDex;
            final OptionSpec<Integer> minApiLevel;
            final OptionSpec<String> inputList;
            final OptionSpec<String> inputs;
            final OptionSpec<Void> version;
            final OptionSpec<Void> help;
            final OptionSpec<Integer> maxIndexNumber;

            Spec() {
                this.parser.accepts("dex");
                this.debug = this.parser.accepts("debug", "Print debug information");
                this.verbose = this.parser.accepts("verbose", "Print verbose information");
                this.positions = this.parser.accepts("positions", "What source-position information to keep. One of: none, lines, important").withOptionalArg().describedAs("keep").defaultsTo("lines", (String[])new String[0]);
                this.noLocals = this.parser.accepts("no-locals", "Don't keep local variable information");
                this.statistics = this.parser.accepts("statistics", "Print statistics information");
                this.noOptimize = this.parser.accepts("no-optimize", "Don't optimize");
                this.optimizeList = this.parser.accepts("optimize-list", "File listing methods to optimize").withRequiredArg().describedAs(DxCompatOptions.FILE_ARG);
                this.noOptimizeList = this.parser.accepts("no-optimize-list", "File listing methods not to optimize").withRequiredArg().describedAs(DxCompatOptions.FILE_ARG);
                this.noStrict = this.parser.accepts("no-strict", "Disable strict file/class name checks");
                this.keepClasses = this.parser.accepts("keep-classes", "Keep input class files in in output jar");
                this.output = this.parser.accepts("output", "Output file or directory").withRequiredArg().describedAs(DxCompatOptions.FILE_ARG);
                this.dumpTo = this.parser.accepts("dump-to", "File to dump information to").withRequiredArg().describedAs(DxCompatOptions.FILE_ARG);
                this.dumpWidth = this.parser.accepts("dump-width", "Max width for columns in dump output").withRequiredArg().ofType(Integer.class).defaultsTo(0, (Integer[])new Integer[0]).describedAs(DxCompatOptions.NUM_ARG);
                this.dumpMethod = this.parser.accepts("dump-method", "Method to dump information for").withRequiredArg().describedAs(DxCompatOptions.METHOD_ARG);
                this.dump = this.parser.accepts("dump", "Dump information");
                this.verboseDump = this.parser.accepts("verbose-dump", "Dump verbose information");
                this.noFiles = this.parser.accepts("no-files", "Don't fail if given no files");
                this.coreLibrary = this.parser.accepts("core-library", "Construct a core library");
                this.numThreads = this.parser.accepts("num-threads", "Number of threads to run with").withRequiredArg().ofType(Integer.class).defaultsTo(1, (Integer[])new Integer[0]).describedAs(DxCompatOptions.NUM_ARG);
                this.incremental = this.parser.accepts("incremental", "Merge result with the output if it exists");
                this.forceJumbo = this.parser.accepts("force-jumbo", "Force use of string-jumbo instructions");
                this.noWarning = this.parser.accepts("no-warning", "Suppress warnings");
                this.maxIndexNumber = this.parser.accepts("set-max-idx-number", "Undocumented: Set maximal index number to use in a dex file.").withRequiredArg().ofType(Integer.class).defaultsTo(0, (Integer[])new Integer[0]).describedAs("Maximum index");
                this.minimalMainDex = this.parser.accepts("minimal-main-dex", "Produce smallest possible main dex");
                this.mainDexList = this.parser.accepts("main-dex-list", "File listing classes that must be in the main dex file").withRequiredArg().describedAs(DxCompatOptions.FILE_ARG);
                this.multiDex = this.parser.accepts("multi-dex", "Allow generation of multi-dex").requiredIf(this.minimalMainDex, this.mainDexList, this.maxIndexNumber);
                this.minApiLevel = this.parser.accepts("min-sdk-version", "Minimum Android API level compatibility.").withRequiredArg().ofType(Integer.class);
                this.inputList = this.parser.accepts("input-list", "File listing input files").withRequiredArg().describedAs(DxCompatOptions.FILE_ARG);
                this.inputs = this.parser.nonOptions("Input files");
                this.version = this.parser.accepts("version", "Print the version of this tool").forHelp();
                this.help = this.parser.accepts("help", "Print this message").forHelp();
            }
        }

        public static class DxUsageMessage
        extends Exception {
            public final String message;

            DxUsageMessage(String message) {
                this.message = message;
            }

            void printHelpOn(PrintStream sink) throws IOException {
                sink.println(this.message);
            }
        }

        public static enum PositionInfo {
            NONE,
            IMPORTANT,
            LINES,
            THROWING;

        }
    }
}

