/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.TypeVerificationHelper;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Phi
extends Value {
    private final BasicBlock block;
    private final List<Value> operands = new ArrayList<Value>();
    private Set<Value> debugValues = null;
    private List<Map<Integer, Value>> definitionUsers = new ArrayList<Map<Integer, Value>>();

    public Phi(int number, BasicBlock block, ValueType type, DebugLocalInfo local) {
        super(number, type, local);
        this.block = block;
        block.addPhi(this);
    }

    @Override
    public boolean isPhi() {
        return true;
    }

    @Override
    public Phi asPhi() {
        return this;
    }

    public BasicBlock getBlock() {
        return this.block;
    }

    public void addOperands(IRBuilder builder, int register) {
        assert (this.operands.isEmpty());
        boolean canBeNull = false;
        if (this.block.getPredecessors().size() == 0) {
            this.throwUndefinedValueError();
        }
        for (BasicBlock pred : this.block.getPredecessors()) {
            BasicBlock.EdgeType edgeType = pred.getEdgeType(this.block);
            Value operand = builder.readRegister(register, this.type, pred, edgeType, this.getLocalInfo());
            operand.constrainType(this.type);
            canBeNull |= operand.canBeNull();
            this.appendOperand(operand);
        }
        if (!canBeNull) {
            this.markNeverNull();
        }
        this.removeTrivialPhi();
    }

    public void addOperands(List<Value> operands) {
        this.addOperands(operands, true);
    }

    public void addOperands(List<Value> operands, boolean removeTrivialPhi) {
        assert (this.operands.isEmpty());
        boolean canBeNull = false;
        if (operands.size() == 0) {
            this.throwUndefinedValueError();
        }
        for (Value operand : operands) {
            canBeNull |= operand.canBeNull();
            this.appendOperand(operand);
        }
        if (!canBeNull) {
            this.markNeverNull();
        }
        if (removeTrivialPhi) {
            this.removeTrivialPhi();
        }
    }

    public void addDebugValue(Value value) {
        assert (value.hasLocalInfo());
        if (this.debugValues == null) {
            this.debugValues = new HashSet<Value>();
        }
        this.debugValues.add(value);
        value.addDebugPhiUser(this);
    }

    private void throwUndefinedValueError() {
        throw new CompilationError("Undefined value encountered during compilation. This is typically caused by invalid dex input that uses a register that is not define on all control-flow paths leading to the use.");
    }

    private void appendOperand(Value operand) {
        this.operands.add(operand);
        operand.addPhiUser(this);
    }

    public Value getOperand(int predIndex) {
        return this.operands.get(predIndex);
    }

    public List<Value> getOperands() {
        return this.operands;
    }

    public void removeOperand(int index) {
        this.operands.get(index).removePhiUser(this);
        this.operands.remove(index);
    }

    public void removeOperandsByIndex(List<Integer> operandsToRemove) {
        if (operandsToRemove.isEmpty()) {
            return;
        }
        ArrayList<Value> copy = new ArrayList<Value>(this.operands);
        this.operands.clear();
        int current = 0;
        for (int i : operandsToRemove) {
            this.operands.addAll(copy.subList(current, i));
            ((Value)copy.get(i)).removePhiUser(this);
            current = i + 1;
        }
        this.operands.addAll(copy.subList(current, copy.size()));
    }

    public void replaceOperandAt(int predIndex, Value newValue) {
        Value current = this.operands.get(predIndex);
        this.operands.set(predIndex, newValue);
        newValue.addPhiUser(this);
        current.removePhiUser(this);
    }

    void replaceOperand(Value current, Value newValue) {
        for (int i = 0; i < this.operands.size(); ++i) {
            if (this.operands.get(i) != current) continue;
            this.operands.set(i, newValue);
            newValue.addPhiUser(this);
        }
    }

    void replaceDebugValue(Value current, Value newValue) {
        assert (current.hasLocalInfo());
        assert (current.getLocalInfo() == newValue.getLocalInfo());
        if (this.debugValues.remove(current)) {
            this.addDebugValue(newValue);
        }
    }

    public boolean isTrivialPhi() {
        Value same = null;
        for (Value op : this.operands) {
            if (op == same || op == this) continue;
            if (same != null) {
                return false;
            }
            same = op;
        }
        return true;
    }

    public void removeTrivialPhi() {
        Value same = null;
        for (Value value : this.operands) {
            if (value == same || value == this) continue;
            if (same != null) {
                assert (!this.isTrivialPhi());
                return;
            }
            same = value;
        }
        assert (this.isTrivialPhi());
        if (same == null) {
            return;
        }
        for (Value value : this.operands) {
            value.removePhiUser(this);
        }
        if (this.definitionUsers != null) {
            for (Map map2 : this.definitionUsers) {
                for (Map.Entry entry : map2.entrySet()) {
                    if (entry.getValue() != this) continue;
                    entry.setValue(same);
                    if (!same.isPhi()) continue;
                    same.asPhi().addDefinitionsUser(map2);
                }
            }
        }
        Set<Phi> phiUsersToSimplify = this.uniquePhiUsers();
        this.replaceUsers(same);
        for (Phi user : phiUsersToSimplify) {
            user.removeTrivialPhi();
        }
        this.block.removePhi(this);
    }

    public String printPhi() {
        StringBuilder builder = new StringBuilder();
        builder.append("v");
        builder.append(this.number);
        if (this.hasLocalInfo()) {
            builder.append("(").append(this.getLocalInfo()).append(")");
        }
        builder.append(" <- phi");
        StringUtils.append(builder, ListUtils.map(this.operands, Value::toString));
        builder.append(" : ").append((Object)this.type);
        return builder.toString();
    }

    public void print(CfgPrinter printer) {
        int uses = this.numberOfPhiUsers() + this.numberOfUsers();
        printer.print("0 ").append(uses).append(" v").append(this.number).append(" Phi");
        for (Value operand : this.operands) {
            printer.append(" v").append(operand.number);
        }
    }

    public void addDefinitionsUser(Map<Integer, Value> currentDefinitions) {
        this.definitionUsers.add(currentDefinitions);
    }

    public void removeDefinitionsUser(Map<Integer, Value> currentDefinitions) {
        this.definitionUsers.remove(currentDefinitions);
    }

    public void clearDefinitionsUsers() {
        this.definitionUsers = null;
    }

    @Override
    public boolean knownToBeBoolean() {
        return this.knownToBeBoolean(new HashSet<Phi>());
    }

    private boolean knownToBeBoolean(HashSet<Phi> active) {
        active.add(this);
        for (Value operand : this.operands) {
            if (operand.isPhi()) continue;
            if (operand.isConstNumber()) {
                ConstNumber number = operand.getConstInstruction().asConstNumber();
                if (number.isIntegerOne() || number.isIntegerZero()) continue;
                return false;
            }
            return false;
        }
        for (Value operand : this.operands) {
            if (!operand.isPhi() || active.contains(operand.asPhi()) || operand.asPhi().knownToBeBoolean(active)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean needsRegister() {
        return true;
    }

    public Set<Value> getDebugValues() {
        return this.debugValues != null ? this.debugValues : ImmutableSet.of();
    }

    public boolean usesValueOneTime(Value usedValue) {
        return this.operands.indexOf(usedValue) == this.operands.lastIndexOf(usedValue);
    }

    public DexType computeVerificationType(TypeVerificationHelper helper) {
        assert (this.outType().isObject());
        HashSet<DexType> operandTypes = new HashSet<DexType>(this.operands.size());
        for (Value operand : this.operands) {
            DexType operandType = helper.getType(operand);
            if (operandType == null) continue;
            operandTypes.add(operandType);
        }
        return helper.join(operandTypes);
    }
}

